/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.spec.provider.writer;

import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.common.client.JaxrsCommonClient;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import ee.jakarta.tck.ws.rs.spec.provider.writer.AppAnyEntityWriter;
import ee.jakarta.tck.ws.rs.spec.provider.writer.AppJavaEntityWriter;
import ee.jakarta.tck.ws.rs.spec.provider.writer.AppXmlObjectWriter;
import ee.jakarta.tck.ws.rs.spec.provider.writer.DefaultEntityWriter;
import ee.jakarta.tck.ws.rs.spec.provider.writer.EntityForWriter;
import ee.jakarta.tck.ws.rs.spec.provider.writer.OkResponse;
import ee.jakarta.tck.ws.rs.spec.provider.writer.Resource;
import ee.jakarta.tck.ws.rs.spec.provider.writer.TSAppConfig;
import jakarta.ws.rs.core.MediaType;
import java.io.IOException;
import java.io.InputStream;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class JAXRSClientIT
extends JaxrsCommonClient {
    public JAXRSClientIT() {
        this.setup();
        this.setContextRoot("/jaxrs_spec_provider_writer_web/resource");
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        InputStream inStream = JAXRSClientIT.class.getClassLoader().getResourceAsStream("ee/jakarta/tck/ws/rs/spec/provider/writer/web.xml.template");
        String webXml = JAXRSClientIT.editWebXmlString(inStream);
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jaxrs_spec_provider_writer_web.war");
        archive.addClasses(new Class[]{TSAppConfig.class, Resource.class, OkResponse.class, EntityForWriter.class, DefaultEntityWriter.class, AppXmlObjectWriter.class, AppJavaEntityWriter.class, AppAnyEntityWriter.class});
        archive.setWebXML((Asset)new StringAsset(webXml));
        return archive;
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Test
    public void responseSubClassTest() throws JAXRSCommonClient.Fault {
        this.setWriter(AppAnyEntityWriter.class);
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "subresponse"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, AppAnyEntityWriter.class.getSimpleName());
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, AppAnyEntityWriter.class.getSimpleName().toUpperCase());
        this.invoke();
    }

    @Test
    public void supportXmlByDefaultWriterTest() throws JAXRSCommonClient.Fault {
        this.setWriter(DefaultEntityWriter.class);
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "supportxml"));
        this.setProperty(JAXRSCommonClient.Property.UNORDERED_SEARCH_STRING, AppAnyEntityWriter.class.getSimpleName());
        this.setProperty(JAXRSCommonClient.Property.UNORDERED_SEARCH_STRING, DefaultEntityWriter.class.getSimpleName());
        this.setProperty(JAXRSCommonClient.Property.UNORDERED_SEARCH_STRING, DefaultEntityWriter.class.getSimpleName().toUpperCase());
        this.invoke();
    }

    @Test
    public void supportXmlByXmlWriterTest() throws JAXRSCommonClient.Fault {
        this.setWriter(AppXmlObjectWriter.class);
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "supportxml"));
        this.setProperty(JAXRSCommonClient.Property.UNORDERED_SEARCH_STRING, AppAnyEntityWriter.class.getSimpleName());
        this.setProperty(JAXRSCommonClient.Property.UNORDERED_SEARCH_STRING, AppXmlObjectWriter.class.getSimpleName());
        this.setProperty(JAXRSCommonClient.Property.UNORDERED_SEARCH_STRING, DefaultEntityWriter.class.getSimpleName());
        this.setProperty(JAXRSCommonClient.Property.UNORDERED_SEARCH_STRING, AppXmlObjectWriter.class.getSimpleName().toUpperCase());
        this.invoke();
    }

    @Test
    public void supportAllTest() throws JAXRSCommonClient.Fault {
        this.setWriter(DefaultEntityWriter.class);
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "supportall"));
        this.setProperty(JAXRSCommonClient.Property.UNORDERED_SEARCH_STRING, AppAnyEntityWriter.class.getSimpleName());
        this.setProperty(JAXRSCommonClient.Property.UNORDERED_SEARCH_STRING, DefaultEntityWriter.class.getSimpleName());
        this.setProperty(JAXRSCommonClient.Property.UNORDERED_SEARCH_STRING, DefaultEntityWriter.class.getSimpleName().toUpperCase());
        this.invoke();
    }

    @Test
    public void supportAppJavaTest() throws JAXRSCommonClient.Fault {
        this.setWriter(AppJavaEntityWriter.class);
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "supportmedia"));
        this.setProperty(JAXRSCommonClient.Property.CONTENT, new MediaType("application", "java").toString());
        this.setProperty(JAXRSCommonClient.Property.UNORDERED_SEARCH_STRING, AppJavaEntityWriter.class.getSimpleName());
        this.setProperty(JAXRSCommonClient.Property.UNORDERED_SEARCH_STRING, AppJavaEntityWriter.class.getSimpleName().toUpperCase());
        this.invoke();
    }

    private void setWriter(Class<?> clazz) throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "writer"));
        this.setProperty(JAXRSCommonClient.Property.CONTENT, clazz.getName());
        this.invoke();
        this.setPrintEntity(true);
    }
}

