/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.signaturetest.jaxrs;

import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import ee.jakarta.tck.ws.rs.signaturetest.SigTestEE;
import ee.jakarta.tck.ws.rs.signaturetest.SigTestResult;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import org.junit.jupiter.api.Test;

public class JAXRSSigTestIT
extends SigTestEE {
    private static final long serialVersionUID = 1675845761668114828L;
    public static final String EJB_VEHICLE = "ejb";
    public static final String SERVLET_VEHICLE = "servlet";
    public static final String JSP_VEHICLE = "jsp";
    public static final String APP_CLIENT_VEHICLE = "appclient";
    public static final String NO_VEHICLE = "standalone";
    private static final String[] DEFAULT_PKGS = new String[]{"jakarta.ws.rs", "jakarta.ws.rs.client", "jakarta.ws.rs.core", "jakarta.ws.rs.container", "jakarta.ws.rs.ext", "jakarta.ws.rs.sse"};
    private static final String[] EJB_SERVLET_JSP_PKGS = new String[0];
    private static final String[] SERVLET_JSP_PKGS = new String[0];
    private static final String[] NO_CONTAINER_PKGS = new String[]{"jakarta.ws.rs", "jakarta.ws.rs.client", "jakarta.ws.rs.core", "jakarta.ws.rs.container", "jakarta.ws.rs.ext", "jakarta.ws.rs.sse"};

    public JAXRSSigTestIT() {
        this.setup();
    }

    protected String[] getPackages() {
        return DEFAULT_PKGS;
    }

    private static void addDefaultPkgs(List<String> sigArgsList) {
        for (int i = 0; i < DEFAULT_PKGS.length; ++i) {
            sigArgsList.add(DEFAULT_PKGS[i]);
        }
    }

    private static void addEjbServletJspPkgs(List<String> sigArgsList) {
        for (int i = 0; i < EJB_SERVLET_JSP_PKGS.length; ++i) {
            sigArgsList.add(EJB_SERVLET_JSP_PKGS[i]);
        }
    }

    private static void addServletJspPkgs(List<String> sigArgsList) {
        for (int i = 0; i < SERVLET_JSP_PKGS.length; ++i) {
            sigArgsList.add(SERVLET_JSP_PKGS[i]);
        }
    }

    private static void addNoContainerPkgs(List<String> sigArgsList) {
        for (int i = 0; i < NO_CONTAINER_PKGS.length; ++i) {
            sigArgsList.add(NO_CONTAINER_PKGS[i]);
        }
    }

    @Override
    protected String[] getPackages(String vehicleName) {
        LinkedList<String> packages = new LinkedList<String>();
        if (vehicleName.equals(NO_VEHICLE)) {
            JAXRSSigTestIT.addNoContainerPkgs(packages);
        } else {
            JAXRSSigTestIT.addDefaultPkgs(packages);
            if (vehicleName.equals(EJB_VEHICLE) || vehicleName.equals(SERVLET_VEHICLE) || vehicleName.equals(JSP_VEHICLE)) {
                JAXRSSigTestIT.addEjbServletJspPkgs(packages);
            }
            if (vehicleName.equals(SERVLET_VEHICLE) || vehicleName.equals(JSP_VEHICLE)) {
                JAXRSSigTestIT.addServletJspPkgs(packages);
            }
        }
        return packages.toArray(new String[packages.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File writeStreamToTempFile(InputStream inputStream, String tempFilePrefix, String tempFileSuffix) throws IOException {
        try (FileOutputStream outputStream = null;){
            int bytesRead;
            File file = File.createTempFile(tempFilePrefix, tempFileSuffix);
            outputStream = new FileOutputStream(file);
            byte[] buffer = new byte[1024];
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, bytesRead);
            }
            File file2 = file;
            return file2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File writeStreamToSigFile(InputStream inputStream, String packageVersion) throws IOException {
        String tmpdir = System.getProperty("java.io.tmpdir");
        try (FileOutputStream outputStream = null;){
            int bytesRead;
            File sigfile = new File(tmpdir + File.separator + "jakarta.ws.rs.sig_" + packageVersion);
            if (sigfile.exists()) {
                sigfile.delete();
                TestUtil.logMsg("Existing signature file deleted to create new one");
            }
            if (!sigfile.createNewFile()) {
                TestUtil.logErr("signature file is not created");
            }
            outputStream = new FileOutputStream(sigfile);
            byte[] buffer = new byte[1024];
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, bytesRead);
            }
            File file = sigfile;
            return file;
        }
    }

    @Override
    @Test
    public void signatureTest() throws SigTestEE.Fault {
        TestUtil.logMsg("$$$ JAXRSSigTestIT.signatureTest() called");
        SigTestResult results = null;
        String mapFile = null;
        String packageFile = null;
        String repositoryDir = null;
        Properties mapFileAsProps = null;
        try {
            InputStream inStreamMapfile = JAXRSSigTestIT.class.getClassLoader().getResourceAsStream("ee/jakarta/tck/ws/rs/signaturetest/sig-test.map");
            File mFile = this.writeStreamToTempFile(inStreamMapfile, "sig-test", ".map");
            mapFile = mFile.getCanonicalPath();
            TestUtil.logMsg("mapFile location is :" + mapFile);
            InputStream inStreamPackageFile = JAXRSSigTestIT.class.getClassLoader().getResourceAsStream("ee/jakarta/tck/ws/rs/signaturetest/sig-test-pkg-list.txt");
            File pFile = this.writeStreamToTempFile(inStreamPackageFile, "sig-test-pkg-list", ".txt");
            packageFile = pFile.getCanonicalPath();
            TestUtil.logMsg("packageFile location is :" + packageFile);
            mapFileAsProps = this.getSigTestDriver().loadMapFile(mapFile);
            String packageVersion = mapFileAsProps.getProperty("jakarta.ws.rs");
            TestUtil.logMsg("Package version from mapfile :" + packageVersion);
            InputStream inStreamSigFile = JAXRSSigTestIT.class.getClassLoader().getResourceAsStream("ee/jakarta/tck/ws/rs/signaturetest/jakarta.ws.rs.sig_" + packageVersion);
            File sigFile = this.writeStreamToSigFile(inStreamSigFile, packageVersion);
            TestUtil.logMsg("signature File location is :" + sigFile.getCanonicalPath());
            repositoryDir = System.getProperty("java.io.tmpdir");
        }
        catch (IOException ex) {
            TestUtil.logMsg("Exception while creating temp files :" + ex);
        }
        String[] packages = this.getPackages(this.testInfo.getVehicle());
        String[] classes = this.getClasses(this.testInfo.getVehicle());
        String testClasspath = System.getProperty("signature.sigTestClasspath");
        String optionalPkgToIgnore = this.testInfo.getOptionalTechPackagesToIgnore();
        ArrayList<String> unlistedTechnologyPkgs = this.getUnlistedOptionalPackages();
        Properties sysProps = System.getProperties();
        String version = (String)sysProps.get("java.version");
        if (!version.startsWith("1.")) {
            String jimageDir = this.testInfo.getJImageDir();
            File f = new File(jimageDir);
            f.mkdirs();
            String javaHome = (String)sysProps.get("java.home");
            TestUtil.logMsg("Executing JImage");
            try {
                ProcessBuilder pb = new ProcessBuilder(javaHome + "/bin/jimage", "extract", "--dir=" + jimageDir, javaHome + "/lib/modules");
                TestUtil.logMsg(javaHome + "/bin/jimage extract --dir=" + jimageDir + " " + javaHome + "/lib/modules");
                pb.redirectErrorStream(true);
                Process proc = pb.start();
                BufferedReader out = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                String line = null;
                while ((line = out.readLine()) != null) {
                    TestUtil.logMsg(line);
                }
                int rc = proc.waitFor();
                TestUtil.logMsg("JImage RC = " + rc);
                out.close();
            }
            catch (Exception e) {
                TestUtil.logMsg("Exception while executing JImage!  Some tests may fail.");
                e.printStackTrace();
            }
        }
        try {
            results = this.getSigTestDriver().executeSigTest(packageFile, mapFile, repositoryDir, packages, classes, testClasspath, unlistedTechnologyPkgs, optionalPkgToIgnore);
            TestUtil.logMsg(results.toString());
            if (!results.passed()) {
                TestUtil.logErr("results.passed() returned false");
                throw new Exception();
            }
            if (NO_VEHICLE.equalsIgnoreCase(this.testInfo.getVehicle())) {
                if (mapFileAsProps == null || mapFileAsProps.size() == 0) {
                    TestUtil.logMsg("JAXRSSigTestIT.signatureTest() returning, as signature map file is empty.");
                    return;
                }
                boolean isJTASigTest = false;
                String jtaVersion = mapFileAsProps.getProperty("jakarta.transaction");
                if (jtaVersion == null || "".equals(jtaVersion.trim())) {
                    TestUtil.logMsg("JAXRSSigTestIT.signatureTest() returning, as this is neither JTA TCK run, not Java EE CTS run.");
                    return;
                }
                TestUtil.logMsg("jtaVersion " + jtaVersion);
                if (mapFileAsProps.size() == 1) {
                    isJTASigTest = true;
                }
                if (isJTASigTest || !jtaVersion.startsWith("1.2")) {
                    this.verifyJtaJarTest();
                }
            }
            TestUtil.logMsg("$$$ JAXRSSigTestIT.signatureTest() returning");
        }
        catch (Exception e) {
            if (results != null && !results.passed()) {
                throw new SigTestEE.Fault("JAXRSSigTestIT.signatureTest() failed!, diffs found");
            }
            TestUtil.logErr("Unexpected exception " + e.getMessage());
            throw new SigTestEE.Fault("signatureTest failed with an unexpected exception", e);
        }
    }
}

