/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.ee.rs.ext.providers;

import ee.jakarta.tck.ws.rs.common.AbstractMessageBodyRW;
import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.common.webclient.http.HttpResponse;
import ee.jakarta.tck.ws.rs.ee.rs.core.application.ApplicationHolderSingleton;
import ee.jakarta.tck.ws.rs.ee.rs.core.application.ApplicationServlet;
import ee.jakarta.tck.ws.rs.ee.rs.ext.contextresolver.EnumContextResolver;
import ee.jakarta.tck.ws.rs.ee.rs.ext.contextresolver.EnumProvider;
import ee.jakarta.tck.ws.rs.ee.rs.ext.contextresolver.TextPlainEnumContextResolver;
import ee.jakarta.tck.ws.rs.ee.rs.ext.exceptionmapper.AnyExceptionExceptionMapper;
import ee.jakarta.tck.ws.rs.ee.rs.ext.exceptionmapper.IOExceptionExceptionMapper;
import ee.jakarta.tck.ws.rs.ee.rs.ext.messagebodyreaderwriter.EntityAnnotation;
import ee.jakarta.tck.ws.rs.ee.rs.ext.messagebodyreaderwriter.EntityMessageReader;
import ee.jakarta.tck.ws.rs.ee.rs.ext.messagebodyreaderwriter.EntityMessageWriter;
import ee.jakarta.tck.ws.rs.ee.rs.ext.messagebodyreaderwriter.ReadableWritableEntity;
import ee.jakarta.tck.ws.rs.ee.rs.ext.providers.ProvidersServlet;
import ee.jakarta.tck.ws.rs.ee.rs.ext.providers.TSAppConfig;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.InputStream;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class JAXRSProvidersClientIT
extends JAXRSCommonClient {
    private static final long serialVersionUID = -935293219512493643L;
    protected int expectedSingletons = 1;
    protected int expectedClasses = 1;

    public JAXRSProvidersClientIT() {
        this.setup();
        TSAppConfig cfg = new TSAppConfig();
        this.setContextRoot("/jaxrs_ee_ext_providers_web/ProvidersServlet");
        this.expectedClasses = cfg.getClasses().size();
        this.expectedSingletons = cfg.getSingletons().size();
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        InputStream inStream = JAXRSProvidersClientIT.class.getClassLoader().getResourceAsStream("ee/jakarta/tck/ws/rs/ee/rs/ext/providers/web.xml.template");
        String webXml = JAXRSProvidersClientIT.editWebXmlString(inStream);
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jaxrs_ee_ext_providers_web.war");
        archive.addClasses(new Class[]{TSAppConfig.class, ProvidersServlet.class, AbstractMessageBodyRW.class, ApplicationServlet.class, ApplicationHolderSingleton.class, EnumProvider.class, EnumContextResolver.class, TextPlainEnumContextResolver.class, AnyExceptionExceptionMapper.class, IOExceptionExceptionMapper.class, EntityAnnotation.class, EntityMessageReader.class, EntityMessageWriter.class, ReadableWritableEntity.class});
        archive.setWebXML((Asset)new StringAsset(webXml));
        return archive;
    }

    @Test
    public void getSingletonsTest() throws JAXRSCommonClient.Fault {
        this.setProperty("REQUEST", this.buildRequest("GET ", "GetSingletons"));
        this.setProperty("STATUS_CODE", JAXRSProvidersClientIT.getStatusCode(Response.Status.OK));
        this.invoke();
        Assertions.assertTrue((this.getReturnedNumber() == this.expectedSingletons ? 1 : 0) != 0, (String)("Application.getSingletons() return incorrect value:" + this.getReturnedNumber()));
    }

    @Test
    public void getClassesTest() throws JAXRSCommonClient.Fault {
        this.setProperty("REQUEST", this.buildRequest("GET ", "GetClasses"));
        this.setProperty("STATUS_CODE", JAXRSProvidersClientIT.getStatusCode(Response.Status.OK));
        this.invoke();
        Assertions.assertTrue((this.getReturnedNumber() == this.expectedClasses ? 1 : 0) != 0, (String)("Application.getClasses() return incorrect value:" + this.getReturnedNumber()));
    }

    @Test
    public void isRegisteredTextPlainContextResolverTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest("GET ", "isRegisteredTextPlainContextResolver"));
        this.setProperty(JAXRSCommonClient.Property.STATUS_CODE, JAXRSProvidersClientIT.getStatusCode(Response.Status.OK));
        this.invoke();
    }

    @Test
    public void isRegisteredAppJsonContextResolverTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest("GET ", "isRegisteredAppJsonContextResolver"));
        this.setProperty(JAXRSCommonClient.Property.STATUS_CODE, JAXRSProvidersClientIT.getStatusCode(Response.Status.OK));
        this.invoke();
    }

    @Test
    public void isRegisteredExceptionMapperRuntimeExceptionTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest("GET ", "isRegisteredExceptionMapperRuntimeEx"));
        this.setProperty(JAXRSCommonClient.Property.STATUS_CODE, JAXRSProvidersClientIT.getStatusCode(Response.Status.INTERNAL_SERVER_ERROR));
        this.invoke();
    }

    @Test
    public void isRegisteredExceptionMapperNullExceptionTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest("GET ", "isRegisteredExceptionMapperNullEx"));
        this.setProperty(JAXRSCommonClient.Property.STATUS_CODE, JAXRSProvidersClientIT.getStatusCode(Response.Status.NO_CONTENT));
        this.invoke();
    }

    @Test
    public void isRegisteredRuntimeExceptionExceptionMapperTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest("GET ", "isRegisteredRuntimeExceptionMapper"));
        this.setProperty(JAXRSCommonClient.Property.STATUS_CODE, JAXRSProvidersClientIT.getStatusCode(Response.Status.OK));
        this.invoke();
    }

    @Test
    public void isRegisteredIOExceptionExceptionMapperTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest("GET ", "isRegisteredIOExceptionMapper"));
        this.setProperty(JAXRSCommonClient.Property.STATUS_CODE, JAXRSProvidersClientIT.getStatusCode(Response.Status.ACCEPTED));
        this.invoke();
    }

    @Test
    public void isRegisteredMessageBodyWriterWildcardTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest("GET ", "isRegisteredWriterWildcard"));
        this.setProperty(JAXRSCommonClient.Property.STATUS_CODE, JAXRSProvidersClientIT.getStatusCode(Response.Status.OK));
        this.invoke();
    }

    @Test
    public void isRegisteredMessageBodyWriterXmlTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest("GET ", "isRegisteredMessageWriterXml"));
        this.setProperty(JAXRSCommonClient.Property.STATUS_CODE, JAXRSProvidersClientIT.getStatusCode(Response.Status.OK));
        this.invoke();
    }

    @Test
    public void isRegisteredMessageBodyReaderWildcardTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest("GET ", "isRegisteredMessageReaderWildCard"));
        this.setProperty(JAXRSCommonClient.Property.STATUS_CODE, JAXRSProvidersClientIT.getStatusCode(Response.Status.OK));
        this.invoke();
    }

    @Test
    public void isRegisteredMessageBodReaderXmlTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest("GET ", "isRegisteredMessageReaderXml"));
        this.setProperty(JAXRSCommonClient.Property.STATUS_CODE, JAXRSProvidersClientIT.getStatusCode(Response.Status.OK));
        this.invoke();
    }

    @Test
    public void writeBodyEntityUsingWriterTest() throws JAXRSCommonClient.Fault {
        String ename = EnumProvider.JAXRS.name();
        String search = new ReadableWritableEntity(ename).toXmlString();
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "Accept: text/xml");
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest("GET ", "writeBodyEntityUsingWriter"));
        this.setProperty(JAXRSCommonClient.Property.STATUS_CODE, JAXRSProvidersClientIT.getStatusCode(Response.Status.OK));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, search);
        this.invoke();
    }

    @Test
    public void writeHeaderEntityUsingWriterTest() throws JAXRSCommonClient.Fault {
        String ename = EnumProvider.JAXRS.name();
        String search = new ReadableWritableEntity(ename).toXmlString();
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "Accept: text/xml");
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest("GET ", "writeHeaderEntityUsingWriter"));
        this.setProperty(JAXRSCommonClient.Property.STATUS_CODE, JAXRSProvidersClientIT.getStatusCode(Response.Status.OK));
        this.setProperty(JAXRSCommonClient.Property.EXPECTED_HEADERS, "READABLEWRITEABLE:" + search);
        this.invoke();
    }

    @Test
    public void writeIOExceptionUsingWriterTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "Accept: text/xml");
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest("GET ", "writeIOExceptionUsingWriter"));
        this.setProperty(JAXRSCommonClient.Property.STATUS_CODE, JAXRSProvidersClientIT.getStatusCode(Response.Status.ACCEPTED));
        this.setProperty(JAXRSCommonClient.Property.STATUS_CODE, JAXRSProvidersClientIT.getStatusCode(Response.Status.INTERNAL_SERVER_ERROR));
        this.invoke();
    }

    @Test
    public void writeIOExceptionWithoutWriterTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "Accept: text/xml");
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest("GET ", "writeIOExceptionWithoutWriter"));
        this.setProperty(JAXRSCommonClient.Property.STATUS_CODE, JAXRSProvidersClientIT.getStatusCode(Response.Status.ACCEPTED));
        this.invoke();
    }

    @Test
    public void readEntityFromHeaderTest() throws JAXRSCommonClient.Fault {
        ReadableWritableEntity entity = new ReadableWritableEntity(EnumProvider.JAXRS.name());
        String header = "READABLEWRITEABLE:" + entity.toXmlString();
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "Content-Type: text/xml");
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, header);
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest("POST", "readEntityFromHeader"));
        this.setProperty(JAXRSCommonClient.Property.STATUS_CODE, JAXRSProvidersClientIT.getStatusCode(Response.Status.OK));
        this.invoke();
    }

    @Test
    public void readEntityFromBodyTest() throws JAXRSCommonClient.Fault {
        ReadableWritableEntity entity = new ReadableWritableEntity(EnumProvider.JAXRS.name());
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "Content-Type: text/xml");
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest("POST", "readEntityFromBody"));
        this.setProperty(JAXRSCommonClient.Property.CONTENT, entity.toXmlString());
        this.setProperty(JAXRSCommonClient.Property.STATUS_CODE, JAXRSProvidersClientIT.getStatusCode(Response.Status.OK));
        this.invoke();
    }

    @Test
    public void readEntityIOExceptionTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "Content-Type: text/xml");
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest("POST", "readEntityIOException"));
        this.setProperty(JAXRSCommonClient.Property.STATUS_CODE, JAXRSProvidersClientIT.getStatusCode(Response.Status.ACCEPTED));
        this.invoke();
    }

    @Test
    public void readEntityWebException400Test() throws JAXRSCommonClient.Fault {
        String code = "READABLEWRITEABLE:" + Response.Status.BAD_REQUEST.name();
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "Content-Type: text/xml");
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest("POST", "readEntityWebException"));
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, code);
        this.setProperty(JAXRSCommonClient.Property.STATUS_CODE, JAXRSProvidersClientIT.getStatusCode(Response.Status.BAD_REQUEST));
        this.invoke();
    }

    @Test
    public void readEntityWebException410Test() throws JAXRSCommonClient.Fault {
        String code = "READABLEWRITEABLE:" + Response.Status.GONE.name();
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "Content-Type: text/xml");
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest("POST", "readEntityWebException"));
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, code);
        this.setProperty(JAXRSCommonClient.Property.STATUS_CODE, JAXRSProvidersClientIT.getStatusCode(Response.Status.GONE));
        this.invoke();
    }

    protected int getReturnedNumber() throws JAXRSCommonClient.Fault {
        String body;
        HttpResponse response = this._testCase.getResponse();
        try {
            body = response.getResponseBodyAsString();
        }
        catch (IOException e) {
            throw new JAXRSCommonClient.Fault(e);
        }
        return Integer.parseInt(body);
    }
}

