/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.api.rs.core.uribuilder;

import ee.jakarta.tck.ws.rs.api.rs.core.uribuilder.TestPath;
import ee.jakarta.tck.ws.rs.api.rs.core.uribuilder.TestPathBad;
import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import jakarta.ws.rs.core.Link;
import jakarta.ws.rs.core.UriBuilder;
import jakarta.ws.rs.core.UriBuilderException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

public class JAXRSClientIT
extends JAXRSCommonClient {
    private static final long serialVersionUID = 1814450070599603168L;
    private static final String LOCALHOST = "http://localhost:8080";
    private static final String EXPECTED_PATH = "path-rootless/test2/x%25yz//path-absolute/test1/fred@example.com/x%25yz";
    private static final String ENCODED_EXPECTED_PATH = "path-rootless%2Ftest2/x%25yz/%2Fpath-absolute%2F%2525test1/fred@example.com/x%25yz";
    StringBuilder sb;
    boolean pass = true;
    URI uri;

    public JAXRSClientIT() {
        this.setContextRoot("/jaxrs_rs.core_uribuilder_web");
        this.pass = true;
        this.sb = new StringBuilder();
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Test
    public void buildTest1() throws JAXRSCommonClient.Fault {
        String value = "test1#test2";
        String expected_value = "test1%23test2";
        try {
            this.uri = UriBuilder.fromPath((String)"{arg1}").build(new Object[]{value});
            this.gotExpectedPass(this.uri.toString(), expected_value);
        }
        catch (Exception ex) {
            this.pass = false;
            this.sb.append("Unexpected exception thrown: " + ex.getMessage());
        }
        this.assertPassAndLog();
    }

    @Test
    public void buildTest2() throws JAXRSCommonClient.Fault {
        Object value = null;
        try {
            UriBuilder.fromPath((String)"{arg1}").build(new Object[]{value});
            this.pass = false;
            this.sb.append("Expected IllegalArgumentException not thrown" + newline);
        }
        catch (IllegalArgumentException ilex) {
            this.sb.append("Expected IllegalArgumentException thrown");
        }
        this.assertPassAndLog();
    }

    @Test
    public void fragmentTest1() throws JAXRSCommonClient.Fault {
        String expected_value = "test#xyz";
        try {
            this.uri = UriBuilder.fromPath((String)"test").fragment("xyz").build(new Object[0]);
            this.gotExpectedPass(this.uri.toString(), expected_value);
        }
        catch (Exception ex) {
            this.pass = false;
            this.sb.append("Unexpected exception thrown: " + ex.getMessage());
        }
        this.assertPassAndLog();
    }

    @Test
    public void buildFromMapTest1() throws JAXRSCommonClient.Fault {
        HashMap<String, String> maps = new HashMap<String, String>();
        maps.put("x", "x%yz");
        maps.put("y", "/path-absolute/%25test1");
        maps.put("z", "fred@example.com");
        maps.put("w", "path-rootless/test2");
        try {
            this.uri = UriBuilder.fromPath((String)"").path("{w}/{x}/{y}/{z}/{x}").buildFromMap(maps);
            this.gotExpectedPass(this.uri.getRawPath(), ENCODED_EXPECTED_PATH);
        }
        catch (Exception ex) {
            this.pass = false;
            this.sb.append("Unexpected exception thrown: " + ex.getMessage() + newline);
        }
        this.assertPassAndLog();
    }

    @Test
    public void buildFromMapTest2() throws JAXRSCommonClient.Fault {
        HashMap<String, String> maps = new HashMap<String, String>();
        maps.put("x", "x%yz");
        maps.put("y", "/path-absolute/%25test1");
        maps.put("z", "fred@example.com");
        maps.put("w", "path-rootless/test2");
        maps.put("u", "extra");
        try {
            this.uri = UriBuilder.fromPath((String)"").path("{w}/{x}/{y}/{z}/{x}").buildFromMap(maps);
            this.gotExpectedPass(this.uri.getRawPath(), ENCODED_EXPECTED_PATH);
        }
        catch (Exception ex) {
            this.pass = false;
            this.sb.append("Unexpected exception thrown: " + ex.getMessage() + newline);
        }
        this.assertPassAndLog();
    }

    @Test
    public void buildFromMapTest3() throws JAXRSCommonClient.Fault {
        HashMap<String, String> maps = new HashMap<String, String>();
        maps.put("x", null);
        maps.put("y", "/path-absolute/test1");
        maps.put("z", "fred@example.com");
        maps.put("w", "path-rootless/test2");
        maps.put("u", "extra");
        try {
            UriBuilder.fromPath((String)"").path("{w}/{x}/{y}/{z}/{x}").buildFromMap(maps);
            throw new JAXRSCommonClient.Fault("Test Failed: expected IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException ex) {
            TestUtil.logTrace("Test passed: expected TestUtil.logTrace( thrown");
            return;
        }
    }

    @Test
    public void buildFromMapTest4() throws JAXRSCommonClient.Fault {
        HashMap<String, String> maps = new HashMap<String, String>();
        maps.put("x", "x%yz");
        maps.put("y", "/path-absolute/test1");
        maps.put("z", "fred@example.com");
        maps.put("w", "path-rootless/test2");
        maps.put("u", "extra");
        try {
            UriBuilder.fromPath((String)"").path("{w}/{v}/{x}/{y}/{z}/{x}").buildFromMap(maps);
            throw new JAXRSCommonClient.Fault("Test Failed: expected IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException ex) {
            TestUtil.logTrace("Test passed: expected TestUtil.logTrace( thrown");
            return;
        }
    }

    @Test
    public void buildFromMapTest5() throws JAXRSCommonClient.Fault {
        HashMap<String, String> maps = new HashMap<String, String>();
        maps.put("x", "x%yz");
        maps.put("y", "/path-absolute/%25test1");
        maps.put("z", "fred@example.com");
        maps.put("w", "path-rootless/test2");
        HashMap<String, String> maps1 = new HashMap<String, String>();
        maps1.put("x", "x%20yz");
        maps1.put("y", "/path-absolute/test1");
        maps1.put("z", "fred@example.com");
        maps1.put("w", "path-rootless/test2");
        HashMap<String, String> maps2 = new HashMap<String, String>();
        maps2.put("x", "x%yz");
        maps2.put("y", "/path-absolute/%25test1");
        maps2.put("z", "fred@example.com");
        maps2.put("w", "path-rootless/test2");
        maps2.put("v", "xyz");
        String expected_path_1 = "path-rootless%2Ftest2/x%2520yz/%2Fpath-absolute%2Ftest1/fred@example.com/x%2520yz";
        try {
            UriBuilder ub = UriBuilder.fromPath((String)"").path("{w}/{x}/{y}/{z}/{x}");
            this.uri = ub.buildFromMap(maps);
            this.gotExpectedPass(this.uri.getRawPath(), ENCODED_EXPECTED_PATH);
            this.uri = ub.buildFromMap(maps1);
            this.gotExpectedPass(this.uri.getRawPath(), expected_path_1);
            this.uri = ub.buildFromMap(maps2);
            this.gotExpectedPass(this.uri.getRawPath(), ENCODED_EXPECTED_PATH);
        }
        catch (Throwable ex) {
            this.pass = false;
            this.sb.append("Unexpected exception thrown: " + ex.getMessage() + newline);
        }
        this.assertPassAndLog();
    }

    @Test
    public void buildFromEncodedMapTest1() throws JAXRSCommonClient.Fault {
        HashMap<String, String> maps = new HashMap<String, String>();
        maps.put("x", "x%20yz");
        maps.put("y", "/path-absolute/%test1");
        maps.put("z", "fred@example.com");
        maps.put("w", "path-rootless/test2");
        String expected_path = "path-rootless/test2/x%20yz//path-absolute/%25test1/fred@example.com/x%20yz";
        try {
            this.uri = UriBuilder.fromPath((String)"").path("{w}/{x}/{y}/{z}/{x}").buildFromEncodedMap(maps);
            this.gotExpectedPass(this.uri.getRawPath(), expected_path);
        }
        catch (Exception ex) {
            this.pass = false;
            this.sb.append("Unexpected exception thrown: " + ex.getMessage() + newline);
        }
        this.assertPassAndLog();
    }

    @Test
    public void buildFromEncodedMapTest2() throws JAXRSCommonClient.Fault {
        HashMap<String, String> maps = new HashMap<String, String>();
        maps.put("x", "x%yz");
        maps.put("y", "/path-absolute/test1");
        maps.put("z", "fred@example.com");
        maps.put("w", "path-rootless/test2");
        maps.put("u", "extra");
        try {
            this.uri = UriBuilder.fromPath((String)"").path("{w}/{x}/{y}/{z}/{x}").buildFromEncodedMap(maps);
            this.gotExpectedPass(this.uri.getRawPath(), EXPECTED_PATH);
        }
        catch (Exception ex) {
            this.pass = false;
            this.sb.append("Unexpected exception thrown: " + ex.getMessage() + newline);
        }
        this.assertPassAndLog();
    }

    @Test
    public void buildFromEncodedMapTest3() throws JAXRSCommonClient.Fault {
        HashMap<String, String> maps = new HashMap<String, String>();
        maps.put("x", null);
        maps.put("y", "/path-absolute/test1");
        maps.put("z", "fred@example.com");
        maps.put("w", "path-rootless/test2");
        maps.put("u", "extra");
        try {
            UriBuilder.fromPath((String)"").path("{w}/{x}/{y}/{z}/{x}").buildFromEncodedMap(maps);
            throw new JAXRSCommonClient.Fault("Test Failed: expected IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException ex) {
            TestUtil.logTrace("Test passed: expected TestUtil.logTrace( thrown");
            return;
        }
    }

    @Test
    public void buildFromEncodedMapTest4() throws JAXRSCommonClient.Fault {
        HashMap<String, String> maps = new HashMap<String, String>();
        maps.put("x", "x%yz");
        maps.put("y", "/path-absolute/test1");
        maps.put("z", "fred@example.com");
        maps.put("w", "path-rootless/test2");
        maps.put("u", "extra");
        try {
            UriBuilder.fromPath((String)"").path("{w}/{v}/{x}/{y}/{z}/{x}").buildFromEncodedMap(maps);
            throw new JAXRSCommonClient.Fault("Test Failed: expected IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException ex) {
            TestUtil.logTrace("Test passed: expected TestUtil.logTrace( thrown");
            return;
        }
    }

    @Test
    public void buildFromEncodedMapTest5() throws JAXRSCommonClient.Fault {
        HashMap<String, String> maps = new HashMap<String, String>();
        maps.put("x", "x%yz");
        maps.put("y", "/path-absolute/test1");
        maps.put("z", "fred@example.com");
        maps.put("w", "path-rootless/test2");
        HashMap<String, String> maps1 = new HashMap<String, String>();
        maps1.put("x", "x%20yz");
        maps1.put("y", "/path-absolute/test1");
        maps1.put("z", "fred@example.com");
        maps1.put("w", "path-rootless/test2");
        HashMap<String, String> maps2 = new HashMap<String, String>();
        maps2.put("x", "x%yz");
        maps2.put("y", "/path-absolute/test1");
        maps2.put("z", "fred@example.com");
        maps2.put("w", "path-rootless/test2");
        maps2.put("v", "xyz");
        String expected_path_1 = "path-rootless/test2/x%20yz//path-absolute/test1/fred@example.com/x%20yz";
        try {
            UriBuilder ub = UriBuilder.fromPath((String)"").path("{w}/{x}/{y}/{z}/{x}");
            this.uri = ub.buildFromEncodedMap(maps);
            this.gotExpectedPass(this.uri.getRawPath(), EXPECTED_PATH);
            this.uri = ub.buildFromEncodedMap(maps1);
            this.gotExpectedPass(this.uri.getRawPath(), expected_path_1);
            this.uri = ub.buildFromEncodedMap(maps2);
            this.gotExpectedPass(this.uri.getRawPath(), EXPECTED_PATH);
        }
        catch (Throwable ex) {
            this.pass = false;
            this.sb.append("Unexpected exception thrown: " + ex.getMessage() + newline);
        }
        this.assertPassAndLog();
    }

    @Test
    public void fromPathTest1() throws JAXRSCommonClient.Fault {
        String[] paths = new String[]{"/", "", "/path-absolute/test1", "fred@example.com", "path-rootless/test2"};
        for (int j = 0; j < paths.length; ++j) {
            try {
                this.uri = UriBuilder.fromPath((String)paths[j]).build(new Object[0]);
                this.gotExpectedPass(this.uri.getPath(), paths[j]);
                continue;
            }
            catch (Exception ex) {
                this.pass = false;
                this.sb.append("Unexpected exception thrown: " + ex.getMessage());
            }
        }
        this.assertPassAndLog();
    }

    @Test
    public void fromPathTest2() throws JAXRSCommonClient.Fault {
        String path = null;
        try {
            UriBuilder.fromPath(path);
            throw new JAXRSCommonClient.Fault("Test Failed: expected IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
    }

    @Test
    public void fromResourceTest1() throws JAXRSCommonClient.Fault {
        Class res = null;
        try {
            UriBuilder.fromResource(res);
            throw new JAXRSCommonClient.Fault("Test Failed: expected IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
    }

    @Test
    public void fromResourceTest2() throws JAXRSCommonClient.Fault {
        Class<TestPath> res = TestPath.class;
        String expected_path = "/TestPath";
        try {
            this.uri = UriBuilder.fromResource(res).build(new Object[0]);
            this.gotExpectedPass(this.uri.toString(), expected_path);
        }
        catch (Exception ex) {
            this.pass = false;
            this.sb.append("Unexpected exception thrown: " + ex.getMessage());
        }
        this.assertPassAndLog();
    }

    @Test
    public void fromUriTest1() throws JAXRSCommonClient.Fault {
        try {
            UriBuilder.fromUri((URI)this.uri);
            throw new JAXRSCommonClient.Fault("Test Failed: expected IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
    }

    @Test
    public void fromUriTest2() throws JAXRSCommonClient.Fault {
        String uri = null;
        try {
            UriBuilder.fromUri(uri);
            throw new JAXRSCommonClient.Fault("Test Failed: expected IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
    }

    @Test
    public void fromUriTest3() throws JAXRSCommonClient.Fault {
        String[] uris = new String[]{"ftp://ftp.is.co.za/rfc/rfc1808.txt", "mailto:java-net@java.sun.com", "news:comp.lang.java", "urn:isbn:096139210x", "http://www.ietf.org/rfc/rfc2396.txt", "ldap://[2001:db8::7]/c=GB?objectClass?one", "tel:+1-816-555-1212", "telnet://192.0.2.16:80/", "foo://example.com:8042/over/there?name=ferret#nose"};
        for (int j = 0; j < 9; ++j) {
            try {
                this.uri = UriBuilder.fromUri((String)uris[j]).build(new Object[0]);
                this.gotExpectedPass(this.uri.toString().trim(), uris[j]);
                continue;
            }
            catch (Exception ex) {
                this.pass = false;
                this.sb.append("Unexpected exception thrown: " + ex.getMessage());
            }
        }
        this.assertPassAndLog();
    }

    @Test
    public void fromUriTest4() throws JAXRSCommonClient.Fault {
        String[] uris = new String[]{"ftp://ftp.is.co.za/rfc/rfc1808.txt", "mailto:java-net@java.sun.com", "news:comp.lang.java", "urn:isbn:096139210x", "http://www.ietf.org/rfc/rfc2396.txt", "ldap://[2001:db8::7]/c=GB?objectClass?one", "tel:+1-816-555-1212", "telnet://192.0.2.16:80/", "foo://example.com:8042/over/there?name=ferret#nose"};
        for (int j = 0; j < 9; ++j) {
            try {
                this.uri = UriBuilder.fromUri((URI)new URI(uris[j])).build(new Object[0]);
                this.gotExpectedPass(this.uri.toString().trim(), uris[j]);
                continue;
            }
            catch (Exception ex) {
                this.pass = false;
                this.sb.append("Unexpected exception thrown: " + ex.getMessage());
            }
        }
        this.assertPassAndLog();
    }

    @Test
    public void pathTest() throws JAXRSCommonClient.Fault {
        String path = "test1#test2";
        String path1 = "/TestPath";
        String expected_path = "test1%23test2/TestPath";
        try {
            URI uri = UriBuilder.fromPath((String)path).path(path1).build(new Object[0]);
            this.gotExpectedPass(uri.toString(), expected_path);
        }
        catch (Exception ex) {
            this.pass = false;
            this.sb.append("Unexpected exception thrown: " + ex.getMessage());
        }
        this.assertPassAndLog();
    }

    @Test
    public void pathTest0() throws JAXRSCommonClient.Fault {
        String path = "test1#test2";
        String path1 = "TestPath";
        String expected_path = "test1%23test2/TestPath";
        try {
            URI uri = UriBuilder.fromPath((String)path).path(path1).build(new Object[0]);
            this.gotExpectedPass(uri.toString(), expected_path);
        }
        catch (Exception ex) {
            this.pass = false;
            this.sb.append("Unexpected exception thrown: " + ex.getMessage());
        }
        this.assertPassAndLog();
    }

    @Test
    public void pathTest1() throws JAXRSCommonClient.Fault {
        String path = "test1#test2";
        String path1 = null;
        try {
            UriBuilder.fromPath((String)path).path(path1);
            throw new JAXRSCommonClient.Fault("Test Failed.  Expected IllegalArgumentException not thrown.");
        }
        catch (IllegalArgumentException ilex) {
            TestUtil.logTrace("Expected IllegalArgumentException thrown: " + ilex.getMessage());
            return;
        }
    }

    @Test
    public void pathTest2() throws JAXRSCommonClient.Fault {
        String path = "test1#test2";
        Class<TestPath> path1 = TestPath.class;
        String expected_path = "test1%23test2/TestPath";
        try {
            this.uri = UriBuilder.fromPath((String)path).path(path1).build(new Object[0]);
            this.gotExpectedPass(this.uri.toString(), expected_path);
        }
        catch (Exception ex) {
            this.pass = false;
            this.sb.append("Unexpected exception thrown: " + ex.getMessage());
        }
        this.assertPassAndLog();
    }

    @Test
    public void pathTest3() throws JAXRSCommonClient.Fault {
        String path = "test1#test2";
        Class path1 = null;
        try {
            UriBuilder.fromPath((String)path).path(path1);
            throw new JAXRSCommonClient.Fault("Test Failed.  Expected IllegalArgumentException not thrown.");
        }
        catch (IllegalArgumentException ilex) {
            TestUtil.logTrace("Expected IllegalArgumentException thrown: " + ilex.getMessage());
            return;
        }
    }

    @Test
    public void pathTest4() throws JAXRSCommonClient.Fault {
        String path = "test1#test2";
        Class<TestPathBad> path1 = TestPathBad.class;
        try {
            UriBuilder.fromPath((String)path).path(path1);
            throw new JAXRSCommonClient.Fault("Test Failed.  Expected IllegalArgumentException not thrown.");
        }
        catch (IllegalArgumentException ilex) {
            TestUtil.logTrace("Expected IllegalArgumentException thrown: " + ilex.getMessage());
            return;
        }
    }

    @Test
    public void pathTest5() throws JAXRSCommonClient.Fault {
        String path = "/TestPath";
        Class<TestPath> path1 = TestPath.class;
        String md = "headSub";
        String expected_path = "/TestPath/sub";
        try {
            this.uri = UriBuilder.fromPath((String)path).path(path1, md).build(new Object[0]);
            this.gotExpectedPass(this.uri.toString(), expected_path);
        }
        catch (Exception ex) {
            this.pass = false;
            this.sb.append("Unexpected exception thrown: " + ex.getMessage());
        }
        this.assertPassAndLog();
    }

    @Test
    public void pathTest6() throws JAXRSCommonClient.Fault {
        String path = "/TestPath";
        Class<TestPath> path1 = TestPath.class;
        String md = "getPlain";
        try {
            UriBuilder.fromPath((String)path).path(path1, md).build(new Object[0]);
            throw new JAXRSCommonClient.Fault("Test failed, expected IllegalArgumentException not thrown." + newline);
        }
        catch (IllegalArgumentException ilex) {
            TestUtil.logTrace("Expected IllegalArgumentException thrown: " + ilex.getMessage());
            return;
        }
    }

    @Test
    public void pathTest7() throws JAXRSCommonClient.Fault {
        String path = "/TestPath";
        Class<TestPath> path1 = TestPath.class;
        String md = null;
        try {
            UriBuilder.fromPath((String)path).path(path1, md).build(new Object[0]);
            throw new JAXRSCommonClient.Fault("Test failed, expected IllegalArgumentException not thrown." + newline);
        }
        catch (IllegalArgumentException ilex) {
            TestUtil.logTrace("Expected IllegalArgumentException thrown: " + ilex.getMessage());
            return;
        }
    }

    @Test
    public void pathTest8() throws JAXRSCommonClient.Fault {
        String path = "/TestPath";
        Class path1 = null;
        String md = "headSub";
        try {
            UriBuilder.fromPath((String)path).path(path1, md).build(new Object[0]);
            throw new JAXRSCommonClient.Fault("Test failed, expected IllegalArgumentException not thrown." + newline);
        }
        catch (IllegalArgumentException ilex) {
            TestUtil.logTrace("Expected IllegalArgumentException thrown: " + ilex.getMessage());
            return;
        }
    }

    @Test
    public void pathTest9() throws JAXRSCommonClient.Fault {
        String path = "/TestPath";
        Class<TestPath> path1 = TestPath.class;
        String md = "test1";
        try {
            UriBuilder.fromPath((String)path).path(path1, md).build(new Object[0]);
            throw new JAXRSCommonClient.Fault("Test Failed.  Expected IllegalArgumentException not thrown.");
        }
        catch (IllegalArgumentException ilex) {
            TestUtil.logTrace("Expected IllegalArgumentException thrown: " + ilex.getMessage());
            return;
        }
    }

    @Test
    public void pathTest10() throws JAXRSCommonClient.Fault {
        String path = "/TestPath";
        Class<TestPath> path1 = TestPath.class;
        String expected_path = "/TestPath/sub";
        try {
            Method md = path1.getMethod("headSub", new Class[0]);
            URI uri = UriBuilder.fromPath((String)path).path(md).build(new Object[0]);
            this.gotExpectedPass(uri.toString(), expected_path);
        }
        catch (Exception ex) {
            this.pass = false;
            this.sb.append("Unexpected exception thrown: " + ex.getMessage());
        }
        this.assertPassAndLog();
    }

    @Test
    public void pathTest11() throws JAXRSCommonClient.Fault {
        String path = "/TestPath";
        Class<TestPath> path1 = TestPath.class;
        String expected_path = "/TestPath/sub1";
        try {
            Method md = path1.getMethod("test1", new Class[0]);
            URI uri = UriBuilder.fromPath((String)path).path(md).build(new Object[0]);
            this.gotExpectedPass(uri.toString(), expected_path);
        }
        catch (Exception ex) {
            this.pass = false;
            this.sb.append("Unexpected exception thrown: " + ex.getMessage());
        }
        this.assertPassAndLog();
    }

    @Test
    public void pathTest12() throws JAXRSCommonClient.Fault {
        String path = "/TestPath";
        Class<TestPath> path1 = TestPath.class;
        try {
            Method md = path1.getMethod("getPlain", new Class[0]);
            UriBuilder.fromPath((String)path).path(md).build(new Object[0]);
            throw new JAXRSCommonClient.Fault("Test Failed.  Expected IllegalArgumentException not thrown.");
        }
        catch (IllegalArgumentException ilex) {
            TestUtil.logTrace("Expected IllegalArgumentException thrown: " + ilex.getMessage());
        }
        catch (NoSuchMethodException ex) {
            throw new JAXRSCommonClient.Fault("Test Failed.  Unexpected exception thrown: " + ex.getMessage());
        }
    }

    @Test
    public void pathTest13() throws JAXRSCommonClient.Fault {
        String path = "test1#test2";
        Method path1 = null;
        try {
            UriBuilder.fromPath((String)path).path(path1);
            throw new JAXRSCommonClient.Fault("Test Failed.  Expected IllegalArgumentException not thrown.");
        }
        catch (IllegalArgumentException ilex) {
            TestUtil.logTrace("Expected IllegalArgumentException thrown: " + ilex.getMessage());
            return;
        }
    }

    @Test
    public void replacePathTest1() throws JAXRSCommonClient.Fault {
        String path = "/TestPath";
        String new_path = "/TestPathAgain";
        try {
            URI uri = UriBuilder.fromPath((String)path).replacePath(new_path).build(new Object[0]);
            this.gotExpectedPass(uri.toString(), new_path);
        }
        catch (Exception ex) {
            this.pass = false;
            this.sb.append("Unexpected exception thrown: " + ex.getMessage());
        }
        this.assertPassAndLog();
    }

    @Test
    public void replacePathTest2() throws JAXRSCommonClient.Fault {
        String path = "/TestPath1/TestPath2";
        String new_path = null;
        try {
            URI uri = UriBuilder.fromPath((String)path).replacePath(new_path).build(new Object[0]);
            boolean conditionTrue = uri.toString() == null || uri.toString().trim().compareTo("") == 0;
            this.gotExpectedPass(!conditionTrue, uri.toString(), new_path);
        }
        catch (Exception ex) {
            this.pass = false;
            this.sb.append("Unexpected exception thrown: " + ex.getMessage());
        }
        this.assertPassAndLog();
    }

    @Test
    public void replacePathTest3() throws JAXRSCommonClient.Fault {
        String path = "TestPath";
        String new_path = null;
        try {
            this.uri = UriBuilder.fromPath((String)path).replacePath(new_path).build(new Object[0]);
            boolean conditionTrue = this.uri.toString() == null || this.uri.toString().trim().compareTo("") == 0;
            this.gotExpectedPass(!conditionTrue, this.uri.toString(), new_path);
        }
        catch (Exception ex) {
            this.pass = false;
            this.sb.append("Unexpected exception thrown: " + ex.getMessage());
        }
        this.assertPassAndLog();
    }

    @Test
    public void portTest1() throws JAXRSCommonClient.Fault {
        String uri_string = "foo://example.com:8042/over/there?name=ferret#nose";
        String uri_string_expected = "foo://example.com:2008/over/there?name=ferret#nose";
        int port = 2008;
        try {
            this.uri = UriBuilder.fromUri((String)uri_string).port(port).build(new Object[0]);
            this.gotExpectedPass(this.uri.toString().trim(), uri_string_expected);
        }
        catch (Exception ex) {
            throw new JAXRSCommonClient.Fault("Test Failed: unexpected Exception thrown", ex);
        }
    }

    @Test
    public void portTest2() throws JAXRSCommonClient.Fault {
        String uri_string = "foo://example.com:8042/over/there?name=ferret#nose";
        int port = -10;
        try {
            this.uri = UriBuilder.fromUri((String)uri_string).port(port).build(new Object[0]);
            throw new JAXRSCommonClient.Fault("Test failed, expected IllegalArgumentException not thrown.Got uri=" + this.uri.toString() + " instead.");
        }
        catch (IllegalArgumentException ex) {
            TestUtil.logTrace("Test Passed: expected IllegalArgumentException thrown");
            return;
        }
    }

    @Test
    public void hostTest1() throws JAXRSCommonClient.Fault {
        String uri_string = "foo://example.com:8042/over/there?name=ferret#nose";
        String uri_string_1 = "foo://java.net:8042/over/there?name=ferret#nose";
        String host = "java.net";
        try {
            this.uri = UriBuilder.fromUri((String)uri_string).host(host).build(new Object[0]);
            this.gotExpectedPass(this.uri.toString().trim(), uri_string_1);
        }
        catch (Exception ex) {
            throw new JAXRSCommonClient.Fault("Test Failed: unexpected Exception thrown", ex);
        }
    }

    @Test
    public void hostTest2() throws JAXRSCommonClient.Fault {
        String uri_string = "foo://example.com:8042/over/there?name=ferret#nose";
        String host = "";
        try {
            this.uri = UriBuilder.fromUri((String)uri_string).host(host).build(new Object[0]);
            throw new JAXRSCommonClient.Fault("Test failed, expected IllegalArgumentException not thrown.Got uri=" + this.uri.toString() + " instead.");
        }
        catch (IllegalArgumentException ex) {
            TestUtil.logTrace("Test Passed: expected IllegalArgumentException thrown");
            return;
        }
    }

    @Test
    public void schemeTest1() throws JAXRSCommonClient.Fault {
        String uri_string = "foo://example.com:8042/over/there?name=ferret#nose";
        String uri_string_1 = "http://example.com:8042/over/there?name=ferret#nose";
        String scheme = "http";
        try {
            this.uri = UriBuilder.fromUri((String)uri_string).scheme(scheme).build(new Object[0]);
            this.gotExpectedPass(this.uri.toString().trim(), uri_string_1);
        }
        catch (Exception ex) {
            throw new JAXRSCommonClient.Fault("Test Failed: unexpected Exception thrown", ex);
        }
    }

    @Test
    public void schemeTest2() throws JAXRSCommonClient.Fault {
        String uri_string = "http://example.com:8042/over/there?name=ferret#nose";
        String scheme = null;
        try {
            this.uri = UriBuilder.fromUri((String)uri_string).scheme(scheme).build(new Object[0]);
            Assertions.assertTrue((this.uri.getRawSchemeSpecificPart() == null ? 1 : 0) != 0, (String)("scheme not cleared as expected, got" + this.uri.getSchemeSpecificPart()));
        }
        catch (Throwable ex) {
            TestUtil.logTrace("Unexpected Exception thrown. Test Failed." + ex.getMessage());
        }
    }

    @Test
    public void schemeSpecificPartTest() throws JAXRSCommonClient.Fault {
        String uri_1 = "http://example.com:8042/uber/here?name=ferret#nose";
        String uri_2 = "//example1.com:8041/over/there?name=monkey";
        String uri_3 = "http://example1.com:8041/over/there?name=monkey#nose";
        try {
            this.uri = UriBuilder.fromUri((String)uri_1).schemeSpecificPart(uri_2).build(new Object[0]);
            this.gotExpectedPass(this.uri.toString().trim(), uri_3);
        }
        catch (Exception ex) {
            throw new JAXRSCommonClient.Fault("Test Failed: unexpected Exception thrown", ex);
        }
    }

    @Test
    public void schemeSpecificPartTest1() throws JAXRSCommonClient.Fault {
        String uri_1 = "http://example.com:8042/uber/here?name=ferret#nose";
        String uri_2 = null;
        try {
            UriBuilder.fromUri((String)uri_1).schemeSpecificPart(uri_2).build(new Object[0]);
            this.sb.append("Test Failed: expected IllegalArgumentException Exception not thrown.");
            this.pass = false;
        }
        catch (IllegalArgumentException ex) {
            this.sb.append("Expected IllegalArgumentException thrown. Test PASSED.");
        }
        catch (Exception ex) {
            this.sb.append("Test Failed: wrong Exception thrown" + ex.getMessage());
            this.pass = false;
        }
        this.assertPassAndLog();
    }

    @Test
    public void templateTest1() throws JAXRSCommonClient.Fault {
        String expected_value = "test#xyz";
        try {
            this.uri = UriBuilder.fromPath((String)"{arg1}").fragment("{arg2}").build(new Object[]{"test", "xyz"});
            this.gotExpectedPass(this.uri.toString(), expected_value);
        }
        catch (Exception ex) {
            this.pass = false;
            this.sb.append("Unexpected exception thrown: " + ex.getMessage());
        }
        this.assertPassAndLog();
    }

    @Test
    public void templateTest2() throws JAXRSCommonClient.Fault {
        String expected_value = "test1/test2/test1";
        try {
            this.uri = UriBuilder.fromPath((String)"{arg1}/{arg2}/{arg1}").build(new Object[]{"test1", "test2", "test3"});
            this.gotExpectedPass(this.uri.toString(), expected_value);
        }
        catch (Exception ex) {
            this.pass = false;
            this.sb.append("Unexpected exception thrown: " + ex.getMessage());
        }
        this.assertPassAndLog();
    }

    @Test
    public void uriTest() throws JAXRSCommonClient.Fault {
        String[] uris_orig = JAXRSClientIT.getOrigUris();
        URI[] uris_replace = JAXRSClientIT.getReplacementUris();
        String[] uris_expect = JAXRSClientIT.getExpectedUris();
        int i = 0;
        int k = 0;
        for (int j = 0; j < 17; ++j) {
            try {
                this.sb.append("Replace uri with ").append(uris_replace[j]).append(newline);
                this.uri = UriBuilder.fromUri((URI)new URI(uris_orig[j])).uri(uris_replace[j]).build(new Object[0]);
                if (this.gotExpectedPass(this.uri.toString().trim(), uris_expect[j]) != 0) {
                    ++i;
                    continue;
                }
                ++k;
                continue;
            }
            catch (Exception ex) {
                this.pass = false;
                this.sb.append("Unexpected exception thrown: ").append(ex.getMessage()).append(newline);
                this.sb.append("Test failed with exception for expected uri: ").append(uris_expect[j]).append(newline);
            }
        }
        Assertions.assertTrue((boolean)this.pass, (String)(k + "assertion passed." + newline + i + "assertion(s) failed:" + this.sb.toString() + newline));
        JAXRSClientIT.logMsg(this.sb);
    }

    @Test
    public void uriTest1() throws JAXRSCommonClient.Fault {
        try {
            UriBuilder.fromPath((String)"/").uri(this.uri);
            throw new JAXRSCommonClient.Fault("Expected IllegalArgumentException not thrown" + newline);
        }
        catch (IllegalArgumentException ilex) {
            TestUtil.logTrace("Expected IllegalArgumentException thrown");
            return;
        }
    }

    @Test
    public void fromEncodedTest1() throws JAXRSCommonClient.Fault {
        String expected_value_1 = "http://localhost:8080/a/%25/=/%25G0/%25/=";
        String expected_value_2 = "http://localhost:8080/xy/%20/%25/xy";
        try {
            this.uri = UriBuilder.fromPath((String)LOCALHOST).path("/{v}/{w}/{x}/{y}/{z}/{x}").buildFromEncoded(new Object[]{"a", "%25", "=", "%G0", "%", "23"});
            this.gotExpectedPass(this.uri.toString(), expected_value_1);
            this.uri = UriBuilder.fromPath((String)LOCALHOST).path("/{x}/{y}/{z}/{x}").buildFromEncoded(new Object[]{"xy", " ", "%"});
            this.gotExpectedPass(this.uri.toString(), expected_value_2);
        }
        catch (Exception ex) {
            this.pass = false;
            this.sb.append("Unexpected Exception thrown" + ex.getMessage());
        }
        this.assertPassAndLog();
    }

    @Test
    public void fromEncodedTest2() throws JAXRSCommonClient.Fault {
        try {
            this.uri = UriBuilder.fromPath((String)LOCALHOST).path("/{v}/{w}/{x}/{y}/{z}/{x}").buildFromEncoded(new Object[]{"a", "%25", "=", "%G0"});
            throw new JAXRSCommonClient.Fault("Expected IllegalArgumentException Not thrown. uri =" + this.uri.toString());
        }
        catch (IllegalArgumentException ilex) {
            TestUtil.logTrace("Expected IllegalArgumentException thrown");
            return;
        }
    }

    @Test
    public void fromEncodedTest3() throws JAXRSCommonClient.Fault {
        try {
            UriBuilder.fromPath((String)LOCALHOST).path("/{v}/{w}/{x}/{y}/{z}/{x}").buildFromEncoded(new Object[]{"a", "%25", null, "%G0"});
            throw new JAXRSCommonClient.Fault("Expected IllegalArgumentException Not thrown");
        }
        catch (IllegalArgumentException ilex) {
            TestUtil.logTrace("Expected IllegalArgumentException thrown");
            return;
        }
    }

    @Test
    public void queryParamTest1() throws JAXRSCommonClient.Fault {
        String name = null;
        try {
            UriBuilder.fromPath((String)LOCALHOST).queryParam(name, new Object[]{"x", "y"});
            throw new JAXRSCommonClient.Fault("Expected IllegalArgumentException Not thrown");
        }
        catch (IllegalArgumentException ilex) {
            TestUtil.logTrace("Expected IllegalArgumentException thrown");
            return;
        }
    }

    @Test
    public void queryParamTest2() throws JAXRSCommonClient.Fault {
        String name = "name";
        try {
            UriBuilder.fromPath((String)LOCALHOST).queryParam(name, new Object[]{null});
            throw new JAXRSCommonClient.Fault("Expected IllegalArgumentException Not thrown");
        }
        catch (IllegalArgumentException ilex) {
            TestUtil.logTrace("Expected IllegalArgumentException thrown");
            return;
        }
    }

    @Test
    public void queryParamTest3() throws JAXRSCommonClient.Fault {
        String name = "name";
        try {
            UriBuilder.fromPath((String)LOCALHOST).queryParam(name, new Object[]{"x", null});
            throw new JAXRSCommonClient.Fault("Expected IllegalArgumentException Not thrown");
        }
        catch (IllegalArgumentException ilex) {
            TestUtil.logTrace("Expected IllegalArgumentException thrown");
            return;
        }
    }

    @Test
    public void queryParamTest4() throws JAXRSCommonClient.Fault {
        String name = "name";
        String expected_value = "http://localhost:8080?name=x&name=y";
        try {
            this.uri = UriBuilder.fromPath((String)LOCALHOST).queryParam(name, new Object[]{"x", "y"}).build(new Object[0]);
            this.gotExpectedPass(this.uri.toString(), expected_value);
        }
        catch (Exception ex) {
            this.pass = false;
            this.sb.append("Unexpected Exception thrown" + ex.getMessage());
        }
        this.assertPassAndLog();
    }

    @Test
    public void queryParamTest5() throws JAXRSCommonClient.Fault {
        String name = "name";
        String actual = null;
        String expected_value = "http://localhost:8080?name=x%3D&name=y?&name=x+y&name=%26";
        try {
            this.uri = UriBuilder.fromPath((String)LOCALHOST).queryParam(name, new Object[]{"x=", "y?", "x y", "&"}).build(new Object[0]);
            actual = this.uri.toString().replace("%3F", "?").replace("%3f", "?");
            this.gotExpectedPass(actual, expected_value);
        }
        catch (Exception ex) {
            this.pass = false;
            this.sb.append("Unexpected Exception thrown" + ex.getMessage());
        }
        this.assertPassAndLog();
    }

    @Test
    public void replaceQueryTest1() throws JAXRSCommonClient.Fault {
        String name = "name";
        String expected_value = "http://localhost:8080?name1=xyz";
        try {
            this.uri = UriBuilder.fromPath((String)LOCALHOST).queryParam(name, new Object[]{"x=", "y?", "x y", "&"}).replaceQuery("name1=xyz").build(new Object[0]);
            this.gotExpectedPass(this.uri.toString(), expected_value);
        }
        catch (Exception ex) {
            this.pass = false;
            this.sb.append("Unexpected Exception thrown" + ex.getMessage());
        }
        this.assertPassAndLog();
    }

    @Test
    public void replaceQueryTest2() throws JAXRSCommonClient.Fault {
        String name = "name";
        try {
            this.uri = UriBuilder.fromPath((String)LOCALHOST).queryParam(name, new Object[]{"x=", "y?", "x y", "&"}).replaceQuery(null).build(new Object[0]);
            this.gotExpectedPass(this.uri.toString(), LOCALHOST);
        }
        catch (Exception ex) {
            this.pass = false;
            this.sb.append("Unexpected Exception thrown" + ex.getMessage());
        }
        this.assertPassAndLog();
    }

    @Test
    public void replaceQueryTest3() throws JAXRSCommonClient.Fault {
        String name = "name";
        String expected_value = "http://localhost:8080?name1=x&name2=%20&name3=x+y&name4=23&name5=x%20y";
        try {
            this.uri = UriBuilder.fromPath((String)LOCALHOST).queryParam(name, new Object[]{"x=", "y?", "x y", "&"}).replaceQuery("name1=x&name2=%20&name3=x+y&name4=23&name5=x y").build(new Object[0]);
            this.gotExpectedPass(this.uri.toString(), expected_value);
        }
        catch (Exception ex) {
            this.pass = false;
            this.sb.append("Unexpected Exception thrown" + ex.getMessage());
        }
        this.assertPassAndLog();
    }

    @Test
    @Disabled
    public void replaceQueryTest4() throws JAXRSCommonClient.Fault {
        String value = "http://localhost:8080?name1=x&name2=%20&name3=x+y&name4=x%20y";
        try {
            this.uri = UriBuilder.fromPath((String)value).replaceQuery("name$*()^@!+-]}[{|<>,./:;'#1==x?&name2=%20y").build(new Object[0]);
            this.pass = false;
            this.sb.append("Expected IllegalArgumentException not thrown");
            this.sb.append("uri=" + this.uri.getQuery());
        }
        catch (IllegalArgumentException ex) {
            this.sb.append("Expected IllegalArgumentException thrown");
        }
        catch (Exception ex1) {
            this.pass = false;
            this.sb.append("Wrong type Exception thrown" + ex1.getMessage());
        }
        this.assertPassAndLog();
    }

    @Test
    public void replaceQueryParamTest1() throws JAXRSCommonClient.Fault {
        String name = null;
        try {
            UriBuilder.fromPath((String)LOCALHOST).queryParam(name, new Object[]{"x", null});
            throw new JAXRSCommonClient.Fault("Expected IllegalArgumentException Not thrown");
        }
        catch (IllegalArgumentException ilex) {
            TestUtil.logTrace("Expected IllegalArgumentException thrown");
            return;
        }
    }

    @Test
    public void replaceQueryParamTest2() throws JAXRSCommonClient.Fault {
        String name = "name";
        try {
            this.uri = UriBuilder.fromPath((String)LOCALHOST).queryParam(name, new Object[]{"x=", "y?", "x y", "&"}).replaceQueryParam(name, (Object[])null).build(new Object[0]);
            this.gotExpectedPass(this.uri.toString(), LOCALHOST);
        }
        catch (Exception ex) {
            this.pass = false;
            this.sb.append("Unexpected Exception thrown" + ex.getMessage());
        }
        this.assertPassAndLog();
    }

    @Test
    public void replaceQueryParamTest3() throws JAXRSCommonClient.Fault {
        String name = "name";
        String expected_value = "http://localhost:8080?name=x&name=y&name=y+x&name=x%25y&name=%20";
        try {
            this.uri = UriBuilder.fromPath((String)LOCALHOST).queryParam(name, new Object[]{"x=", "y?", "x y", "&"}).replaceQueryParam(name, new Object[]{"x", "y", "y x", "x%y", "%20"}).build(new Object[0]);
            this.gotExpectedPass(this.uri.toString(), expected_value);
        }
        catch (Exception ex) {
            this.pass = false;
            this.sb.append("Unexpected Exception thrown" + ex.getMessage());
        }
        this.assertPassAndLog();
    }

    @Test
    public void segmentTest1() throws JAXRSCommonClient.Fault {
        Object path = null;
        try {
            UriBuilder.fromPath((String)"/").segment(new String[]{path}).build(new Object[0]);
            throw new JAXRSCommonClient.Fault("TestFailed: expected IllegalArgumentException not thrown.");
        }
        catch (IllegalArgumentException ex) {
            TestUtil.logTrace("Test Passed: Expected IllegalArgumentException thrown.");
            return;
        }
    }

    @Test
    public void segmentTest2() throws JAXRSCommonClient.Fault {
        String path1 = "";
        String[] path2 = new String[]{"a1", "/", "3b "};
        String expected_path = "a1/%2F/3b%20";
        try {
            this.uri = UriBuilder.fromPath((String)path1).segment(path2).build(new Object[0]);
            this.gotExpectedPass(this.uri.toString(), expected_path);
        }
        catch (Exception ex) {
            this.pass = false;
            this.sb.append("Unexpected Exception thrown" + ex.getMessage());
        }
        this.assertPassAndLog();
    }

    @Test
    public void segmentTest3() throws JAXRSCommonClient.Fault {
        String path1 = "ab";
        String[] path2 = new String[]{"a1", "x/y", "3b "};
        String expected_path = "ab/a1/x%2Fy/3b%20";
        try {
            this.uri = UriBuilder.fromPath((String)path1).segment(path2).build(new Object[0]);
            this.gotExpectedPass(this.uri.toString(), expected_path);
        }
        catch (Exception ex) {
            this.pass = false;
            this.sb.append("Unexpected Exception thrown" + ex.getMessage());
        }
        this.assertPassAndLog();
    }

    @Test
    public void uriBuilderExceptionTest1() throws JAXRSCommonClient.Fault {
        try {
            throw new UriBuilderException();
        }
        catch (UriBuilderException ube) {
            if (ube.getMessage() != "" && ube.getMessage() != null) {
                throw new JAXRSCommonClient.Fault("Test Failed.  Expecting empty message, Got " + ube.getMessage());
            }
            TestUtil.logTrace("Test Passed with empty message: " + ube.getMessage() + ".");
            return;
        }
    }

    @Test
    public void uriBuilderExceptionTest2() throws JAXRSCommonClient.Fault {
        String msg = "JAX-RS Test Message: xyz";
        try {
            throw new UriBuilderException(msg);
        }
        catch (UriBuilderException ube) {
            if (!msg.equals(ube.getMessage())) {
                throw new JAXRSCommonClient.Fault("Test Failed.  Expecting message," + msg + ", got " + ube.getMessage() + ".");
            }
            TestUtil.logTrace("Test Passed with correct message: " + ube.getMessage() + ".");
            return;
        }
    }

    @Test
    public void uriBuilderExceptionTest3() throws JAXRSCommonClient.Fault {
        String msg = "JAX-RS Test Message: xyz";
        String msg1 = "JAX-RS Test Message Again: xyz";
        try {
            throw new UriBuilderException(msg, (Throwable)new Exception(msg1));
        }
        catch (UriBuilderException ube) {
            if (!ube.getMessage().contains(msg)) {
                throw new JAXRSCommonClient.Fault("Test Failed.  Expecting message," + msg + ", got " + ube.getMessage() + ".");
            }
            TestUtil.logTrace("Test Passed with correct message: " + ube.getMessage() + ".");
            return;
        }
    }

    @Test
    public void uriBuilderExceptionTest4() throws JAXRSCommonClient.Fault {
        String msg = "JAX-RS Test Message Again: xyz";
        try {
            throw new UriBuilderException((Throwable)new Exception(msg));
        }
        catch (UriBuilderException ube) {
            if (!ube.getMessage().contains(msg)) {
                throw new JAXRSCommonClient.Fault("Test Failed.  Expecting message," + msg + ", got " + ube.getMessage() + ".");
            }
            TestUtil.logTrace("Test Passed with correct message: " + ube.getMessage() + ".");
            return;
        }
    }

    @Test
    public void cloneTest1() throws JAXRSCommonClient.Fault {
        String path1 = "test";
        String frag = "xyz";
        String expected_path_1 = "test#xyz";
        HashMap<String, String> maps = new HashMap<String, String>();
        maps.put("x", "x%yz");
        maps.put("y", "/path-absolute/%25test1");
        maps.put("z", "fred@example.com");
        maps.put("w", "path-rootless/test2");
        String expected_path_2 = "test/path-rootless%2Ftest2/x%25yz/%2Fpath-absolute%2F%2525test1/fred@example.com/x%25yz#xyz";
        try {
            UriBuilder ub = UriBuilder.fromPath((String)path1).fragment(frag);
            UriBuilder ub1 = ub.clone();
            this.uri = ub.build(new Object[0]);
            this.gotExpectedPass(this.uri.toString(), expected_path_1);
            URI uri1 = ub1.path("{w}/{x}/{y}/{z}/{x}").buildFromMap(maps);
            this.gotExpectedPass(uri1.toString(), expected_path_2);
        }
        catch (Exception ex) {
            this.pass = false;
            this.sb.append("Unexpected exception thrown: " + ex.getMessage());
        }
        this.assertPassAndLog();
    }

    @Test
    public void matrixParamTest1() throws JAXRSCommonClient.Fault {
        String name = null;
        try {
            UriBuilder.fromPath((String)LOCALHOST).matrixParam(name, new Object[]{"x", "y"});
            this.sb.append("Expected IllegalArgumentException Not thrown");
            this.pass = false;
        }
        catch (IllegalArgumentException ilex) {
            this.sb.append("Expected IllegalArgumentException thrown");
        }
        catch (Throwable th) {
            this.pass = false;
            this.sb.append("Incorrect Exception thrown: " + th.getMessage());
        }
        this.assertPassAndLog();
    }

    @Test
    public void matrixParamTest2() throws JAXRSCommonClient.Fault {
        String name = "name";
        try {
            UriBuilder.fromPath((String)LOCALHOST).matrixParam(name, new Object[]{null});
            this.sb.append("Expected IllegalArgumentException Not thrown");
            this.pass = false;
        }
        catch (IllegalArgumentException ilex) {
            this.sb.append("Expected IllegalArgumentException thrown");
        }
        catch (Throwable th) {
            this.pass = false;
            this.sb.append("Incorrect Exception thrown: " + th.getMessage());
        }
        this.assertPassAndLog();
    }

    @Test
    public void matrixParamTest3() throws JAXRSCommonClient.Fault {
        String name = "name";
        String expected_value = "http://localhost:8080;name=x;name=y";
        try {
            this.uri = UriBuilder.fromPath((String)LOCALHOST).matrixParam(name, new Object[]{"x", "y"}).build(new Object[0]);
            this.gotExpectedPass(this.uri.toString(), expected_value);
        }
        catch (Exception ex) {
            this.pass = false;
            this.sb.append("Unexpected Exception thrown" + ex.getMessage());
        }
        this.assertPassAndLog();
    }

    @Test
    public void replaceMatrixParamTest1() throws JAXRSCommonClient.Fault {
        String name = "name";
        try {
            UriBuilder.fromPath((String)LOCALHOST).matrixParam(name, new Object[]{"x=", "y?", "x y", "&"}).replaceMatrixParam(null, new Object[]{"x", "y"}).build(new Object[0]);
            this.pass = false;
            this.sb.append("Expected exception not thrown.");
        }
        catch (IllegalArgumentException ex) {
            this.sb.append("Expected exception thrown.");
        }
        catch (Throwable th) {
            this.pass = false;
            this.sb.append("Wrong type of  Exception thrown" + th.getMessage());
        }
        this.assertPassAndLog();
    }

    @Test
    public void replaceMatrixParamTest2() throws JAXRSCommonClient.Fault {
        String name = "name";
        try {
            this.uri = UriBuilder.fromPath((String)LOCALHOST).matrixParam(name, new Object[]{"x=", "y?", "x y", "&"}).replaceMatrixParam(name, new Object[0]).build(new Object[0]);
            this.gotExpectedPass(this.uri.toString(), LOCALHOST);
        }
        catch (Exception ex) {
            this.pass = false;
            this.sb.append("Unexpected Exception thrown" + ex.getMessage());
        }
        this.assertPassAndLog();
    }

    @Test
    public void replaceMatrixParamTest3() throws JAXRSCommonClient.Fault {
        String name = "name";
        String expected = "http://localhost:8080;name=x;name=y;name=y%20x;name=x%25y;name=%20";
        try {
            this.uri = UriBuilder.fromPath((String)"http://localhost:8080;name=x=;name=y?;name=x y;name=&").replaceMatrixParam(name, new Object[]{"x", "y", "y x", "x%y", "%20"}).build(new Object[0]);
            this.gotExpectedPass(this.uri.toString(), expected);
        }
        catch (Exception ex) {
            this.pass = false;
            this.sb.append("Unexpected Exception thrown" + ex.getMessage());
        }
        this.assertPassAndLog();
    }

    @Test
    public void replaceMatrixParamTest4() throws JAXRSCommonClient.Fault {
        String name = "name1";
        String expected = "http://localhost:8080;name=x=;name=y%3F;name=x%20y;name=&;name1=x;name1=y;name1=y%20x;name1=x%25y;name1=%20";
        try {
            this.uri = UriBuilder.fromPath((String)"http://localhost:8080;name=x=;name=y?;name=x y;name=&").replaceMatrixParam(name, new Object[]{"x", "y", "y x", "x%y", "%20"}).build(new Object[0]);
            this.gotExpectedPass(this.uri.toString(), expected);
        }
        catch (Exception ex) {
            this.pass = false;
            this.sb.append("Unexpected Exception thrown" + ex.getMessage());
        }
        this.assertPassAndLog();
    }

    @Test
    public void replaceMatrixTest1() throws JAXRSCommonClient.Fault {
        String name = "name";
        String expected1 = "http://localhost:8080;";
        try {
            this.uri = UriBuilder.fromPath((String)LOCALHOST).matrixParam(name, new Object[]{"x=", "y?", "x y", "&"}).replaceMatrix(null).build(new Object[0]);
            String sUri = this.uri.toString();
            boolean condition = sUri.compareToIgnoreCase(LOCALHOST) == 0 || sUri.compareToIgnoreCase(expected1) == 0;
            this.gotExpectedPass(!condition, sUri, LOCALHOST);
        }
        catch (Exception ex) {
            this.pass = false;
            this.sb.append("Unexpected Exception thrown" + ex.getMessage());
        }
        this.assertPassAndLog();
    }

    @Test
    public void replaceMatrixTest2() throws JAXRSCommonClient.Fault {
        String expected = "http://localhost:8080;name=x;name=y;name=y%20x;name=x%25y;name=%20";
        String value = "name=x;name=y;name=y x;name=x%y;name= ";
        try {
            this.uri = UriBuilder.fromPath((String)"http://localhost:8080;name=x=;name=y?;name=x y;name=&").replaceMatrix(value).build(new Object[0]);
            this.gotExpectedPass(this.uri.toString(), expected);
        }
        catch (Exception ex) {
            this.pass = false;
            this.sb.append("Unexpected Exception thrown" + ex.getMessage());
        }
        this.assertPassAndLog();
    }

    @Test
    public void replaceMatrixTest3() throws JAXRSCommonClient.Fault {
        String expected = "http://localhost:8080;name1=x;name1=y;name1=y%20x;name1=x%25y;name1=%20";
        String value = "name1=x;name1=y;name1=y x;name1=x%y;name1= ";
        try {
            this.uri = UriBuilder.fromPath((String)"http://localhost:8080;name=x=;name=y?;name=x y;name=&").replaceMatrix(value).build(new Object[0]);
            this.gotExpectedPass(this.uri.toString(), expected);
        }
        catch (Exception ex) {
            this.pass = false;
            this.sb.append("Unexpected Exception thrown" + ex.getMessage());
        }
        this.assertPassAndLog();
    }

    @Test
    public void userInfoTest() throws JAXRSCommonClient.Fault {
        String unexpected = "Unexpected user info:";
        String userInfo = "foo:foo";
        this.uri = UriBuilder.fromUri((String)LOCALHOST).build(new Object[0]);
        Assertions.assertTrue((this.uri.getUserInfo() == null ? 1 : 0) != 0, (String)(unexpected + this.uri.getUserInfo()));
        this.uri = UriBuilder.fromUri((String)LOCALHOST).userInfo(userInfo).build(new Object[0]);
        Assertions.assertTrue((boolean)this.uri.getRawUserInfo().equals(userInfo), (String)(unexpected + this.uri.getRawUserInfo()));
        System.out.println(this.uri.getRawUserInfo());
        this.uri = UriBuilder.fromUri((String)"http://foo2:foo2@localhost:8080").userInfo(userInfo).build(new Object[0]);
        System.out.println(this.uri.getRawUserInfo());
        Assertions.assertTrue((boolean)userInfo.equals(this.uri.getRawUserInfo()), (String)(unexpected + this.uri.getRawUserInfo()));
        this.uri = UriBuilder.fromPath((String)"").scheme("http").userInfo(userInfo).host("localhost").port(8080).build(new Object[0]);
        Assertions.assertTrue((boolean)this.uri.getRawUserInfo().equals(userInfo), (String)(unexpected + this.uri.getRawUserInfo()));
    }

    @Test
    public void buildObjectsBooleanEncodedTest() throws JAXRSCommonClient.Fault {
        Object[] s = new Object[]{"path-rootless/test2", new StringBuilder("x%yz"), "/path-absolute/%25test1", "fred@example.com"};
        this.uri = UriBuilder.fromPath((String)"").path("{v}/{w}/{x}/{y}/{w}").build(new Object[]{s[0], s[1], s[2], s[3], s[1]}, true);
        this.gotExpectedPass(this.uri.getRawPath(), ENCODED_EXPECTED_PATH);
        this.assertPassAndLog();
    }

    @Test
    public void buildObjectsBooleanNotEncodedTest() throws JAXRSCommonClient.Fault {
        Object[] s = new Object[]{new StringBuffer("path-rootless/test2"), "x%yz", "/path-absolute", "test1", "fred@example.com"};
        this.uri = UriBuilder.fromPath((String)"").path("{v}/{w}/{x}/{y}/{z}/{w}").build(new Object[]{s[0], s[1], s[2], s[3], s[4], s[1]}, false);
        this.gotExpectedPass(this.uri.getRawPath(), EXPECTED_PATH);
        this.assertPassAndLog();
    }

    @Test
    public void buildObjectsBooleanThrowsIAEWhenNoValueSuppliedTest() throws JAXRSCommonClient.Fault {
        try {
            this.uri = UriBuilder.fromPath((String)"").path("{v}/{w}").build(new Object[]{"first"}, false);
            JAXRSClientIT.fault("IllegalArgumentException has not been thrown, uri:", this.uri);
        }
        catch (IllegalArgumentException e) {
            JAXRSClientIT.logMsg("IllegalArgumentException has been thrown as expected", e);
        }
    }

    @Test
    public void buildObjectsBooleanThrowsIAEWhenValueIsNullTest() throws JAXRSCommonClient.Fault {
        try {
            this.uri = UriBuilder.fromPath((String)"").path("{v}/{w}").build(new Object[]{"first", null}, false);
            JAXRSClientIT.fault("IllegalArgumentException has not been thrown");
        }
        catch (IllegalArgumentException e) {
            JAXRSClientIT.logMsg("IllegalArgumentException has been thrown as expected", e);
        }
    }

    @Test
    public void buildFromMapWithBooleanSlashEncodedTest() throws JAXRSCommonClient.Fault {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("x", new StringBuilder("x%yz"));
        map.put("y", new StringBuffer("/path-absolute/%25test1"));
        map.put("z", new Object(){

            public String toString() {
                return "fred@example.com";
            }
        });
        map.put("w", "path-rootless/test2");
        UriBuilder builder = UriBuilder.fromPath((String)"").path("{w}/{x}/{y}/{z}/{x}");
        builder.buildFromMap(map, false);
        this.uri = builder.buildFromMap(map, true);
        this.gotExpectedPass(this.uri.getRawPath(), ENCODED_EXPECTED_PATH);
        this.assertPassAndLog();
    }

    @Test
    public void buildFromMapWithBooleanSlashNotEncodedTest() throws JAXRSCommonClient.Fault {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("x", new StringBuilder("x%yz"));
        map.put("y", new StringBuffer("/path-absolute/test1"));
        map.put("z", new Object(){

            public String toString() {
                return "fred@example.com";
            }
        });
        map.put("w", "path-rootless/test2");
        UriBuilder builder = UriBuilder.fromPath((String)"").path("{w}/{x}/{y}/{z}/{x}");
        this.uri = builder.buildFromMap(map, false);
        this.gotExpectedPass(this.uri.getRawPath(), EXPECTED_PATH);
        this.assertPassAndLog();
    }

    @Test
    public void buildFromMapWithBooleanThrowsIAEWhenNoSuppliedValueTest() throws JAXRSCommonClient.Fault {
        HashMap<String, CharSequence> map = new HashMap<String, CharSequence>();
        map.put("x", new StringBuilder("x%yz"));
        map.put("y", new StringBuffer("/path-absolute/test1"));
        map.put("w", "path-rootless/test2");
        UriBuilder builder = UriBuilder.fromPath((String)"").path("{w}/{x}/{y}/{z}/{x}");
        try {
            this.uri = builder.buildFromMap(map, false);
            JAXRSClientIT.fault("No exception has been thrown");
        }
        catch (IllegalArgumentException e) {
            JAXRSClientIT.logMsg("IllegalArgumentException has been thrown as expected");
        }
    }

    @Test
    public void buildFromMapWithBooleanThrowsIAEWhenNullValueTest() throws JAXRSCommonClient.Fault {
        HashMap<String, CharSequence> map = new HashMap<String, CharSequence>();
        map.put("x", new StringBuilder("x%yz"));
        map.put("y", new StringBuffer("/path-absolute/test1"));
        map.put("z", null);
        map.put("w", "path-rootless/test2");
        UriBuilder builder = UriBuilder.fromPath((String)"").path("{w}/{x}/{y}/{z}/{x}");
        try {
            this.uri = builder.buildFromMap(map, false);
            JAXRSClientIT.fault("No exception has been thrown");
        }
        catch (IllegalArgumentException e) {
            JAXRSClientIT.logMsg("IllegalArgumentException has been thrown as expected");
        }
    }

    @Test
    public void fromLinkTest() throws JAXRSCommonClient.Fault {
        URI uri = UriBuilder.fromUri((String)LOCALHOST).build(new Object[0]);
        Link link = Link.fromUri((URI)uri).build(new Object[0]);
        URI uri2 = UriBuilder.fromLink((Link)link).build(new Object[0]);
        Assertions.assertTrue((boolean)uri.equals(uri2), (String)("URI" + uri + "and" + uri2 + "are not equal"));
        JAXRSClientIT.logMsg("URI fromLink is equal to the expected URI");
    }

    @Test
    public void fromLinkThrowsIllegalArgumentExceptionTest() throws JAXRSCommonClient.Fault {
        try {
            UriBuilder.fromLink((Link)null);
            throw new JAXRSCommonClient.Fault("IllegalArgumentException has not been thrown");
        }
        catch (IllegalArgumentException e) {
            JAXRSClientIT.logMsg("IllegalArgumentException has been thrown as expected");
            return;
        }
    }

    @Test
    public void fromMethodTest() throws JAXRSCommonClient.Fault {
        URI uri = UriBuilder.fromMethod(TestPath.class, (String)"headSub").build(new Object[0]);
        Assertions.assertTrue((boolean)uri.toASCIIString().equals("/sub"), (String)"There is no /sub in the URI");
        JAXRSClientIT.logMsg("URI fromMethod is equal to the expected URI", uri);
    }

    @Test
    public void fromMethodThrowsIllegalArgumentExceptionWhenMorePathsTest() throws JAXRSCommonClient.Fault {
        try {
            UriBuilder.fromMethod(TestPath.class, (String)"test1");
            throw new JAXRSCommonClient.Fault("IllegalArgumentException has not been thrown");
        }
        catch (IllegalArgumentException e) {
            JAXRSClientIT.logMsg("IllegalArgumentException has been sucessfully thrown", e);
            return;
        }
    }

    @Test
    public void fromMethodThrowsIllegalArgumentExceptionWhenNoPathTest() throws JAXRSCommonClient.Fault {
        try {
            UriBuilder.fromMethod(TestPath.class, (String)"getPlain");
            throw new JAXRSCommonClient.Fault("IllegalArgumentException has not been thrown");
        }
        catch (IllegalArgumentException e) {
            JAXRSClientIT.logMsg("IllegalArgumentException has been sucessfully thrown", e);
            return;
        }
    }

    @Test
    public void toTemplateTest() throws JAXRSCommonClient.Fault {
        String template = "{v}/{w}/{x}/{y}/{w}";
        UriBuilder builder = UriBuilder.fromPath((String)"").path(template);
        JAXRSClientIT.assertEquals(template, builder.toTemplate(), "Given template", template, "differs from obtain", builder.toTemplate());
        JAXRSClientIT.logMsg("Got expected template", template);
    }

    @Test
    public void uriStringTest() throws JAXRSCommonClient.Fault {
        String[] origUris = JAXRSClientIT.getOrigUris();
        URI[] replaceUris = JAXRSClientIT.getReplacementUris();
        String[] expectUris = JAXRSClientIT.getExpectedUris();
        int failed = 0;
        int passed = 0;
        for (int cnt = 0; cnt < 17; ++cnt) {
            try {
                this.sb.append("Replace uri ").append(origUris[cnt]).append(" with ").append(replaceUris[cnt].toASCIIString()).append(newline);
                this.uri = UriBuilder.fromUri((URI)new URI(origUris[cnt])).uri(replaceUris[cnt].toASCIIString()).build(new Object[0]);
                if (this.gotExpectedPass(this.uri.toString().trim(), expectUris[cnt]) != 0) {
                    ++failed;
                    continue;
                }
                ++passed;
                continue;
            }
            catch (Exception ex) {
                this.pass = false;
                this.sb.append("Unexpected exception thrown: ").append(ex.getMessage()).append(newline);
                this.sb.append("Test failed with exception for expected uri: ").append(expectUris[cnt]).append(newline);
                ++failed;
            }
        }
        Assertions.assertTrue((boolean)this.pass, (String)(passed + "assertion passed." + newline + failed + "assertion(s) failed:" + this.sb.toString() + newline));
    }

    @Test
    public void uriStringThrowsIAEWhenNullTest() throws JAXRSCommonClient.Fault {
        try {
            UriBuilder.fromMethod(TestPath.class, (String)"headSub").uri((String)null);
            throw new JAXRSCommonClient.Fault("No Exception has been thrown for #uri(null)");
        }
        catch (IllegalArgumentException e) {
            JAXRSClientIT.logMsg("#IllegalArgumentException has been thrown as expected for #uri(null)");
            return;
        }
    }

    @Test
    public void uriStringThrowsIAEWhenNoUriTest() throws JAXRSCommonClient.Fault {
        String sUri = "://";
        try {
            this.uri = UriBuilder.fromUri((URI)new URI("news//:comp.lang.java")).uri(sUri).build(new Object[0]);
            JAXRSClientIT.fault("No Exception has been thrown for #uri(noURI)", this.uri);
        }
        catch (IllegalArgumentException e) {
            JAXRSClientIT.logMsg("#IllegalArgumentException has been thrown as expected for #uri(noURI)");
        }
        catch (URISyntaxException e) {
            throw new JAXRSCommonClient.Fault(e);
        }
    }

    @Test
    public void resolveTemplateStringObjectTest() throws JAXRSCommonClient.Fault {
        String template = "{v}/{w}/{x}/{y}/{w}";
        UriBuilder builder = UriBuilder.fromPath((String)"").path(template).resolveTemplate("v", (Object)new StringBuilder("aaa"));
        String resolvedTemplate = template.replace("{v}", "aaa");
        String builderTemplate = builder.toTemplate();
        JAXRSClientIT.assertEquals(resolvedTemplate, builderTemplate, "Given template", template, "was not resolved correctly, remains", builderTemplate);
        JAXRSClientIT.logMsg("Got expected template", template);
    }

    @Test
    public void resolveTemplateStringObjectThrowsIAEOnNullNameTest() throws JAXRSCommonClient.Fault {
        String template = "{v}/{w}/{x}/{y}/{w}";
        UriBuilder builder = UriBuilder.fromPath((String)"").path(template);
        try {
            builder.resolveTemplate(null, (Object)"aaa");
            JAXRSClientIT.fault("No exception has been thrown");
        }
        catch (IllegalArgumentException e) {
            JAXRSClientIT.logMsg("IllegalArgumentException has been thrown as expected", e);
        }
    }

    @Test
    public void resolveTemplateStringObjectThrowsIAEOnNullValueTest() throws JAXRSCommonClient.Fault {
        String template = "{v}/{w}/{x}/{y}/{w}";
        UriBuilder builder = UriBuilder.fromPath((String)"").path(template);
        try {
            builder.resolveTemplate("v", null);
            JAXRSClientIT.fault("No exception has been thrown");
        }
        catch (IllegalArgumentException e) {
            JAXRSClientIT.logMsg("IllegalArgumentException has been thrown as expected", e);
        }
    }

    @Test
    public void resolveTemplateStringObjectBooleanSlashEncodedTest() throws JAXRSCommonClient.Fault {
        String template = "{v}/{w}/{x}/{y}/{w}";
        UriBuilder builder = UriBuilder.fromPath((String)"").path(template).resolveTemplate("v", (Object)new StringBuilder("a/a/a"), true);
        String resolvedTemplate = template.replace("{v}", "a%2Fa%2Fa");
        String builderTemplate = builder.toTemplate().replace("%2f", "%2F");
        JAXRSClientIT.assertEquals(resolvedTemplate, builderTemplate, "Given template", template, "was not resolved correctly, remains", builderTemplate);
        JAXRSClientIT.logMsg("Got expected template", template);
    }

    @Test
    public void resolveTemplateStringObjectBooleanSlashNotEncodedTest() throws JAXRSCommonClient.Fault {
        String template = "{v}/{w}/{x}/{y}/{w}";
        UriBuilder builder = UriBuilder.fromPath((String)"").path(template).resolveTemplate("v", (Object)new StringBuilder("a/a/a"), false);
        String resolvedTemplate = template.replace("{v}", "a/a/a");
        String builderTemplate = builder.toTemplate();
        JAXRSClientIT.assertEquals(resolvedTemplate, builderTemplate, "Given template", template, "was not resolved correctly, remains", builderTemplate);
        JAXRSClientIT.logMsg("Got expected template", template);
    }

    @Test
    public void resolveTemplateStringObjectBooleanThrowsIAEOnNullNameTest() throws JAXRSCommonClient.Fault {
        String template = "{v}/{w}/{x}/{y}/{w}";
        UriBuilder builder = UriBuilder.fromPath((String)"").path(template);
        try {
            builder.resolveTemplate(null, (Object)"aaa", false);
            JAXRSClientIT.fault("No exception has been thrown");
        }
        catch (IllegalArgumentException e) {
            JAXRSClientIT.logMsg("IllegalArgumentException has been thrown as expected", e);
        }
    }

    @Test
    public void resolveTemplateStringObjectBooleanThrowsIAEOnNullValueTest() throws JAXRSCommonClient.Fault {
        String template = "{v}/{w}/{x}/{y}/{w}";
        UriBuilder builder = UriBuilder.fromPath((String)"").path(template);
        try {
            builder.resolveTemplate("v", null, false);
            JAXRSClientIT.fault("No exception has been thrown");
        }
        catch (IllegalArgumentException e) {
            JAXRSClientIT.logMsg("IllegalArgumentException has been thrown as expected", e);
        }
    }

    @Test
    public void resolveTemplateFromEncodedTest() throws JAXRSCommonClient.Fault {
        Object[] s = new Object[]{"path-rootless%2Ftest2", new StringBuilder("x%25yz"), "%2Fpath-absolute%2F%2525test1", "fred@example.com"};
        UriBuilder builder = UriBuilder.fromPath((String)"").path("{v}/{w}/{x}/{y}/{w}");
        builder = builder.resolveTemplateFromEncoded("v", s[0]);
        builder = builder.resolveTemplateFromEncoded("w", s[1]);
        builder = builder.resolveTemplateFromEncoded("x", s[2]);
        builder = builder.resolveTemplateFromEncoded("y", s[3]);
        this.uri = builder.build(new Object[0]);
        this.gotExpectedPass(this.uri.getRawPath(), ENCODED_EXPECTED_PATH);
        this.assertPassAndLog();
    }

    @Test
    public void resolveTemplateFromEncodedPercentEncodedTest() throws JAXRSCommonClient.Fault {
        Object[] s = new Object[]{"path-rootless%2Ftest2", new StringBuilder("x%yz"), "%2Fpath-absolute%2F%2525test1", "fred@example.com"};
        UriBuilder builder = UriBuilder.fromPath((String)"").path("{v}/{w}/{x}/{y}/{w}");
        builder = builder.resolveTemplateFromEncoded("v", s[0]);
        builder = builder.resolveTemplateFromEncoded("w", s[1]);
        builder = builder.resolveTemplateFromEncoded("x", s[2]);
        builder = builder.resolveTemplateFromEncoded("y", s[3]);
        this.uri = builder.build(new Object[0]);
        this.gotExpectedPass(this.uri.getRawPath(), ENCODED_EXPECTED_PATH);
        this.assertPassAndLog();
    }

    @Test
    public void resolveTemplateFromEncodedThrowsNullOnNullNameTest() throws JAXRSCommonClient.Fault {
        Object[] s = new Object[]{"path-rootless%2Ftest2", new StringBuilder("x%25yz"), "%2Fpath-absolute%2F%2525test1", "fred@example.com"};
        UriBuilder builder = UriBuilder.fromPath((String)"").path("{v}/{w}/{x}/{y}/{w}");
        try {
            builder.resolveTemplateFromEncoded(null, s[0]);
            JAXRSClientIT.fault("No exception has been thrown");
        }
        catch (IllegalArgumentException e) {
            JAXRSClientIT.logMsg("IllegalArgumentException thrown as expected", e);
        }
    }

    @Test
    public void resolveTemplateFromEncodedThrowsNullOnNullValueTest() throws JAXRSCommonClient.Fault {
        UriBuilder builder = UriBuilder.fromPath((String)"").path("{v}/{w}/{x}/{y}/{w}");
        try {
            builder.resolveTemplateFromEncoded("v", null);
            JAXRSClientIT.fault("No exception has been thrown");
        }
        catch (IllegalArgumentException e) {
            JAXRSClientIT.logMsg("IllegalArgumentException thrown as expected", e);
        }
    }

    @Test
    public void resolveTemplatesMapTest() throws JAXRSCommonClient.Fault {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("x", new StringBuilder("x%yz"));
        map.put("y", new StringBuffer("/path-absolute/%25test1"));
        map.put("z", new Object(){

            public String toString() {
                return "fred@example.com";
            }
        });
        map.put("w", "path-rootless/test2");
        UriBuilder builder = UriBuilder.fromPath((String)"").path("{w}/{x}/{y}/{z}/{x}");
        this.uri = builder.resolveTemplates(map).build(new Object[0]);
        this.gotExpectedPass(this.uri.getRawPath(), ENCODED_EXPECTED_PATH);
        this.assertPassAndLog();
    }

    @Test
    public void resolveTemplatesMapThrowsIAEOnNullNameTest() throws JAXRSCommonClient.Fault {
        HashMap<String, CharSequence> map = new HashMap<String, CharSequence>();
        map.put("a", new StringBuilder("x%yz"));
        map.put(null, "path-rootless/test2");
        UriBuilder builder = UriBuilder.fromPath((String)"").path("{a}/{b}");
        try {
            builder.resolveTemplates(map);
            JAXRSClientIT.fault("IllegalArgumentException has not been thrown");
        }
        catch (IllegalArgumentException e) {
            JAXRSClientIT.logMsg("IllegalArgumentException has been thrown as expected", e);
        }
    }

    @Test
    public void resolveTemplatesMapThrowsIAEOnNullValueTest() throws JAXRSCommonClient.Fault {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("a", null);
        map.put("b", "path-rootless/test2");
        UriBuilder builder = UriBuilder.fromPath((String)"").path("{a}/{b}");
        try {
            builder.resolveTemplates(map);
            JAXRSClientIT.fault("IllegalArgumentException has not been thrown");
        }
        catch (IllegalArgumentException e) {
            JAXRSClientIT.logMsg("IllegalArgumentException has been thrown as expected", e);
        }
    }

    @Test
    public void resolveTemplatesMapBooleanSlashEncodedTest() throws JAXRSCommonClient.Fault {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("x", new StringBuilder("x%yz"));
        map.put("y", new StringBuffer("/path-absolute/%25test1"));
        map.put("z", new Object(){

            public String toString() {
                return "fred@example.com";
            }
        });
        map.put("w", "path-rootless/test2");
        UriBuilder builder = UriBuilder.fromPath((String)"").path("{w}/{x}/{y}/{z}/{x}");
        this.uri = builder.resolveTemplates(map, true).build(new Object[0]);
        this.gotExpectedPass(this.uri.getRawPath(), ENCODED_EXPECTED_PATH);
        this.assertPassAndLog();
    }

    @Test
    public void resolveTemplatesMapBooleanSlashNotEncodedTest() throws JAXRSCommonClient.Fault {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("x", new StringBuilder("x%yz"));
        map.put("y", new StringBuffer("/path-absolute/test1"));
        map.put("z", new Object(){

            public String toString() {
                return "fred@example.com";
            }
        });
        map.put("w", "path-rootless/test2");
        UriBuilder builder = UriBuilder.fromPath((String)"").path("{w}/{x}/{y}/{z}/{x}");
        this.uri = builder.resolveTemplates(map, false).build(new Object[0]);
        this.gotExpectedPass(this.uri.getRawPath(), EXPECTED_PATH);
        this.assertPassAndLog();
    }

    @Test
    public void resolveTemplatesMapBooleanThrowsIAEOnNullNameTest() throws JAXRSCommonClient.Fault {
        HashMap<String, CharSequence> map = new HashMap<String, CharSequence>();
        map.put("a", new StringBuilder("x%yz"));
        map.put(null, "path-rootless/test2");
        UriBuilder builder = UriBuilder.fromPath((String)"").path("{a}/{b}");
        try {
            builder.resolveTemplates(map, true);
            JAXRSClientIT.fault("IllegalArgumentException has not been thrown");
        }
        catch (IllegalArgumentException e) {
            JAXRSClientIT.logMsg("IllegalArgumentException has been thrown as expected", e);
        }
    }

    @Test
    public void resolveTemplatesMapBooleanThrowsIAEOnNullValueTest() throws JAXRSCommonClient.Fault {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("a", null);
        map.put("b", "path-rootless/test2");
        UriBuilder builder = UriBuilder.fromPath((String)"").path("{a}/{b}");
        try {
            builder.resolveTemplates(map, false);
            JAXRSClientIT.fault("IllegalArgumentException has not been thrown");
        }
        catch (IllegalArgumentException e) {
            JAXRSClientIT.logMsg("IllegalArgumentException has been thrown as expected", e);
        }
    }

    @Test
    public void resolveTemplatesMapBooleanThrowsIAEOnNullMapTest() throws JAXRSCommonClient.Fault {
        UriBuilder builder = UriBuilder.fromPath((String)"").path("{a}/{b}");
        try {
            builder.resolveTemplates((Map)null, false);
            JAXRSClientIT.fault("IllegalArgumentException has not been thrown");
        }
        catch (IllegalArgumentException e) {
            JAXRSClientIT.logMsg("IllegalArgumentException has been thrown as expected", e);
        }
    }

    @Test
    public void resolveTemplatesFromEncodedTest() throws JAXRSCommonClient.Fault {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("v", new StringBuilder("path-rootless%2Ftest2"));
        map.put("w", new StringBuilder("x%25yz"));
        map.put("x", new Object(){

            public String toString() {
                return "%2Fpath-absolute%2F%2525test1";
            }
        });
        map.put("y", "fred@example.com");
        UriBuilder builder = UriBuilder.fromPath((String)"").path("{v}/{w}/{x}/{y}/{w}");
        builder = builder.resolveTemplatesFromEncoded(map);
        this.uri = builder.build(new Object[0]);
        this.gotExpectedPass(this.uri.getRawPath(), ENCODED_EXPECTED_PATH);
        this.assertPassAndLog();
    }

    @Test
    public void resolveTemplatesFromEncodedPercentEncodedTest() throws JAXRSCommonClient.Fault {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("v", new StringBuilder("path-rootless%2Ftest2"));
        map.put("w", new StringBuilder("x%yz"));
        map.put("x", new Object(){

            public String toString() {
                return "%2Fpath-absolute%2F%2525test1";
            }
        });
        map.put("y", "fred@example.com");
        UriBuilder builder = UriBuilder.fromPath((String)"").path("{v}/{w}/{x}/{y}/{w}");
        builder = builder.resolveTemplatesFromEncoded(map);
        this.uri = builder.build(new Object[0]);
        this.gotExpectedPass(this.uri.getRawPath(), ENCODED_EXPECTED_PATH);
        this.assertPassAndLog();
    }

    @Test
    public void resolveTemplatesFromEncodedThrowsNullOnNullNameTest() throws JAXRSCommonClient.Fault {
        HashMap<Object, String> map = new HashMap<Object, String>();
        map.put(null, "aa");
        UriBuilder builder = UriBuilder.fromPath((String)"").path("{v}/{w}/{x}/{y}/{w}");
        try {
            builder.resolveTemplatesFromEncoded(map);
            JAXRSClientIT.fault("No exception has been thrown");
        }
        catch (IllegalArgumentException e) {
            JAXRSClientIT.logMsg("IllegalArgumentException thrown as expected", e);
        }
    }

    @Test
    public void resolveTemplatesFromEncodedThrowsNullOnNullValueTest() throws JAXRSCommonClient.Fault {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("v", null);
        UriBuilder builder = UriBuilder.fromPath((String)"").path("{v}/{w}/{x}/{y}/{w}");
        try {
            builder.resolveTemplatesFromEncoded(map);
            JAXRSClientIT.fault("No exception has been thrown");
        }
        catch (IllegalArgumentException e) {
            JAXRSClientIT.logMsg("IllegalArgumentException thrown as expected", e);
        }
    }

    @Test
    public void resolveTemplatesFromEncodedThrowsNullOnNullMapTest() throws JAXRSCommonClient.Fault {
        UriBuilder builder = UriBuilder.fromPath((String)"").path("{v}/{w}/{x}/{y}/{w}");
        try {
            builder.resolveTemplatesFromEncoded((Map)null);
            JAXRSClientIT.fault("No exception has been thrown");
        }
        catch (IllegalArgumentException e) {
            JAXRSClientIT.logMsg("IllegalArgumentException thrown as expected", e);
        }
    }

    private int gotExpectedPass(String got, String expected) {
        int compare = (got = got.replace("%2f", "%2F")).compareToIgnoreCase(expected);
        this.gotExpectedPass(compare != 0, got, expected);
        return compare;
    }

    private boolean gotExpectedPass(boolean conditionFalse, String got, String expected) {
        if (conditionFalse) {
            this.pass = false;
            this.sb.append("Incorrect URI returned: ").append(got);
            this.sb.append(", expecting ").append(expected);
        } else {
            this.sb.append("Got expected return: ").append(expected);
        }
        this.sb.append(newline);
        return conditionFalse;
    }

    private void assertPassAndLog() throws JAXRSCommonClient.Fault {
        Assertions.assertTrue((boolean)this.pass, (String)("At least one assertion failed:" + this.sb.toString()));
        TestUtil.logTrace(this.sb.toString());
    }

    private static String[] getOrigUris() {
        String[] uris_orig = new String[]{"ftp://ftp.is.co.za/rfc/rfc1808.txt", "ftp://ftp.is.co.za/rfc/rfc1808.txt", "mailto:java-net@java.sun.com", "mailto:java-net@java.sun.com", "news:comp.lang.java", "news:comp.lang.java", "urn:isbn:096139210x", "http://www.ietf.org/rfc/rfc2396.txt", "http://www.ietf.org/rfc/rfc2396.txt", "ldap://[2001:db8::7]/c=GB?objectClass?one", "ldap://[2001:db8::7]/c=GB?objectClass?one", "tel:+1-816-555-1212", "tel:+1-816-555-1212", "telnet://192.0.2.16:80/", "telnet://192.0.2.16:80/", "foo://example.com:8042/over/there?name=ferret#nose", "foo://example.com:8042/over/there?name=ferret#nose"};
        return uris_orig;
    }

    private static URI[] getReplacementUris() throws JAXRSCommonClient.Fault {
        URI[] uris_replace = new URI[]{null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null};
        try {
            uris_replace[0] = new URI("http", "//ftp.is.co.za/rfc/rfc1808.txt", null);
            uris_replace[1] = new URI(null, "ftp.is.co.za", "/test/rfc1808.txt", null, null);
            uris_replace[2] = new URI("mailto", "java-net@java.sun.com", null);
            uris_replace[3] = new URI(null, "testuser@sun.com", null);
            uris_replace[4] = new URI("http", "//comp.lang.java", null);
            uris_replace[5] = new URI(null, "news.lang.java", null);
            uris_replace[6] = new URI("urn:isbn:096139210x");
            uris_replace[7] = new URI(null, "//www.ietf.org/rfc/rfc2396.txt", null);
            uris_replace[8] = new URI(null, "www.ietf.org", "/rfc/rfc2396.txt", null, null);
            uris_replace[9] = new URI("ldap", "//[2001:db8::7]/c=GB?objectClass?one", null);
            uris_replace[10] = new URI(null, "//[2001:db8::7]/c=GB?objectClass?one", null);
            uris_replace[11] = new URI("tel", "+1-816-555-1212", null);
            uris_replace[12] = new URI(null, "+1-866-555-1212", null);
            uris_replace[13] = new URI("telnet", "//192.0.2.16:80/", null);
            uris_replace[14] = new URI(null, "//192.0.2.16:81/", null);
            uris_replace[15] = new URI("http", "//example.com:8042/over/there?name=ferret", null);
            uris_replace[16] = new URI(null, "//example.com:8042/over/there?name=ferret", "mouth");
        }
        catch (Exception ex) {
            throw new JAXRSCommonClient.Fault("========== Exception thrown constructing replacing URIs: " + ex.getMessage() + newline);
        }
        return uris_replace;
    }

    private static String[] getExpectedUris() {
        String[] uris_expect = new String[]{"http://ftp.is.co.za/rfc/rfc1808.txt", "ftp://ftp.is.co.za/test/rfc1808.txt", "mailto:java-net@java.sun.com", "mailto:testuser@sun.com", "http://comp.lang.java", "news:news.lang.java", "urn:isbn:096139210x", "http://www.ietf.org/rfc/rfc2396.txt", "http://www.ietf.org/rfc/rfc2396.txt", "ldap://[2001:db8::7]/c=GB?objectClass?one", "ldap://[2001:db8::7]/c=GB?objectClass?one", "tel:+1-816-555-1212", "tel:+1-866-555-1212", "telnet://192.0.2.16:80/", "telnet://192.0.2.16:81/", "http://example.com:8042/over/there?name=ferret#nose", "foo://example.com:8042/over/there?name=ferret#mouth"};
        return uris_expect;
    }
}

