/*
 * Decompiled with CFR 0.152.
 */
package jakarta.mvc.tck.tests.security.csrf.base;

import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import jakarta.mvc.tck.tests.security.csrf.base.CsrfBaseController;
import jakarta.mvc.tck.util.Archives;
import jakarta.mvc.tck.util.MvcMatchers;
import java.io.IOException;
import java.net.URL;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
@SpecVersion(spec="mvc", version="1.0")
public class CsrfBaseTest {
    @ArquillianResource
    private URL baseUrl;
    private WebClient webClient;

    @Deployment(testable=false)
    public static WebArchive createDeployment() {
        return Archives.getMvcArchive().addClass(CsrfBaseController.class).addView("csrf/base/base.jsp").build();
    }

    @Before
    public void before() {
        this.webClient = new WebClient();
        this.webClient.getOptions().setThrowExceptionOnFailingStatusCode(false);
        this.webClient.getOptions().setRedirectEnabled(false);
    }

    @Test
    @SpecAssertion(section="cross-site-request-forgery", id="csrf-obj")
    public void csrfInstanceViaContext() throws IOException {
        HtmlPage page = (HtmlPage)this.webClient.getPage(this.baseUrl.toString() + "mvc/csrf/base");
        Assert.assertThat((Object)page.getWebResponse().getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
        Assert.assertThat((Object)page.getElementById("csrf-injected").getTextContent(), (Matcher)CoreMatchers.equalTo((Object)"true"));
    }

    @Test
    @SpecAssertion(section="cross-site-request-forgery", id="csrf-obj")
    public void csrfInstanceViaEL() throws IOException {
        HtmlPage page = (HtmlPage)this.webClient.getPage(this.baseUrl.toString() + "mvc/csrf/base");
        Assert.assertThat((Object)page.getWebResponse().getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
        Assert.assertThat((Object)page.getElementById("csrf-el").getTextContent(), (Matcher)CoreMatchers.equalTo((Object)"true"));
    }

    @Test
    @SpecAssertion(section="cross-site-request-forgery", id="csrf-hidden-field")
    public void canInjectTokenIntoHiddenField() throws IOException {
        HtmlPage page = (HtmlPage)this.webClient.getPage(this.baseUrl.toString() + "mvc/csrf/base");
        Assert.assertThat((Object)page.getWebResponse().getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
        DomElement inputHidden = page.getElementById("token");
        Assert.assertNotNull((String)"Hidden input not found", (Object)inputHidden);
        Assert.assertThat((Object)inputHidden.getAttribute("name"), MvcMatchers.isNotBlank());
        Assert.assertThat((Object)inputHidden.getAttribute("value"), MvcMatchers.isNotBlank());
    }

    @Test
    @SpecAssertion(section="cross-site-request-forgery", id="csrf-inject-header")
    public void tokenIsProvidedViaElAndResponseHeader() throws IOException {
        HtmlPage page = (HtmlPage)this.webClient.getPage(this.baseUrl.toString() + "mvc/csrf/base");
        Assert.assertThat((Object)page.getWebResponse().getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
        DomElement hiddenField = page.getElementById("token");
        String hiddenFieldValue = hiddenField.getAttribute("value");
        Assert.assertThat((Object)hiddenFieldValue, MvcMatchers.isNotBlank());
        String headerValue = page.getWebResponse().getResponseHeaderValue("X-CSRF-TOKEN");
        Assert.assertThat((Object)headerValue, MvcMatchers.isNotBlank());
        Assert.assertThat((Object)headerValue, (Matcher)CoreMatchers.equalTo((Object)hiddenFieldValue));
    }
}

