/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.javatest.exec.ExecModel;
import com.sun.javatest.exec.FilesPane;
import com.sun.javatest.exec.ReportHandler;
import com.sun.javatest.tool.ToolAction;
import com.sun.javatest.tool.ToolDialog;
import com.sun.javatest.tool.UIFactory;
import java.awt.AWTEvent;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;

class ReportBrowser
extends ToolDialog {
    private ExecModel model;
    private ReportHandler reportHandler;
    private FilesPane fp;
    private File reportFile;

    public ReportBrowser(JComponent parent, ExecModel model, UIFactory uif, ReportHandler rh) {
        super(parent, uif, "rb");
        this.model = model;
        this.reportHandler = rh;
    }

    void show(File f) {
        try {
            this.setSelectedFile(f);
            this.setVisible(true);
        }
        catch (IOException e) {
            this.uif.showError("rb.load.error", new Object[]{f, e});
        }
    }

    void setSelectedFile(File f) throws IOException {
        if (f == null) {
            throw new NullPointerException();
        }
        this.reportFile = f;
        this.setI18NTitle("rb.title", f);
        if (this.fp == null) {
            this.initGUI();
        }
        this.fp.setBaseDirectory(f);
        this.fp.setFile(f.toURL());
    }

    File getSelectedFile() {
        return this.reportFile;
    }

    @Override
    protected void initGUI() {
        this.setHelp("report.reportBrowser.csh");
        this.fp = new FilesPane(this.uif);
        int dpi = this.uif.getDotsPerInch();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int prefWidth = Math.min(7 * dpi, screenSize.width * 9 / 10);
        int prefHeight = Math.min(9 * dpi, screenSize.height * 9 / 10);
        this.fp.setPreferredSize(new Dimension(prefWidth, prefHeight));
        this.setBody(this.fp);
        JMenuBar menuBar = this.uif.createMenuBar("rb.menubar");
        menuBar.add(this.createFileMenu(this.reportHandler));
        menuBar.add(this.uif.createHorizontalGlue("rb.pad"));
        menuBar.add(this.createHelpMenu());
        this.setJMenuBar(menuBar);
        if (this.reportFile == null) {
            this.setI18NTitle("rb.title");
        } else {
            this.setI18NTitle("rb.title_file", this.reportFile);
            this.fp.setBaseDirectory(this.reportFile);
            try {
                this.fp.setFile(this.reportFile.toURL());
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        this.setDefaultCloseOperation(0);
    }

    private JMenu createFileMenu(ReportHandler reportHandler) {
        Action newReport = reportHandler.getNewReportAction();
        Action openReport = reportHandler.getOpenReportAction();
        ToolAction printSetup = new ToolAction(this.uif, "rb.file.printSetup"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReportBrowser.this.model.printSetup();
            }
        };
        ToolAction print = new ToolAction(this.uif, "rb.file.print"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReportBrowser.this.model.print(ReportBrowser.this.fp);
            }
        };
        ToolAction close = new ToolAction(this.uif, "rb.file.close"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReportBrowser.this.setVisible(false);
                ReportBrowser.this.cleanup();
            }
        };
        Action[] actions = new Action[]{newReport, openReport, null, printSetup, print, null, close};
        JMenu fileMenu = this.uif.createMenu("rb.file", actions);
        return fileMenu;
    }

    private JMenu createHelpMenu() {
        JMenu helpMenu = this.uif.createMenu("rb.help");
        JMenuItem rbItem = this.uif.createHelpMenuItem("rb.help.rb", "report.reportBrowser.csh");
        helpMenu.add(rbItem);
        return helpMenu;
    }

    @Override
    protected void windowClosingAction(AWTEvent e) {
        this.setVisible(false);
        this.cleanup();
    }

    private void cleanup() {
        this.fp.clear();
    }
}

