/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config;

import io.helidon.common.LazyValue;
import io.helidon.common.NativeImageHelper;
import io.helidon.config.FileSystemWatcher;
import io.helidon.config.PollingStrategies;
import io.helidon.config.spi.ChangeEventType;
import io.helidon.config.spi.PollingStrategy;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class MutabilitySupport {
    private static final Logger LOGGER = Logger.getLogger(MutabilitySupport.class.getName());
    private static final LazyValue<ScheduledExecutorService> EXECUTOR = LazyValue.create(Executors::newSingleThreadScheduledExecutor);

    private MutabilitySupport() {
    }

    public static Runnable poll(Path path, Duration duration, Consumer<Path> updater, Consumer<Path> cleaner) {
        if (NativeImageHelper.isBuildTime()) {
            LOGGER.info("File polling is not enabled in native image build time. Path: " + path);
        }
        PollingStrategy strategy = PollingStrategies.regular(duration).executor((ScheduledExecutorService)EXECUTOR.get()).build();
        strategy.start((PollingStrategy.Polled)new PathPolled(path, updater, cleaner));
        return () -> ((PollingStrategy)strategy).stop();
    }

    public static Runnable watch(Path path, Consumer<Path> updater, Consumer<Path> cleaner) {
        if (NativeImageHelper.isBuildTime()) {
            LOGGER.info("File watching is not enabled in native image build time. Path: " + path);
        }
        FileSystemWatcher watcher = FileSystemWatcher.builder().executor((ScheduledExecutorService)EXECUTOR.get()).build();
        watcher.start(path, event -> {
            try {
                if (event.type() == ChangeEventType.DELETED) {
                    cleaner.accept((Path)event.target());
                } else {
                    updater.accept((Path)event.target());
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Failed to process change watcher event " + event + " for file " + path.toAbsolutePath(), e);
            }
        });
        return watcher::stop;
    }

    private static class PathPolled
    implements PollingStrategy.Polled {
        private final Path path;
        private final Consumer<Path> updater;
        private final Consumer<Path> cleaner;
        private boolean exists;
        private Instant lastChange;

        private PathPolled(Path path, Consumer<Path> updater, Consumer<Path> cleaner) {
            this.path = path;
            this.updater = updater;
            this.cleaner = cleaner;
            this.exists = Files.exists(path, new LinkOption[0]);
            if (this.exists) {
                try {
                    this.lastChange = Files.getLastModifiedTime(path, new LinkOption[0]).toInstant();
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        }

        public ChangeEventType poll(Instant when) {
            try {
                return this.doPoll();
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Failed to poll for changes at " + when, e);
                return ChangeEventType.CHANGED;
            }
        }

        private ChangeEventType doPoll() {
            ChangeEventType response;
            if (Files.exists(this.path, new LinkOption[0])) {
                ChangeEventType response2;
                if (this.exists) {
                    Instant instant = Instant.now();
                    try {
                        instant = Files.getLastModifiedTime(this.path, new LinkOption[0]).toInstant();
                    }
                    catch (IOException e) {
                        LOGGER.log(Level.WARNING, "Failed to get last modified for " + this.path.toAbsolutePath(), e);
                    }
                    if (instant.isAfter(this.lastChange)) {
                        this.lastChange = instant;
                        response2 = ChangeEventType.CHANGED;
                        this.updater.accept(this.path);
                    } else {
                        response2 = ChangeEventType.UNCHANGED;
                    }
                } else {
                    response2 = ChangeEventType.CREATED;
                    this.updater.accept(this.path);
                }
                this.exists = true;
                return response2;
            }
            if (this.exists) {
                response = ChangeEventType.DELETED;
                this.cleaner.accept(this.path);
            } else {
                response = ChangeEventType.UNCHANGED;
            }
            this.exists = false;
            return response;
        }
    }
}

