/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.injection;

import java.lang.reflect.Field;
import org.jboss.weld.bean.proxy.DecoratorProxy;
import org.jboss.weld.injection.AbstractResourceInjection;
import org.jboss.weld.injection.Exceptions;
import org.jboss.weld.injection.FieldInjectionPoint;
import org.jboss.weld.injection.spi.ResourceReferenceFactory;
import org.jboss.weld.interceptor.util.proxy.TargetInstanceProxy;
import org.jboss.weld.util.reflection.Reflections;

class FieldResourceInjection<T, X>
extends AbstractResourceInjection<T> {
    private final Field accessibleField;

    FieldResourceInjection(FieldInjectionPoint<T, X> fieldInjectionPoint, ResourceReferenceFactory<T> factory) {
        super(factory);
        this.accessibleField = Reflections.getAccessibleCopyOfMember(fieldInjectionPoint.getAnnotated().getJavaMember());
    }

    @Override
    protected void injectMember(Object declaringInstance, Object reference) {
        try {
            Object instanceToInject = declaringInstance;
            if (!(instanceToInject instanceof DecoratorProxy) && instanceToInject instanceof TargetInstanceProxy) {
                instanceToInject = ((TargetInstanceProxy)Reflections.cast(declaringInstance)).weld_getTargetInstance();
            }
            this.accessibleField.set(instanceToInject, reference);
        }
        catch (IllegalArgumentException e) {
            Exceptions.rethrowException(e);
        }
        catch (IllegalAccessException e) {
            Exceptions.rethrowException(e);
        }
    }

    @Override
    Field getMember() {
        return this.accessibleField;
    }
}

