/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.profiler;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;

public class FetchGroupMonitor {
    public static Map<Class<?>, Set<String>> fetchedAttributes = new HashMap();
    public static Boolean shouldMonitor;

    public static boolean shouldMonitor() {
        if (shouldMonitor == null) {
            shouldMonitor = Boolean.FALSE;
            String property = PrivilegedAccessHelper.getSystemProperty("org.eclipse.persistence.fetchgroupmonitor");
            if (property != null && property.equalsIgnoreCase("TRUE")) {
                shouldMonitor = Boolean.TRUE;
            }
        }
        return shouldMonitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void recordFetchedAttribute(Class<?> domainClass, String attributeName) {
        if (!FetchGroupMonitor.shouldMonitor()) {
            return;
        }
        Map<Class<?>, Set<String>> map = fetchedAttributes;
        synchronized (map) {
            Set classesFetchedAttributes = fetchedAttributes.computeIfAbsent(domainClass, k -> new HashSet());
            classesFetchedAttributes.add(attributeName);
        }
    }
}

