/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.deployment.annotation.impl;

import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.annotation.impl.ModuleScanner;
import com.sun.enterprise.deployment.web.AppListenerDescriptor;
import com.sun.enterprise.deployment.web.ServletFilter;
import jakarta.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.deployment.common.Descriptor;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.internal.api.ClassLoaderHierarchy;
import org.glassfish.web.deployment.descriptor.WebFragmentDescriptor;
import org.jvnet.hk2.annotations.Service;

@Service(name="war")
@PerLookup
public class WarScanner
extends ModuleScanner<WebBundleDescriptor> {
    private boolean scanOtherLibraries;
    @Inject
    private ClassLoaderHierarchy clHierarchy;

    public void setScanOtherLibraries(boolean scanOtherLibraries) {
        this.scanOtherLibraries = scanOtherLibraries;
    }

    public boolean isScanOtherLibraries() {
        return this.scanOtherLibraries;
    }

    protected void process(File archiveFile, WebBundleDescriptor webBundleDesc, ClassLoader classLoader) throws IOException {
        this.archiveFile = archiveFile;
        this.classLoader = classLoader;
    }

    protected final void completeProcess(WebBundleDescriptor descriptor, ReadableArchive archive) throws IOException {
        if (this.isScanOtherLibraries()) {
            this.addLibraryJars((Descriptor)descriptor, archive);
            return;
        }
        File webinf = new File(this.archiveFile, "WEB-INF");
        if (descriptor instanceof WebFragmentDescriptor) {
            File jarFile;
            WebFragmentDescriptor webFragmentDesc = (WebFragmentDescriptor)descriptor;
            File lib = new File(webinf, "lib");
            if (lib.exists() && (jarFile = new File(lib, webFragmentDesc.getJarName())).exists()) {
                if (jarFile.isDirectory()) {
                    this.addScanDirectory(jarFile);
                } else {
                    this.addScanJar(jarFile);
                }
            }
        } else {
            File classes = new File(webinf, "classes");
            if (classes.exists()) {
                this.addScanDirectory(classes);
            }
        }
        this.scanXmlDefinedClassesIfNecessary(descriptor);
    }

    private void scanXmlDefinedClassesIfNecessary(WebBundleDescriptor webBundleDesc) throws IOException {
        ClassLoader commonCL = this.clHierarchy.getCommonClassLoader();
        for (Object element : webBundleDesc.getWebComponentDescriptors()) {
            String servletName;
            if (!element.isServlet() || !this.isScan(servletName = element.getWebComponentImplementation(), commonCL)) continue;
            this.addScanClassName(servletName);
        }
        List servletFilters = webBundleDesc.getServletFilters();
        for (ServletFilter filter : servletFilters) {
            String filterName = filter.getClassName();
            if (!this.isScan(filterName, commonCL)) continue;
            this.addScanClassName(filter.getClassName());
        }
        List listeners = webBundleDesc.getAppListenersCopy();
        for (AppListenerDescriptor listenerDesc : listeners) {
            String listenerName = listenerDesc.getListener();
            if (!this.isScan(listenerName, commonCL)) continue;
            this.addScanClassName(listenerName);
        }
    }

    private boolean isScan(String className, ClassLoader commonCL) throws IOException {
        boolean result = false;
        String resourceName = "/" + className.replace(".", "/") + ".class";
        return commonCL.getResource(resourceName) != null;
    }
}

