/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.provider;

import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.ext.Provider;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.glassfish.admin.rest.RestLogging;
import org.glassfish.admin.rest.provider.BaseProvider;
import org.glassfish.admin.rest.provider.ProviderUtil;
import org.glassfish.admin.rest.results.GetResultList;
import org.jvnet.hk2.config.Dom;

@Provider
@Produces(value={"application/json"})
public class GetResultListJsonProvider
extends BaseProvider<GetResultList> {
    public GetResultListJsonProvider() {
        super(GetResultList.class, MediaType.APPLICATION_JSON_TYPE);
    }

    @Override
    public String getContent(GetResultList proxy) {
        JSONObject obj = new JSONObject();
        try {
            obj.put("entity", (Object)new JSONObject());
            obj.put("methods", (Object)ProviderUtil.getJsonForMethodMetaData(proxy.getMetaData()));
            if (proxy.getDomList().size() > 0) {
                obj.put("childResources", (Object)this.getResourcesLinks(proxy.getDomList()));
            }
            if (proxy.getCommandResourcesPaths().length > 0) {
                obj.put("commands", (Object)this.getCommandLinks(proxy.getCommandResourcesPaths()));
            }
        }
        catch (JSONException ex) {
            RestLogging.restLogger.log(Level.SEVERE, null, ex);
        }
        return obj.toString();
    }

    private JSONArray getResourcesLinks(List<Dom> proxyList) {
        JSONArray array = new JSONArray();
        for (Map.Entry<String, String> link : this.getResourceLinks(proxyList).entrySet()) {
            array.put((Object)link.getValue());
        }
        return array;
    }

    private JSONArray getCommandLinks(String[][] commandResourcesPaths) throws JSONException {
        JSONArray array = new JSONArray();
        for (String[] commandResourcePath : commandResourcesPaths) {
            array.put((Object)ProviderUtil.getElementLink(this.uriInfo, commandResourcePath[0]));
        }
        return array;
    }
}

