/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.helper;

import java.beans.Introspector;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.core.helper.CoreHelper;
import org.eclipse.persistence.internal.databaseaccess.DatabaseAccessor;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.logging.AbstractSessionLog;

public class Helper
extends CoreHelper
implements Serializable {
    public static boolean shouldOptimizeDates = false;
    public static final Object NULL_VALUE = new Helper();
    private static final String NULL_STRING = "null";
    protected static final Queue<Calendar> calendarCache = Helper.initCalendarCache();
    protected static final TimeZone defaultTimeZone = TimeZone.getDefault();
    private static DateTimeFormatter dateTimeFormatter;
    protected static String CR;
    public static final String SPACE = " ";
    public static final String INDENT = "  ";
    public static final String NL = "\n";
    protected static String PATH_SEPARATOR;
    protected static String FILE_SEPARATOR;
    protected static String CURRENT_WORKING_DIRECTORY;
    protected static String TEMP_DIRECTORY;
    @Deprecated
    public static boolean isZeroValidPrimaryKey;
    public static final String IS_PROPERTY_METHOD_PREFIX = "is";
    public static final String GET_PROPERTY_METHOD_PREFIX = "get";
    public static final String SET_PROPERTY_METHOD_PREFIX = "set";
    public static final String SET_IS_PROPERTY_METHOD_PREFIX = "setIs";
    public static final int POSITION_AFTER_IS_PREFIX;
    public static final int POSITION_AFTER_GET_PREFIX;
    public static final String DEFAULT_DATABASE_DELIMITER = "\"";
    public static final String PERSISTENCE_SET = "_persistence_set_";
    public static final String PERSISTENCE_GET = "_persistence_get_";
    public static final String PERSISTENCE_FIELDNAME_PREFIX = "_persistence_";
    public static final String PERSISTENCE_FIELDNAME_POSTFIX = "_vh";
    private static String defaultStartDatabaseDelimiter;
    private static String defaultEndDatabaseDelimiter;

    public static boolean shouldOptimizeDates() {
        return shouldOptimizeDates;
    }

    public static void setShouldOptimizeDates(boolean value) {
        shouldOptimizeDates = value;
    }

    public static Queue<Calendar> getCalendarCache() {
        return calendarCache;
    }

    public static Queue<Calendar> initCalendarCache() {
        ConcurrentLinkedQueue<Calendar> calendarCache = new ConcurrentLinkedQueue<Calendar>();
        for (int index = 0; index < 10; ++index) {
            calendarCache.add(Calendar.getInstance());
        }
        return calendarCache;
    }

    public static Calendar allocateCalendar() {
        Calendar calendar = Helper.getCalendarCache().poll();
        if (calendar == null) {
            calendar = Calendar.getInstance();
        }
        return calendar;
    }

    public static TimeZone getDefaultTimeZone() {
        return defaultTimeZone;
    }

    public static DateTimeFormatter getDefaultDateTimeFormatter() {
        if (dateTimeFormatter == null) {
            dateTimeFormatter = new DateTimeFormatterBuilder().append(new DateTimeFormatterBuilder().parseCaseInsensitive().parseLenient().optionalStart().append(DateTimeFormatter.ISO_LOCAL_DATE).optionalEnd().optionalStart().appendLiteral('T').optionalEnd().optionalStart().append(DateTimeFormatter.ISO_LOCAL_TIME).optionalEnd().toFormatter()).optionalStart().appendOffsetId().optionalStart().appendLiteral('[').parseCaseSensitive().appendZoneRegionId().appendLiteral(']').toFormatter();
        }
        return dateTimeFormatter;
    }

    public static void releaseCalendar(Calendar calendar) {
        Helper.getCalendarCache().offer(calendar);
    }

    public static <E> void addAllToVector(Vector<E> theVector, Vector<? extends E> elementsToAdd) {
        Enumeration<E> stream = elementsToAdd.elements();
        while (stream.hasMoreElements()) {
            theVector.addElement(stream.nextElement());
        }
    }

    public static <T> Vector<T> addAllUniqueToVector(Vector<T> objects, List<T> objectsToAdd) {
        if (objectsToAdd == null) {
            return objects;
        }
        int size = objectsToAdd.size();
        for (int index = 0; index < size; ++index) {
            T element = objectsToAdd.get(index);
            if (objects.contains(element)) continue;
            objects.add(element);
        }
        return objects;
    }

    public static <T> List<T> addAllUniqueToList(List<T> objects, List<T> objectsToAdd) {
        if (objectsToAdd == null) {
            return objects;
        }
        int size = objectsToAdd.size();
        for (int index = 0; index < size; ++index) {
            T element = objectsToAdd.get(index);
            if (objects.contains(element)) continue;
            objects.add(element);
        }
        return objects;
    }

    public static Object[] arrayFromVector(Vector<?> vector) {
        Object[] result = new Object[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            result[i] = vector.elementAt(i);
        }
        return result;
    }

    public static String integerToHexString(Integer i) {
        return i != null ? Integer.toHexString(i) : NULL_STRING;
    }

    public static byte[] buildBytesFromHexString(String hex) {
        String tmpString = hex;
        if (tmpString.length() % 2 != 0) {
            throw ConversionException.couldNotConvertToByteArray(hex);
        }
        byte[] bytes = new byte[tmpString.length() / 2];
        int byteIndex = bytes.length - 1;
        int strIndex = tmpString.length() - 2;
        while (byteIndex >= 0) {
            byte digit1 = (byte)Character.digit(tmpString.charAt(strIndex), 16);
            byte digit2 = (byte)Character.digit(tmpString.charAt(strIndex + 1), 16);
            if (digit1 == -1 || digit2 == -1) {
                throw ConversionException.couldNotBeConverted(hex, ClassConstants.APBYTE);
            }
            bytes[byteIndex] = (byte)(digit1 * 16 + digit2);
            --byteIndex;
            strIndex -= 2;
        }
        return bytes;
    }

    public static String buildHexStringFromBytes(byte[] bytes) {
        char[] hexArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        StringBuilder stringBuilder = new StringBuilder();
        for (int byteIndex = 0; byteIndex < bytes.length; ++byteIndex) {
            int tempByte = bytes[byteIndex];
            if (tempByte < 0) {
                tempByte += 256;
            }
            if ((tempByte = (int)((byte)(tempByte / 16))) > 16) {
                throw ConversionException.couldNotBeConverted(bytes, ClassConstants.STRING);
            }
            stringBuilder.append(hexArray[tempByte]);
            tempByte = bytes[byteIndex];
            if (tempByte < 0) {
                tempByte += 256;
            }
            if ((tempByte = (int)((byte)(tempByte % 16))) > 16) {
                throw ConversionException.couldNotBeConverted(bytes, ClassConstants.STRING);
            }
            stringBuilder.append(hexArray[tempByte]);
        }
        return stringBuilder.toString();
    }

    public static <T> Vector<T> buildVectorFromMapElements(Map<?, T> map) {
        Vector<T> vector = new Vector<T>(map.size());
        Iterator<T> iterator = map.values().iterator();
        while (iterator.hasNext()) {
            vector.addElement(iterator.next());
        }
        return vector;
    }

    public static Calendar calendarFromUtilDate(java.util.Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        if (date instanceof Timestamp) {
            calendar.set(14, ((Timestamp)date).getNanos() / 1000000);
        }
        return calendar;
    }

    public static <T> boolean classImplementsInterface(Class<T> aClass, Class<?> anInterface) {
        int i;
        if (aClass == anInterface) {
            return true;
        }
        Class<?>[] interfaces = aClass.getInterfaces();
        for (i = 0; i < interfaces.length; ++i) {
            if (interfaces[i] != anInterface) continue;
            return true;
        }
        for (i = 0; i < interfaces.length; ++i) {
            if (!Helper.classImplementsInterface(interfaces[i], anInterface)) continue;
            return true;
        }
        Class<T> superClass = aClass.getSuperclass();
        if (superClass == null) {
            return false;
        }
        return Helper.classImplementsInterface(superClass, anInterface);
    }

    public static boolean classIsSubclass(Class<?> subClass, Class<?> superClass) {
        if (superClass == null) {
            return false;
        }
        for (Class<?> temp = subClass; temp != null; temp = temp.getSuperclass()) {
            if (temp != superClass) continue;
            return true;
        }
        return false;
    }

    public static int compareVersions(String version1, String version2) {
        return Helper.compareVersions(Helper.version(version1), Helper.version(version2));
    }

    protected static List<Integer> version(String version) {
        ArrayList<Integer> list = new ArrayList<Integer>(5);
        int iBegin = -1;
        boolean isPrefix = true;
        for (int i = 0; i < version.length(); ++i) {
            char ch = version.charAt(i);
            if ('0' <= ch && ch <= '9') {
                isPrefix = false;
                if (iBegin != -1) continue;
                iBegin = i;
                continue;
            }
            if (iBegin == -1) {
                if (isPrefix) continue;
                break;
            }
            isPrefix = false;
            String strNum = version.substring(iBegin, i);
            int num = Integer.parseInt(strNum, 10);
            list.add(num);
            iBegin = -1;
            if (ch != '.') break;
        }
        if (iBegin >= 0) {
            String strNum = version.substring(iBegin, version.length());
            int num = Integer.parseInt(strNum, 10);
            list.add(num);
        }
        return list;
    }

    protected static int compareVersions(List<Integer> list1, List<Integer> list2) {
        int n = Math.max(list1.size(), list2.size());
        int res = 0;
        for (int i = 0; i < n; ++i) {
            int l1 = 0;
            if (i < list1.size()) {
                l1 = list1.get(i);
            }
            int l2 = 0;
            if (i < list2.size()) {
                l2 = list2.get(i);
            }
            if (l1 < l2) {
                res = -1;
                break;
            }
            if (l1 <= l2) continue;
            res = 1;
            break;
        }
        return res;
    }

    public static <T> Class<T> getClassFromClasseName(String className, ClassLoader classLoader) {
        if (className == null) {
            return null;
        }
        return PrivilegedAccessHelper.callDoPrivilegedWithException(() -> PrivilegedAccessHelper.getClassForName(className, true, classLoader), ex -> ValidationException.classNotFoundWhileConvertingClassNames(className, ex));
    }

    public static String getComponentTypeNameFromArrayString(String aString) {
        if (aString == null || aString.length() == 0) {
            return null;
        }
        if (aString.length() > 3 && aString.startsWith("[L") && aString.endsWith(";")) {
            return aString.substring(2, aString.length() - 1);
        }
        if (aString.startsWith("[")) {
            Class<?> primitiveClass = null;
            try {
                primitiveClass = Class.forName(aString);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (primitiveClass != null) {
                return primitiveClass.getComponentType().getName();
            }
        }
        return null;
    }

    public static boolean compareArrays(Object[] array1, Object[] array2) {
        if (array1.length != array2.length) {
            return false;
        }
        for (int index = 0; index < array1.length; ++index) {
            if (!(array1[index] != null ? !array1[index].equals(array2[index]) : array2[index] != null)) continue;
            return false;
        }
        return true;
    }

    public static boolean compareBigDecimals(BigDecimal one, BigDecimal two) {
        if (one.scale() != two.scale()) {
            double doubleOne = one.doubleValue();
            double doubleTwo = two.doubleValue();
            if (doubleOne != Double.POSITIVE_INFINITY && doubleOne != Double.NEGATIVE_INFINITY && doubleTwo != Double.POSITIVE_INFINITY && doubleTwo != Double.NEGATIVE_INFINITY) {
                return doubleOne == doubleTwo;
            }
        }
        return one.equals(two);
    }

    public static boolean compareByteArrays(byte[] array1, byte[] array2) {
        if (array1.length != array2.length) {
            return false;
        }
        for (int index = 0; index < array1.length; ++index) {
            if (array1[index] == array2[index]) continue;
            return false;
        }
        return true;
    }

    public static boolean compareCharArrays(char[] array1, char[] array2) {
        if (array1.length != array2.length) {
            return false;
        }
        for (int index = 0; index < array1.length; ++index) {
            if (array1[index] == array2[index]) continue;
            return false;
        }
        return true;
    }

    public static boolean areTypesAssignable(List<Class<?>> types1, List<Class<?>> types2) {
        if (types1 == null || types2 == null) {
            return false;
        }
        if (types1.size() == types2.size()) {
            for (int i = 0; i < types1.size(); ++i) {
                Class<?> type1 = types1.get(i);
                Class<?> type2 = types2.get(i);
                if (type1 == null || type2 == null || type1.isAssignableFrom(type2)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean compareHashtables(Hashtable<?, ?> hashtable1, Hashtable<?, ?> hashtable2) {
        if (hashtable1.size() != hashtable2.size()) {
            return false;
        }
        Hashtable clonedHashtable = (Hashtable)hashtable2.clone();
        Enumeration<?> enumtr = hashtable1.elements();
        while (enumtr.hasMoreElements()) {
            Object element = enumtr.nextElement();
            if (clonedHashtable.remove(element) != null) continue;
            return false;
        }
        return clonedHashtable.isEmpty();
    }

    public static boolean comparePotentialArrays(Object firstValue, Object secondValue) {
        Class<?> firstClass = firstValue.getClass();
        Class<?> secondClass = secondValue.getClass();
        if (firstClass == ClassConstants.APBYTE && secondClass == ClassConstants.APBYTE) {
            return Helper.compareByteArrays((byte[])firstValue, (byte[])secondValue);
        }
        if (firstClass == ClassConstants.APCHAR && secondClass == ClassConstants.APCHAR) {
            return Helper.compareCharArrays((char[])firstValue, (char[])secondValue);
        }
        if (firstClass.isArray() && secondClass.isArray()) {
            return Helper.compareArrays((Object[])firstValue, (Object[])secondValue);
        }
        if (firstValue instanceof BigDecimal && secondValue instanceof BigDecimal) {
            return Helper.compareBigDecimals((BigDecimal)firstValue, (BigDecimal)secondValue);
        }
        return false;
    }

    public static <K, V> Map<K, V> concatenateMaps(Map<? extends K, ? extends V> first, Map<? extends K, ? extends V> second) {
        HashMap<K, V> concatenation = new HashMap<K, V>(first.size() + second.size() + 4);
        concatenation.putAll(first);
        concatenation.putAll(second);
        return concatenation;
    }

    public static <E> Vector<E> concatenateUniqueVectors(Vector<? extends E> first, Vector<? extends E> second) {
        NonSynchronizedVector<E> concatenation = NonSynchronizedVector.newInstance();
        Enumeration<E> stream = first.elements();
        while (stream.hasMoreElements()) {
            ((Vector)concatenation).addElement(stream.nextElement());
        }
        stream = second.elements();
        while (stream.hasMoreElements()) {
            E element = stream.nextElement();
            if (concatenation.contains(element)) continue;
            ((Vector)concatenation).addElement(element);
        }
        return concatenation;
    }

    public static <E> List<E> concatenateUniqueLists(List<? extends E> first, List<? extends E> second) {
        ArrayList<E> concatenation = new ArrayList<E>(first.size() + second.size());
        concatenation.addAll(first);
        for (E element : second) {
            if (concatenation.contains(element)) continue;
            concatenation.add(element);
        }
        return concatenation;
    }

    public static <E> Vector<E> concatenateVectors(Vector<? extends E> first, Vector<? extends E> second) {
        NonSynchronizedVector<E> concatenation = NonSynchronizedVector.newInstance();
        Enumeration<E> stream = first.elements();
        while (stream.hasMoreElements()) {
            ((Vector)concatenation).addElement(stream.nextElement());
        }
        stream = second.elements();
        while (stream.hasMoreElements()) {
            ((Vector)concatenation).addElement(stream.nextElement());
        }
        return concatenation;
    }

    public static <E> Vector<E> copyVector(List<E> originalVector, int startIndex, int stopIndex) throws ValidationException {
        if (stopIndex < startIndex) {
            return NonSynchronizedVector.newInstance();
        }
        NonSynchronizedVector<E> newVector = NonSynchronizedVector.newInstance(stopIndex - startIndex);
        for (int index = startIndex; index < stopIndex; ++index) {
            ((Vector)newVector).add(originalVector.get(index));
        }
        return newVector;
    }

    public static String[] copyStringArray(String[] original) {
        if (original == null) {
            return null;
        }
        int length = original.length;
        String[] copy = new String[length];
        System.arraycopy(original, 0, copy, 0, length);
        return copy;
    }

    public static int[] copyIntArray(int[] original) {
        if (original == null) {
            return null;
        }
        int length = original.length;
        int[] copy = new int[length];
        System.arraycopy(original, 0, copy, 0, length);
        return copy;
    }

    public static boolean[] copyBooleanArray(boolean[] original) {
        if (original == null) {
            return null;
        }
        int length = original.length;
        boolean[] copy = new boolean[length];
        System.arraycopy(original, 0, copy, 0, length);
        return copy;
    }

    public static String cr() {
        if (CR == null) {
            CR = PrivilegedAccessHelper.getSystemProperty("line.separator");
        }
        return CR;
    }

    public static String currentWorkingDirectory() {
        if (CURRENT_WORKING_DIRECTORY == null) {
            CURRENT_WORKING_DIRECTORY = PrivilegedAccessHelper.getSystemProperty("user.dir");
        }
        return CURRENT_WORKING_DIRECTORY;
    }

    public static String tempDirectory() {
        if (TEMP_DIRECTORY == null) {
            TEMP_DIRECTORY = PrivilegedAccessHelper.getSystemProperty("java.io.tmpdir");
        }
        return TEMP_DIRECTORY;
    }

    public static Date dateFromLong(Long longObject) {
        return new Date(longObject);
    }

    public static Date dateFromYearMonthDate(int year, int month, int day) {
        Calendar localCalendar = Helper.allocateCalendar();
        localCalendar.clear();
        localCalendar.set(year, month, day, 0, 0, 0);
        long millis = localCalendar.getTimeInMillis();
        Date date = new Date(millis);
        Helper.releaseCalendar(localCalendar);
        return date;
    }

    public static Date dateFromString(String dateString) throws ConversionException {
        int day;
        int month;
        int year;
        StringTokenizer dateStringTokenizer;
        if (dateString.indexOf(47) != -1) {
            dateStringTokenizer = new StringTokenizer(dateString, "/");
        } else if (dateString.indexOf(45) != -1) {
            dateStringTokenizer = new StringTokenizer(dateString, "- ");
        } else {
            throw ConversionException.incorrectDateFormat(dateString);
        }
        try {
            year = Integer.parseInt(dateStringTokenizer.nextToken());
            month = Integer.parseInt(dateStringTokenizer.nextToken());
            day = Integer.parseInt(dateStringTokenizer.nextToken());
        }
        catch (NumberFormatException exception) {
            throw ConversionException.incorrectDateFormat(dateString);
        }
        return Helper.dateFromYearMonthDate(year, --month, day);
    }

    public static Date dateFromTimestamp(Timestamp timestamp) {
        return Helper.sqlDateFromUtilDate(timestamp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean doesFileExist(String fileName) {
        FileReader reader = null;
        try {
            reader = new FileReader(fileName);
        }
        catch (FileNotFoundException fnfException) {
            boolean bl;
            try {
                bl = false;
            }
            catch (Throwable throwable) {
                Helper.close(reader);
                throw throwable;
            }
            Helper.close(reader);
            return bl;
        }
        Helper.close(reader);
        return true;
    }

    public static String doubleSlashes(String path) {
        StringBuilder buffer = new StringBuilder(path.length() + 5);
        for (int index = 0; index < path.length(); ++index) {
            char charater = path.charAt(index);
            buffer.append(charater);
            if (charater != '\\') continue;
            buffer.append('\\');
        }
        return buffer.toString();
    }

    public static String extractJarNameFromURL(URL url) {
        String tempName = url.getFile();
        int start = tempName.indexOf("file:") + 5;
        int end = tempName.indexOf("!/");
        return tempName.substring(start, end);
    }

    public static String fileSeparator() {
        if (FILE_SEPARATOR == null) {
            FILE_SEPARATOR = PrivilegedAccessHelper.getSystemProperty("file.separator");
        }
        return FILE_SEPARATOR;
    }

    public static Field getField(Class<?> javaClass, String fieldName) throws NoSuchFieldException {
        try {
            return PrivilegedAccessHelper.callDoPrivilegedWithException(() -> PrivilegedAccessHelper.getField(javaClass, fieldName, true));
        }
        catch (NoSuchFieldException | RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(String.format("Getting %s field failed", fieldName), ex);
        }
    }

    public static Method getDeclaredMethod(Class<?> javaClass, String methodName) throws NoSuchMethodException {
        return Helper.getDeclaredMethod(javaClass, methodName, null);
    }

    public static Method getDeclaredMethod(Class<?> javaClass, String methodName, Class<?>[] methodParameterTypes) throws NoSuchMethodException {
        try {
            return PrivilegedAccessHelper.callDoPrivilegedWithException(() -> PrivilegedAccessHelper.getMethod(javaClass, methodName, methodParameterTypes, true));
        }
        catch (NoSuchMethodException | RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(String.format("Getting %s method failed", methodName), ex);
        }
    }

    public static Object getInstanceFromClass(Class<?> classFullName) {
        if (classFullName == null) {
            return null;
        }
        return PrivilegedAccessHelper.callDoPrivilegedWithException(() -> PrivilegedAccessHelper.newInstanceFromClass(classFullName), ex -> {
            ValidationException exc = new ValidationException();
            exc.setInternalException(ex);
            return exc;
        });
    }

    public static Class<?> getObjectClass(Class<?> javaClass) {
        return ConversionManager.getObjectClass(javaClass);
    }

    public static String getShortClassName(Class<?> javaClass) {
        return Helper.getShortClassName(javaClass.getName());
    }

    public static String getShortClassName(String javaClassName) {
        return javaClassName.substring(javaClassName.lastIndexOf(46) + 1);
    }

    public static String getShortClassName(Object object) {
        return Helper.getShortClassName(object.getClass());
    }

    public static String getPackageName(Class<?> javaClass) {
        String className = Helper.getShortClassName(javaClass);
        return javaClass.getName().substring(0, javaClass.getName().length() - (className.length() + 1));
    }

    public static String getTabs(int noOfTabs) {
        StringWriter writer = new StringWriter();
        for (int index = 0; index < noOfTabs; ++index) {
            writer.write("\t");
        }
        return writer.toString();
    }

    public static int indexOfNullElement(Vector<?> v, int index) {
        int size = v.size();
        for (int i = index; i < size; ++i) {
            if (v.elementAt(i) != null) continue;
            return i;
        }
        return -1;
    }

    public static boolean isPrimitiveWrapper(Class<?> classInQuestion) {
        return classInQuestion.equals(Character.class) || classInQuestion.equals(Boolean.class) || classInQuestion.equals(Byte.class) || classInQuestion.equals(Short.class) || classInQuestion.equals(Integer.class) || classInQuestion.equals(Long.class) || classInQuestion.equals(Float.class) || classInQuestion.equals(Double.class);
    }

    public static boolean isUpperCaseString(String s) {
        char[] c = s.toCharArray();
        for (int i = 0; i < s.length(); ++i) {
            if (!Character.isLowerCase(c[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isVowel(char c) {
        return c == 'A' || c == 'a' || c == 'e' || c == 'E' || c == 'i' || c == 'I' || c == 'o' || c == 'O' || c == 'u' || c == 'U';
    }

    public static File[] listFilesIn(File directory) {
        if (directory.isDirectory()) {
            return directory.listFiles();
        }
        return new File[0];
    }

    public static <T> Vector<T> makeVectorFromObject(Object theObject) {
        if (theObject instanceof Vector) {
            return (Vector)theObject;
        }
        if (theObject instanceof Collection) {
            Collection col = (Collection)theObject;
            Vector returnVector = new Vector(col.size());
            returnVector.addAll(col);
            return returnVector;
        }
        Vector<Object> returnVector = new Vector<Object>();
        returnVector.addElement(theObject);
        return returnVector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void outputClassFile(String className, byte[] classBytes, String outputPath) {
        StringBuilder directoryName = new StringBuilder();
        StringTokenizer tokenizer = new StringTokenizer(className, "\n\\/");
        String token = null;
        while (tokenizer.hasMoreTokens()) {
            token = tokenizer.nextToken();
            if (!tokenizer.hasMoreTokens()) continue;
            directoryName.append(token).append(File.separator);
        }
        FileOutputStream fos = null;
        try {
            File file;
            Object usedOutputPath = outputPath;
            if (!outputPath.endsWith(File.separator)) {
                usedOutputPath = outputPath + File.separator;
            }
            if (!(file = new File((String)usedOutputPath + directoryName)).exists() && !file.mkdirs()) {
                AbstractSessionLog.getLog().log(3, "weaver", "weaver_not_overwriting", (Object)file);
            }
            if (!(file = new File(file, token + ".class")).exists()) {
                if (!file.createNewFile()) {
                    AbstractSessionLog.getLog().log(3, "weaver", "weaver_not_overwriting", (Object)file);
                }
            } else if (!PrivilegedAccessHelper.getSystemProperty("eclipselink.weaving.overwrite.existing", "false").equalsIgnoreCase("true")) {
                AbstractSessionLog.getLog().log(6, "weaver", "weaver_not_overwriting", (Object)className);
                Helper.close(fos);
                return;
            }
            fos = new FileOutputStream(file);
            fos.write(classBytes);
            Helper.close(fos);
        }
        catch (Exception e) {
            AbstractSessionLog.getLog().log(6, "weaver", "weaver_could_not_write", (Object)className, (Object)e);
            AbstractSessionLog.getLog().logThrowable(1, "weaver", e);
        }
        finally {
            Helper.close(fos);
        }
    }

    public static String pathSeparator() {
        if (PATH_SEPARATOR == null) {
            PATH_SEPARATOR = PrivilegedAccessHelper.getSystemProperty("path.separator");
        }
        return PATH_SEPARATOR;
    }

    public static String printStackTraceToString(Throwable aThrowable) {
        StringWriter swriter = new StringWriter();
        PrintWriter writer = new PrintWriter((Writer)swriter, true);
        aThrowable.printStackTrace(writer);
        writer.close();
        return swriter.toString();
    }

    public static String printTimeFromMilliseconds(long milliseconds) {
        if (milliseconds > 1000L && milliseconds < 60000L) {
            return milliseconds / 1000L + "s";
        }
        if (milliseconds > 60000L) {
            return milliseconds / 60000L + "min " + Helper.printTimeFromMilliseconds(milliseconds % 60000L);
        }
        return milliseconds + "ms";
    }

    public static String printVector(Vector<?> vector) {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("[");
        Enumeration<?> enumtr = vector.elements();
        stringWriter.write(String.valueOf(enumtr.nextElement()));
        while (enumtr.hasMoreElements()) {
            stringWriter.write(SPACE);
            stringWriter.write(String.valueOf(enumtr.nextElement()));
        }
        stringWriter.write("]");
        return stringWriter.toString();
    }

    public static <K, V> Hashtable<K, V> rehashHashtable(Hashtable<K, V> table) {
        Hashtable<K, V> rehashedTable = new Hashtable<K, V>(table.size() + 2);
        Enumeration<V> values = table.elements();
        Enumeration<K> keys = table.keys();
        while (keys.hasMoreElements()) {
            K key = keys.nextElement();
            V value = values.nextElement();
            rehashedTable.put(key, value);
        }
        return rehashedTable;
    }

    public static <K, V> Map<K, V> rehashMap(Map<K, V> table) {
        HashMap<K, V> rehashedTable = new HashMap<K, V>(table.size() + 2);
        Iterator<V> values = table.values().iterator();
        for (K key : table.keySet()) {
            V value = values.next();
            rehashedTable.put(key, value);
        }
        return rehashedTable;
    }

    public static String removeAllButAlphaNumericToFit(String s1, int maximumStringLength) {
        int s1Index;
        int s1Size = s1.length();
        if (s1Size <= maximumStringLength) {
            return s1;
        }
        StringBuilder buf = new StringBuilder();
        int numberOfCharsToBeRemoved = s1.length() - maximumStringLength;
        for (s1Index = 0; numberOfCharsToBeRemoved > 0 && s1Index < s1Size; ++s1Index) {
            char currentChar = s1.charAt(s1Index);
            if (Character.isLetterOrDigit(currentChar)) {
                buf.append(currentChar);
                continue;
            }
            --numberOfCharsToBeRemoved;
        }
        while (s1Index < s1Size) {
            buf.append(s1.charAt(s1Index));
            ++s1Index;
        }
        return buf.toString();
    }

    public static String removeCharacterToFit(String s1, char aChar, int maximumStringLength) {
        int s1Index;
        int s1Size = s1.length();
        if (s1Size <= maximumStringLength) {
            return s1;
        }
        StringBuilder buf = new StringBuilder();
        int numberOfCharsToBeRemoved = s1.length() - maximumStringLength;
        for (s1Index = 0; numberOfCharsToBeRemoved > 0 && s1Index < s1Size; ++s1Index) {
            char currentChar = s1.charAt(s1Index);
            if (currentChar == aChar) {
                --numberOfCharsToBeRemoved;
                continue;
            }
            buf.append(currentChar);
        }
        while (s1Index < s1Size) {
            buf.append(s1.charAt(s1Index));
            ++s1Index;
        }
        return buf.toString();
    }

    public static String removeVowels(String s1) {
        StringBuilder buf = new StringBuilder();
        int s1Size = s1.length();
        for (int s1Index = 0; s1Index < s1Size; ++s1Index) {
            char currentChar = s1.charAt(s1Index);
            if (Helper.isVowel(currentChar)) continue;
            buf.append(currentChar);
        }
        return buf.toString();
    }

    public static String replaceFirstSubString(String source, String subString, String replacement) {
        int index = source.indexOf(subString);
        if (index >= 0) {
            return source.substring(0, index) + replacement + source.substring(index + subString.length());
        }
        return null;
    }

    public static <T> Vector<T> reverseVector(Vector<T> theVector) {
        Vector<T> tempVector = new Vector<T>(theVector.size());
        for (int i = theVector.size() - 1; i > -1; --i) {
            T currentElement = theVector.elementAt(i);
            tempVector.addElement(currentElement);
        }
        return tempVector;
    }

    public static String rightTrimString(String originalString) {
        int len;
        for (len = originalString.length(); len > 0 && originalString.charAt(len - 1) <= ' '; --len) {
        }
        return originalString.substring(0, len);
    }

    public static String shortenStringsByRemovingVowelsToFit(String s1, String s2, int maximumStringLength) {
        int size = s1.length() + s2.length();
        if (size <= maximumStringLength) {
            return s1 + s2;
        }
        int s1Size = s1.length();
        int s2Size = s2.length();
        StringBuilder buf1 = new StringBuilder();
        StringBuilder buf2 = new StringBuilder();
        int numberOfCharsToBeRemoved = size - maximumStringLength;
        int s1Index = 0;
        int s2Index = 0;
        int modulo2 = 0;
        while (numberOfCharsToBeRemoved > 0 && (s1Index < s1Size || s2Index < s2Size)) {
            if (modulo2 % 2 == 0) {
                if (s1Index < s1Size) {
                    if (Helper.isVowel(s1.charAt(s1Index))) {
                        --numberOfCharsToBeRemoved;
                    } else {
                        buf1.append(s1.charAt(s1Index));
                    }
                    ++s1Index;
                }
            } else if (s2Index < s2Size) {
                if (Helper.isVowel(s2.charAt(s2Index))) {
                    --numberOfCharsToBeRemoved;
                } else {
                    buf2.append(s2.charAt(s2Index));
                }
                ++s2Index;
            }
            ++modulo2;
        }
        while (s1Index < s1Size) {
            buf1.append(s1.charAt(s1Index));
            ++s1Index;
        }
        while (s2Index < s2Size) {
            buf2.append(s2.charAt(s2Index));
            ++s2Index;
        }
        return buf1.toString() + buf2;
    }

    public static Date sqlDateFromUtilDate(java.util.Date utilDate) {
        Calendar calendar = Helper.allocateCalendar();
        calendar.setTime(utilDate);
        Date date = Helper.dateFromCalendar(calendar);
        Helper.releaseCalendar(calendar);
        return date;
    }

    public static String printDate(Date date) {
        Calendar calendar = Helper.allocateCalendar();
        calendar.setTime(date);
        String string = Helper.printDate(calendar);
        Helper.releaseCalendar(calendar);
        return string;
    }

    public static String printDate(Calendar calendar) {
        return Helper.printDate(calendar, true);
    }

    public static String printDate(Calendar calendar, boolean useLocalTime) {
        int day;
        int month;
        int year;
        if (useLocalTime && !defaultTimeZone.equals(calendar.getTimeZone())) {
            Calendar localCalendar = Helper.allocateCalendar();
            localCalendar.setTimeInMillis(calendar.getTimeInMillis());
            year = localCalendar.get(1);
            month = localCalendar.get(2) + 1;
            day = localCalendar.get(5);
            Helper.releaseCalendar(localCalendar);
        } else {
            year = calendar.get(1);
            month = calendar.get(2) + 1;
            day = calendar.get(5);
        }
        char[] buf = "2000-00-00".toCharArray();
        buf[0] = Character.forDigit(year / 1000, 10);
        buf[1] = Character.forDigit(year / 100 % 10, 10);
        buf[2] = Character.forDigit(year / 10 % 10, 10);
        buf[3] = Character.forDigit(year % 10, 10);
        buf[5] = Character.forDigit(month / 10, 10);
        buf[6] = Character.forDigit(month % 10, 10);
        buf[8] = Character.forDigit(day / 10, 10);
        buf[9] = Character.forDigit(day % 10, 10);
        return new String(buf);
    }

    public static String printTime(Time time) {
        Calendar calendar = Helper.allocateCalendar();
        calendar.setTime(time);
        String string = Helper.printTime(calendar);
        Helper.releaseCalendar(calendar);
        return string;
    }

    public static String printTime(Calendar calendar) {
        return Helper.printTime(calendar, true);
    }

    public static String printTime(Calendar calendar, boolean useLocalTime) {
        int second;
        int minute;
        int hour;
        if (useLocalTime && !defaultTimeZone.equals(calendar.getTimeZone())) {
            Calendar localCalendar = Helper.allocateCalendar();
            localCalendar.setTimeInMillis(calendar.getTimeInMillis());
            hour = localCalendar.get(11);
            minute = localCalendar.get(12);
            second = localCalendar.get(13);
            Helper.releaseCalendar(localCalendar);
        } else {
            hour = calendar.get(11);
            minute = calendar.get(12);
            second = calendar.get(13);
        }
        Object hourString = hour < 10 ? "0" + hour : Integer.toString(hour);
        Object minuteString = minute < 10 ? "0" + minute : Integer.toString(minute);
        Object secondString = second < 10 ? "0" + second : Integer.toString(second);
        return (String)hourString + ":" + (String)minuteString + ":" + (String)secondString;
    }

    public static String printCalendar(Calendar calendar) {
        return Helper.printCalendar(calendar, true);
    }

    public static String printCalendar(Calendar calendar, boolean useLocalTime) {
        String millisString = calendar.get(14) == 0 ? "0" : Helper.buildZeroPrefixAndTruncTrailZeros(calendar.get(14), 3);
        StringBuilder timestampBuf = new StringBuilder();
        timestampBuf.append(Helper.printDate(calendar, useLocalTime));
        timestampBuf.append(SPACE);
        timestampBuf.append(Helper.printTime(calendar, useLocalTime));
        timestampBuf.append(".");
        timestampBuf.append(millisString);
        return timestampBuf.toString();
    }

    public static String printTimestamp(Timestamp timestamp) {
        Calendar calendar = Helper.allocateCalendar();
        calendar.setTime(timestamp);
        String nanosString = timestamp.getNanos() == 0 ? "0" : Helper.buildZeroPrefixAndTruncTrailZeros(timestamp.getNanos(), 9);
        StringBuilder timestampBuf = new StringBuilder();
        timestampBuf.append(Helper.printDate(calendar));
        timestampBuf.append(SPACE);
        timestampBuf.append(Helper.printTime(calendar));
        timestampBuf.append(".");
        timestampBuf.append(nanosString);
        Helper.releaseCalendar(calendar);
        return timestampBuf.toString();
    }

    public static String buildZeroPrefix(int number, int totalDigits) {
        Object numbString = Helper.buildZeroPrefixWithoutSign(number, totalDigits);
        numbString = number < 0 ? "-" + (String)numbString : "+" + (String)numbString;
        return numbString;
    }

    public static String buildZeroPrefixWithoutSign(int number, int totalDigits) {
        String zeros = "000000000";
        int absValue = number < 0 ? -number : number;
        Object numbString = Integer.toString(absValue);
        numbString = zeros.substring(0, totalDigits - ((String)numbString).length()) + (String)numbString;
        return numbString;
    }

    public static String buildZeroPrefixAndTruncTrailZeros(int number, int totalDigits) {
        String zeros = "000000000";
        Object numbString = Integer.toString(number);
        numbString = zeros.substring(0, totalDigits - ((String)numbString).length()) + (String)numbString;
        char[] numbChar = new char[((String)numbString).length()];
        ((String)numbString).getChars(0, ((String)numbString).length(), numbChar, 0);
        int truncIndex = totalDigits - 1;
        while (numbChar[truncIndex] == '0') {
            --truncIndex;
        }
        return new String(numbChar, 0, truncIndex + 1);
    }

    public static String printTimestampWithoutNanos(Timestamp timestamp) {
        Calendar calendar = Helper.allocateCalendar();
        calendar.setTime(timestamp);
        String string = Helper.printCalendarWithoutNanos(calendar);
        Helper.releaseCalendar(calendar);
        return string;
    }

    public static String printCalendarWithoutNanos(Calendar calendar) {
        StringBuilder timestampBuf = new StringBuilder();
        timestampBuf.append(Helper.printDate(calendar));
        timestampBuf.append(SPACE);
        timestampBuf.append(Helper.printTime(calendar));
        return timestampBuf.toString();
    }

    public static Date dateFromCalendar(Calendar calendar) {
        if (!defaultTimeZone.equals(calendar.getTimeZone())) {
            Calendar localCalendar = Helper.allocateCalendar();
            localCalendar.setTimeInMillis(calendar.getTimeInMillis());
            Date date = Helper.dateFromYearMonthDate(localCalendar.get(1), localCalendar.get(2), localCalendar.get(5));
            Helper.releaseCalendar(localCalendar);
            return date;
        }
        if (calendar.get(11) == 0 && calendar.get(12) == 0 && calendar.get(13) == 0 && calendar.get(14) == 0) {
            return new Date(calendar.getTimeInMillis());
        }
        return Helper.dateFromYearMonthDate(calendar.get(1), calendar.get(2), calendar.get(5));
    }

    public static Date truncateDate(Date date) {
        Calendar calendar = Helper.allocateCalendar();
        calendar.setTime(date);
        if (calendar.get(11) != 0 || calendar.get(12) != 0 || calendar.get(13) != 0 || calendar.get(14) != 0) {
            int year = calendar.get(1);
            int month = calendar.get(2);
            int day = calendar.get(5);
            calendar.clear();
            calendar.set(year, month, day, 0, 0, 0);
            long millis = calendar.getTimeInMillis();
            date = new Date(millis);
        }
        Helper.releaseCalendar(calendar);
        return date;
    }

    public static Date truncateDateIgnoreMilliseconds(Date date) {
        Calendar calendar = Helper.allocateCalendar();
        calendar.setTime(date);
        if (calendar.get(11) != 0 || calendar.get(12) != 0 || calendar.get(13) != 0) {
            int year = calendar.get(1);
            int month = calendar.get(2);
            int day = calendar.get(5);
            calendar.clear();
            calendar.set(year, month, day, 0, 0, 0);
            long millis = calendar.getTimeInMillis();
            date = new Date(millis);
        }
        Helper.releaseCalendar(calendar);
        return date;
    }

    public static void systemBug(String description) {
    }

    public static Time timeFromDate(java.util.Date date) {
        Calendar calendar = Helper.allocateCalendar();
        calendar.setTime(date);
        Time time = Helper.timeFromCalendar(calendar);
        Helper.releaseCalendar(calendar);
        return time;
    }

    public static Time timeFromLong(Long longObject) {
        return new Time(longObject);
    }

    public static Time timeFromHourMinuteSecond(int hour, int minute, int second) {
        Calendar localCalendar = Helper.allocateCalendar();
        localCalendar.clear();
        localCalendar.set(1970, 0, 1, hour, minute, second);
        long millis = localCalendar.getTimeInMillis();
        Time time = new Time(millis);
        Helper.releaseCalendar(localCalendar);
        return time;
    }

    public static Time timeFromString(String timeString) throws ConversionException {
        int second;
        int minute;
        int hour;
        String timePortion = timeString;
        if (timeString.length() > 12) {
            timePortion = timeString.substring(11, 19);
        }
        if (timePortion.indexOf(45) == -1 && timePortion.indexOf(47) == -1 && timePortion.indexOf(46) == -1 && timePortion.indexOf(58) == -1) {
            throw ConversionException.incorrectTimeFormat(timePortion);
        }
        StringTokenizer timeStringTokenizer = new StringTokenizer(timePortion, " /:.-");
        try {
            hour = Integer.parseInt(timeStringTokenizer.nextToken());
            minute = Integer.parseInt(timeStringTokenizer.nextToken());
            second = Integer.parseInt(timeStringTokenizer.nextToken());
        }
        catch (NumberFormatException exception) {
            throw ConversionException.incorrectTimeFormat(timeString);
        }
        return Helper.timeFromHourMinuteSecond(hour, minute, second);
    }

    public static Time timeFromTimestamp(Timestamp timestamp) {
        return Helper.timeFromDate(timestamp);
    }

    public static Time timeFromCalendar(Calendar calendar) {
        if (!defaultTimeZone.equals(calendar.getTimeZone())) {
            Calendar localCalendar = Helper.allocateCalendar();
            localCalendar.setTimeInMillis(calendar.getTimeInMillis());
            Time date = Helper.timeFromHourMinuteSecond(localCalendar.get(11), localCalendar.get(12), localCalendar.get(13));
            Helper.releaseCalendar(localCalendar);
            return date;
        }
        return Helper.timeFromHourMinuteSecond(calendar.get(11), calendar.get(12), calendar.get(13));
    }

    public static Timestamp timestampFromCalendar(Calendar calendar) {
        return Helper.timestampFromLong(calendar.getTimeInMillis());
    }

    public static Timestamp timestampFromDate(java.util.Date date) {
        return Helper.timestampFromLong(date.getTime());
    }

    public static Timestamp timestampFromLong(Long millis) {
        return Helper.timestampFromLong((long)millis);
    }

    public static Timestamp timestampFromLong(long millis) {
        Timestamp timestamp = new Timestamp(millis);
        if (millis % 1000L > 0L) {
            timestamp.setNanos((int)(millis % 1000L) * 1000000);
        } else if (millis % 1000L < 0L) {
            timestamp.setNanos((int)(1000000000L - Math.abs(millis % 1000L * 1000000L)));
        }
        return timestamp;
    }

    public static Timestamp timestampFromString(String timestampString) throws ConversionException {
        boolean containsNanos;
        if (timestampString.indexOf(45) == -1 && timestampString.indexOf(47) == -1 && timestampString.indexOf(46) == -1 && timestampString.indexOf(58) == -1) {
            throw ConversionException.incorrectTimestampFormat(timestampString);
        }
        StringTokenizer timestampStringTokenizer = new StringTokenizer(timestampString, " /:.-+");
        int year = 0;
        int month = 0;
        int day = 0;
        int hour = 0;
        int minute = 0;
        int second = 0;
        int nanos = 0;
        try {
            year = Integer.parseInt(timestampStringTokenizer.nextToken());
            month = Integer.parseInt(timestampStringTokenizer.nextToken());
            day = Integer.parseInt(timestampStringTokenizer.nextToken());
            try {
                hour = Integer.parseInt(timestampStringTokenizer.nextToken());
                minute = Integer.parseInt(timestampStringTokenizer.nextToken());
                second = Integer.parseInt(timestampStringTokenizer.nextToken());
            }
            catch (NoSuchElementException noSuchElementException) {}
        }
        catch (NumberFormatException exception) {
            throw ConversionException.incorrectTimestampFormat(timestampString);
        }
        boolean bl = containsNanos = timestampString.indexOf(46) > -1;
        if (containsNanos) {
            try {
                String nanoToken = timestampStringTokenizer.nextToken();
                nanos = Integer.parseInt(nanoToken);
                for (int times = 0; times < 9 - nanoToken.length(); ++times) {
                    nanos *= 10;
                }
            }
            catch (NumberFormatException exception) {
                throw ConversionException.incorrectTimestampFormat(timestampString);
            }
        }
        return Helper.timestampFromYearMonthDateHourMinuteSecondNanos(year, month - 1, day, hour, minute, second, nanos);
    }

    public static Timestamp timestampFromYearMonthDateHourMinuteSecondNanos(int year, int month, int date, int hour, int minute, int second, int nanos) {
        return new Timestamp(year - 1900, month, date, hour, minute, second, nanos);
    }

    public static void toDo(String description) {
    }

    public static String toSlashedClassName(String dottedClassName) {
        if (dottedClassName == null) {
            return null;
        }
        if (dottedClassName.indexOf(46) >= 0) {
            return dottedClassName.replace('.', '/');
        }
        return dottedClassName;
    }

    public static String truncate(String originalString, int size) {
        if (originalString.length() <= size) {
            return originalString;
        }
        String vowels = "AaEeIiOoUu";
        StringBuilder newStringBufferTmp = new StringBuilder(originalString.length());
        int counter = originalString.length() - size;
        for (int index = originalString.length() - 1; index >= 0; --index) {
            if (vowels.indexOf(originalString.charAt(index)) == -1) {
                newStringBufferTmp.append(originalString.charAt(index));
                continue;
            }
            if (--counter != 0) continue;
            StringBuilder newStringBuffer = new StringBuilder(size);
            newStringBuffer.append(originalString.substring(0, index));
            newStringBuffer.append((CharSequence)newStringBufferTmp.reverse());
            return newStringBuffer.toString();
        }
        return newStringBufferTmp.reverse().substring(0, size);
    }

    public static java.util.Date utilDateFromLong(Long longObject) {
        return new java.util.Date(longObject);
    }

    public static java.util.Date utilDateFromSQLDate(Date sqlDate) {
        return new java.util.Date(sqlDate.getTime());
    }

    public static java.util.Date utilDateFromTime(Time time) {
        return new java.util.Date(time.getTime());
    }

    public static java.util.Date utilDateFromTimestamp(Timestamp timestampObject) {
        boolean appendNanos;
        long time = timestampObject.getTime();
        boolean bl = appendNanos = time % 1000L == 0L;
        if (appendNanos) {
            return new java.util.Date(time + (long)(timestampObject.getNanos() / 1000000));
        }
        return new java.util.Date(time);
    }

    public static <T> Vector<T> vectorFromArray(T[] array) {
        Vector<T> result = new Vector<T>(array.length);
        for (int i = 0; i < array.length; ++i) {
            result.addElement(array[i]);
        }
        return result;
    }

    public static void writeHexString(byte[] bytes, Writer writer) throws IOException {
        writer.write(Helper.buildHexStringFromBytes(bytes));
    }

    public static boolean isEquivalentToNull(Object value) {
        return !isZeroValidPrimaryKey && (value.getClass() == ClassConstants.LONG && (Long)value == 0L || value.getClass() == ClassConstants.INTEGER && (Integer)value == 0);
    }

    public static boolean isNumberNegativeOrZero(Object value) {
        return value.getClass() == ClassConstants.BIGDECIMAL && ((BigDecimal)value).signum() <= 0 || value.getClass() == ClassConstants.BIGINTEGER && ((BigInteger)value).signum() <= 0 || value instanceof Number && ((Number)value).longValue() <= 0L;
    }

    public static int countOccurrencesOf(Object comparisonObject, List<?> list) {
        boolean comparisonObjectIsNull;
        int instances = 0;
        boolean bl = comparisonObjectIsNull = comparisonObject == null;
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                Object listObject = list.get(i);
                if ((!comparisonObjectIsNull || listObject != null) && (comparisonObjectIsNull || !comparisonObject.equals(listObject))) continue;
                ++instances;
            }
        }
        return instances;
    }

    public static URI toURI(URL url) throws URISyntaxException {
        try {
            return url.toURI();
        }
        catch (URISyntaxException exception) {
            return new URI(url.getProtocol(), url.getUserInfo(), url.getHost(), url.getPort(), url.getPath(), url.getQuery(), null);
        }
    }

    public static String getWeavedValueHolderGetMethodName(String attributeName) {
        return PERSISTENCE_GET + attributeName + PERSISTENCE_FIELDNAME_POSTFIX;
    }

    public static String getWeavedValueHolderSetMethodName(String attributeName) {
        return PERSISTENCE_SET + attributeName + PERSISTENCE_FIELDNAME_POSTFIX;
    }

    public static String getWeavedGetMethodName(String attributeName) {
        return PERSISTENCE_GET + attributeName;
    }

    public static String getWeavedSetMethodName(String attributeName) {
        return PERSISTENCE_SET + attributeName;
    }

    public static void close(Closeable c) {
        try {
            if (c != null) {
                c.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static String getAttributeNameFromMethodName(String methodName) {
        String restOfName = methodName;
        if (methodName.equals(GET_PROPERTY_METHOD_PREFIX) || methodName.equals(IS_PROPERTY_METHOD_PREFIX)) {
            return "";
        }
        if (methodName.startsWith(GET_PROPERTY_METHOD_PREFIX)) {
            restOfName = methodName.substring(POSITION_AFTER_GET_PREFIX);
        } else if (methodName.startsWith(IS_PROPERTY_METHOD_PREFIX)) {
            restOfName = methodName.substring(POSITION_AFTER_IS_PREFIX);
        }
        return Introspector.decapitalize(restOfName);
    }

    public static String getDefaultStartDatabaseDelimiter() {
        if (defaultStartDatabaseDelimiter == null) {
            defaultStartDatabaseDelimiter = DEFAULT_DATABASE_DELIMITER;
        }
        return defaultStartDatabaseDelimiter;
    }

    public static String getDefaultEndDatabaseDelimiter() {
        if (defaultEndDatabaseDelimiter == null) {
            defaultEndDatabaseDelimiter = DEFAULT_DATABASE_DELIMITER;
        }
        return defaultEndDatabaseDelimiter;
    }

    public static void setDefaultStartDatabaseDelimiter(String delimiter) {
        defaultStartDatabaseDelimiter = delimiter;
    }

    public static void setDefaultEndDatabaseDelimiter(String delimiter) {
        defaultEndDatabaseDelimiter = delimiter;
    }

    public static String convertLikeToRegex(String like) {
        Object pattern = like.replaceAll("\\?", "\\\\?");
        pattern = ((String)pattern).replaceAll("\\*", "\\\\*");
        pattern = ((String)pattern).replaceAll("\\.", "\\\\.");
        pattern = ((String)pattern).replaceAll("\\[", "\\\\[");
        pattern = ((String)pattern).replaceAll("\\)", "\\\\)");
        pattern = ((String)pattern).replaceAll("\\(", "\\\\(");
        pattern = ((String)pattern).replaceAll("\\{", "\\\\{");
        pattern = ((String)pattern).replaceAll("\\+", "\\\\+");
        pattern = ((String)pattern).replaceAll("\\^", "\\\\^");
        pattern = ((String)pattern).replaceAll("\\|", "\\\\|");
        pattern = ((String)pattern).replaceAll("(?<!\\\\)%", ".*");
        pattern = ((String)pattern).replaceAll("(?<!\\\\)_", ".");
        pattern = ((String)pattern).replaceAll("\\\\%", "%");
        pattern = ((String)pattern).replaceAll("\\\\_", "_");
        pattern = "^" + (String)pattern + "$";
        return pattern;
    }

    public static boolean isLob(DatabaseField field) {
        int sqlType = field.sqlType;
        if (sqlType == Integer.MIN_VALUE) {
            Class<?> type = field.getType();
            if (type != null) {
                return ClassConstants.BLOB.equals(type) || ClassConstants.CLOB.equals(type);
            }
            return false;
        }
        return DatabaseAccessor.isBlob(sqlType) || DatabaseAccessor.isClob(sqlType);
    }

    public static boolean hasLob(Collection<DatabaseField> fields) {
        for (DatabaseField field : fields) {
            if (!Helper.isLob(field)) continue;
            return true;
        }
        return false;
    }

    public static long timeWithRoundMiliseconds() {
        return new java.util.Date().getTime() / 1000L * 1000L;
    }

    static {
        PATH_SEPARATOR = null;
        FILE_SEPARATOR = null;
        CURRENT_WORKING_DIRECTORY = null;
        TEMP_DIRECTORY = null;
        isZeroValidPrimaryKey = false;
        POSITION_AFTER_IS_PREFIX = IS_PROPERTY_METHOD_PREFIX.length();
        POSITION_AFTER_GET_PREFIX = GET_PROPERTY_METHOD_PREFIX.length();
        defaultStartDatabaseDelimiter = null;
        defaultEndDatabaseDelimiter = null;
    }
}

