/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.renderkit.html;

import com.sun.webui.jsf.component.Form;
import com.sun.webui.jsf.renderkit.html.AbstractRenderer;
import com.sun.webui.jsf.util.LogUtil;
import com.sun.webui.jsf.util.RenderingUtilities;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import java.io.IOException;
import java.util.Map;

public final class FormRenderer
extends AbstractRenderer {
    private static final String[] STRING_ATTRIBUTES = new String[]{"enctype", "accessKey", "onReset", "onSubmit", "target"};
    private static final String SUBMISSION_COMPONENT_HIDDEN_FIELD = "_submissionComponentId";
    private static final String FORM_HIDDEN_FIELD = "_hidden";

    @Override
    public void decode(FacesContext context, UIComponent component) throws NullPointerException {
        Form.VirtualFormDescriptor vfd;
        String hiddenFieldClientId;
        String submissionComponentId;
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        Form form = (Form)component;
        Map map = context.getExternalContext().getRequestParameterMap();
        boolean b = map.containsKey(form.getClientId(context) + FORM_HIDDEN_FIELD);
        form.setSubmitted(b);
        if (LogUtil.fineEnabled()) {
            LogUtil.fine("Form(id=" + form.getId() + ",submitted=" + form.isSubmitted() + ")");
        }
        if ((submissionComponentId = (String)map.get(hiddenFieldClientId = SUBMISSION_COMPONENT_HIDDEN_FIELD)) != null && (vfd = form.getVFormCompSubmits(submissionComponentId)) != null) {
            form.setSubmittedVirtualForm(vfd);
        }
    }

    @Override
    protected void renderStart(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        Form form = (Form)component;
        if (LogUtil.fineEnabled()) {
            LogUtil.fine("Form(id=" + form.getId() + ")");
        }
        writer.startElement("form", (UIComponent)form);
        form.restoreNonParticipatingSubmittedValues();
    }

    @Override
    protected void renderAttributes(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        Form form = (Form)component;
        this.addCoreAttributes(context, (UIComponent)form, writer, "form");
        writer.writeAttribute("method", (Object)"post", null);
        writer.writeAttribute("action", (Object)this.action(context), null);
        FormRenderer.addStringAttributes(context, (UIComponent)form, writer, EVENTS_ATTRIBUTES);
        FormRenderer.addStringAttributes(context, (UIComponent)form, writer, STRING_ATTRIBUTES);
        if (!form.isAutoComplete()) {
            writer.writeAttribute("autocomplete", (Object)"off", null);
        }
        writer.write("\n");
    }

    @Override
    protected void renderEnd(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        Form form = (Form)component;
        writer.write("\n");
        RenderingUtilities.renderHiddenField(component, writer, form.getClientId(context) + FORM_HIDDEN_FIELD, form.getClientId(context) + FORM_HIDDEN_FIELD);
        writer.write("\n");
        context.getApplication().getViewHandler().writeState(context);
        writer.write("\n");
        writer.endElement("form");
        writer.write("\n");
        if (LogUtil.finestEnabled()) {
            LogUtil.finest("  Rendering completed");
        }
    }

    private String action(FacesContext context) {
        String viewId = context.getViewRoot().getViewId();
        String url = context.getApplication().getViewHandler().getActionURL(context, viewId);
        return context.getExternalContext().encodeActionURL(url);
    }

    private String function(FacesContext context, Form form, String handler) {
        String clientId = form.getClientId(context);
        return handler + "_" + clientId.replace(':', '_');
    }
}

