/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.deployment.node;

import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.RoleReference;
import com.sun.enterprise.deployment.RunAsIdentityDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.deployment.node.DisplayableComponentNode;
import com.sun.enterprise.deployment.node.RunAsNode;
import com.sun.enterprise.deployment.node.SecurityRoleRefNode;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.deployment.web.InitializationParameter;
import com.sun.enterprise.deployment.web.MultipartConfig;
import com.sun.enterprise.deployment.web.SecurityRoleReference;
import java.util.Enumeration;
import java.util.Map;
import java.util.logging.Level;
import org.glassfish.deployment.common.Descriptor;
import org.glassfish.web.deployment.descriptor.MultipartConfigDescriptor;
import org.glassfish.web.deployment.descriptor.WebComponentDescriptorImpl;
import org.glassfish.web.deployment.node.InitParamNode;
import org.glassfish.web.deployment.node.MultipartConfigNode;
import org.glassfish.web.deployment.node.WebCommonNode;
import org.w3c.dom.Node;

public class ServletNode
extends DisplayableComponentNode<WebComponentDescriptor> {
    private static final XMLElement tag = new XMLElement("servlet");
    private WebComponentDescriptor descriptor;

    public ServletNode() {
        this.registerElementHandler(new XMLElement("security-role-ref"), SecurityRoleRefNode.class);
        this.registerElementHandler(new XMLElement("init-param"), InitParamNode.class);
        this.registerElementHandler(new XMLElement("run-as"), RunAsNode.class, "setRunAsIdentity");
        this.registerElementHandler(new XMLElement("multipart-config"), MultipartConfigNode.class);
    }

    protected XMLElement getXMLRootTag() {
        return tag;
    }

    public WebComponentDescriptor getDescriptor() {
        if (this.descriptor == null) {
            this.descriptor = new WebComponentDescriptorImpl();
        }
        return this.descriptor;
    }

    public void addDescriptor(Object newDescriptor) {
        if (newDescriptor instanceof RoleReference) {
            if (DOLUtils.getDefaultLogger().isLoggable(Level.FINE)) {
                DOLUtils.getDefaultLogger().fine("Adding security role ref " + newDescriptor);
            }
            this.descriptor.addSecurityRoleReference((SecurityRoleReference)((RoleReference)newDescriptor));
        } else if (newDescriptor instanceof EnvironmentProperty) {
            if (DOLUtils.getDefaultLogger().isLoggable(Level.FINE)) {
                DOLUtils.getDefaultLogger().fine("Adding init-param " + newDescriptor);
            }
            this.descriptor.addInitializationParameter((InitializationParameter)newDescriptor);
        } else if (newDescriptor instanceof MultipartConfig) {
            this.descriptor.setMultipartConfig((MultipartConfig)newDescriptor);
        } else {
            super.addDescriptor(newDescriptor);
        }
    }

    protected Map<String, String> getDispatchTable() {
        Map table = super.getDispatchTable();
        table.put("display-name", "setName");
        table.put("servlet-name", "setCanonicalName");
        return table;
    }

    public void setElementValue(XMLElement element, String value) {
        if ("servlet-class".equals(element.getQName())) {
            this.descriptor.setServlet(true);
            this.descriptor.setWebComponentImplementation(value);
        } else if ("jsp-file".equals(element.getQName())) {
            this.descriptor.setServlet(false);
            this.descriptor.setWebComponentImplementation(value);
        } else if ("load-on-startup".equals(element.getQName())) {
            if (value.trim().equals("")) {
                this.descriptor.setLoadOnStartUp(Integer.valueOf(Integer.MAX_VALUE));
            } else {
                this.descriptor.setLoadOnStartUp(Integer.valueOf(value));
            }
        } else if ("enabled".equals(element.getQName())) {
            this.descriptor.setEnabled(Boolean.parseBoolean(value));
        } else if ("async-supported".equals(element.getQName())) {
            this.descriptor.setAsyncSupported(Boolean.valueOf(value));
        } else {
            super.setElementValue(element, value);
        }
    }

    public Node writeDescriptor(Node parent, WebComponentDescriptor descriptor) {
        RunAsIdentityDescriptor runAs;
        Node myNode = super.writeDescriptor(parent, (Descriptor)descriptor);
        ServletNode.appendTextChild((Node)myNode, (String)"servlet-name", (String)descriptor.getCanonicalName());
        if (descriptor.isServlet()) {
            ServletNode.appendTextChild((Node)myNode, (String)"servlet-class", (String)descriptor.getWebComponentImplementation());
        } else {
            ServletNode.appendTextChild((Node)myNode, (String)"jsp-file", (String)descriptor.getWebComponentImplementation());
        }
        WebCommonNode.addInitParam(myNode, "init-param", descriptor.getInitializationParameters());
        if (descriptor.getLoadOnStartUp() != null) {
            ServletNode.appendTextChild((Node)myNode, (String)"load-on-startup", (String)String.valueOf(descriptor.getLoadOnStartUp()));
        }
        ServletNode.appendTextChild((Node)myNode, (String)"enabled", (String)String.valueOf(descriptor.isEnabled()));
        if (descriptor.isAsyncSupported() != null) {
            ServletNode.appendTextChild((Node)myNode, (String)"async-supported", (String)String.valueOf(descriptor.isAsyncSupported()));
        }
        if ((runAs = descriptor.getRunAsIdentity()) != null) {
            RunAsNode runAsNode = new RunAsNode();
            runAsNode.writeDescriptor(myNode, "run-as", runAs);
        }
        Enumeration roleRefs = descriptor.getSecurityRoleReferences();
        SecurityRoleRefNode roleRefNode = new SecurityRoleRefNode();
        while (roleRefs.hasMoreElements()) {
            roleRefNode.writeDescriptor(myNode, "security-role-ref", (RoleReference)roleRefs.nextElement());
        }
        MultipartConfigDescriptor multipartConfigDesc = (MultipartConfigDescriptor)descriptor.getMultipartConfig();
        if (multipartConfigDesc != null) {
            MultipartConfigNode multipartConfigNode = new MultipartConfigNode();
            multipartConfigNode.writeDescriptor(myNode, "multipart-config", multipartConfigDesc);
        }
        return myNode;
    }
}

