/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.ee.perms;

import com.sun.enterprise.security.ee.perms.SMGlobalPolicyUtil;
import java.io.File;
import java.io.FilePermission;
import java.net.MalformedURLException;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.deployment.DeploymentContext;

public class PermissionsProcessor {
    public static final String CURRENT_FOLDER = "*";
    public static final String TEMP_FOLDER = "SERVLET-CONTEXT-TEMPDIR";
    protected DeploymentContext context;
    protected SMGlobalPolicyUtil.CommponentType type;
    protected static final Logger logger = Logger.getLogger("jakarta.enterprise.system.core.security");

    public PermissionsProcessor(SMGlobalPolicyUtil.CommponentType type, DeploymentContext dc) throws SecurityException {
        this.type = type;
        this.context = dc;
    }

    protected static PermissionCollection processPermisssonsForPath(PermissionCollection originalPC, DeploymentContext dc) throws MalformedURLException {
        if (originalPC == null) {
            return originalPC;
        }
        Permissions revisedPC = new Permissions();
        Enumeration<Permission> pcEnum = originalPC.elements();
        while (pcEnum.hasMoreElements()) {
            Permission perm = pcEnum.nextElement();
            if (perm instanceof FilePermission) {
                PermissionsProcessor.processFilePermission(revisedPC, dc, (FilePermission)perm);
                continue;
            }
            revisedPC.add(perm);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Revised permissions = " + revisedPC);
        }
        return revisedPC;
    }

    protected static void processFilePermission(PermissionCollection revisedPC, DeploymentContext dc, FilePermission fp) throws MalformedURLException {
        if (PermissionsProcessor.isFilePermforCurrentDir(fp)) {
            PermissionsProcessor.addFilePermissionsForCurrentDir(revisedPC, dc, fp);
        } else if (PermissionsProcessor.isFilePermforTempDir(fp)) {
            PermissionsProcessor.convertTempDirPermission(revisedPC, dc, fp);
        } else {
            revisedPC.add(fp);
        }
    }

    protected static boolean isFilePermforCurrentDir(FilePermission fp) {
        if (fp == null) {
            return false;
        }
        String name = fp.getName();
        return CURRENT_FOLDER.equals(name);
    }

    protected static boolean isFilePermforTempDir(FilePermission fp) {
        if (fp == null) {
            return false;
        }
        String name = fp.getName();
        return TEMP_FOLDER.equals(name);
    }

    protected static void addFilePermissionsForCurrentDir(PermissionCollection revisedPC, DeploymentContext context, FilePermission perm) throws MalformedURLException {
        if (!PermissionsProcessor.isFilePermforCurrentDir(perm)) {
            revisedPC.add(perm);
            return;
        }
        String actions = perm.getActions();
        String rootDir = context.getSource().getURI().toURL().toString();
        FilePermission rootDirPerm = new FilePermission(rootDir, actions);
        revisedPC.add(rootDirPerm);
        FilePermission rootPerm = new FilePermission(rootDir + File.separator + "-", actions);
        revisedPC.add(rootPerm);
        if (context.getScratchDir("ejb") != null) {
            String ejbTmpDir = context.getScratchDir("ejb").toURI().toURL().toString();
            FilePermission ejbDirPerm = new FilePermission(ejbTmpDir, actions);
            revisedPC.add(ejbDirPerm);
            FilePermission ejbPerm = new FilePermission(ejbTmpDir + File.separator + "-", actions);
            revisedPC.add(ejbPerm);
        }
        if (context.getScratchDir("jsp") != null) {
            String jspdir = context.getScratchDir("jsp").toURI().toURL().toString();
            FilePermission jpsDirPerm = new FilePermission(jspdir, actions);
            revisedPC.add(jpsDirPerm);
            FilePermission jpsPerm = new FilePermission(jspdir + File.separator + "-", actions);
            revisedPC.add(jpsPerm);
        }
    }

    protected static Permission convertTempDirPermission(PermissionCollection revisedPC, DeploymentContext context, FilePermission perm) throws MalformedURLException {
        if (!PermissionsProcessor.isFilePermforTempDir(perm)) {
            return perm;
        }
        String actions = perm.getActions();
        if (context.getScratchDir("jsp") != null) {
            String jspdir = context.getScratchDir("jsp").toURI().toURL().toString();
            FilePermission jspDirPerm = new FilePermission(jspdir, actions);
            revisedPC.add(jspDirPerm);
            FilePermission jspPerm = new FilePermission(jspdir + File.separator + "-", actions);
            revisedPC.add(jspPerm);
            return jspPerm;
        }
        return perm;
    }
}

