/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.serializer;

import java.time.Instant;
import java.time.YearMonth;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import org.eclipse.yasson.internal.model.customization.Customization;
import org.eclipse.yasson.internal.serializer.AbstractDateTimeDeserializer;

public class YearMonthTypeDeserializer
extends AbstractDateTimeDeserializer<YearMonth> {
    private static final DateTimeFormatter DEFAULT_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM").withZone(UTC);

    public YearMonthTypeDeserializer(Customization customization) {
        super(YearMonth.class, customization);
    }

    @Override
    protected YearMonth fromInstant(Instant instant) {
        return YearMonth.from(instant.atZone(UTC));
    }

    @Override
    protected YearMonth parseDefault(String jsonValue, Locale locale) {
        return YearMonth.parse(jsonValue, DEFAULT_FORMAT.withLocale(locale));
    }

    @Override
    protected YearMonth parseWithFormatter(String jsonValue, DateTimeFormatter formatter) {
        return YearMonth.parse(jsonValue, formatter);
    }
}

