/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa;

import jakarta.persistence.CacheStoreMode;
import jakarta.persistence.EntityExistsException;
import jakarta.persistence.EntityGraph;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.EntityNotFoundException;
import jakarta.persistence.EntityTransaction;
import jakarta.persistence.FlushModeType;
import jakarta.persistence.LockModeType;
import jakarta.persistence.LockTimeoutException;
import jakarta.persistence.PersistenceException;
import jakarta.persistence.PessimisticLockException;
import jakarta.persistence.Query;
import jakarta.persistence.StoredProcedureQuery;
import jakarta.persistence.SynchronizationType;
import jakarta.persistence.TransactionRequiredException;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaDelete;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.CriteriaUpdate;
import jakarta.persistence.metamodel.Metamodel;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.sql.DataSource;
import org.eclipse.persistence.annotations.CacheKeyType;
import org.eclipse.persistence.config.EntityManagerProperties;
import org.eclipse.persistence.config.ReferenceMode;
import org.eclipse.persistence.descriptors.CMPPolicy;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.VersionLockingPolicy;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.exceptions.JPQLException;
import org.eclipse.persistence.exceptions.OptimisticLockException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.internal.descriptors.OptimisticLockingPolicy;
import org.eclipse.persistence.internal.helper.BasicTypeHelperImpl;
import org.eclipse.persistence.internal.identitymaps.CacheId;
import org.eclipse.persistence.internal.jpa.EJBQueryImpl;
import org.eclipse.persistence.internal.jpa.EntityGraphImpl;
import org.eclipse.persistence.internal.jpa.EntityManagerFactoryDelegate;
import org.eclipse.persistence.internal.jpa.EntityManagerFactoryImpl;
import org.eclipse.persistence.internal.jpa.EntityManagerFactoryProvider;
import org.eclipse.persistence.internal.jpa.EntityManagerSetupImpl;
import org.eclipse.persistence.internal.jpa.QueryHintsHandler;
import org.eclipse.persistence.internal.jpa.QueryImpl;
import org.eclipse.persistence.internal.jpa.StoredProcedureQueryImpl;
import org.eclipse.persistence.internal.jpa.querydef.CriteriaDeleteImpl;
import org.eclipse.persistence.internal.jpa.querydef.CriteriaQueryImpl;
import org.eclipse.persistence.internal.jpa.querydef.CriteriaUpdateImpl;
import org.eclipse.persistence.internal.jpa.transaction.EntityTransactionImpl;
import org.eclipse.persistence.internal.jpa.transaction.EntityTransactionWrapper;
import org.eclipse.persistence.internal.jpa.transaction.JTATransactionWrapper;
import org.eclipse.persistence.internal.jpa.transaction.TransactionWrapper;
import org.eclipse.persistence.internal.jpa.transaction.TransactionWrapperImpl;
import org.eclipse.persistence.internal.localization.ExceptionLocalization;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.DatabaseSessionImpl;
import org.eclipse.persistence.internal.sessions.PropertiesHandler;
import org.eclipse.persistence.internal.sessions.RepeatableWriteUnitOfWork;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.jpa.JpaEntityManager;
import org.eclipse.persistence.queries.AttributeGroup;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.DataReadQuery;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.FetchGroupTracker;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.queries.ResultSetMappingQuery;
import org.eclipse.persistence.queries.SQLResultSetMapping;
import org.eclipse.persistence.queries.StoredProcedureCall;
import org.eclipse.persistence.sessions.Connector;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.DatasourceLogin;
import org.eclipse.persistence.sessions.DefaultConnector;
import org.eclipse.persistence.sessions.JNDIConnector;
import org.eclipse.persistence.sessions.Login;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.sessions.broker.SessionBroker;
import org.eclipse.persistence.sessions.factories.SessionManager;
import org.eclipse.persistence.sessions.server.ConnectionPolicy;
import org.eclipse.persistence.sessions.server.Server;
import org.eclipse.persistence.sessions.server.ServerSession;

public class EntityManagerImpl
implements JpaEntityManager {
    protected TransactionWrapperImpl transaction;
    protected boolean isOpen;
    protected RepeatableWriteUnitOfWork extendedPersistenceContext;
    protected AbstractSession readOnlySession;
    protected AbstractSession databaseSession;
    protected EntityManagerFactoryDelegate factory;
    protected boolean beginEarlyTransaction;
    protected Map properties;
    protected FlushModeType flushMode;
    protected ReferenceMode referenceMode;
    protected ConnectionPolicy connectionPolicy;
    protected Map<String, ConnectionPolicy> connectionPolicies;
    protected WeakHashMap<QueryImpl, QueryImpl> openQueriesMap;
    protected boolean closeOnCommit;
    protected boolean persistOnCommit;
    protected boolean cacheStoreBypass;
    protected String flushClearCache;
    protected boolean shouldValidateExistence;
    protected UnitOfWork.CommitOrderType commitOrder;
    protected boolean commitWithoutPersistRules;
    protected SynchronizationType syncType;
    static Map<String, PropertyProcessor> processors = new HashMap(){
        {
            this.put("eclipselink.transaction.join-existing", new PropertyProcessor(){

                @Override
                void process(String name, Object value, EntityManagerImpl em) {
                    em.beginEarlyTransaction = "true".equalsIgnoreCase(EntityManagerImpl.getPropertiesHandlerProperty(name, (String)value));
                }
            });
            this.put("eclipselink.persistence-context.reference-mode", new PropertyProcessor(){

                @Override
                void process(String name, Object value, EntityManagerImpl em) {
                    em.referenceMode = ReferenceMode.valueOf((String)EntityManagerImpl.getPropertiesHandlerProperty(name, (String)value));
                    if (em.hasActivePersistenceContext()) {
                        em.extendedPersistenceContext.log(6, "properties", "entity_manager_sets_property_while_context_is_active", new Object[]{name});
                    }
                }
            });
            this.put("eclipselink.persistence-context.flush-mode", new PropertyProcessor(){

                @Override
                void process(String name, Object value, EntityManagerImpl em) {
                    em.flushMode = FlushModeType.valueOf((String)EntityManagerImpl.getPropertiesHandlerProperty(name, (String)value));
                }
            });
            this.put("eclipselink.persistence-context.close-on-commit", new PropertyProcessor(){

                @Override
                void process(String name, Object value, EntityManagerImpl em) {
                    em.closeOnCommit = "true".equalsIgnoreCase(EntityManagerImpl.getPropertiesHandlerProperty(name, (String)value));
                    if (em.hasActivePersistenceContext()) {
                        em.extendedPersistenceContext.setResumeUnitOfWorkOnTransactionCompletion(!em.closeOnCommit);
                    }
                }
            });
            this.put("eclipselink.persistence-context.persist-on-commit", new PropertyProcessor(){

                @Override
                void process(String name, Object value, EntityManagerImpl em) {
                    em.persistOnCommit = "true".equalsIgnoreCase(EntityManagerImpl.getPropertiesHandlerProperty(name, (String)value));
                    if (em.hasActivePersistenceContext()) {
                        em.extendedPersistenceContext.setShouldDiscoverNewObjects(em.persistOnCommit);
                    }
                }
            });
            this.put("eclipselink.persistence-context.commit-without-persist-rules", new PropertyProcessor(){

                @Override
                void process(String name, Object value, EntityManagerImpl em) {
                    em.commitWithoutPersistRules = "true".equalsIgnoreCase(EntityManagerImpl.getPropertiesHandlerProperty(name, (String)value));
                    if (em.hasActivePersistenceContext()) {
                        em.extendedPersistenceContext.setDiscoverUnregisteredNewObjectsWithoutPersist(em.commitWithoutPersistRules);
                    }
                }
            });
            this.put("eclipselink.validate-existence", new PropertyProcessor(){

                @Override
                void process(String name, Object value, EntityManagerImpl em) {
                    em.shouldValidateExistence = "true".equalsIgnoreCase(EntityManagerImpl.getPropertiesHandlerProperty(name, (String)value));
                    if (em.hasActivePersistenceContext()) {
                        em.extendedPersistenceContext.setShouldValidateExistence(em.shouldValidateExistence);
                    }
                }
            });
            this.put("eclipselink.order-updates", new PropertyProcessor(){

                @Override
                void process(String name, Object value, EntityManagerImpl em) {
                    em.commitOrder = "true".equalsIgnoreCase(EntityManagerImpl.getPropertiesHandlerProperty(name, (String)value)) ? UnitOfWork.CommitOrderType.ID : UnitOfWork.CommitOrderType.NONE;
                    if (em.hasActivePersistenceContext()) {
                        em.extendedPersistenceContext.setCommitOrder(em.commitOrder);
                    }
                }
            });
            this.put("eclipselink.persistence-context.commit-order", new PropertyProcessor(){

                @Override
                void process(String name, Object value, EntityManagerImpl em) {
                    em.commitOrder = UnitOfWork.CommitOrderType.valueOf((String)EntityManagerImpl.getPropertiesHandlerProperty(name, (String)value).toUpperCase(Locale.ROOT));
                    if (em.hasActivePersistenceContext()) {
                        em.extendedPersistenceContext.setCommitOrder(em.commitOrder);
                    }
                }
            });
            this.put("eclipselink.flush-clear.cache", new PropertyProcessor(){

                @Override
                void process(String name, Object value, EntityManagerImpl em) {
                    em.flushClearCache = EntityManagerImpl.getPropertiesHandlerProperty(name, (String)value);
                    if (em.hasActivePersistenceContext()) {
                        em.extendedPersistenceContext.setFlushClearCache(em.flushClearCache);
                    }
                }
            });
            this.put("jakarta.persistence.cache.storeMode", new PropertyProcessor(){

                @Override
                void process(String name, Object value, EntityManagerImpl em) {
                    boolean bl = em.cacheStoreBypass = value.equals(CacheStoreMode.BYPASS) || value.equals(CacheStoreMode.BYPASS.name());
                    if (em.hasActivePersistenceContext()) {
                        em.extendedPersistenceContext.setShouldStoreByPassCache(em.cacheStoreBypass);
                    }
                }
            });
            PropertyProcessor connectionPolicyPropertyProcessor = new PropertyProcessor(){

                @Override
                void process(String name, Object value, EntityManagerImpl em) {
                    em.connectionPolicy = null;
                    if (em.hasActivePersistenceContext()) {
                        em.extendedPersistenceContext.log(6, "properties", "entity_manager_sets_property_while_context_is_active", new Object[]{name});
                    }
                }
            };
            this.put("eclipselink.jdbc.exclusive-connection.mode", connectionPolicyPropertyProcessor);
            this.put("eclipselink.jdbc.exclusive-connection.is-lazy", connectionPolicyPropertyProcessor);
            this.put("jakarta.persistence.jtaDataSource", connectionPolicyPropertyProcessor);
            this.put("jakarta.persistence.nonJtaDataSource", connectionPolicyPropertyProcessor);
            this.put("jakarta.persistence.jdbc.driver", connectionPolicyPropertyProcessor);
            this.put("jakarta.persistence.jdbc.url", connectionPolicyPropertyProcessor);
            this.put("jakarta.persistence.jdbc.user", connectionPolicyPropertyProcessor);
            this.put("jakarta.persistence.jdbc.password", connectionPolicyPropertyProcessor);
            this.put("eclipselink.jdbc.connection-policy", connectionPolicyPropertyProcessor);
            this.put("eclipselink.oracle.proxy-type", new PropertyProcessor(){

                @Override
                void process(String name, Object value, EntityManagerImpl em) {
                    if (em.hasActivePersistenceContext()) {
                        em.extendedPersistenceContext.log(6, "properties", "entity_manager_sets_property_while_context_is_active", new Object[]{name});
                    }
                }
            });
            this.put("eclipselink.composite-unit.properties", new PropertyProcessor(){

                @Override
                void process(String name, Object value, EntityManagerImpl em) {
                    if (em.connectionPolicies != null) {
                        Map mapOfProperties = (Map)value;
                        for (String sessionName : mapOfProperties.keySet()) {
                            if (!em.connectionPolicies.containsKey(sessionName)) continue;
                            em.connectionPolicies.put(sessionName, null);
                        }
                        if (em.hasActivePersistenceContext()) {
                            em.extendedPersistenceContext.log(6, "properties", "entity_manager_sets_property_while_context_is_active", new Object[]{name});
                        }
                    }
                }
            });
        }
    };

    public EntityManagerImpl(String sessionName) {
        this(SessionManager.getManager().getSession(sessionName), null, SynchronizationType.SYNCHRONIZED);
    }

    protected Map<QueryImpl, QueryImpl> getOpenQueriesMap() {
        if (this.openQueriesMap == null) {
            this.openQueriesMap = new WeakHashMap();
        }
        return this.openQueriesMap;
    }

    protected Set<QueryImpl> getOpenQueriesSet() {
        return this.getOpenQueriesMap().keySet();
    }

    public void addOpenQuery(QueryImpl query) {
        this.getOpenQueriesMap().put(query, query);
        Object transaction = this.checkForTransaction(false);
        if (transaction != null && transaction instanceof EntityTransactionImpl) {
            ((EntityTransactionImpl)transaction).addOpenQuery(query);
        }
    }

    public EntityManagerImpl(AbstractSession databaseSession, SynchronizationType syncType) {
        this(databaseSession, null, syncType);
    }

    public EntityManagerImpl(AbstractSession databaseSession, Map properties, SynchronizationType syncType) {
        this(new EntityManagerFactoryImpl(databaseSession).unwrap(), properties, syncType);
    }

    public EntityManagerImpl(EntityManagerFactoryDelegate factory, Map properties, SynchronizationType syncType) {
        this.factory = factory;
        this.databaseSession = factory.getAbstractSession();
        this.beginEarlyTransaction = factory.getBeginEarlyTransaction();
        this.closeOnCommit = factory.getCloseOnCommit();
        this.flushMode = factory.getFlushMode();
        this.persistOnCommit = factory.getPersistOnCommit();
        this.commitWithoutPersistRules = factory.getCommitWithoutPersistRules();
        this.referenceMode = factory.getReferenceMode();
        this.flushClearCache = factory.getFlushClearCache();
        this.shouldValidateExistence = factory.shouldValidateExistence();
        this.commitOrder = factory.getCommitOrder();
        this.isOpen = true;
        this.cacheStoreBypass = false;
        this.syncType = syncType;
        this.initialize(properties);
    }

    protected void initialize(Map properties) {
        this.detectTransactionWrapper();
        if (this.databaseSession.isServerSession()) {
            this.connectionPolicy = ((ServerSession)this.databaseSession).getDefaultConnectionPolicy();
        } else if (this.databaseSession.isBroker()) {
            SessionBroker broker = (SessionBroker)this.databaseSession;
            this.connectionPolicies = new HashMap<String, ConnectionPolicy>(broker.getSessionsByName().size());
            for (Map.Entry entry : broker.getSessionsByName().entrySet()) {
                this.connectionPolicies.put((String)entry.getKey(), ((ServerSession)entry.getValue()).getDefaultConnectionPolicy());
            }
        }
        if (properties != null) {
            this.properties = new HashMap(properties);
            if (!properties.isEmpty()) {
                this.processProperties();
            }
        }
    }

    public void clear() {
        try {
            this.verifyOpen();
            if (this.extendedPersistenceContext != null) {
                if (this.checkForTransaction(false) == null) {
                    if (this.extendedPersistenceContext.isSynchronized() && (this.extendedPersistenceContext.isCommitPending() || this.extendedPersistenceContext.isAfterWriteChangesButBeforeCommit() || this.extendedPersistenceContext.isMergePending())) {
                        this.extendedPersistenceContext.setResumeUnitOfWorkOnTransactionCompletion(false);
                    } else {
                        this.extendedPersistenceContext.clearForClose(true);
                        this.extendedPersistenceContext.release();
                        this.extendedPersistenceContext.getParent().release();
                    }
                    this.extendedPersistenceContext = null;
                } else {
                    this.extendedPersistenceContext.clear(true);
                }
            }
        }
        catch (RuntimeException exception) {
            this.setRollbackOnly();
            throw exception;
        }
    }

    public void removeExtendedPersistenceContext() {
        this.extendedPersistenceContext = null;
    }

    public void persist(Object entity) {
        try {
            this.verifyOpen();
            if (entity == null) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"not_an_entity", (Object[])new Object[]{null}));
            }
            try {
                this.getActivePersistenceContext(this.checkForTransaction(false)).registerNewObjectForPersist(entity, new IdentityHashMap());
            }
            catch (RuntimeException exception) {
                if (exception instanceof ValidationException) {
                    throw new EntityExistsException(exception.getLocalizedMessage(), (Throwable)exception);
                }
                throw exception;
            }
        }
        catch (RuntimeException exception) {
            this.setRollbackOnly();
            throw exception;
        }
    }

    public <T> T merge(T entity) {
        try {
            this.verifyOpen();
            return (T)this.mergeInternal(entity);
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    protected Object mergeInternal(Object entity) {
        if (entity == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"not_an_entity", (Object[])new Object[]{null}));
        }
        Object merged = null;
        RepeatableWriteUnitOfWork context = this.getActivePersistenceContext(this.checkForTransaction(false));
        try {
            merged = context.mergeCloneWithReferences(entity, 4, true);
        }
        catch (OptimisticLockException ole) {
            throw new jakarta.persistence.OptimisticLockException((Throwable)ole);
        }
        return merged;
    }

    public void remove(Object entity) {
        try {
            this.verifyOpen();
            if (entity == null) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"not_an_entity", (Object[])new Object[]{null}));
            }
            this.getActivePersistenceContext(this.checkForTransaction(false)).performRemove(entity, new IdentityHashMap());
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    public <T> T find(Class<T> entityClass, Object primaryKey) {
        return this.find(entityClass, primaryKey, null, this.getQueryHints(entityClass, OperationType.FIND));
    }

    public <T> T find(Class<T> entityClass, Object primaryKey, Map<String, Object> properties) {
        return this.find(entityClass, primaryKey, null, properties);
    }

    public <T> T find(Class<T> entityClass, Object primaryKey, LockModeType lockMode) {
        return this.find(entityClass, primaryKey, lockMode, this.getQueryHints(entityClass, OperationType.FIND));
    }

    public <T> T find(Class<T> entityClass, Object primaryKey, LockModeType lockMode, Map<String, Object> properties) {
        try {
            AbstractSession session;
            ClassDescriptor descriptor;
            this.verifyOpen();
            if (lockMode != null && !lockMode.equals((Object)LockModeType.NONE)) {
                this.checkForTransaction(true);
            }
            if ((descriptor = (session = this.databaseSession).getDescriptor(entityClass)) == null || descriptor.isDescriptorTypeAggregate()) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"unknown_bean_class", (Object[])new Object[]{entityClass}));
            }
            session = !descriptor.shouldBeReadOnly() || !descriptor.isSharedIsolation() ? (AbstractSession)this.getActiveSession() : (AbstractSession)this.getReadOnlySession();
            if (descriptor.hasTablePerMultitenantPolicy()) {
                descriptor = session.getDescriptor(entityClass);
            }
            return (T)this.findInternal(descriptor, session, primaryKey, lockMode, properties);
        }
        catch (LockTimeoutException e) {
            throw e;
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    public Object find(String entityName, Object primaryKey) {
        try {
            this.verifyOpen();
            AbstractSession session = (AbstractSession)this.getActiveSession();
            ClassDescriptor descriptor = session.getDescriptorForAlias(entityName);
            if (descriptor == null || descriptor.isDescriptorTypeAggregate()) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"unknown_entitybean_name", (Object[])new Object[]{entityName}));
            }
            return this.findInternal(descriptor, session, primaryKey, null, null);
        }
        catch (LockTimeoutException e) {
            throw e;
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    protected Object findInternal(ClassDescriptor descriptor, AbstractSession session, Object id, LockModeType lockMode, Map<String, Object> properties) {
        ReadObjectQuery query;
        Object primaryKey;
        if (id == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"null_pk"));
        }
        if (id instanceof List) {
            primaryKey = descriptor.getCacheKeyType() == CacheKeyType.ID_VALUE ? (((List)id).isEmpty() ? null : ((List)id).get(0)) : new CacheId(((List)id).toArray());
        } else if (id instanceof CacheId) {
            primaryKey = id;
        } else {
            CMPPolicy policy = descriptor.getCMPPolicy();
            Class pkClass = policy.getPKClass();
            if (pkClass != null && pkClass != id.getClass() && !BasicTypeHelperImpl.getInstance().isStrictlyAssignableFrom((Object)pkClass, id.getClass())) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"invalid_pk_class", (Object[])new Object[]{descriptor.getCMPPolicy().getPKClass(), id.getClass()}));
            }
            primaryKey = policy.createPrimaryKeyFromId(id, session);
        }
        if (lockMode != null && (lockMode.name().equals("PESSIMISTIC_READ") || lockMode.name().equals("PESSIMISTIC_WRITE") || lockMode.name().equals("PESSIMISTIC_FORCE_INCREMENT")) && session.isUnitOfWork() && ((UnitOfWorkImpl)session).hasPessimisticLockedObjects()) {
            query = new ReadObjectQuery();
            query.setReferenceClass(descriptor.getJavaClass());
            query.setSelectionId(primaryKey);
            query.checkCacheOnly();
            Object cachedEntity = session.executeQuery((DatabaseQuery)query);
            if (cachedEntity != null && ((UnitOfWorkImpl)session).isPessimisticLocked(cachedEntity)) {
                return cachedEntity;
            }
        }
        if ((query = descriptor.getQueryManager().getReadObjectQuery()) == null) {
            query = this.getReadObjectQuery(descriptor.getJavaClass(), primaryKey, properties);
        } else {
            query.checkPrepare(session, null);
            query = (ReadObjectQuery)query.clone();
            QueryHintsHandler.apply(properties, (DatabaseQuery)query, session.getLoader(), session);
            query.setIsExecutionClone(true);
            query.setSelectionId(primaryKey);
        }
        if (!(properties != null && (properties.containsKey("eclipselink.cache-usage") || properties.containsKey("jakarta.persistence.cache.retrieveMode") || properties.containsKey("jakarta.persistence.cache.storeMode") || properties.containsKey("jakarta.persistence.cacheRetrieveMode") || properties.containsKey("jakarta.persistence.cacheStoreMode")))) {
            query.conformResultsInUnitOfWork();
        }
        return this.executeQuery(query, lockMode, session);
    }

    public void flush() {
        try {
            this.verifyOpen();
            try {
                try {
                    this.getActivePersistenceContext(this.checkForTransaction(true)).writeChanges();
                }
                catch (OptimisticLockException eclipselinkOLE) {
                    throw new jakarta.persistence.OptimisticLockException((Throwable)eclipselinkOLE);
                }
            }
            catch (EclipseLinkException e) {
                throw new PersistenceException((Throwable)e);
            }
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    protected void detectTransactionWrapper() {
        if (this.databaseSession.hasExternalTransactionController()) {
            this.setJTATransactionWrapper();
        } else {
            this.setEntityTransactionWrapper();
        }
    }

    private Object executeQuery(ReadObjectQuery query, LockModeType lockMode, AbstractSession session) {
        if (lockMode != null && query.setLockModeType(lockMode.name(), session)) {
            throw new PersistenceException(ExceptionLocalization.buildMessage((String)"ejb30-wrong-lock_called_without_version_locking-index", null));
        }
        Object result = null;
        try {
            result = session.executeQuery((DatabaseQuery)query);
        }
        catch (DatabaseException e) {
            if (lockMode != null && lockMode.name().contains("PESSIMISTIC_")) {
                if (query.getExecutionSession().getPlatform().isLockTimeoutException(e)) {
                    throw new LockTimeoutException((Throwable)e);
                }
                throw new PessimisticLockException((Throwable)e);
            }
            throw e;
        }
        return result;
    }

    public void refresh(Object entity) {
        this.refresh(entity, null, this.getQueryHints(entity, OperationType.REFRESH));
    }

    public void refresh(Object entity, Map<String, Object> properties) {
        this.refresh(entity, null, properties);
    }

    public void refresh(Object entity, LockModeType lockMode) {
        this.refresh(entity, lockMode, this.getQueryHints(entity, OperationType.REFRESH));
    }

    public void refresh(Object entity, LockModeType lockMode, Map<String, Object> properties) {
        try {
            Object refreshedEntity;
            this.verifyOpen();
            boolean validateExistence = lockMode != null && !lockMode.equals((Object)LockModeType.NONE);
            RepeatableWriteUnitOfWork uow = this.getActivePersistenceContext(this.checkForTransaction(validateExistence));
            if (!this.contains(entity, (UnitOfWork)uow)) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"cant_refresh_not_managed_object", (Object[])new Object[]{entity}));
            }
            ReadObjectQuery query = this.getReadObjectQuery(entity, properties);
            if (properties == null || !properties.containsKey("eclipselink.refresh")) {
                query.refreshIdentityMapResult();
            }
            if (properties == null || !properties.containsKey("eclipselink.refresh.cascade")) {
                query.cascadeByMapping();
            }
            if ((refreshedEntity = this.executeQuery(query, lockMode, (AbstractSession)uow)) == null) {
                throw new EntityNotFoundException(ExceptionLocalization.buildMessage((String)"entity_no_longer_exists_in_db", (Object[])new Object[]{entity}));
            }
        }
        catch (LockTimeoutException e) {
            throw e;
        }
        catch (RuntimeException exception) {
            this.setRollbackOnly();
            throw exception;
        }
    }

    public boolean contains(Object entity) {
        try {
            this.verifyOpen();
            if (entity == null) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"not_an_entity", (Object[])new Object[]{null}));
            }
            ClassDescriptor descriptor = (ClassDescriptor)this.databaseSession.getDescriptors().get(entity.getClass());
            if (descriptor == null || descriptor.isDescriptorTypeAggregate()) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"not_an_entity", (Object[])new Object[]{entity}));
            }
            if (!this.hasActivePersistenceContext()) {
                return false;
            }
            return this.contains(entity, (UnitOfWork)this.getActivePersistenceContext(this.checkForTransaction(false)));
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    protected boolean contains(Object entity, UnitOfWork uow) {
        return ((UnitOfWorkImpl)uow).isObjectRegistered(entity) && !((UnitOfWorkImpl)uow).isObjectDeleted(entity);
    }

    @Override
    public Query createDescriptorNamedQuery(String queryName, Class descriptorClass) {
        return this.createDescriptorNamedQuery(queryName, descriptorClass, null);
    }

    @Override
    public Query createDescriptorNamedQuery(String queryName, Class descriptorClass, List argumentTypes) {
        try {
            DatabaseQuery query;
            this.verifyOpen();
            ClassDescriptor descriptor = this.databaseSession.getDescriptor(descriptorClass);
            if (descriptor != null && (query = descriptor.getQueryManager().getLocalQueryByArgumentTypes(queryName, argumentTypes)) != null) {
                return new EJBQueryImpl(query, this);
            }
            return null;
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    public Query createNamedQuery(String name) {
        try {
            this.verifyOpen();
            EJBQueryImpl query = new EJBQueryImpl(name, this, true);
            query.getDatabaseQueryInternal();
            return query;
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    public <T> TypedQuery<T> createNamedQuery(String name, Class<T> resultClass) {
        return (TypedQuery)this.createNamedQuery(name);
    }

    public StoredProcedureQuery createNamedStoredProcedureQuery(String name) {
        try {
            this.verifyOpen();
            StoredProcedureQueryImpl query = new StoredProcedureQueryImpl(name, this);
            query.getDatabaseQueryInternal();
            return query;
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    public Query createNativeQuery(String sqlString) {
        try {
            this.verifyOpen();
            return new EJBQueryImpl(EJBQueryImpl.buildSQLDatabaseQuery(sqlString, this.databaseSession.getLoader(), this.databaseSession), this);
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    public Query createNativeQuery(String sqlString, Class resultType) {
        try {
            this.verifyOpen();
            return new EJBQueryImpl(EJBQueryImpl.buildSQLDatabaseQuery(resultType, sqlString, this.databaseSession.getLoader(), this.databaseSession), this);
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    public Query createNativeQuery(String sqlString, String resultSetMapping) {
        try {
            this.verifyOpen();
            ResultSetMappingQuery query = new ResultSetMappingQuery();
            query.setSQLResultSetMappingName(resultSetMapping);
            query.setSQLString(sqlString);
            query.setIsUserDefined(true);
            return new EJBQueryImpl((DatabaseQuery)query, this);
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    @Override
    public Session getActiveSession() {
        return this.getActivePersistenceContext(this.checkForTransaction(false));
    }

    public AbstractSession getActiveSessionIfExists() {
        if (this.hasActivePersistenceContext() || this.getAbstractSession().hasTablePerTenantDescriptors()) {
            return (AbstractSession)this.getActiveSession();
        }
        return this.getAbstractSession();
    }

    public Object getDelegate() {
        try {
            this.verifyOpen();
            return this;
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    public FlushModeType getFlushMode() {
        try {
            this.verifyOpen();
            return this.flushMode;
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    @Override
    public UnitOfWork getUnitOfWork() {
        return this.getActivePersistenceContext(this.checkForTransaction(false));
    }

    @Override
    public Session getSession() {
        if (this.checkForTransaction(false) == null) {
            return this.databaseSession.acquireNonSynchronizedUnitOfWork(this.referenceMode);
        }
        return null;
    }

    public EntityTransaction getTransaction() {
        try {
            return ((TransactionWrapper)((Object)this.transaction)).getTransaction();
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    public Object getProperty(String name) {
        Object propertyValue = null;
        if (name == null) {
            return null;
        }
        if (this.properties != null) {
            propertyValue = this.properties.get(name);
        }
        if (propertyValue == null) {
            propertyValue = this.factory.getAbstractSession().getProperty(name);
        }
        return propertyValue;
    }

    protected ReadObjectQuery getReadObjectQuery(Class referenceClass, Object primaryKey, Map properties) {
        ReadObjectQuery query = this.getReadObjectQuery(properties);
        query.setReferenceClass(referenceClass);
        query.setSelectionId(primaryKey);
        return query;
    }

    protected ReadObjectQuery getReadObjectQuery(Map properties) {
        ReadObjectQuery query = new ReadObjectQuery();
        QueryHintsHandler.apply(properties, (DatabaseQuery)query, this.databaseSession.getDatasourcePlatform().getConversionManager().getLoader(), this.databaseSession);
        query.setIsExecutionClone(true);
        return query;
    }

    protected ReadObjectQuery getReadObjectQuery(Object entity, Map properties) {
        ReadObjectQuery query = this.getReadObjectQuery(properties);
        query.setSelectionObject(entity);
        return query;
    }

    public <T> T getReference(Class<T> entityClass, Object primaryKey) {
        try {
            this.verifyOpen();
            UnitOfWork session = (UnitOfWork)this.getActiveSession();
            Object reference = session.getReference(entityClass, primaryKey);
            if (reference == null) {
                Object[] args = new Object[]{primaryKey};
                String message = ExceptionLocalization.buildMessage((String)"no_entities_retrieved_for_get_reference", (Object[])args);
                throw new EntityNotFoundException(message);
            }
            return (T)reference;
        }
        catch (RuntimeException exception) {
            this.setRollbackOnly();
            throw exception;
        }
    }

    public Session getReadOnlySession() {
        if (this.extendedPersistenceContext != null && this.extendedPersistenceContext.isActive()) {
            return this.extendedPersistenceContext.getParent();
        }
        if (this.readOnlySession != null) {
            return this.readOnlySession;
        }
        if (this.databaseSession.isServerSession()) {
            this.readOnlySession = ((ServerSession)this.databaseSession).acquireClientSession(this.connectionPolicy, this.properties);
            return this.readOnlySession;
        }
        if (this.databaseSession.isBroker()) {
            this.readOnlySession = ((SessionBroker)this.databaseSession).acquireClientSessionBroker(this.connectionPolicies, (Map)this.properties.get("eclipselink.composite-unit.properties"));
            return this.readOnlySession;
        }
        return this.databaseSession;
    }

    @Override
    public DatabaseSessionImpl getDatabaseSession() {
        return (DatabaseSessionImpl)this.databaseSession;
    }

    @Override
    public AbstractSession getAbstractSession() {
        return this.databaseSession;
    }

    public void setAbstractSession(AbstractSession session) {
        this.databaseSession = session;
    }

    @Override
    public ServerSession getServerSession() {
        return (ServerSession)this.databaseSession;
    }

    @Override
    public SessionBroker getSessionBroker() {
        return (SessionBroker)this.databaseSession;
    }

    public DatabaseSessionImpl getMemberDatabaseSession(Class cls) {
        if (this.databaseSession.isBroker()) {
            return (DatabaseSessionImpl)((SessionBroker)this.databaseSession).getSessionForClass(cls);
        }
        return null;
    }

    @Override
    public ServerSession getMemberServerSession(Class cls) {
        if (this.databaseSession.isBroker()) {
            return (ServerSession)((SessionBroker)this.databaseSession).getSessionForClass(cls);
        }
        return null;
    }

    @Override
    public String getMemberSessionName(Class cls) {
        if (this.databaseSession.isBroker()) {
            return ((SessionBroker)this.databaseSession).getSessionForClass(cls).getName();
        }
        return null;
    }

    @Override
    public Query createQuery(Expression expression, Class resultType) {
        try {
            this.verifyOpen();
            DatabaseQuery query = this.createQueryInternal(expression, resultType);
            return new EJBQueryImpl(query, this);
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    @Override
    public Query createQuery(DatabaseQuery databaseQuery) {
        try {
            this.verifyOpen();
            return new EJBQueryImpl(databaseQuery, this);
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    public <T> TypedQuery<T> createQuery(CriteriaQuery<T> criteriaQuery) {
        try {
            this.verifyOpen();
            return new EJBQueryImpl(((CriteriaQueryImpl)criteriaQuery).translate(), this);
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    @Override
    public Query createQueryByExample(Object exampleObject) {
        try {
            this.verifyOpen();
            ReadAllQuery query = new ReadAllQuery(exampleObject.getClass());
            query.setExampleObject(exampleObject);
            return new EJBQueryImpl((DatabaseQuery)query, this);
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    @Override
    public Query createQuery(Call call) {
        try {
            this.verifyOpen();
            DataReadQuery query = new DataReadQuery(call);
            return new EJBQueryImpl((DatabaseQuery)query, this);
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    @Override
    public Query createQuery(Call call, Class entityClass) {
        try {
            this.verifyOpen();
            ReadAllQuery query = new ReadAllQuery(entityClass, call);
            return new EJBQueryImpl((DatabaseQuery)query, this);
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    public Query createQuery(String jpqlString) {
        try {
            EJBQueryImpl ejbqImpl;
            this.verifyOpen();
            try {
                ejbqImpl = new EJBQueryImpl(jpqlString, this);
            }
            catch (JPQLException exception) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"wrap_ejbql_exception") + ": " + exception.getLocalizedMessage(), exception);
            }
            return ejbqImpl;
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    public <T> TypedQuery<T> createQuery(String qlString, Class<T> resultClass) {
        return (TypedQuery)this.createQuery(qlString);
    }

    protected DatabaseQuery createQueryInternal(Expression expression, Class resultType) {
        ReadAllQuery query = new ReadAllQuery(resultType);
        query.setSelectionCriteria(expression);
        return query;
    }

    public StoredProcedureQuery createStoredProcedureQuery(String procedureName) {
        try {
            this.verifyOpen();
            StoredProcedureCall call = new StoredProcedureCall();
            call.setProcedureName(procedureName);
            return new StoredProcedureQueryImpl(StoredProcedureQueryImpl.buildResultSetMappingQuery(new ArrayList<SQLResultSetMapping>(), call), this);
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    public StoredProcedureQuery createStoredProcedureQuery(String procedureName, Class ... resultClasses) {
        try {
            this.verifyOpen();
            StoredProcedureCall call = new StoredProcedureCall();
            call.setProcedureName(procedureName);
            call.setHasMultipleResultSets(resultClasses.length > 1);
            ArrayList<SQLResultSetMapping> sqlResultSetMappings = new ArrayList<SQLResultSetMapping>();
            for (Class resultClass : resultClasses) {
                sqlResultSetMappings.add(new SQLResultSetMapping(resultClass));
            }
            return new StoredProcedureQueryImpl(StoredProcedureQueryImpl.buildResultSetMappingQuery(sqlResultSetMappings, call), this);
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    public StoredProcedureQuery createStoredProcedureQuery(String procedureName, String ... resultSetMappings) {
        try {
            this.verifyOpen();
            StoredProcedureCall call = new StoredProcedureCall();
            call.setProcedureName(procedureName);
            call.setHasMultipleResultSets(resultSetMappings.length > 1);
            ArrayList<String> sqlResultSetMappingNames = new ArrayList<String>();
            for (String resultSetMapping : resultSetMappings) {
                sqlResultSetMappingNames.add(resultSetMapping);
            }
            return new StoredProcedureQueryImpl(StoredProcedureQueryImpl.buildResultSetMappingNameQuery(sqlResultSetMappingNames, call), this);
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    @Override
    public void close() {
        try {
            this.verifyOpen();
            this.closeOpenQueries();
            this.isOpen = false;
            this.factory = null;
            this.databaseSession = null;
            if (this.extendedPersistenceContext != null) {
                if (this.checkForTransaction(false) == null && !this.extendedPersistenceContext.isSynchronized()) {
                    this.extendedPersistenceContext.release();
                    this.extendedPersistenceContext.getParent().release();
                } else {
                    this.extendedPersistenceContext.setResumeUnitOfWorkOnTransactionCompletion(false);
                }
                this.extendedPersistenceContext = null;
            }
            if (this.readOnlySession != null) {
                this.readOnlySession.release();
                this.readOnlySession = null;
            }
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    protected void closeOpenQueries() {
        for (QueryImpl openQuery : this.getOpenQueriesSet()) {
            openQuery.close();
        }
    }

    public boolean isFlushModeAUTO() {
        return this.flushMode == FlushModeType.AUTO;
    }

    public boolean isOpen() {
        return this.isOpen && this.factory.isOpen();
    }

    public void lock(Object entity, LockModeType lockMode) {
        this.lock(entity, lockMode, this.getQueryHints(entity, OperationType.LOCK));
    }

    public void lock(Object entity, LockModeType lockMode, Map<String, Object> properties) {
        try {
            this.verifyOpen();
            if (entity == null) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"not_an_entity", (Object[])new Object[]{null}));
            }
            RepeatableWriteUnitOfWork uow = this.getActivePersistenceContext(this.checkForTransaction(true));
            if (!this.contains(entity, (UnitOfWork)uow)) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"cant_lock_not_managed_object", (Object[])new Object[]{entity}));
            }
            if (lockMode == null || lockMode.name().equals("NONE")) {
                return;
            }
            if (lockMode.name().equals("PESSIMISTIC_READ") || lockMode.name().equals("PESSIMISTIC_WRITE") || lockMode.name().equals("PESSIMISTIC_FORCE_INCREMENT")) {
                if (((UnitOfWorkImpl)uow).isPessimisticLocked(entity)) {
                    return;
                }
                ReadObjectQuery query = this.getReadObjectQuery(entity, properties);
                if (properties == null || !properties.containsKey("eclipselink.refresh")) {
                    query.refreshIdentityMapResult();
                }
                if (properties == null || !properties.containsKey("eclipselink.refresh.cascade")) {
                    query.cascadePrivateParts();
                }
                this.executeQuery(query, lockMode, (AbstractSession)this.getActivePersistenceContext(this.checkForTransaction(false)));
            } else {
                RepeatableWriteUnitOfWork context = this.getActivePersistenceContext(this.checkForTransaction(false));
                ClassDescriptor descriptor = context.getDescriptor(entity);
                OptimisticLockingPolicy lockingPolicy = descriptor.getOptimisticLockingPolicy();
                if (lockingPolicy == null || !(lockingPolicy instanceof VersionLockingPolicy)) {
                    throw new PersistenceException(ExceptionLocalization.buildMessage((String)"ejb30-wrong-lock_called_without_version_locking-index", null));
                }
                context.forceUpdateToVersionField(entity, lockMode == LockModeType.WRITE || lockMode.name().equals("OPTIMISTIC_FORCE_INCREMENT"));
            }
        }
        catch (LockTimeoutException e) {
            throw e;
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    public void verifyOpen() {
        if (!this.isOpen || !this.factory.isOpen()) {
            throw new IllegalStateException(ExceptionLocalization.buildMessage((String)"operation_on_closed_entity_manager"));
        }
    }

    public void verifyOpenWithSetRollbackOnly() {
        if (!this.isOpen || !this.factory.isOpen()) {
            this.setRollbackOnly();
            throw new IllegalStateException(ExceptionLocalization.buildMessage((String)"operation_on_closed_entity_manager"));
        }
    }

    public RepeatableWriteUnitOfWork getActivePersistenceContext(Object txn) {
        if (this.extendedPersistenceContext == null || !this.extendedPersistenceContext.isActive()) {
            AbstractSession client;
            if (this.databaseSession.isServerSession()) {
                this.createConnectionPolicy();
                client = ((ServerSession)this.databaseSession).acquireClientSession(this.connectionPolicy, this.properties);
            } else if (this.databaseSession.isBroker()) {
                Map mapOfProperties = null;
                if (this.properties != null) {
                    mapOfProperties = (Map)this.properties.get("eclipselink.composite-unit.properties");
                }
                this.createConnectionPolicies(mapOfProperties);
                client = ((SessionBroker)this.databaseSession).acquireClientSessionBroker(this.connectionPolicies, mapOfProperties);
            } else {
                client = this.databaseSession;
            }
            this.extendedPersistenceContext = client.acquireRepeatableWriteUnitOfWork(this.referenceMode);
            this.extendedPersistenceContext.setResumeUnitOfWorkOnTransactionCompletion(!this.closeOnCommit);
            this.extendedPersistenceContext.setShouldDiscoverNewObjects(this.persistOnCommit);
            this.extendedPersistenceContext.setDiscoverUnregisteredNewObjectsWithoutPersist(this.commitWithoutPersistRules);
            this.extendedPersistenceContext.setFlushClearCache(this.flushClearCache);
            this.extendedPersistenceContext.setShouldValidateExistence(this.shouldValidateExistence);
            this.extendedPersistenceContext.setCommitOrder(this.commitOrder);
            this.extendedPersistenceContext.setShouldCascadeCloneToJoinedRelationship(true);
            this.extendedPersistenceContext.setShouldStoreByPassCache(this.cacheStoreBypass);
            if (txn != null) {
                this.transaction.registerIfRequired((UnitOfWorkImpl)this.extendedPersistenceContext);
            }
            if (client.shouldLog(2, "transaction")) {
                client.log(2, "transaction", "acquire_unit_of_work_with_argument", (Object)String.valueOf(System.identityHashCode(this.extendedPersistenceContext)));
            }
        }
        if (this.beginEarlyTransaction && txn != null && !this.extendedPersistenceContext.isInTransaction()) {
            this.extendedPersistenceContext.beginEarlyTransaction();
        }
        return this.extendedPersistenceContext;
    }

    public void setProperties(Map properties) {
        this.verifyOpenWithSetRollbackOnly();
        this.properties = properties;
        if (this.hasActivePersistenceContext()) {
            this.extendedPersistenceContext.getParent().setProperties(properties);
        }
        if (properties == null || properties.isEmpty()) {
            return;
        }
        this.processProperties();
    }

    public void setProperty(String propertyName, Object value) {
        PropertyProcessor processor;
        this.verifyOpenWithSetRollbackOnly();
        if (propertyName == null || value == null) {
            return;
        }
        if (this.properties == null) {
            this.properties = this.hasActivePersistenceContext() ? this.extendedPersistenceContext.getParent().getProperties() : new HashMap();
        }
        this.properties.put(propertyName, value);
        if (this.hasActivePersistenceContext()) {
            this.extendedPersistenceContext.updateTablePerTenantDescriptors(propertyName, value);
        }
        if ((processor = processors.get(propertyName)) != null) {
            processor.process(propertyName, value, this);
        }
    }

    public boolean hasActivePersistenceContext() {
        return this.extendedPersistenceContext != null && this.extendedPersistenceContext.isActive();
    }

    protected Object checkForTransaction(boolean validateExistence) {
        Object txn = this.transaction.checkForTransaction(validateExistence);
        if (txn != null && !this.transaction.isJoinedToTransaction((UnitOfWorkImpl)this.extendedPersistenceContext)) {
            if (validateExistence) {
                throw new TransactionRequiredException(ExceptionLocalization.buildMessage((String)"cannot_use_transaction_on_unsynced_pc"));
            }
            return null;
        }
        return txn;
    }

    public boolean shouldFlushBeforeQuery() {
        return this.checkForTransaction(false) != null;
    }

    public boolean shouldBeginEarlyTransaction() {
        return this.beginEarlyTransaction;
    }

    public void joinTransaction() {
        try {
            this.verifyOpen();
            this.transaction.registerIfRequired((UnitOfWorkImpl)this.extendedPersistenceContext);
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    protected void setRollbackOnly() {
        this.transaction.setRollbackOnlyInternal();
    }

    protected void processProperties() {
        for (Map.Entry entry : this.properties.entrySet()) {
            PropertyProcessor processor = processors.get(entry.getKey());
            if (processor == null) continue;
            processor.process((String)entry.getKey(), entry.getValue(), this);
        }
    }

    protected String getPropertiesHandlerProperty(String name) {
        return PropertiesHandler.getPropertyValue((String)name, (Map)this.properties, (boolean)false);
    }

    protected static String getPropertiesHandlerProperty(String name, String value) {
        return PropertiesHandler.getPropertyValue((String)name, (String)value);
    }

    protected void setEntityTransactionWrapper() {
        this.transaction = new EntityTransactionWrapper(this);
    }

    public void setFlushMode(FlushModeType flushMode) {
        try {
            this.verifyOpen();
            this.flushMode = flushMode;
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    protected void setJTATransactionWrapper() {
        this.transaction = new JTATransactionWrapper(this);
        if ((this.syncType == null || this.syncType.equals((Object)SynchronizationType.SYNCHRONIZED)) && this.transaction.checkForTransaction(false) != null) {
            this.transaction.registerIfRequired((UnitOfWorkImpl)this.extendedPersistenceContext);
        }
    }

    protected void createConnectionPolicy() {
        if (this.connectionPolicy == null) {
            this.connectionPolicy = EntityManagerImpl.createConnectionPolicy((ServerSession)this.databaseSession, this.properties);
        }
    }

    protected void createConnectionPolicies(Map mapOfProperties) {
        for (Map.Entry<String, ConnectionPolicy> entry : this.connectionPolicies.entrySet()) {
            if (entry.getValue() != null) continue;
            Map properties = null;
            if (mapOfProperties != null) {
                properties = (Map)mapOfProperties.get(entry.getKey());
            }
            ConnectionPolicy connectionPolicy = EntityManagerImpl.createConnectionPolicy((ServerSession)this.databaseSession.getSessionForName(entry.getKey()), properties);
            this.connectionPolicies.put(entry.getKey(), connectionPolicy);
        }
    }

    protected static ConnectionPolicy createConnectionPolicy(ServerSession serverSession, Map properties) {
        ConnectionPolicy.ExclusiveMode exclusiveMode;
        ConnectionPolicy policy = serverSession.getDefaultConnectionPolicy();
        if (properties == null || properties.isEmpty()) {
            return policy;
        }
        ConnectionPolicy policyFromProperties = (ConnectionPolicy)properties.get("eclipselink.jdbc.connection-policy");
        if (policyFromProperties != null) {
            policy = policyFromProperties;
        }
        ConnectionPolicy newPolicy = null;
        String isLazyString = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.jdbc.exclusive-connection.is-lazy", properties, (AbstractSession)serverSession, false);
        if (isLazyString != null) {
            boolean isLazy = Boolean.parseBoolean(isLazyString);
            if (policy.isLazy() != isLazy) {
                if (newPolicy == null) {
                    newPolicy = (ConnectionPolicy)policy.clone();
                }
                newPolicy.setIsLazy(isLazy);
            }
        }
        if ((exclusiveMode = EntityManagerSetupImpl.getConnectionPolicyExclusiveModeFromProperties(properties, (AbstractSession)serverSession, false)) != null && !exclusiveMode.equals((Object)policy.getExclusiveMode())) {
            if (newPolicy == null) {
                newPolicy = (ConnectionPolicy)policy.clone();
            }
            newPolicy.setExclusiveMode(exclusiveMode);
        }
        String user = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("jakarta.persistence.jdbc.user", properties, (AbstractSession)serverSession, false);
        String password = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("jakarta.persistence.jdbc.password", properties, (AbstractSession)serverSession, false);
        String driver = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("jakarta.persistence.jdbc.driver", properties, (AbstractSession)serverSession, false);
        String connectionString = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("jakarta.persistence.jdbc.url", properties, (AbstractSession)serverSession, false);
        Object jtaDataSourceObj = EntityManagerFactoryProvider.getConfigPropertyLogDebug("jakarta.persistence.jtaDataSource", properties, (AbstractSession)serverSession, false);
        DataSource jtaDataSource = null;
        String jtaDataSourceName = null;
        if (jtaDataSourceObj != null) {
            if (jtaDataSourceObj instanceof DataSource) {
                jtaDataSource = (DataSource)jtaDataSourceObj;
            } else if (jtaDataSourceObj instanceof String) {
                jtaDataSourceName = (String)jtaDataSourceObj;
            }
        }
        Object nonjtaDataSourceObj = EntityManagerFactoryProvider.getConfigPropertyLogDebug("jakarta.persistence.nonJtaDataSource", properties, (AbstractSession)serverSession, false);
        DataSource nonjtaDataSource = null;
        String nonjtaDataSourceName = null;
        if (nonjtaDataSourceObj != null) {
            if (nonjtaDataSourceObj instanceof DataSource) {
                nonjtaDataSource = (DataSource)nonjtaDataSourceObj;
            } else if (nonjtaDataSourceObj instanceof String) {
                nonjtaDataSourceName = (String)nonjtaDataSourceObj;
            }
        }
        if (user != null || password != null || driver != null || connectionString != null || jtaDataSourceObj != null || nonjtaDataSourceObj != null) {
            boolean isJNDIConnectorRequired;
            boolean isDefaultConnectorRequired = EntityManagerImpl.isPropertyToBeAdded(driver) || EntityManagerImpl.isPropertyToBeAdded(connectionString);
            boolean bl = isJNDIConnectorRequired = EntityManagerImpl.isPropertyToBeAdded(jtaDataSource, jtaDataSourceName) || EntityManagerImpl.isPropertyToBeAdded(nonjtaDataSource, nonjtaDataSourceName);
            if (isDefaultConnectorRequired && isJNDIConnectorRequired) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"entity_manager_properties_conflict_default_connector_vs_jndi_connector", (Object[])new Object[0]));
            }
            DatasourceLogin login = (DatasourceLogin)policy.getLogin();
            if (login == null) {
                login = policy.getPoolName() != null ? (DatasourceLogin)serverSession.getConnectionPool(policy.getPoolName()).getLogin() : (DatasourceLogin)serverSession.getDatasourceLogin();
            }
            if (login.shouldUseExternalTransactionController() && isDefaultConnectorRequired) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"entity_manager_properties_conflict_default_connector_vs_external_transaction_controller", (Object[])new Object[0]));
            }
            DataSource dataSource = null;
            String dataSourceName = null;
            if (isJNDIConnectorRequired) {
                if (login.shouldUseExternalTransactionController()) {
                    if (EntityManagerImpl.isPropertyToBeAdded(jtaDataSource, jtaDataSourceName)) {
                        dataSource = jtaDataSource;
                        dataSourceName = jtaDataSourceName;
                    }
                    if (EntityManagerImpl.isPropertyToBeAdded(nonjtaDataSource, nonjtaDataSourceName)) {
                        serverSession.log(6, "properties", "entity_manager_ignores_nonjta_data_source");
                    }
                } else {
                    if (EntityManagerImpl.isPropertyToBeAdded(nonjtaDataSource, nonjtaDataSourceName)) {
                        dataSource = nonjtaDataSource;
                        dataSourceName = nonjtaDataSourceName;
                    }
                    if (EntityManagerImpl.isPropertyToBeAdded(jtaDataSource, jtaDataSourceName)) {
                        serverSession.log(6, "properties", "entity_manager_ignores_jta_data_source");
                    }
                }
            }
            Boolean isNewUserRequired = EntityManagerImpl.isPropertyValueToBeUpdated(login.getUserName(), user);
            Boolean isNewPasswordRequired = null;
            if (isNewUserRequired != null) {
                if (isNewUserRequired.booleanValue()) {
                    if (password != null) {
                        isNewPasswordRequired = password.length() > 0;
                    }
                } else {
                    isNewPasswordRequired = Boolean.FALSE;
                }
            }
            DefaultConnector oldDefaultConnector = null;
            if (login.getConnector() instanceof DefaultConnector) {
                oldDefaultConnector = (DefaultConnector)login.getConnector();
            }
            boolean isNewDefaultConnectorRequired = oldDefaultConnector == null && isDefaultConnectorRequired;
            JNDIConnector oldJNDIConnector = null;
            if (login.getConnector() instanceof JNDIConnector) {
                oldJNDIConnector = (JNDIConnector)login.getConnector();
            }
            boolean isNewJNDIConnectorRequired = oldJNDIConnector == null && isJNDIConnectorRequired;
            Boolean isNewDriverRequired = null;
            Boolean isNewConnectionStringRequired = null;
            if (isNewDefaultConnectorRequired) {
                isNewDriverRequired = EntityManagerImpl.isPropertyValueToBeUpdated(null, driver);
                isNewConnectionStringRequired = EntityManagerImpl.isPropertyValueToBeUpdated(null, connectionString);
            } else if (oldDefaultConnector != null) {
                isNewDriverRequired = EntityManagerImpl.isPropertyValueToBeUpdated(oldDefaultConnector.getDriverClassName(), driver);
                isNewConnectionStringRequired = EntityManagerImpl.isPropertyValueToBeUpdated(oldDefaultConnector.getConnectionString(), connectionString);
            }
            Boolean isNewDataSourceRequired = null;
            if (isNewJNDIConnectorRequired) {
                isNewDataSourceRequired = Boolean.TRUE;
            } else if (oldJNDIConnector != null) {
                if (dataSource != null) {
                    if (!dataSource.equals(oldJNDIConnector.getDataSource())) {
                        isNewDataSourceRequired = Boolean.TRUE;
                    }
                } else if (dataSourceName != null && !dataSourceName.equals(oldJNDIConnector.getName())) {
                    isNewDataSourceRequired = Boolean.TRUE;
                }
            }
            if (isNewUserRequired != null || isNewPasswordRequired != null || isNewDriverRequired != null || isNewConnectionStringRequired != null || isNewDataSourceRequired != null) {
                if (newPolicy == null) {
                    newPolicy = (ConnectionPolicy)policy.clone();
                }
                DatasourceLogin newLogin = (DatasourceLogin)newPolicy.getLogin();
                if (newPolicy.getLogin() == null || newPolicy.getLogin() == policy.getLogin()) {
                    newLogin = login.clone();
                    newPolicy.setLogin((Login)newLogin);
                }
                newPolicy.setPoolName(null);
                if (isNewUserRequired != null) {
                    if (isNewUserRequired.booleanValue()) {
                        newLogin.setProperty("user", (Object)user);
                    } else {
                        newLogin.getProperties().remove("user");
                    }
                }
                if (isNewPasswordRequired != null) {
                    if (isNewPasswordRequired.booleanValue()) {
                        newLogin.setProperty("password", (Object)password);
                    } else {
                        newLogin.getProperties().remove("password");
                    }
                }
                if (isNewDefaultConnectorRequired) {
                    newLogin.setConnector((Connector)new DefaultConnector());
                    newLogin.setUsesExternalConnectionPooling(false);
                } else if (isNewJNDIConnectorRequired) {
                    newLogin.setConnector((Connector)new JNDIConnector());
                    newLogin.setUsesExternalConnectionPooling(true);
                }
                if (isDefaultConnectorRequired) {
                    DefaultConnector defaultConnector = (DefaultConnector)newLogin.getConnector();
                    if (isNewDriverRequired != null) {
                        if (isNewDriverRequired.booleanValue()) {
                            defaultConnector.setDriverClassName(driver);
                        } else {
                            defaultConnector.setDriverClassName(null);
                        }
                    }
                    if (isNewConnectionStringRequired != null) {
                        if (isNewConnectionStringRequired.booleanValue()) {
                            defaultConnector.setDatabaseURL(connectionString);
                        } else {
                            defaultConnector.setDatabaseURL(null);
                        }
                    }
                } else if (isNewDataSourceRequired != null) {
                    JNDIConnector jndiConnector = (JNDIConnector)newLogin.getConnector();
                    if (isNewDataSourceRequired.booleanValue()) {
                        if (dataSource != null) {
                            jndiConnector.setDataSource(dataSource);
                        } else {
                            jndiConnector.setDataSource(null);
                            jndiConnector.setName(dataSourceName);
                        }
                    }
                }
            }
        }
        if (newPolicy != null) {
            return newPolicy;
        }
        return policy;
    }

    @Override
    public boolean isBroker() {
        return this.databaseSession.isBroker();
    }

    protected static boolean isPropertyToBeAdded(String value) {
        return value != null && value.length() > 0;
    }

    protected static boolean isPropertyToBeAdded(DataSource ds, String dsName) {
        return ds != null || dsName != null && dsName.length() > 0;
    }

    protected static boolean isPropertyToBeRemoved(String value) {
        return value != null && value.length() == 0;
    }

    protected static Boolean isPropertyValueToBeUpdated(String oldValue, String newValue) {
        if (newValue == null) {
            return null;
        }
        if (newValue.length() > 0) {
            if (oldValue != null) {
                if (newValue.equals(oldValue)) {
                    return null;
                }
                return Boolean.TRUE;
            }
            return Boolean.TRUE;
        }
        if (oldValue != null) {
            return Boolean.FALSE;
        }
        return null;
    }

    public void detach(Object entity) {
        try {
            this.verifyOpen();
            if (entity == null) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"not_an_entity", (Object[])new Object[]{null}));
            }
            ClassDescriptor descriptor = (ClassDescriptor)this.databaseSession.getDescriptors().get(entity.getClass());
            if (descriptor == null || descriptor.isDescriptorTypeAggregate()) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"not_an_entity", (Object[])new Object[]{entity}));
            }
            UnitOfWorkImpl uowImpl = (UnitOfWorkImpl)this.getUnitOfWork();
            uowImpl.unregisterObject(entity, 0, true);
        }
        catch (RuntimeException exception) {
            this.setRollbackOnly();
            throw exception;
        }
    }

    public CriteriaBuilder getCriteriaBuilder() {
        this.verifyOpenWithSetRollbackOnly();
        return this.factory.getCriteriaBuilder();
    }

    protected HashMap<String, Object> getQueryHints(Object entity, OperationType operation) {
        HashMap queryHints = null;
        if (entity != null && this.properties != null) {
            queryHints = new HashMap();
            if (this.properties.containsKey("jakarta.persistence.lock.timeout")) {
                queryHints.put("jakarta.persistence.lock.timeout", this.properties.get("jakarta.persistence.lock.timeout"));
            }
            if (this.properties.containsKey("eclipselink.pessimistic.lock.timeout.unit")) {
                queryHints.put("eclipselink.pessimistic.lock.timeout.unit", this.properties.get("eclipselink.pessimistic.lock.timeout.unit"));
            }
            if (!this.properties.containsKey("eclipselink.cache-usage")) {
                Class<?> cls = entity instanceof Class ? (Class<?>)entity : entity.getClass();
                ClassDescriptor descriptor = this.getActiveSession().getDescriptor(cls);
                if (descriptor != null && !descriptor.isIsolated() && operation != OperationType.LOCK) {
                    Object[] properties;
                    Session activeSession;
                    if (operation == OperationType.FIND) {
                        if (this.properties.containsKey("jakarta.persistence.cache.retrieveMode")) {
                            queryHints.put("jakarta.persistence.cache.retrieveMode", this.properties.get("jakarta.persistence.cache.retrieveMode"));
                        } else if (this.properties.containsKey("jakarta.persistence.cacheRetrieveMode")) {
                            activeSession = this.getActiveSession();
                            if (activeSession != null) {
                                properties = new String[]{"jakarta.persistence.cache.retrieveMode", "jakarta.persistence.cacheRetrieveMode"};
                                ((AbstractSession)activeSession).log(5, "transaction", "deprecated_property", properties);
                            }
                            queryHints.put("jakarta.persistence.cache.retrieveMode", this.properties.get("jakarta.persistence.cacheRetrieveMode"));
                        }
                    }
                    if (this.properties.containsKey("jakarta.persistence.cache.storeMode")) {
                        queryHints.put("jakarta.persistence.cache.storeMode", this.properties.get("jakarta.persistence.cache.storeMode"));
                    } else if (this.properties.containsKey("jakarta.persistence.cacheStoreMode")) {
                        activeSession = this.getActiveSession();
                        if (activeSession != null) {
                            properties = new String[]{"jakarta.persistence.cache.storeMode", "jakarta.persistence.cacheStoreMode"};
                            ((AbstractSession)activeSession).log(5, "transaction", "deprecated_property", properties);
                        }
                        queryHints.put("jakarta.persistence.cache.storeMode", this.properties.get("jakarta.persistence.cacheStoreMode"));
                    }
                }
            }
        }
        return queryHints;
    }

    public Metamodel getMetamodel() {
        this.verifyOpenWithSetRollbackOnly();
        return this.factory.getMetamodel();
    }

    public EntityManagerFactory getEntityManagerFactory() {
        try {
            this.verifyOpen();
            return this.factory;
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    public LockModeType getLockMode(Object entity) {
        try {
            this.verifyOpen();
            this.checkForTransaction(true);
            RepeatableWriteUnitOfWork uowImpl = this.getActivePersistenceContext(this.checkForTransaction(false));
            LockModeType lockMode = LockModeType.NONE;
            if (!this.contains(entity, (UnitOfWork)uowImpl)) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"cant_getLockMode_of_not_managed_object", (Object[])new Object[]{entity}));
            }
            Boolean optimistickLock = (Boolean)uowImpl.getOptimisticReadLockObjects().get(entity);
            if (optimistickLock != null) {
                lockMode = optimistickLock.equals(Boolean.FALSE) ? LockModeType.OPTIMISTIC : (uowImpl.getPessimisticLockedObjects().get(entity) != null ? LockModeType.PESSIMISTIC_FORCE_INCREMENT : LockModeType.OPTIMISTIC_FORCE_INCREMENT);
            } else if (uowImpl.getPessimisticLockedObjects().get(entity) != null) {
                lockMode = LockModeType.PESSIMISTIC_WRITE;
            }
            return lockMode;
        }
        catch (RuntimeException exception) {
            this.setRollbackOnly();
            throw exception;
        }
    }

    public Map<String, Object> getProperties() {
        HashMap sessionMap = new HashMap(this.getAbstractSession().getProperties());
        if (this.properties != null) {
            sessionMap.putAll(this.properties);
        }
        return Collections.unmodifiableMap(sessionMap);
    }

    public Set<String> getSupportedProperties() {
        return EntityManagerProperties.getSupportedProperties();
    }

    public <T> T unwrap(Class<T> cls) {
        if (cls.equals(UnitOfWork.class) || cls.equals(UnitOfWorkImpl.class) || cls.equals(RepeatableWriteUnitOfWork.class)) {
            return (T)this.getUnitOfWork();
        }
        if (cls.equals(JpaEntityManager.class) || cls.equals(EntityManagerImpl.class)) {
            return (T)this;
        }
        if (cls.equals(Session.class) || cls.equals(AbstractSession.class)) {
            return (T)this.getAbstractSession();
        }
        if (cls.equals(DatabaseSession.class) || cls.equals(DatabaseSessionImpl.class)) {
            return (T)this.getDatabaseSession();
        }
        if (cls.equals(Server.class) || cls.equals(ServerSession.class)) {
            return (T)this.getServerSession();
        }
        if (cls.equals(SessionBroker.class)) {
            return (T)this.getSessionBroker();
        }
        if (cls.equals(Connection.class)) {
            UnitOfWorkImpl unitOfWork = (UnitOfWorkImpl)this.getUnitOfWork();
            Accessor accessor = unitOfWork.getAccessor();
            if (unitOfWork.getParent().isExclusiveIsolatedClientSession()) {
                Connection conn = accessor.getConnection();
                if (conn == null) {
                    boolean activeTran;
                    boolean uowInTran = unitOfWork.isInTransaction();
                    boolean bl = activeTran = this.checkForTransaction(false) != null;
                    if (uowInTran || activeTran) {
                        if (activeTran) {
                            unitOfWork.beginEarlyTransaction();
                        }
                        accessor.incrementCallCount(unitOfWork.getParent());
                        accessor.decrementCallCount();
                        conn = accessor.getConnection();
                    }
                }
                return (T)conn;
            }
            if (unitOfWork.isInTransaction()) {
                return (T)unitOfWork.getAccessor().getConnection();
            }
            if (this.checkForTransaction(false) != null) {
                unitOfWork.beginEarlyTransaction();
                accessor = unitOfWork.getAccessor();
                accessor.incrementCallCount(unitOfWork.getParent());
                accessor.decrementCallCount();
                return (T)accessor.getConnection();
            }
            return null;
        }
        if (cls.getName().equals("jakarta.resource.cci.Connection")) {
            UnitOfWorkImpl unitOfWork = (UnitOfWorkImpl)this.getUnitOfWork();
            if (unitOfWork.isInTransaction() || unitOfWork.getParent().isExclusiveIsolatedClientSession()) {
                return (T)unitOfWork.getAccessor().getConnection();
            }
            if (this.checkForTransaction(false) != null) {
                unitOfWork.beginEarlyTransaction();
                Accessor accessor = unitOfWork.getAccessor();
                accessor.incrementCallCount(unitOfWork.getParent());
                accessor.decrementCallCount();
                return (T)accessor.getDatasourceConnection();
            }
            return null;
        }
        throw new PersistenceException(ExceptionLocalization.buildMessage((String)"unable_to_unwrap_jpa", (Object[])new String[]{EntityManager.class.getName(), cls.getName()}));
    }

    @Override
    public void load(Object entityOrEntities, AttributeGroup group) {
        this.verifyOpen();
        this.getActivePersistenceContext(this.checkForTransaction(false)).load(entityOrEntities, group);
    }

    @Override
    public Object copy(Object entityOrEntities, AttributeGroup group) {
        this.verifyOpen();
        return this.getActivePersistenceContext(this.checkForTransaction(false)).copy(entityOrEntities, group);
    }

    public static void processUnfetchedAttribute(FetchGroupTracker entity, String attributeName) {
        String errorMsg = entity._persistence_getFetchGroup().onUnfetchedAttribute(entity, attributeName);
        if (errorMsg != null) {
            throw new EntityNotFoundException(errorMsg);
        }
    }

    public static void processUnfetchedAttributeForSet(FetchGroupTracker entity, String attributeName) {
        String errorMsg = entity._persistence_getFetchGroup().onUnfetchedAttributeForSet(entity, attributeName);
        if (errorMsg != null) {
            throw new EntityNotFoundException(errorMsg);
        }
    }

    public Query createQuery(CriteriaUpdate updateQuery) {
        try {
            this.verifyOpen();
            return new EJBQueryImpl(((CriteriaUpdateImpl)updateQuery).translate(), this);
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    public Query createQuery(CriteriaDelete deleteQuery) {
        try {
            this.verifyOpen();
            return new EJBQueryImpl(((CriteriaDeleteImpl)deleteQuery).translate(), this);
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    public boolean isJoinedToTransaction() {
        this.verifyOpen();
        return this.transaction.isJoinedToTransaction((UnitOfWorkImpl)this.extendedPersistenceContext);
    }

    public <T> EntityGraph<T> createEntityGraph(Class<T> rootType) {
        ClassDescriptor descriptor = this.getAbstractSession().getDescriptor(rootType);
        if (descriptor == null || descriptor.isAggregateDescriptor()) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"unknown_bean_class", (Object[])new Object[]{rootType.getName()}));
        }
        return new EntityGraphImpl(new AttributeGroup(null, rootType, true), descriptor);
    }

    public EntityGraph createEntityGraph(String graphName) {
        AttributeGroup group = (AttributeGroup)this.getAbstractSession().getAttributeGroups().get(graphName);
        if (group == null) {
            return null;
        }
        ClassDescriptor descriptor = this.getAbstractSession().getDescriptor(group.getType());
        return new EntityGraphImpl(group.clone(), descriptor);
    }

    public EntityGraph getEntityGraph(String graphName) {
        AttributeGroup group = (AttributeGroup)this.getAbstractSession().getAttributeGroups().get(graphName);
        if (group == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"no_entity_graph_of_name", (Object[])new Object[]{graphName}));
        }
        return new EntityGraphImpl(group);
    }

    public <T> List<EntityGraph<? super T>> getEntityGraphs(Class<T> entityClass) {
        ClassDescriptor descriptor = this.getAbstractSession().getDescriptor(entityClass);
        if (descriptor == null || descriptor.isAggregateDescriptor()) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"unknown_bean_class", (Object[])new Object[]{entityClass.getName()}));
        }
        ArrayList<EntityGraph<T>> result = new ArrayList<EntityGraph<T>>();
        for (AttributeGroup group : descriptor.getAttributeGroups().values()) {
            result.add(new EntityGraphImpl(group));
        }
        if (descriptor.hasInheritance()) {
            while (descriptor.getInheritancePolicy().getParentDescriptor() != null) {
                descriptor = descriptor.getInheritancePolicy().getParentDescriptor();
                for (AttributeGroup group : descriptor.getAttributeGroups().values()) {
                    result.add(new EntityGraphImpl(group));
                }
            }
        }
        return result;
    }

    public SynchronizationType getSyncType() {
        return this.syncType;
    }

    static abstract class PropertyProcessor {
        PropertyProcessor() {
        }

        abstract void process(String var1, Object var2, EntityManagerImpl var3);
    }

    protected static enum OperationType {
        FIND,
        REFRESH,
        LOCK;

    }
}

