/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.remote.sse;

import com.sun.enterprise.admin.remote.sse.GfSseInboundEvent;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;

public final class GfSseEventReceiver
implements Closeable {
    private final InputStream inputStream;
    private final Charset charset;
    private boolean closed;

    GfSseEventReceiver(InputStream inputStream, Charset charset) {
        this.inputStream = inputStream;
        this.charset = charset;
    }

    public GfSseInboundEvent readEvent() throws IOException {
        GfSseInboundEvent inboundEvent = new GfSseInboundEvent();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        State currentState = State.START;
        String fieldName = null;
        try {
            int data = 0;
            block9: while ((data = this.inputStream.read()) != -1) {
                switch (currentState) {
                    case START: {
                        if (data == 58) {
                            currentState = State.COMMENT;
                            continue block9;
                        }
                        if (data != 10) {
                            baos.write(data);
                            currentState = State.FIELD_NAME;
                            continue block9;
                        }
                        if (!inboundEvent.isEmpty()) {
                            return inboundEvent;
                        }
                        inboundEvent = new GfSseInboundEvent();
                        continue block9;
                    }
                    case COMMENT: {
                        if (data != 10) continue block9;
                        currentState = State.START;
                        continue block9;
                    }
                    case FIELD_NAME: {
                        if (data == 58) {
                            fieldName = baos.toString(this.charset);
                            baos.reset();
                            currentState = State.FIELD_VALUE_FIRST;
                            continue block9;
                        }
                        if (data == 10) {
                            this.processField(inboundEvent, baos.toString(this.charset), new byte[0], this.charset);
                            baos.reset();
                            currentState = State.START;
                            continue block9;
                        }
                        baos.write(data);
                        continue block9;
                    }
                    case FIELD_VALUE_FIRST: {
                        if (data != 32) {
                            baos.write(data);
                        }
                        if (data == 10) {
                            this.processField(inboundEvent, fieldName, baos.toByteArray(), this.charset);
                            baos.reset();
                            currentState = State.START;
                            continue block9;
                        }
                        currentState = State.FIELD_VALUE;
                        continue block9;
                    }
                    case FIELD_VALUE: {
                        if (data == 10) {
                            this.processField(inboundEvent, fieldName, baos.toByteArray(), this.charset);
                            baos.reset();
                            currentState = State.START;
                            continue block9;
                        }
                        baos.write(data);
                        continue block9;
                    }
                }
            }
            if (data == -1) {
                this.closed = true;
            }
            return null;
        }
        catch (IOException e) {
            this.closed = true;
            throw e;
        }
    }

    private void processField(GfSseInboundEvent inboundEvent, String name, byte[] value, Charset valueCharset) {
        if (name.equals("event")) {
            inboundEvent.setName(new String(value, valueCharset));
        } else if (name.equals("data")) {
            inboundEvent.addData(value);
            inboundEvent.addData(new byte[]{10});
        } else if (name.equals("id")) {
            String s;
            if (value != null) {
                s = new String(value, valueCharset).trim();
                if (!s.matches("\\-?\\d+")) {
                    s = "";
                }
            } else {
                s = "";
            }
            inboundEvent.setId(s);
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        this.inputStream.close();
    }

    private static enum State {
        START,
        COMMENT,
        FIELD_NAME,
        FIELD_VALUE_FIRST,
        FIELD_VALUE,
        EVENT_FIRED;

    }
}

