/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.el.spec.lambda;

import com.sun.ts.tests.el.common.util.TypesBean;
import com.sun.ts.tests.el.common.util.Validator;
import jakarta.el.ELProcessor;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

public class ELClientIT {
    private static final System.Logger logger = System.getLogger(ELClientIT.class.getName());

    @AfterEach
    public void cleanup() throws Exception {
        logger.log(System.Logger.Level.INFO, "Cleanup method called");
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Test
    public void elLambdaExprBigDecimalTest() throws Exception {
        String comparitorA = "BigDecimal";
        for (Class<?> bType : TypesBean.getNumberMap().keySet()) {
            String bValue = TypesBean.getNumberMap().get(bType);
            String bName = bType.getSimpleName();
            this.runLambdaExpressions("+", BigDecimal.valueOf(2L), comparitorA, bValue, bName);
            this.runLambdaExpressions("-", BigDecimal.valueOf(0L), comparitorA, bValue, bName);
            this.runLambdaExpressions("*", BigDecimal.valueOf(1L), comparitorA, bValue, bName);
            this.runLambdaExpressions("/", BigDecimal.valueOf(1L), comparitorA, bValue, bName);
            this.runLambdaExpressions("div", BigDecimal.valueOf(1L), comparitorA, bValue, bName);
            this.runLambdaExpressions("%", 0.0, comparitorA, bValue, bName);
            this.runLambdaExpressions("mod", 0.0, comparitorA, bValue, bName);
        }
    }

    @Test
    public void elLambdaExprFloatTest() throws Exception {
        String comparitorA = "Float";
        ArrayList<String> excludeList = new ArrayList<String>();
        excludeList.add("BigDecimal");
        for (Class<?> bType : TypesBean.getNumberMap().keySet()) {
            String bValue = TypesBean.getNumberMap().get(bType);
            String bName = bType.getSimpleName();
            if (excludeList.contains(bName)) {
                logger.log(System.Logger.Level.INFO, "*** Skipping " + comparitorA + " with " + bName + ", Already Tested in " + bName + " Test Sequence ***");
                continue;
            }
            if ("BigInteger".equals(bName)) {
                this.runLambdaExpressions("+", BigDecimal.valueOf(2L), comparitorA, bValue, bName);
                this.runLambdaExpressions("-", BigDecimal.valueOf(0L), comparitorA, bValue, bName);
                this.runLambdaExpressions("*", BigDecimal.valueOf(1L), comparitorA, bValue, bName);
                this.runLambdaExpressions("/", BigDecimal.valueOf(1L), comparitorA, bValue, bName);
                this.runLambdaExpressions("div", BigDecimal.valueOf(1L), comparitorA, bValue, bName);
            } else {
                this.runLambdaExpressions("+", 2.0, comparitorA, bValue, bName);
                this.runLambdaExpressions("-", 0.0, comparitorA, bValue, bName);
                this.runLambdaExpressions("*", 1.0, comparitorA, bValue, bName);
                this.runLambdaExpressions("/", 1.0, comparitorA, bValue, bName);
                this.runLambdaExpressions("div", 1.0, comparitorA, bValue, bName);
            }
            this.runLambdaExpressions("%", 0.0, comparitorA, bValue, bName);
            this.runLambdaExpressions("mod", 0.0, comparitorA, bValue, bName);
        }
    }

    @Test
    public void elLambdaExprDoubleTest() throws Exception {
        String comparitorA = "Double";
        ArrayList<String> excludeList = new ArrayList<String>();
        excludeList.add("BigDecimal");
        excludeList.add("Float");
        for (Class<?> bType : TypesBean.getNumberMap().keySet()) {
            String bValue = TypesBean.getNumberMap().get(bType);
            String bName = bType.getSimpleName();
            if (excludeList.contains(bName)) {
                logger.log(System.Logger.Level.INFO, "*** Skipping " + comparitorA + " with " + bName + ", Already Tested in " + bName + " Test Sequence ***");
                continue;
            }
            if ("BigInteger".equals(bName)) {
                this.runLambdaExpressions("+", BigDecimal.valueOf(2L), comparitorA, bValue, bName);
                this.runLambdaExpressions("-", BigDecimal.valueOf(0L), comparitorA, bValue, bName);
                this.runLambdaExpressions("*", BigDecimal.valueOf(1L), comparitorA, bValue, bName);
                this.runLambdaExpressions("/", BigDecimal.valueOf(1L), comparitorA, bValue, bName);
                this.runLambdaExpressions("div", BigDecimal.valueOf(1L), comparitorA, bValue, bName);
            } else {
                this.runLambdaExpressions("+", 2.0, comparitorA, bValue, bName);
                this.runLambdaExpressions("-", 0.0, comparitorA, bValue, bName);
                this.runLambdaExpressions("*", 1.0, comparitorA, bValue, bName);
                this.runLambdaExpressions("/", 1.0, comparitorA, bValue, bName);
                this.runLambdaExpressions("div", 1.0, comparitorA, bValue, bName);
            }
            this.runLambdaExpressions("%", 0.0, comparitorA, bValue, bName);
            this.runLambdaExpressions("mod", 0.0, comparitorA, bValue, bName);
        }
    }

    @Test
    public void elLambdaExprBigIntegerTest() throws Exception {
        String comparitorA = "BigInteger";
        ArrayList<String> excludeList = new ArrayList<String>();
        excludeList.add("BigDecimal");
        excludeList.add("Double");
        excludeList.add("Float");
        for (Class<?> bType : TypesBean.getNumberMap().keySet()) {
            String bValue = TypesBean.getNumberMap().get(bType);
            String bName = bType.getSimpleName();
            if (excludeList.contains(bName)) {
                logger.log(System.Logger.Level.INFO, "*** Skipping " + comparitorA + " with " + bName + ", Already Tested in " + bName + " Test Sequence ***");
                continue;
            }
            this.runLambdaExpressions("+", BigInteger.valueOf(2L), comparitorA, bValue, bName);
            this.runLambdaExpressions("-", BigInteger.valueOf(0L), comparitorA, bValue, bName);
            this.runLambdaExpressions("*", BigInteger.valueOf(1L), comparitorA, bValue, bName);
            this.runLambdaExpressions("/", BigDecimal.valueOf(1L), comparitorA, bValue, bName);
            this.runLambdaExpressions("div", BigDecimal.valueOf(1L), comparitorA, bValue, bName);
            this.runLambdaExpressions("%", BigInteger.valueOf(0L), comparitorA, bValue, bName);
            this.runLambdaExpressions("mod", BigInteger.valueOf(0L), comparitorA, bValue, bName);
        }
    }

    @Test
    public void elLambdaExprIntegerTest() throws Exception {
        String comparitorA = "Integer";
        ArrayList<String> excludeList = new ArrayList<String>();
        excludeList.add("BigDecimal");
        excludeList.add("BigInteger");
        excludeList.add("Double");
        excludeList.add("Float");
        for (Class<?> bType : TypesBean.getNumberMap().keySet()) {
            String bValue = TypesBean.getNumberMap().get(bType);
            String bName = bType.getSimpleName();
            if (excludeList.contains(bName)) {
                logger.log(System.Logger.Level.INFO, "*** Skipping " + comparitorA + " with " + bName + ", Already Tested in " + bName + " Test Sequence ***");
                continue;
            }
            this.runLambdaExpressions("+", 2L, comparitorA, bValue, bName);
            this.runLambdaExpressions("-", 0L, comparitorA, bValue, bName);
            this.runLambdaExpressions("*", 1L, comparitorA, bValue, bName);
            this.runLambdaExpressions("/", 1.0, comparitorA, bValue, bName);
            this.runLambdaExpressions("div", 1.0, comparitorA, bValue, bName);
            this.runLambdaExpressions("%", 0L, comparitorA, bValue, bName);
            this.runLambdaExpressions("mod", 0L, comparitorA, bValue, bName);
        }
    }

    @Test
    public void elLambdaExprLongTest() throws Exception {
        String comparitorA = "Long";
        ArrayList<String> excludeList = new ArrayList<String>();
        excludeList.add("BigDecimal");
        excludeList.add("BigInteger");
        excludeList.add("Integer");
        excludeList.add("Double");
        excludeList.add("Float");
        for (Class<?> bType : TypesBean.getNumberMap().keySet()) {
            String bValue = TypesBean.getNumberMap().get(bType);
            String bName = bType.getSimpleName();
            if (excludeList.contains(bName)) {
                logger.log(System.Logger.Level.INFO, "*** Skipping " + comparitorA + " with " + bName + ", Already Tested in " + bName + " Test Sequence ***");
                continue;
            }
            this.runLambdaExpressions("+", 2L, comparitorA, bValue, bName);
            this.runLambdaExpressions("-", 0L, comparitorA, bValue, bName);
            this.runLambdaExpressions("*", 1L, comparitorA, bValue, bName);
            this.runLambdaExpressions("/", 1.0, comparitorA, bValue, bName);
            this.runLambdaExpressions("div", 1.0, comparitorA, bValue, bName);
            this.runLambdaExpressions("%", 0L, comparitorA, bValue, bName);
            this.runLambdaExpressions("mod", 0L, comparitorA, bValue, bName);
        }
    }

    @Test
    public void elLambdaExprShortTest() throws Exception {
        String comparitorA = "Short";
        ArrayList<String> excludeList = new ArrayList<String>();
        excludeList.add("BigDecimal");
        excludeList.add("BigInteger");
        excludeList.add("Integer");
        excludeList.add("Double");
        excludeList.add("Float");
        excludeList.add("Long");
        for (Class<?> bType : TypesBean.getNumberMap().keySet()) {
            String bValue = TypesBean.getNumberMap().get(bType);
            String bName = bType.getSimpleName();
            if (excludeList.contains(bName)) {
                logger.log(System.Logger.Level.INFO, "*** Skipping " + comparitorA + " with " + bName + ", Already Tested in " + bName + " Test Sequence ***");
                continue;
            }
            this.runLambdaExpressions("+", 2L, comparitorA, bValue, bName);
            this.runLambdaExpressions("-", 0L, comparitorA, bValue, bName);
            this.runLambdaExpressions("*", 1L, comparitorA, bValue, bName);
            this.runLambdaExpressions("/", 1.0, comparitorA, bValue, bName);
            this.runLambdaExpressions("div", 1.0, comparitorA, bValue, bName);
            this.runLambdaExpressions("%", 0L, comparitorA, bValue, bName);
            this.runLambdaExpressions("mod", 0L, comparitorA, bValue, bName);
        }
    }

    @Test
    public void elLambdaExprByteTest() throws Exception {
        String comparitorA = "Byte";
        ArrayList<String> excludeList = new ArrayList<String>();
        excludeList.add("BigDecimal");
        excludeList.add("BigInteger");
        excludeList.add("Integer");
        excludeList.add("Double");
        excludeList.add("Float");
        excludeList.add("Long");
        excludeList.add("Short");
        for (Class<?> bType : TypesBean.getNumberMap().keySet()) {
            String bValue = TypesBean.getNumberMap().get(bType);
            String bName = bType.getSimpleName();
            if (excludeList.contains(bName)) {
                logger.log(System.Logger.Level.INFO, "*** Skipping " + comparitorA + " with " + bName + ", Already Tested in " + bName + " Test Sequence ***");
                continue;
            }
            this.runLambdaExpressions("+", 2L, comparitorA, bValue, bName);
            this.runLambdaExpressions("-", 0L, comparitorA, bValue, bName);
            this.runLambdaExpressions("*", 1L, comparitorA, bValue, bName);
            this.runLambdaExpressions("/", 1.0, comparitorA, bValue, bName);
            this.runLambdaExpressions("div", 1.0, comparitorA, bValue, bName);
            this.runLambdaExpressions("%", 0L, comparitorA, bValue, bName);
            this.runLambdaExpressions("mod", 0L, comparitorA, bValue, bName);
        }
    }

    @Test
    public void elLambdaExprStringTest() throws Exception {
        ELProcessor elp = new ELProcessor();
        String aValue = "a='Testing'";
        String bValue = "b='Testing'";
        elp.eval(aValue);
        elp.eval(bValue);
        Validator.testExpression(elp, "(((x, y)-> x += y)(a, b))", "TestingTesting", "'Testing' += 'Testing'");
    }

    @Test
    public void elLambdaExprNullTest() throws Exception {
        ELProcessor elp = new ELProcessor();
        elp.defineBean("types", (Object)new TypesBean());
        Long expected = 0L;
        String aValue = "a = types.tckNull";
        String bValue = "b = types.tckNull";
        elp.eval(aValue);
        elp.eval(bValue);
        String operator = "+";
        Validator.testExpression(elp, "(((x, y)-> x " + operator + " y)(a, b))", expected, "null + null");
        operator = "-";
        Validator.testExpression(elp, "(((x, y)-> x " + operator + " y)(a, b))", expected, "null - null");
        operator = "*";
        Validator.testExpression(elp, "(((x, y)-> x " + operator + " y)(a, b))", expected, "null * null");
        operator = "/";
        Validator.testExpression(elp, "(((x, y)-> x " + operator + " y)(a, b))", expected, "null / null");
        operator = "div";
        Validator.testExpression(elp, "(((x, y)-> x " + operator + " y)(a, b))", expected, "null div null");
        operator = "%";
        Validator.testExpression(elp, "(((x, y)-> x " + operator + " y)(a, b))", expected, "null % null");
        operator = "mod";
        Validator.testExpression(elp, "(((x, y)-> x " + operator + " y)(a, b))", expected, "null mod null");
    }

    private void runLambdaExpressions(String operator, Number expectedResult, String aType, String comparitorB, String bName) throws Exception {
        ELProcessor elp = new ELProcessor();
        elp.defineBean("types", (Object)new TypesBean());
        String comparitorA = "a=types.tck" + aType;
        elp.eval(comparitorA);
        elp.eval(comparitorB);
        Validator.testExpression(elp, "(x->(y->x " + operator + " y)(a))(b)", expectedResult, aType + " " + operator + " " + bName);
        Validator.testExpression(elp, "(()->y->y " + operator + " a)()(b)", expectedResult, aType + " " + operator + " " + bName);
        Validator.testExpression(elp, "f = (x)->(tem=x; y->tem " + operator + " y); f(a)(b)", expectedResult, aType + " " + operator + " " + bName);
        Validator.testExpression(elp, "f = ()->y->y " + operator + " a; f()(b)", expectedResult, aType + " " + operator + " " + bName);
        Validator.testExpression(elp, "f = (x)->(tem=x; y->tem " + operator + " y); f(a)(b)", expectedResult, aType + " " + operator + " " + bName);
        Validator.testExpression(elp, "(((x, y)-> x " + operator + " y)(a, b))", expectedResult, aType + " " + operator + " " + bName);
        String zValue = "z = (x,y)->x " + operator + " y";
        elp.eval(zValue);
        Validator.testExpression(elp, "z(a, b)", expectedResult, aType + " " + operator + " " + bName);
        Validator.testExpression(elp, "func = (x,y)->x " + operator + " y; func(a, b)", expectedResult, aType + " " + operator + " " + bName);
        elp.eval("cond = true");
        Validator.testExpression(elp, "(cond->true? a " + operator + " b: a " + operator + " 2)(a)", expectedResult, aType + " " + operator + " " + bName);
        elp.eval("cond = false");
        Validator.testExpression(elp, "(cond->false? a " + operator + " 2: a " + operator + " b)(a)", expectedResult, aType + " " + operator + " " + bName);
    }
}

