/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.el.spec.elvisoperator;

import com.sun.ts.tests.el.common.util.ExprEval;
import com.sun.ts.tests.el.common.util.NameValuePair;
import jakarta.el.ELException;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

public class ELClientIT {
    private static final System.Logger logger = System.getLogger(ELClientIT.class.getName());
    private final boolean[] deferred = new boolean[]{true, false};

    @AfterEach
    public void cleanup() throws Exception {
        logger.log(System.Logger.Level.INFO, "Cleanup method called");
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Test
    public void elEvlisNullTest() throws Exception {
        boolean pass = false;
        String[] symbols = new String[]{"$", "#"};
        String expectedResult = "default";
        try {
            for (String prefix : symbols) {
                String expr = prefix + "{null ?: 'default'}";
                Object result = ExprEval.evaluateValueExpression(expr, null, String.class);
                if (result == null) {
                    logger.log(System.Logger.Level.TRACE, "result is null");
                } else {
                    logger.log(System.Logger.Level.TRACE, "result is " + result.toString());
                }
                boolean bl = pass = ExprEval.compareClass(result, String.class) && ExprEval.compareValue(result, expectedResult);
                if (pass) continue;
                throw new Exception("TEST FAILED: pass = false");
            }
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    @Test
    public void elElvisEmptyStringTest() throws Exception {
        this.testElvisOperator("", "default");
    }

    @Test
    public void elElvisNonTrueStringTest() throws Exception {
        this.testElvisOperator("other", "default");
    }

    @Test
    public void elElvisFalseStringTest() throws Exception {
        this.testElvisOperator("false", "default");
    }

    @Test
    public void elElvisTrueStringTest() throws Exception {
        String testVal = "true";
        this.testElvisOperator(testVal, testVal);
    }

    @Test
    public void elElvisLongTest() throws Exception {
        Assertions.assertThrows(ELException.class, () -> this.testElvisOperator(0L, "ignored"));
    }

    private void testElvisOperator(Object testVal, Object expectedResult) throws Exception {
        boolean pass = false;
        NameValuePair[] value = NameValuePair.buildNameValuePair(testVal, "default");
        try {
            for (boolean tf : this.deferred) {
                String expr = ExprEval.buildElExpr(tf, "elvis");
                Object result = ExprEval.evaluateValueExpression(expr, value, Object.class);
                logger.log(System.Logger.Level.TRACE, "result is " + result.toString());
                boolean bl = pass = ExprEval.compareClass(result, expectedResult.getClass()) && ExprEval.compareValue(result, expectedResult);
                if (pass) continue;
                throw new Exception("TEST FAILED: pass = false");
            }
        }
        catch (ELException e) {
            throw e;
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }
}

