/*
 * Decompiled with CFR 0.152.
 */
package org.testng;

import java.util.Collection;
import java.util.Map;
import org.testng.ISuite;
import org.testng.ISuiteResult;
import org.testng.ITestContext;
import org.testng.internal.SuiteRunnerMap;
import org.testng.xml.XmlSuite;

class SuiteResultCounts {
    int m_total = 0;
    int m_skipped = 0;
    int m_failed = 0;
    int m_confFailures = 0;
    int m_confSkips = 0;

    SuiteResultCounts() {
    }

    public void calculateResultCounts(XmlSuite xmlSuite, SuiteRunnerMap suiteRunnerMap) {
        Map<String, ISuiteResult> results;
        ISuite iSuite = suiteRunnerMap.get(xmlSuite);
        if (iSuite != null && (results = iSuite.getResults()) != null) {
            Collection<ISuiteResult> tempSuiteResult = results.values();
            for (ISuiteResult isr : tempSuiteResult) {
                ITestContext ctx = isr.getTestContext();
                int skipped = ctx.getSkippedTests().size();
                int failed = ctx.getFailedTests().size() + ctx.getFailedButWithinSuccessPercentageTests().size();
                this.m_skipped += skipped;
                this.m_failed += failed;
                this.m_confFailures += ctx.getFailedConfigurations().size();
                this.m_confSkips += ctx.getSkippedConfigurations().size();
                this.m_total += ctx.getPassedTests().size() + failed + skipped;
            }
            for (XmlSuite childSuite : xmlSuite.getChildSuites()) {
                this.calculateResultCounts(childSuite, suiteRunnerMap);
            }
        }
    }
}

