/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.valueextraction.builtin;

import jakarta.validation.Validator;
import jakarta.validation.constraints.NotNull;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.hibernate.beanvalidation.tck.tests.AbstractTCKTest;
import org.hibernate.beanvalidation.tck.util.ConstraintViolationAssert;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="3.0.0")
public class IterableValueExtractorTest
extends AbstractTCKTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)IterableValueExtractorTest.webArchiveBuilder().withTestClass(IterableValueExtractorTest.class)).build();
    }

    @Test
    @SpecAssertion(section="valueextractordefinition-builtinvalueextractors", id="a")
    public void iterableValueExtractor() {
        Validator validator = this.getValidator();
        Set violations = validator.validate((Object)new IterableHolder(new IterableImpl<String>(Arrays.asList("valid", null))), new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyPaths(ConstraintViolationAssert.pathWith().property("iterable").containerElement("<iterable element>", true, null, null, Iterable.class, 0));
    }

    private static class IterableHolder {
        private final Iterable<@NotNull String> iterable;

        private IterableHolder(Iterable<String> iterable) {
            this.iterable = iterable;
        }
    }

    private static class IterableImpl<T>
    implements Iterable<T> {
        private final List<T> innerList;

        private IterableImpl(List<T> innerList) {
            this.innerList = innerList;
        }

        @Override
        public Iterator<T> iterator() {
            return this.innerList.iterator();
        }
    }
}

