/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.time.temporal.Temporal;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.data.TemporalOffset;
import org.assertj.core.error.ShouldBeCloseTo;
import org.assertj.core.internal.Failures;
import org.assertj.core.internal.Objects;
import org.assertj.core.util.Preconditions;
import org.assertj.core.util.VisibleForTesting;

public abstract class AbstractTemporalAssert<SELF extends AbstractTemporalAssert<SELF, TEMPORAL>, TEMPORAL extends Temporal>
extends AbstractAssert<SELF, TEMPORAL> {
    protected AbstractTemporalAssert(TEMPORAL actual, Class<?> selfType) {
        super(actual, selfType);
    }

    @VisibleForTesting
    protected TEMPORAL getActual() {
        return (TEMPORAL)((Temporal)this.actual);
    }

    public SELF isCloseTo(TEMPORAL other, TemporalOffset<? super TEMPORAL> offset) {
        Objects.instance().assertNotNull(this.info, this.actual);
        Preconditions.checkNotNull(other, "The temporal object to compare actual with should not be null");
        Preconditions.checkNotNull(offset, "The offset should not be null");
        if (offset.isBeyondOffset((Temporal)this.actual, other)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeCloseTo.shouldBeCloseTo((Temporal)this.actual, other, offset.getBeyondOffsetDifferenceDescription((Temporal)this.actual, other)));
        }
        return (SELF)((AbstractTemporalAssert)this.myself);
    }

    public SELF isCloseTo(String otherAsString, TemporalOffset<? super TEMPORAL> offset) {
        Preconditions.checkNotNull(otherAsString, "The String representing of the temporal object to compare actual with should not be null");
        return this.isCloseTo(this.parse(otherAsString), offset);
    }

    protected abstract TEMPORAL parse(String var1);
}

