/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.core.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.logging.Logger;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.core.impl.RuntimeLogger;
import org.jboss.arquillian.core.spi.InvocationException;
import org.jboss.arquillian.core.spi.Manager;
import org.jboss.arquillian.core.spi.ObserverMethod;

public class ObserverImpl
implements ObserverMethod,
Comparable<ObserverMethod> {
    private static Logger log = Logger.getLogger(ObserverMethod.class.getName());
    private Object target;
    private Method method;

    ObserverImpl(Object target, Method method) {
        this.target = target;
        this.method = method;
    }

    public static ObserverImpl of(Object extension, Method observerMethod) {
        return new ObserverImpl(extension, observerMethod);
    }

    public Type getType() {
        return this.method.getGenericParameterTypes()[0];
    }

    public Method getMethod() {
        return this.method;
    }

    public boolean invoke(Manager manager, Object event) {
        try {
            Object[] arguments = this.resolveArguments(manager, event);
            if (this.containsNull(arguments)) {
                return false;
            }
            if (!this.method.isAccessible()) {
                this.method.setAccessible(true);
            }
            this.method.invoke(this.target, arguments);
            return true;
        }
        catch (Exception e) {
            if (e instanceof InvocationTargetException) {
                Throwable cause = ((InvocationTargetException)e).getTargetException();
                if (cause instanceof InvocationException) {
                    throw (InvocationException)cause;
                }
                throw new InvocationException(cause);
            }
            throw new InvocationException((Throwable)e);
        }
    }

    @Override
    public int compareTo(ObserverMethod o) {
        if (o == null) {
            return 1;
        }
        Integer a = this.getPresedence(this.getMethod());
        Integer b = this.getPresedence(o.getMethod());
        return b.compareTo(a);
    }

    private Integer getPresedence(Method method) {
        Annotation[][] annotationArray = method.getParameterAnnotations();
        int n = annotationArray.length;
        for (int i = 0; i < n; ++i) {
            Annotation[] annotations;
            for (Annotation annotation : annotations = annotationArray[i]) {
                if (annotation.annotationType() != Observes.class) continue;
                return ((Observes)annotation).precedence();
            }
        }
        return 0;
    }

    private Object[] resolveArguments(Manager manager, Object event) {
        Class<?>[] argumentTypes = this.getMethod().getParameterTypes();
        int numberOfArguments = argumentTypes.length;
        Object[] arguments = new Object[numberOfArguments];
        arguments[0] = event;
        for (int i = 1; i < numberOfArguments; ++i) {
            Class<?> argumentType = argumentTypes[i];
            arguments[i] = manager.resolve(argumentType);
            if (!RuntimeLogger.DEBUG.booleanValue() || arguments[i] != null) continue;
            log.warning(String.format("Argument %d (of type %s) for %s#%s is null. Observer method won't be invoked.", i + 1, argumentType.getSimpleName(), this.getMethod().getDeclaringClass().getName(), this.getMethod().getName()));
        }
        return arguments;
    }

    private boolean containsNull(Object[] arguments) {
        for (Object argument : arguments) {
            if (argument != null) continue;
            return true;
        }
        return false;
    }
}

