/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.validation.groupconversion.containerelement;

import jakarta.validation.constraints.NotNull;
import jakarta.validation.groups.Default;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.time.Year;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.beanvalidation.tck.tests.AbstractTCKTest;
import org.hibernate.beanvalidation.tck.tests.validation.groupconversion.containerelement.Address;
import org.hibernate.beanvalidation.tck.tests.validation.groupconversion.containerelement.BasicPostal;
import org.hibernate.beanvalidation.tck.tests.validation.groupconversion.containerelement.Complete;
import org.hibernate.beanvalidation.tck.tests.validation.groupconversion.containerelement.Complex;
import org.hibernate.beanvalidation.tck.tests.validation.groupconversion.containerelement.RegisteredAddresses;
import org.hibernate.beanvalidation.tck.util.ConstraintViolationAssert;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="3.0.0")
public abstract class AbstractContainerElementGroupConversionValidationTest
extends AbstractTCKTest {
    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-groupsequence-groupconversion", id="c"), @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine", id="a"), @SpecAssertion(section="constraintdeclarationvalidationprocess-groupsequence-groupconversion-examples", id="a"), @SpecAssertion(section="xml-mapping-constraintdeclarationinxml-containerelementconstraints", id="i")})
    public void testGroupConversionIsAppliedOnField() {
        Set constraintViolations = this.getValidator().validate((Object)TestRegisteredAddresses.withInvalidMainAddress(), new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyPaths(ConstraintViolationAssert.pathWith().property("mainAddresses").containerElement("<map value>", true, TestRegisteredAddresses.REFERENCE_YEAR, null, Map.class, 1).property("street1", true, null, 1, List.class, 0), ConstraintViolationAssert.pathWith().property("mainAddresses").containerElement("<map value>", true, TestRegisteredAddresses.REFERENCE_YEAR, null, Map.class, 1).property("zipCode", true, null, 1, List.class, 0));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-groupsequence-groupconversion", id="c"), @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine", id="a"), @SpecAssertion(section="constraintdeclarationvalidationprocess-groupsequence-groupconversion-examples", id="a"), @SpecAssertion(section="xml-mapping-constraintdeclarationinxml-containerelementconstraints", id="i")})
    public void testSeveralGroupConversionsAppliedOnField() {
        RegisteredAddresses registeredAddressesWithInvalidPreferredShipmentAddress = TestRegisteredAddresses.withInvalidPreferredShipmentAddress();
        Set constraintViolations = this.getValidator().validate((Object)registeredAddressesWithInvalidPreferredShipmentAddress, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyPaths(ConstraintViolationAssert.pathWith().property("preferredShipmentAddresses").containerElement("<map value>", true, TestRegisteredAddresses.REFERENCE_YEAR, null, Map.class, 1).property("street1", true, null, 1, List.class, 0), ConstraintViolationAssert.pathWith().property("preferredShipmentAddresses").containerElement("<map value>", true, TestRegisteredAddresses.REFERENCE_YEAR, null, Map.class, 1).property("zipCode", true, null, 1, List.class, 0));
        constraintViolations = this.getValidator().validate((Object)registeredAddressesWithInvalidPreferredShipmentAddress, new Class[]{Complex.class});
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyPaths(ConstraintViolationAssert.pathWith().property("preferredShipmentAddresses").containerElement("<map value>", true, TestRegisteredAddresses.REFERENCE_YEAR, null, Map.class, 1).property("doorCode", true, null, 1, List.class, 0));
        constraintViolations = this.getValidator().validate((Object)registeredAddressesWithInvalidPreferredShipmentAddress, new Class[]{Default.class, Complex.class});
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyPaths(ConstraintViolationAssert.pathWith().property("preferredShipmentAddresses").containerElement("<map value>", true, TestRegisteredAddresses.REFERENCE_YEAR, null, Map.class, 1).property("street1", true, null, 1, List.class, 0), ConstraintViolationAssert.pathWith().property("preferredShipmentAddresses").containerElement("<map value>", true, TestRegisteredAddresses.REFERENCE_YEAR, null, Map.class, 1).property("zipCode", true, null, 1, List.class, 0), ConstraintViolationAssert.pathWith().property("preferredShipmentAddresses").containerElement("<map value>", true, TestRegisteredAddresses.REFERENCE_YEAR, null, Map.class, 1).property("doorCode", true, null, 1, List.class, 0));
        constraintViolations = this.getValidator().validate((Object)registeredAddressesWithInvalidPreferredShipmentAddress, new Class[]{Complete.class});
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyPaths(ConstraintViolationAssert.pathWith().property("preferredShipmentAddresses").containerElement("<map value>", true, TestRegisteredAddresses.REFERENCE_YEAR, null, Map.class, 1).property("street1", true, null, 1, List.class, 0), ConstraintViolationAssert.pathWith().property("preferredShipmentAddresses").containerElement("<map value>", true, TestRegisteredAddresses.REFERENCE_YEAR, null, Map.class, 1).property("zipCode", true, null, 1, List.class, 0), ConstraintViolationAssert.pathWith().property("preferredShipmentAddresses").containerElement("<map value>", true, TestRegisteredAddresses.REFERENCE_YEAR, null, Map.class, 1).property("doorCode", true, null, 1, List.class, 0));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-groupsequence-groupconversion", id="c"), @SpecAssertion(section="constraintdeclarationvalidationprocess-groupsequence-groupconversion-examples", id="a"), @SpecAssertion(section="xml-mapping-constraintdeclarationinxml-containerelementconstraints", id="i")})
    public void testGroupConversionIsAppliedOnProperty() {
        Set constraintViolations = this.getValidator().validate((Object)TestRegisteredAddresses.withInvalidShipmentAddress(), new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyPaths(ConstraintViolationAssert.pathWith().property("shipmentAddresses").containerElement("<map value>", true, TestRegisteredAddresses.REFERENCE_YEAR, null, Map.class, 1).property("street1", true, null, 1, List.class, 0), ConstraintViolationAssert.pathWith().property("shipmentAddresses").containerElement("<map value>", true, TestRegisteredAddresses.REFERENCE_YEAR, null, Map.class, 1).property("zipCode", true, null, 1, List.class, 0));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-groupsequence-groupconversion", id="c"), @SpecAssertion(section="constraintdeclarationvalidationprocess-groupsequence-groupconversion-examples", id="a"), @SpecAssertion(section="xml-mapping-constraintdeclarationinxml-containerelementconstraints", id="i")})
    public void testGroupConversionIsAppliedOnMethodReturnValue() throws Exception {
        RegisteredAddresses registeredAddresses = TestRegisteredAddresses.validRegisteredAddresses();
        Method method = RegisteredAddresses.class.getMethod("retrieveMainAddresses", new Class[0]);
        Map<Year, List<Address>> returnValue = TestAddresses.wrap(TestAddresses.withInvalidStreet1());
        Set constraintViolations = this.getExecutableValidator().validateReturnValue((Object)registeredAddresses, method, returnValue, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class).withPropertyPath(ConstraintViolationAssert.pathWith().method("retrieveMainAddresses").returnValue().containerElement("<map value>", true, TestRegisteredAddresses.REFERENCE_YEAR, null, Map.class, 1).property("street1", true, null, 0, List.class, 0)));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-groupsequence-groupconversion", id="c"), @SpecAssertion(section="constraintdeclarationvalidationprocess-groupsequence-groupconversion-examples", id="a"), @SpecAssertion(section="xml-mapping-constraintdeclarationinxml-containerelementconstraints", id="i")})
    public void testGroupConversionIsAppliedOnMethodParameter() throws Exception {
        RegisteredAddresses registeredAddresses = TestRegisteredAddresses.validRegisteredAddresses();
        Method method = RegisteredAddresses.class.getMethod("setMainAddresses", Map.class);
        Object[] arguments = new Object[]{TestAddresses.wrap(TestAddresses.withInvalidStreet1())};
        Set constraintViolations = this.getExecutableValidator().validateParameters((Object)registeredAddresses, method, arguments, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class).withPropertyPath(ConstraintViolationAssert.pathWith().method("setMainAddresses").parameter("mainAddresses", 0).containerElement("<map value>", true, TestRegisteredAddresses.REFERENCE_YEAR, null, Map.class, 1).property("street1", true, null, 0, List.class, 0)));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-groupsequence-groupconversion", id="c"), @SpecAssertion(section="constraintdeclarationvalidationprocess-groupsequence-groupconversion-examples", id="a"), @SpecAssertion(section="xml-mapping-constraintdeclarationinxml-containerelementconstraints", id="i")})
    public void testGroupConversionIsAppliedOnConstructorReturnValue() throws Exception {
        Constructor constructor = RegisteredAddresses.class.getConstructor(Map.class);
        RegisteredAddresses createdObject = TestRegisteredAddresses.withMainAddressInvalidStreet1();
        Set constraintViolations = this.getExecutableValidator().validateConstructorReturnValue(constructor, (Object)createdObject, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class).withPropertyPath(ConstraintViolationAssert.pathWith().constructor(RegisteredAddresses.class).returnValue().property("mainAddresses").containerElement("<map value>", true, TestRegisteredAddresses.REFERENCE_YEAR, null, Map.class, 1).property("street1", true, null, 1, List.class, 0)));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-groupsequence-groupconversion", id="c"), @SpecAssertion(section="constraintdeclarationvalidationprocess-groupsequence-groupconversion-examples", id="a"), @SpecAssertion(section="xml-mapping-constraintdeclarationinxml-containerelementconstraints", id="i")})
    public void testGroupConversionIsAppliedOnConstructorParameter() throws Exception {
        Constructor constructor = RegisteredAddresses.class.getConstructor(Map.class);
        Object[] arguments = new Object[]{TestAddresses.wrap(TestAddresses.withInvalidStreet1())};
        Set constraintViolations = this.getExecutableValidator().validateConstructorParameters(constructor, arguments, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class).withPropertyPath(ConstraintViolationAssert.pathWith().constructor(RegisteredAddresses.class).parameter("mainAddresses", 0).containerElement("<map value>", true, TestRegisteredAddresses.REFERENCE_YEAR, null, Map.class, 1).property("street1", true, null, 0, List.class, 0)));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-groupsequence-groupconversion", id="e"), @SpecAssertion(section="constraintdeclarationvalidationprocess-groupsequence-groupconversion-examples", id="a"), @SpecAssertion(section="xml-mapping-constraintdeclarationinxml-containerelementconstraints", id="i")})
    public void testGroupConversionIsNotExecutedRecursively() {
        Set constraintViolations = this.getValidator().validate((Object)TestRegisteredAddresses.withInvalidOfficeAddress(), new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyPaths(ConstraintViolationAssert.pathWith().property("officeAddresses").containerElement("<map value>", true, TestRegisteredAddresses.REFERENCE_YEAR, null, Map.class, 1).property("street1", true, null, 1, List.class, 0), ConstraintViolationAssert.pathWith().property("officeAddresses").containerElement("<map value>", true, TestRegisteredAddresses.REFERENCE_YEAR, null, Map.class, 1).property("zipCode", true, null, 1, List.class, 0));
        constraintViolations = this.getValidator().validate((Object)TestRegisteredAddresses.withInvalidOfficeAddress(), new Class[]{BasicPostal.class});
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyPaths(ConstraintViolationAssert.pathWith().property("officeAddresses").containerElement("<map value>", true, TestRegisteredAddresses.REFERENCE_YEAR, null, Map.class, 1).property("doorCode", true, null, 1, List.class, 0));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-groupsequence-groupconversion", id="h"), @SpecAssertion(section="constraintdeclarationvalidationprocess-groupsequence-groupconversion-examples", id="a"), @SpecAssertion(section="xml-mapping-constraintdeclarationinxml-containerelementconstraints", id="i")})
    public void testGroupConversionWithSequenceAsTo() {
        RegisteredAddresses registeredAddresses = TestRegisteredAddresses.validRegisteredAddresses();
        Set constraintViolations = this.getValidator().validate((Object)registeredAddresses, new Class[0]);
        ConstraintViolationAssert.assertNoViolations(constraintViolations);
        registeredAddresses.getWeekendAddresses().get(TestRegisteredAddresses.REFERENCE_YEAR).get(0).setDoorCode("ABC");
        constraintViolations = this.getValidator().validate((Object)registeredAddresses, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyPaths(ConstraintViolationAssert.pathWith().property("weekendAddresses").containerElement("<map value>", true, TestRegisteredAddresses.REFERENCE_YEAR, null, Map.class, 1).property("doorCode", true, null, 0, List.class, 0));
        registeredAddresses.getWeekendAddresses().get(TestRegisteredAddresses.REFERENCE_YEAR).get(0).setStreet1(null);
        constraintViolations = this.getValidator().validate((Object)registeredAddresses, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyPaths(ConstraintViolationAssert.pathWith().property("weekendAddresses").containerElement("<map value>", true, TestRegisteredAddresses.REFERENCE_YEAR, null, Map.class, 1).property("street1", true, null, 0, List.class, 0));
    }

    private static class TestAddresses {
        private TestAddresses() {
        }

        public static Address validAddress() {
            return new Address("Main Street", "c/o Hitchcock", "123", "AB");
        }

        public static Address invalidAddress() {
            return new Address(null, null, "12", "ABC");
        }

        public static Address withInvalidStreet1() {
            Address address = TestAddresses.validAddress();
            address.setStreet1(null);
            return address;
        }

        public static Map<Year, List<Address>> wrap(Address address) {
            HashMap<Year, List<Address>> addresses = new HashMap<Year, List<Address>>();
            addresses.put(TestRegisteredAddresses.REFERENCE_YEAR, Arrays.asList(address));
            return addresses;
        }
    }

    private static class TestRegisteredAddresses {
        public static final Year REFERENCE_YEAR = Year.of(2016);

        private TestRegisteredAddresses() {
        }

        public static RegisteredAddresses validRegisteredAddresses() {
            return new RegisteredAddresses().addMainAddress(REFERENCE_YEAR, TestAddresses.validAddress()).addShipmentAddress(REFERENCE_YEAR, TestAddresses.validAddress()).addPreferredShipmentAddress(REFERENCE_YEAR, TestAddresses.validAddress()).addOfficeAddress(REFERENCE_YEAR, TestAddresses.validAddress()).addWeekendAddress(REFERENCE_YEAR, TestAddresses.validAddress());
        }

        public static RegisteredAddresses withInvalidMainAddress() {
            RegisteredAddresses registeredAddresses = TestRegisteredAddresses.validRegisteredAddresses();
            registeredAddresses.addMainAddress(REFERENCE_YEAR, TestAddresses.invalidAddress());
            return registeredAddresses;
        }

        public static RegisteredAddresses withMainAddressInvalidStreet1() {
            RegisteredAddresses registeredAddresses = TestRegisteredAddresses.validRegisteredAddresses();
            registeredAddresses.addMainAddress(REFERENCE_YEAR, TestAddresses.withInvalidStreet1());
            return registeredAddresses;
        }

        public static RegisteredAddresses withInvalidShipmentAddress() {
            RegisteredAddresses registeredAddresses = TestRegisteredAddresses.validRegisteredAddresses();
            registeredAddresses.addShipmentAddress(REFERENCE_YEAR, TestAddresses.invalidAddress());
            return registeredAddresses;
        }

        public static RegisteredAddresses withInvalidPreferredShipmentAddress() {
            RegisteredAddresses registeredAddresses = TestRegisteredAddresses.validRegisteredAddresses();
            registeredAddresses.addPreferredShipmentAddress(REFERENCE_YEAR, TestAddresses.invalidAddress());
            return registeredAddresses;
        }

        public static RegisteredAddresses withInvalidOfficeAddress() {
            RegisteredAddresses registeredAddresses = TestRegisteredAddresses.validRegisteredAddresses();
            registeredAddresses.addOfficeAddress(REFERENCE_YEAR, TestAddresses.invalidAddress());
            return registeredAddresses;
        }
    }
}

