/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.migration.ui;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.edapt.common.URIUtils;
import org.eclipse.emf.edapt.common.ui.SelectionUtils;
import org.eclipse.emf.edapt.history.Release;
import org.eclipse.emf.edapt.migration.IDebugger;
import org.eclipse.emf.edapt.migration.IOracle;
import org.eclipse.emf.edapt.migration.Metamodel;
import org.eclipse.emf.edapt.migration.Model;
import org.eclipse.emf.edapt.migration.Persistency;
import org.eclipse.emf.edapt.migration.ReleaseUtils;
import org.eclipse.emf.edapt.migration.execution.Migrator;
import org.eclipse.emf.edapt.migration.execution.MigratorRegistry;
import org.eclipse.emf.edapt.migration.ui.InteractiveDebugger;
import org.eclipse.emf.edapt.migration.ui.InteractiveOracle;
import org.eclipse.emf.edapt.migration.ui.ReleaseDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MigratorHandlerBase
extends AbstractHandler {
    private List<IFile> selectedFiles;

    public Object execute(ExecutionEvent event) {
        this.updateSelection(HandlerUtil.getCurrentSelection((ExecutionEvent)event));
        this.run();
        return null;
    }

    protected void run() {
        List<URI> modelURIs = this.getURIs();
        Migrator migrator = this.getMigrator(modelURIs);
        if (migrator == null) {
            return;
        }
        Release release = this.getRelease(modelURIs, migrator);
        if (release == null) {
            return;
        }
        this.run(modelURIs, migrator, release);
    }

    protected abstract void run(List<URI> var1, Migrator var2, Release var3);

    protected Migrator getMigrator(List<URI> modelURIs) {
        MigratorRegistry.getInstance().setOracle((IOracle)new InteractiveOracle());
        MigratorRegistry.getInstance().setDebugger((IDebugger)new InteractiveDebugger());
        String nsURI = ReleaseUtils.getNamespaceURI((URI)modelURIs.get(0));
        if (nsURI == null) {
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Namespace", (String)"Not a valid model");
            return null;
        }
        Migrator migrator = this.getRegistryMigrator(nsURI);
        return migrator;
    }

    private Migrator getRegistryMigrator(String nsURI) {
        Migrator migrator = MigratorRegistry.getInstance().getMigrator(nsURI);
        if (migrator == null) {
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Migrator", (String)"No migrator registered for model with that namespace");
            return null;
        }
        return migrator;
    }

    protected Release getRelease(List<URI> modelURIs, Migrator migrator) {
        HashSet<Release> releases = new HashSet<Release>(migrator.getRelease(modelURIs.get(0)));
        Release release = null;
        if (releases.size() > 1) {
            Iterator i = releases.iterator();
            while (i.hasNext()) {
                Release r = (Release)i.next();
                Metamodel metamodel = migrator.getMetamodel(r);
                try {
                    Model model = Persistency.loadModel(modelURIs, (Metamodel)metamodel);
                    model.checkConformance();
                }
                catch (Exception exception) {
                    i.remove();
                }
            }
        }
        if (releases.size() > 1) {
            ReleaseDialog dialog = new ReleaseDialog(releases);
            if (dialog.open() != 0) {
                return null;
            }
            release = dialog.getRelease();
        } else {
            release = (Release)releases.iterator().next();
        }
        return release;
    }

    protected List<URI> getURIs() {
        ArrayList<URI> uris = new ArrayList<URI>();
        for (IFile file : this.selectedFiles) {
            uris.add(URIUtils.getURI((IResource)file));
        }
        return uris;
    }

    private void updateSelection(ISelection selection) {
        this.selectedFiles = SelectionUtils.getSelectedElements((ISelection)selection);
    }

    protected List<IFile> getSelectedFiles() {
        return this.selectedFiles;
    }
}

