/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.history.presentation;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.edapt.declaration.Operation;
import org.eclipse.emf.edapt.declaration.Parameter;
import org.eclipse.emf.edapt.history.Change;
import org.eclipse.emf.edapt.history.MigrationChange;
import org.eclipse.emf.edapt.history.OperationChange;
import org.eclipse.emf.edapt.history.OperationInstance;
import org.eclipse.emf.edapt.history.PrimitiveChange;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.part.ViewPart;

public class ChangeDocumentationView
extends ViewPart
implements ISelectionListener {
    public static final String ID = ChangeDocumentationView.class.getName();
    private FormText text;

    public void createPartControl(Composite parent) {
        Color white = Display.getDefault().getSystemColor(1);
        GridLayout layout = new GridLayout(1, false);
        Composite composite = new Composite(parent, 0);
        composite.setBackground(white);
        composite.setLayout((Layout)layout);
        this.text = new FormText(composite, 0);
        this.text.setBackground(white);
        this.text.setLayoutData((Object)new GridData(1808));
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().addSelectionListener((ISelectionListener)this);
    }

    public void setFocus() {
        if (!this.text.isDisposed()) {
            this.text.setFocus();
        }
    }

    private String getDocumentation(Change change) {
        if (change instanceof OperationChange) {
            OperationChange operationChange = (OperationChange)change;
            Operation operation = operationChange.getOperation().getOperation();
            return this.getDocumentation(operation);
        }
        if (change instanceof PrimitiveChange) {
            PrimitiveChange primitiveChange = (PrimitiveChange)change;
            return this.getDocumentation(primitiveChange);
        }
        if (change instanceof MigrationChange) {
            return this.getMigrationDocumentation();
        }
        return "<form></form>";
    }

    private String getMigrationDocumentation() {
        return this.assemble("Custom Migration", "This change attaches a custom migration to a sequence of changes.", new String[]{"<b>changes</b>: the sequence of changes"});
    }

    private String getDocumentation(PrimitiveChange change) {
        EClass eClass = change.eClass();
        switch (eClass.getClassifierID()) {
            case 12: {
                return this.getAddDocumentation();
            }
            case 13: {
                return this.getRemoveDocumentation();
            }
            case 11: {
                return this.getSetDocumentation();
            }
            case 7: {
                return this.getCreateDocumentation();
            }
            case 9: {
                return this.getDeleteDocumentation();
            }
            case 8: {
                return this.getMoveDocumentation();
            }
            case 4: {
                return this.getNoChangeDocumentation();
            }
        }
        return "<form></form>";
    }

    private String getNoChangeDocumentation() {
        return this.assemble("Primitive \"No Change\"", "In the metamodel, nothing is changed.", new String[0]);
    }

    private String getMoveDocumentation() {
        return this.assemble("Primitive \"Move\"", "In the metamodel, an element is moved to a new target. This primitive only applies to containment references.", new String[]{"<b>element</b>: the element which is moved", "<b>target</b>: the target to which the element is moved", "<b>reference</b>: the reference to which the element is moved", "<b>source</b>: the source from which the element is moved"});
    }

    private String getDeleteDocumentation() {
        return this.assemble("Primitive \"Delete\"", "In the metamodel, an element is deleted from a target. In addition, cross references are removed which target the element or its children. This primitive only applies to containment references.", new String[]{"<b>element</b>: the element which is deleted", "<b>target</b>: the target from which the element is deleted", "<b>reference</b>: the reference from which the element is deleted", "<b>changes</b>: changes that delete the cross references"});
    }

    private String getCreateDocumentation() {
        return this.assemble("Primitive \"Create\"", "In the metamodel, an element is created as a child of a target and initialized. This primitive only applies to containment references.", new String[]{"<b>element</b>: the element which is created", "<b>target</b>: the target as a child of which the element is created", "<b>reference</b>: the reference in which the element is created", "<b>changes</b>: changes that initialize attribute and cross references of the element"});
    }

    private String getSetDocumentation() {
        return this.assemble("Primitive \"Set\"", "In the metamodel, the value of an element's feature is changed. This primitive only applies to single-valued features which are either attribute or cross reference.", new String[]{"<b>element</b>: the element whose feature's value is changed", "<b>feature</b>: the single-valued feature", "<b>value</b>: the new value", "<b>oldValue</b>: the old value"});
    }

    private String getRemoveDocumentation() {
        return this.assemble("Primitive \"Remove\"", "In the metamodel, a value is removed from a feature of an element. This primitive only applies to many-valued features which are either attribute or cross reference.", new String[]{"<b>element</b>: the element from whose feature the value is removed", "<b>feature</b>: the multi-valued feature", "<b>value</b>: the value that is removed"});
    }

    private String getAddDocumentation() {
        return this.assemble("Primitive \"Add\"", "In the metamodel, a value is added to a feature of an element. This primitive only applies to many-valued features which are either attribute or cross reference.", new String[]{"<b>element</b>: the element to whose feature the value is added", "<b>feature</b>: the multi-valued feature", "<b>value</b>: the value that is added"});
    }

    private String getDocumentation(Operation operation) {
        String[] parameterList = new String[operation.getParameters().size()];
        int i = 0;
        for (Parameter parameter : operation.getParameters()) {
            parameterList[i++] = "<b>" + parameter.getName() + "</b>: " + parameter.getDescription();
        }
        return this.assemble("Operation \"" + operation.getLabel() + "\"", operation.getDescription(), parameterList);
    }

    private void unsetText() {
        this.text.setText("", false, false);
    }

    private String assemble(String title, String description, String[] list) {
        StringBuffer result = new StringBuffer();
        result.append("<form>");
        result.append("<p><b>");
        result.append(title);
        result.append("</b></p>");
        result.append("<p>");
        result.append(description);
        result.append("</p>");
        String[] stringArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            result.append("<li>");
            result.append(item);
            result.append("</li>");
            ++n2;
        }
        result.append("</form>");
        return result.toString();
    }

    public void dispose() {
        super.dispose();
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().removeSelectionListener((ISelectionListener)this);
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        IStructuredSelection structuredSelection;
        if (selection instanceof IStructuredSelection && (structuredSelection = (IStructuredSelection)selection).size() == 1) {
            Object element = structuredSelection.getFirstElement();
            if (element instanceof Change) {
                Change change = (Change)element;
                this.text.setText(this.getDocumentation(change), true, false);
                return;
            }
            if (element instanceof OperationInstance) {
                OperationInstance operationInstance = (OperationInstance)element;
                Operation operation = operationInstance.getOperation();
                this.text.setText(this.getDocumentation(operation), true, false);
                return;
            }
        }
        this.unsetText();
    }
}

