/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.history.provider.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edapt.history.Change;
import org.eclipse.emf.edapt.history.util.MoveChecker;
import org.eclipse.emf.edit.command.DragAndDropCommand;
import org.eclipse.emf.edit.domain.EditingDomain;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestrictingDragAndDropCommand
extends DragAndDropCommand {
    public RestrictingDragAndDropCommand(EditingDomain domain, Object owner, float location, int operations, int operation, Collection<?> collection) {
        super(domain, owner, location, operations, operation, collection);
    }

    protected boolean prepareDropMoveOn() {
        if (!super.prepareDropMoveOn()) {
            return false;
        }
        List<Change> changes = this.getChanges();
        EObject target = (EObject)this.owner;
        if (changes.contains(this.owner)) {
            return false;
        }
        boolean canBeMoved = MoveChecker.canBeMoved(changes, (EObject)target);
        return canBeMoved;
    }

    private List<Change> getChanges() {
        ArrayList<Change> changes = new ArrayList<Change>();
        for (Object element : this.collection) {
            if (element instanceof Change) {
                changes.add((Change)element);
                continue;
            }
            return Collections.emptyList();
        }
        return changes;
    }

    protected boolean prepareDropCopyOn() {
        return false;
    }

    protected boolean prepareDropMoveInsert(Object parent, Collection<?> children, int index) {
        if (!super.prepareDropMoveInsert(parent, children, index)) {
            return false;
        }
        List<Change> changes = this.getChanges();
        EObject target = (EObject)parent;
        boolean canBeMoved = MoveChecker.canBeMoved(changes, (EObject)target, (int)index);
        return canBeMoved;
    }

    protected boolean prepareDropCopyInsert(Object parent, Collection<?> children, int index) {
        return false;
    }
}

