/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.history.reconstruction;

import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.diff.metamodel.ComparisonResourceSetSnapshot;
import org.eclipse.emf.compare.diff.metamodel.DiffFactory;
import org.eclipse.emf.compare.diff.metamodel.DiffResourceSet;
import org.eclipse.emf.compare.diff.service.DiffService;
import org.eclipse.emf.compare.match.metamodel.Match2Elements;
import org.eclipse.emf.compare.match.metamodel.MatchFactory;
import org.eclipse.emf.compare.match.metamodel.MatchModel;
import org.eclipse.emf.compare.match.metamodel.MatchResourceSet;
import org.eclipse.emf.compare.match.metamodel.Side;
import org.eclipse.emf.compare.match.metamodel.UnmatchElement;
import org.eclipse.emf.compare.match.metamodel.UnmatchModel;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edapt.history.reconstruction.CompositeMapping;
import org.eclipse.emf.edapt.history.reconstruction.DiffModelFilterUtils;
import org.eclipse.emf.edapt.history.reconstruction.DiffModelOrderFilter;
import org.eclipse.emf.edapt.history.reconstruction.EcoreForwardReconstructor;
import org.eclipse.emf.edapt.history.reconstruction.IDiffModelFilter;
import org.eclipse.emf.edapt.history.reconstruction.MappingBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HistoryComparer {
    private final EcoreForwardReconstructor sourceReconstructor;
    private final EcoreForwardReconstructor targetReconstructor;
    private final CompositeMapping mapping;
    private final Map<EObject, Match2Elements> matches;

    public HistoryComparer(EcoreForwardReconstructor source, EcoreForwardReconstructor target) {
        this.sourceReconstructor = source;
        this.targetReconstructor = target;
        this.mapping = new CompositeMapping((MappingBase)source.getMapping(), (MappingBase)target.getMapping());
        this.matches = new IdentityHashMap<EObject, Match2Elements>();
    }

    public ComparisonResourceSetSnapshot compare() {
        MatchResourceSet matchResourceSet = this.createMatchResourceSet();
        DiffResourceSet diffResourceSet = DiffService.doDiff((MatchResourceSet)matchResourceSet);
        ComparisonResourceSetSnapshot snapshot = DiffFactory.eINSTANCE.createComparisonResourceSetSnapshot();
        snapshot.setMatchResourceSet(matchResourceSet);
        DiffModelFilterUtils.filter(diffResourceSet, (IDiffModelFilter)DiffModelOrderFilter.INSTANCE);
        snapshot.setDiffResourceSet(diffResourceSet);
        return snapshot;
    }

    private MatchResourceSet createMatchResourceSet() {
        this.matches.clear();
        MatchResourceSet matchResourceSet = MatchFactory.eINSTANCE.createMatchResourceSet();
        this.createSourceMatches(matchResourceSet);
        this.createTargetUnmatches(matchResourceSet);
        return matchResourceSet;
    }

    private void createSourceMatches(MatchResourceSet matchResourceSet) {
        for (Resource sourceResource : this.sourceReconstructor.getResourceSet().getResources()) {
            EList sourceMatches = sourceResource.getContents();
            Resource targetResource = null;
            for (EObject source : sourceMatches) {
                EObject target = this.mapping.getTarget(source);
                if (target == null || target.eResource() == null) continue;
                targetResource = target.eResource();
            }
            if (targetResource != null) {
                EList targetMatches = targetResource.getContents();
                MatchModel matchModel = this.createMatchModel((List<EObject>)sourceMatches, (List<EObject>)targetMatches);
                matchResourceSet.getMatchModels().add((Object)matchModel);
                continue;
            }
            UnmatchModel unmatchModel = MatchFactory.eINSTANCE.createUnmatchModel();
            unmatchModel.getRoots().addAll((Collection)sourceMatches);
            unmatchModel.setSide(Side.LEFT);
            matchResourceSet.getUnmatchedModels().add((Object)unmatchModel);
        }
    }

    private void createTargetUnmatches(MatchResourceSet matchResourceSet) {
        for (Resource targetResource : this.targetReconstructor.getResourceSet().getResources()) {
            EList targetMatches = targetResource.getContents();
            Resource sourceResource = null;
            for (EObject target : targetMatches) {
                EObject source = this.mapping.getSource(target);
                if (source == null || source.eResource() == null) continue;
                sourceResource = source.eResource();
            }
            if (sourceResource != null) continue;
            UnmatchModel unmatchModel = MatchFactory.eINSTANCE.createUnmatchModel();
            unmatchModel.getRoots().addAll((Collection)targetMatches);
            unmatchModel.setSide(Side.RIGHT);
            matchResourceSet.getUnmatchedModels().add((Object)unmatchModel);
        }
    }

    private MatchModel createMatchModel(List<EObject> sourceMatches, List<EObject> targetMatches) {
        MatchModel matchModel = MatchFactory.eINSTANCE.createMatchModel();
        matchModel.getRightRoots().addAll(sourceMatches);
        matchModel.getLeftRoots().addAll(targetMatches);
        while (!sourceMatches.isEmpty() || !targetMatches.isEmpty()) {
            List<EObject> sourceUnmatches = this.createSourceMatches(sourceMatches, matchModel);
            List<EObject> targetUnmatches = this.createTargetMatches(targetMatches, matchModel);
            sourceMatches = this.createSourceUnmatches(sourceUnmatches, matchModel);
            targetMatches = this.createTargetUnmatches(targetUnmatches, matchModel);
        }
        return matchModel;
    }

    private List<EObject> createSourceMatches(List<EObject> sourceMatches, MatchModel matchModel) {
        ArrayList<EObject> sourceUnmatches = new ArrayList<EObject>();
        for (EObject source : sourceMatches) {
            EObject target = this.getTarget(source);
            if (this.exists(target)) {
                EObject parent = source.eContainer();
                Match2Elements match = null;
                if (parent != null) {
                    Match2Elements parentMatch = this.matches.get(parent);
                    if (parentMatch == null) {
                        parent = this.getSource(target.eContainer());
                        parentMatch = this.matches.get(parent);
                    }
                    match = this.createOrGetMatch(source, target, parentMatch);
                } else {
                    match = this.createOrGetMatch(source, target, matchModel);
                }
                this.createSourceMatches(source, match, sourceUnmatches);
                continue;
            }
            sourceUnmatches.add(source);
        }
        return sourceUnmatches;
    }

    private void createSourceMatches(EObject parent, Match2Elements parentMatch, List<EObject> sourceUnmatches) {
        for (EObject source : parent.eContents()) {
            EObject target = this.getTarget(source);
            if (this.exists(target)) {
                Match2Elements match1 = this.newMatch(source, target);
                parentMatch.getSubMatchElements().add((Object)match1);
                Match2Elements match = match1;
                this.createSourceMatches(source, match, sourceUnmatches);
                continue;
            }
            sourceUnmatches.add(source);
        }
    }

    private List<EObject> createTargetMatches(List<EObject> targetMatches, MatchModel matchModel) {
        ArrayList<EObject> targetUnmatches = new ArrayList<EObject>();
        for (EObject target : targetMatches) {
            EObject source = this.getSource(target);
            if (this.exists(source)) {
                EObject parent = this.getSource(target.eContainer());
                if (parent == null) {
                    parent = source.eContainer();
                }
                Match2Elements match = null;
                if (parent != null) {
                    Match2Elements parentMatch = this.matches.get(parent);
                    match = this.createOrGetMatch(source, target, parentMatch);
                } else {
                    match = this.createOrGetMatch(source, target, matchModel);
                }
                this.createTargetMatches(target, match, targetUnmatches);
                continue;
            }
            targetUnmatches.add(target);
        }
        return targetUnmatches;
    }

    private void createTargetMatches(EObject parent, Match2Elements parentMatch, List<EObject> targetUnmatches) {
        for (EObject target : parent.eContents()) {
            EObject source = this.getSource(target);
            if (this.exists(source)) {
                Match2Elements match = this.createOrGetMatch(source, target, parentMatch);
                this.createTargetMatches(target, match, targetUnmatches);
                continue;
            }
            targetUnmatches.add(target);
        }
    }

    private List<EObject> createSourceUnmatches(List<EObject> sourceUnmatches, MatchModel matchModel) {
        ArrayList<EObject> sourceMatches = new ArrayList<EObject>();
        for (EObject source : sourceUnmatches) {
            this.createUnmatch(source, Side.RIGHT, matchModel);
            this.createSourceUnmatches(source, matchModel, sourceMatches);
        }
        return sourceMatches;
    }

    private void createSourceUnmatches(EObject parent, MatchModel matchModel, List<EObject> sourceMatches) {
        for (EObject source : parent.eContents()) {
            EObject target = this.getTarget(source);
            if (this.exists(target)) {
                sourceMatches.add(source);
                continue;
            }
            this.createSourceUnmatches(source, matchModel, sourceMatches);
        }
    }

    private List<EObject> createTargetUnmatches(List<EObject> targetUnmatches, MatchModel matchModel) {
        ArrayList<EObject> targetMatches = new ArrayList<EObject>();
        for (EObject target : targetUnmatches) {
            this.createUnmatch(target, Side.LEFT, matchModel);
            this.createTargetUnmatches(target, matchModel, targetMatches);
        }
        return targetMatches;
    }

    private void createTargetUnmatches(EObject parent, MatchModel matchModel, List<EObject> targetMatches) {
        for (EObject target : parent.eContents()) {
            EObject source = this.getSource(target);
            if (this.exists(source)) {
                targetMatches.add(target);
                continue;
            }
            this.createTargetUnmatches(target, matchModel, targetMatches);
        }
    }

    private boolean exists(EObject element) {
        return element != null && element.eResource() != null;
    }

    public EObject getTarget(EObject source) {
        if (source instanceof EGenericType) {
            return this.getGenericTarget((EGenericType)source);
        }
        return this.mapping.getTarget(source);
    }

    private EGenericType getGenericTarget(EGenericType source) {
        EObject parent = source.eContainer();
        EObject targetParent = this.mapping.getTarget(parent);
        if (targetParent != null) {
            EReference reference = source.eContainmentFeature();
            if (reference.isMany()) {
                List targets = (List)targetParent.eGet((EStructuralFeature)reference);
                for (EGenericType target : targets) {
                    if (target.getEClassifier() != this.mapping.getTarget((EObject)source.getEClassifier())) continue;
                    return target;
                }
            } else {
                EGenericType target = (EGenericType)targetParent.eGet((EStructuralFeature)reference);
                return target;
            }
        }
        return null;
    }

    public EObject getSource(EObject target) {
        if (target instanceof EGenericType) {
            return this.getGenericSource((EGenericType)target);
        }
        return this.mapping.getSource(target);
    }

    private EGenericType getGenericSource(EGenericType target) {
        EObject parent = target.eContainer();
        EObject sourceParent = this.mapping.getSource(parent);
        if (sourceParent != null) {
            EReference reference = target.eContainmentFeature();
            if (reference.isMany()) {
                List sources = (List)sourceParent.eGet((EStructuralFeature)reference);
                for (EGenericType source : sources) {
                    if (source.getEClassifier() != this.mapping.getSource((EObject)target.getEClassifier())) continue;
                    return source;
                }
            } else {
                EGenericType source = (EGenericType)sourceParent.eGet((EStructuralFeature)reference);
                return source;
            }
        }
        return null;
    }

    private Match2Elements createOrGetMatch(EObject source, EObject target, MatchModel matchModel) {
        Match2Elements match = this.matches.get(source);
        if (match == null) {
            match = this.newMatch(source, target);
            matchModel.getMatchedElements().add((Object)match);
        }
        return match;
    }

    private Match2Elements createOrGetMatch(EObject source, EObject target, Match2Elements parentMatch) {
        Match2Elements match = this.matches.get(source);
        if (match == null) {
            match = this.newMatch(source, target);
            parentMatch.getSubMatchElements().add((Object)match);
        }
        return match;
    }

    private Match2Elements newMatch(EObject source, EObject target) {
        Match2Elements match = MatchFactory.eINSTANCE.createMatch2Elements();
        match.setRightElement(source);
        match.setLeftElement(target);
        match.setSimilarity(1.0);
        this.matches.put(source, match);
        return match;
    }

    private UnmatchElement createUnmatch(EObject element, Side side, MatchModel matchModel) {
        UnmatchElement unmatch = MatchFactory.eINSTANCE.createUnmatchElement();
        unmatch.setElement(element);
        unmatch.setSide(side);
        if (side == Side.LEFT) {
            matchModel.getUnmatchedElements().add(0, (Object)unmatch);
        } else {
            matchModel.getUnmatchedElements().add((Object)unmatch);
        }
        return unmatch;
    }

    public EcoreForwardReconstructor getSourceReconstructor() {
        return this.sourceReconstructor;
    }

    public EcoreForwardReconstructor getTargetReconstructor() {
        return this.targetReconstructor;
    }
}

