/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.history.recorder;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edapt.common.MetamodelExtent;
import org.eclipse.emf.edapt.common.ResourceUtils;
import org.eclipse.emf.edapt.history.History;
import org.eclipse.emf.edapt.history.HistoryFactory;
import org.eclipse.emf.edapt.history.Release;
import org.eclipse.emf.edapt.history.recorder.CommandStackListener;
import org.eclipse.emf.edapt.history.recorder.HistoryGenerator;
import org.eclipse.emf.edapt.history.util.HistoryUtils;
import org.eclipse.emf.edit.domain.EditingDomain;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditingDomainListener {
    private Resource historyResource;
    private CommandStackListener commandStackListener;
    private final EditingDomain editingDomain;
    private boolean listening;

    public EditingDomainListener(EditingDomain editingDomain) {
        this.editingDomain = editingDomain;
        this.listening = false;
    }

    public void beginListening() {
        if (this.isListening()) {
            throw new IllegalStateException("Listener already activated");
        }
        this.commandStackListener = new CommandStackListener(this.editingDomain.getCommandStack(), this.historyResource);
        this.commandStackListener.beginListening();
        this.listening = true;
    }

    public void endListening() {
        if (!this.isListening()) {
            throw new IllegalStateException("Listener already deactivated");
        }
        this.commandStackListener.endListening();
        this.listening = false;
    }

    public boolean isListening() {
        return this.listening;
    }

    public void resetRecorder() {
        this.commandStackListener.resetRecorder();
    }

    public boolean loadHistory() {
        ResourceSet resourceSet = this.editingDomain.getResourceSet();
        URI uri = HistoryUtils.getHistoryURI((Resource)((Resource)resourceSet.getResources().get(0)));
        this.historyResource = resourceSet.createResource(uri);
        try {
            this.historyResource.load(null);
            EcoreUtil.resolveAll((Resource)this.historyResource);
            return true;
        }
        catch (IOException iOException) {
            resourceSet.getResources().remove((Object)this.historyResource);
            return false;
        }
    }

    public boolean isRecorded(Resource metamodel) {
        List rootPackages = ResourceUtils.getRootElements((Resource)metamodel, EPackage.class);
        EList historyRootPackages = this.getHistory().getRootPackages();
        for (EPackage rootPackage : rootPackages) {
            if (!historyRootPackages.contains(rootPackage)) continue;
            return true;
        }
        return false;
    }

    public void addHistory(Resource metamodel) {
        List rootPackages = ResourceUtils.getRootElements((Resource)metamodel, EPackage.class);
        this.getExtent().addRootPackages((Collection)rootPackages);
        HistoryUtils.setHistoryURI((Resource)metamodel, (URI)this.historyResource.getURI());
        HistoryGenerator generator = new HistoryGenerator(rootPackages);
        EList changes = generator.generate().getFirstRelease().getChanges();
        this.getHistory().getLastRelease().getChanges().addAll((Collection)changes);
    }

    public void createHistory(List<Resource> metamodelResources) {
        URI historyURI = HistoryUtils.getDefaultHistoryURI((Resource)metamodelResources.get(0));
        this.createHistory(metamodelResources, historyURI);
    }

    public void createHistory(List<Resource> metamodelResources, URI historyURI) {
        this.historyResource = this.editingDomain.getResourceSet().createResource(historyURI);
        ArrayList rootPackages = new ArrayList();
        for (Resource resource : metamodelResources) {
            HistoryUtils.setHistoryURI((Resource)resource, (URI)historyURI);
            rootPackages.addAll(ResourceUtils.getRootElements((Resource)resource, EPackage.class));
        }
        History history = new HistoryGenerator(rootPackages).generate();
        this.historyResource.getContents().add((Object)history);
    }

    public void release() {
        Release currentRelease = this.getHistory().getLastRelease();
        if (!currentRelease.getChanges().isEmpty()) {
            currentRelease.setDate(new Date());
            HistoryFactory factory = HistoryFactory.eINSTANCE;
            Release version = factory.createRelease();
            this.getHistory().getReleases().add((Object)version);
        }
    }

    public History getHistory() {
        History history = (History)this.historyResource.getContents().get(0);
        return history;
    }

    public EditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    public MetamodelExtent getExtent() {
        return this.commandStackListener.getExtent();
    }
}

