/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.common;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.edapt.common.CommonActivator;
import org.eclipse.emf.edapt.common.LoggingUtils;
import org.eclipse.emf.edapt.common.URIUtils;

public final class FileUtils {
    private FileUtils() {
    }

    public static String getContents(IFile file) {
        try {
            InputStream input = file.getContents();
            String contents = FileUtils.getContents(input);
            input.close();
            return contents;
        }
        catch (CoreException e) {
            LoggingUtils.logError((Plugin)CommonActivator.getDefault(), e);
            return null;
        }
        catch (IOException e) {
            LoggingUtils.logError((Plugin)CommonActivator.getDefault(), e);
            return null;
        }
    }

    public static String getContents(InputStream in) {
        try {
            String line;
            StringBuffer buffer = new StringBuffer();
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            while ((line = reader.readLine()) != null) {
                buffer.append(line);
                buffer.append('\n');
            }
            return buffer.toString();
        }
        catch (Exception e) {
            LoggingUtils.logError((Plugin)CommonActivator.getDefault(), e);
            return null;
        }
    }

    public static String getContents(File file) {
        try {
            String line;
            StringBuffer buffer = new StringBuffer();
            BufferedReader reader = new BufferedReader(new FileReader(file));
            while ((line = reader.readLine()) != null) {
                buffer.append(line);
                buffer.append('\n');
            }
            return buffer.toString();
        }
        catch (Exception e) {
            LoggingUtils.logError((Plugin)CommonActivator.getDefault(), e);
            return null;
        }
    }

    public static IFile resolveFile(IContainer container, String name) {
        if (container instanceof IProject) {
            return ((IProject)container).getFile(name);
        }
        if (container instanceof IFolder) {
            return ((IFolder)container).getFile(name);
        }
        return null;
    }

    public static void move(File source, File target) {
        source.renameTo(target);
    }

    public static void move(URI source, URI target) {
        FileUtils.move(URIUtils.getJavaFile(source), URIUtils.getJavaFile(target));
    }

    public static void delete(File target) {
        target.delete();
    }

    public static void delete(URI target) {
        FileUtils.delete(URIUtils.getJavaFile(target));
    }

    public static void copy(File source, File target) throws IOException {
        int len;
        FileInputStream in = new FileInputStream(source);
        FileOutputStream out = new FileOutputStream(target);
        byte[] buffer = new byte[1024];
        while ((len = in.read(buffer)) != -1) {
            out.write(buffer, 0, len);
        }
        in.close();
        out.close();
    }

    public static void copy(URI source, URI target) throws IOException {
        FileUtils.copy(URIUtils.getJavaFile(source), URIUtils.getJavaFile(target));
    }

    public static void createFile(String name, String contents) throws IOException {
        FileWriter writer = new FileWriter(name);
        writer.write(contents);
        writer.close();
    }

    public static void createDir(String name) {
        new File(name).mkdir();
    }

    public static String getExtension(File file) {
        String name;
        int i;
        if (!file.isDirectory() && (i = (name = file.getName()).lastIndexOf(46)) >= 0) {
            return name.substring(i + 1);
        }
        return null;
    }

    public static String getNameWithoutExtension(File file) {
        int i;
        String name = file.getName();
        if (!file.isDirectory() && (i = name.lastIndexOf(46)) >= 0) {
            return name.substring(0, i);
        }
        return name;
    }

    public static File replaceFileExtension(File file, String newExtension) {
        String name = FileUtils.getNameWithoutExtension(file);
        return new File(file.getParentFile(), String.valueOf(name) + "." + newExtension);
    }

    public static void deleteContents(File dir) {
        if (!dir.exists()) {
            return;
        }
        File[] fileArray = dir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                FileUtils.deleteContents(file);
            }
            file.delete();
            ++n2;
        }
    }

    public static IFile getFile(String fullPath) {
        return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(fullPath));
    }
}

