/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.jvm;

import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.BoundKind;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.Annotate;
import com.sun.tools.javac.jvm.ClassFile;
import com.sun.tools.javac.jvm.Code;
import com.sun.tools.javac.jvm.Pool;
import com.sun.tools.javac.jvm.Target;
import com.sun.tools.javac.util.BaseFileObject;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Convert;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Options;
import com.sun.tools.javac.util.Pair;
import com.sun.tools.javac.util.Version;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.nio.CharBuffer;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import javax.lang.model.AnnotatedConstruct;
import javax.lang.model.SourceVersion;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Version(value="@(#)ClassReader.java\t1.135 06/12/07")
public class ClassReader
extends ClassFile
implements Symbol.Completer {
    protected static final Context.Key<ClassReader> classReaderKey = new Context.Key();
    Annotate annotate;
    boolean verbose;
    boolean checkClassFile;
    public boolean readAllOfClassFile = false;
    boolean allowGenerics;
    boolean allowVarargs;
    boolean allowAnnotations;
    public boolean saveParameterNames;
    private boolean cacheCompletionFailure;
    public boolean preferSource;
    final Log log;
    Symtab syms;
    Types types;
    final Name.Table names;
    final Name completionFailureName;
    private final JavaFileManager fileManager;
    public SourceCompleter sourceCompleter = null;
    private Map<Name, Symbol.ClassSymbol> classes;
    private Map<Name, Symbol.PackageSymbol> packages;
    protected Scope typevars;
    protected JavaFileObject currentClassFile = null;
    protected Symbol currentOwner = null;
    byte[] buf = new byte[65520];
    int bp;
    Object[] poolObj;
    int[] poolIdx;
    byte[] signature;
    int sigp;
    int siglimit;
    boolean sigEnterPhase = false;
    byte[] signatureBuffer = new byte[0];
    int sbp = 0;
    private boolean readingClassAttr = false;
    private List<Type> missingTypeVariables = List.nil();
    private List<Type> foundTypeVariables = List.nil();
    private boolean suppressFlush = false;
    private boolean filling = false;
    private Symbol.CompletionFailure cachedCompletionFailure = new Symbol.CompletionFailure(null, null);
    protected JavaFileManager.Location currentLoc;
    private boolean verbosePath;

    public static ClassReader instance(Context context) {
        ClassReader classReader = context.get(classReaderKey);
        if (classReader == null) {
            classReader = new ClassReader(context, true);
        }
        return classReader;
    }

    public void init(Symtab symtab) {
        this.init(symtab, true);
    }

    private void init(Symtab symtab, boolean bl) {
        if (this.classes != null) {
            return;
        }
        if (bl) {
            assert (this.packages == null || this.packages == symtab.packages);
            this.packages = symtab.packages;
            assert (this.classes == null || this.classes == symtab.classes);
            this.classes = symtab.classes;
        } else {
            this.packages = new HashMap<Name, Symbol.PackageSymbol>();
            this.classes = new HashMap<Name, Symbol.ClassSymbol>();
        }
        this.packages.put(this.names.empty, symtab.rootPackage);
        symtab.rootPackage.completer = this;
        symtab.unnamedPackage.completer = this;
    }

    protected ClassReader(Context context, boolean bl) {
        this.cachedCompletionFailure.setStackTrace(new StackTraceElement[0]);
        this.verbosePath = true;
        if (bl) {
            context.put(classReaderKey, this);
        }
        this.names = Name.Table.instance(context);
        this.syms = Symtab.instance(context);
        this.types = Types.instance(context);
        this.fileManager = context.get(JavaFileManager.class);
        if (this.fileManager == null) {
            throw new AssertionError((Object)"FileManager initialization error");
        }
        this.init(this.syms, bl);
        this.log = Log.instance(context);
        Options options = Options.instance(context);
        this.annotate = Annotate.instance(context);
        this.verbose = options.get("-verbose") != null;
        this.checkClassFile = options.get("-checkclassfile") != null;
        Source source = Source.instance(context);
        this.allowGenerics = source.allowGenerics();
        this.allowVarargs = source.allowVarargs();
        this.allowAnnotations = source.allowAnnotations();
        this.saveParameterNames = options.get("save-parameter-names") != null;
        this.cacheCompletionFailure = options.get("dev") == null;
        this.preferSource = "source".equals(options.get("-Xprefer"));
        this.completionFailureName = options.get("failcomplete") != null ? this.names.fromString(options.get("failcomplete")) : null;
        this.typevars = new Scope(this.syms.noSymbol);
    }

    private void enterMember(Symbol.ClassSymbol classSymbol, Symbol symbol) {
        if ((symbol.flags_field & 0x80001000L) != 4096L) {
            classSymbol.members_field.enter(symbol);
        }
    }

    public BadClassFile badClassFile(String string, Object ... objectArray) {
        return new BadClassFile(this.currentOwner.enclClass(), this.currentClassFile, Log.getLocalizedString(string, objectArray));
    }

    char nextChar() {
        return (char)(((this.buf[this.bp++] & 0xFF) << 8) + (this.buf[this.bp++] & 0xFF));
    }

    int nextInt() {
        return ((this.buf[this.bp++] & 0xFF) << 24) + ((this.buf[this.bp++] & 0xFF) << 16) + ((this.buf[this.bp++] & 0xFF) << 8) + (this.buf[this.bp++] & 0xFF);
    }

    char getChar(int n) {
        return (char)(((this.buf[n] & 0xFF) << 8) + (this.buf[n + 1] & 0xFF));
    }

    int getInt(int n) {
        return ((this.buf[n] & 0xFF) << 24) + ((this.buf[n + 1] & 0xFF) << 16) + ((this.buf[n + 2] & 0xFF) << 8) + (this.buf[n + 3] & 0xFF);
    }

    long getLong(int n) {
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(this.buf, n, 8));
        try {
            return dataInputStream.readLong();
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
    }

    float getFloat(int n) {
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(this.buf, n, 4));
        try {
            return dataInputStream.readFloat();
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
    }

    double getDouble(int n) {
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(this.buf, n, 8));
        try {
            return dataInputStream.readDouble();
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
    }

    void indexPool() {
        this.poolIdx = new int[this.nextChar()];
        this.poolObj = new Object[this.poolIdx.length];
        int n = 1;
        block6: while (n < this.poolIdx.length) {
            this.poolIdx[n++] = this.bp;
            byte by = this.buf[this.bp++];
            switch (by) {
                case 1: 
                case 2: {
                    char c = this.nextChar();
                    this.bp += c;
                    continue block6;
                }
                case 7: 
                case 8: {
                    this.bp += 2;
                    continue block6;
                }
                case 3: 
                case 4: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    this.bp += 4;
                    continue block6;
                }
                case 5: 
                case 6: {
                    this.bp += 8;
                    ++n;
                    continue block6;
                }
            }
            throw this.badClassFile("bad.const.pool.tag.at", Byte.toString(by), Integer.toString(this.bp - 1));
        }
    }

    Object readPool(int n) {
        Object object = this.poolObj[n];
        if (object != null) {
            return object;
        }
        int n2 = this.poolIdx[n];
        if (n2 == 0) {
            return null;
        }
        byte by = this.buf[n2];
        switch (by) {
            case 1: {
                this.poolObj[n] = this.names.fromUtf(this.buf, n2 + 3, this.getChar(n2 + 1));
                break;
            }
            case 2: {
                throw this.badClassFile("unicode.str.not.supported", new Object[0]);
            }
            case 7: {
                this.poolObj[n] = this.readClassOrType(this.getChar(n2 + 1));
                break;
            }
            case 8: {
                this.poolObj[n] = this.readName(this.getChar(n2 + 1)).toString();
                break;
            }
            case 9: {
                Symbol.ClassSymbol classSymbol = this.readClassSymbol(this.getChar(n2 + 1));
                ClassFile.NameAndType nameAndType = (ClassFile.NameAndType)this.readPool(this.getChar(n2 + 3));
                this.poolObj[n] = new Symbol.VarSymbol(0L, nameAndType.name, nameAndType.type, classSymbol);
                break;
            }
            case 10: 
            case 11: {
                Symbol.ClassSymbol classSymbol = this.readClassSymbol(this.getChar(n2 + 1));
                ClassFile.NameAndType nameAndType = (ClassFile.NameAndType)this.readPool(this.getChar(n2 + 3));
                this.poolObj[n] = new Symbol.MethodSymbol(0L, nameAndType.name, nameAndType.type, classSymbol);
                break;
            }
            case 12: {
                this.poolObj[n] = new ClassFile.NameAndType(this.readName(this.getChar(n2 + 1)), this.readType(this.getChar(n2 + 3)));
                break;
            }
            case 3: {
                this.poolObj[n] = this.getInt(n2 + 1);
                break;
            }
            case 4: {
                this.poolObj[n] = new Float(this.getFloat(n2 + 1));
                break;
            }
            case 5: {
                this.poolObj[n] = new Long(this.getLong(n2 + 1));
                break;
            }
            case 6: {
                this.poolObj[n] = new Double(this.getDouble(n2 + 1));
                break;
            }
            default: {
                throw this.badClassFile("bad.const.pool.tag", Byte.toString(by));
            }
        }
        return this.poolObj[n];
    }

    Type readType(int n) {
        int n2 = this.poolIdx[n];
        return this.sigToType(this.buf, n2 + 3, this.getChar(n2 + 1));
    }

    Object readClassOrType(int n) {
        int n2 = this.poolIdx[n];
        char c = this.getChar(n2 + 1);
        int n3 = n2 + 3;
        assert (this.buf[n3] == 91 || this.buf[n3 + c - 1] != 59);
        return this.buf[n3] == 91 || this.buf[n3 + c - 1] == 59 ? this.sigToType(this.buf, n3, c) : this.enterClass(this.names.fromUtf(ClassReader.internalize(this.buf, n3, c)));
    }

    List<Type> readTypeParams(int n) {
        int n2 = this.poolIdx[n];
        return this.sigToTypeParams(this.buf, n2 + 3, this.getChar(n2 + 1));
    }

    Symbol.ClassSymbol readClassSymbol(int n) {
        return (Symbol.ClassSymbol)this.readPool(n);
    }

    Name readName(int n) {
        return (Name)this.readPool(n);
    }

    Type sigToType(Name name) {
        return name == null ? null : this.sigToType(name.table.names, name.index, name.len);
    }

    Type sigToType(byte[] byArray, int n, int n2) {
        this.signature = byArray;
        this.sigp = n;
        this.siglimit = n + n2;
        return this.sigToType();
    }

    Type sigToType() {
        switch ((char)this.signature[this.sigp]) {
            case 'T': {
                ++this.sigp;
                int n = this.sigp;
                while (this.signature[this.sigp] != 59) {
                    ++this.sigp;
                }
                ++this.sigp;
                return this.sigEnterPhase ? Type.noType : this.findTypeVar(this.names.fromUtf(this.signature, n, this.sigp - 1 - n));
            }
            case '+': {
                ++this.sigp;
                Type type = this.sigToType();
                return new Type.WildcardType(type, BoundKind.EXTENDS, this.syms.boundClass);
            }
            case '*': {
                ++this.sigp;
                return new Type.WildcardType(this.syms.objectType, BoundKind.UNBOUND, this.syms.boundClass);
            }
            case '-': {
                ++this.sigp;
                Type type = this.sigToType();
                return new Type.WildcardType(type, BoundKind.SUPER, this.syms.boundClass);
            }
            case 'B': {
                ++this.sigp;
                return this.syms.byteType;
            }
            case 'C': {
                ++this.sigp;
                return this.syms.charType;
            }
            case 'D': {
                ++this.sigp;
                return this.syms.doubleType;
            }
            case 'F': {
                ++this.sigp;
                return this.syms.floatType;
            }
            case 'I': {
                ++this.sigp;
                return this.syms.intType;
            }
            case 'J': {
                ++this.sigp;
                return this.syms.longType;
            }
            case 'L': {
                Type type = this.classSigToType();
                if (this.sigp < this.siglimit && this.signature[this.sigp] == 46) {
                    throw this.badClassFile("deprecated inner class signature syntax (please recompile from source)", new Object[0]);
                }
                return type;
            }
            case 'S': {
                ++this.sigp;
                return this.syms.shortType;
            }
            case 'V': {
                ++this.sigp;
                return this.syms.voidType;
            }
            case 'Z': {
                ++this.sigp;
                return this.syms.booleanType;
            }
            case '[': {
                ++this.sigp;
                return new Type.ArrayType(this.sigToType(), (Symbol.TypeSymbol)this.syms.arrayClass);
            }
            case '(': {
                ++this.sigp;
                List<Type> list = this.sigToTypes(')');
                Type type = this.sigToType();
                List<Type> list2 = List.nil();
                while (this.signature[this.sigp] == 94) {
                    ++this.sigp;
                    list2 = list2.prepend(this.sigToType());
                }
                return new Type.MethodType(list, type, list2.reverse(), this.syms.methodClass);
            }
            case '<': {
                this.typevars = this.typevars.dup(this.currentOwner);
                Type.ForAll forAll = new Type.ForAll(this.sigToTypeParams(), this.sigToType());
                this.typevars = this.typevars.leave();
                return forAll;
            }
        }
        throw this.badClassFile("bad.signature", Convert.utf2string(this.signature, this.sigp, 10));
    }

    Type classSigToType() {
        if (this.signature[this.sigp] != 76) {
            throw this.badClassFile("bad.class.signature", Convert.utf2string(this.signature, this.sigp, 10));
        }
        ++this.sigp;
        Type type = Type.noType;
        int n = this.sbp;
        block10: while (true) {
            byte by = this.signature[this.sigp++];
            switch (by) {
                case 59: {
                    Symbol.ClassSymbol classSymbol = this.enterClass(this.names.fromUtf(this.signatureBuffer, n, this.sbp - n));
                    type = type == Type.noType ? classSymbol.erasure(this.types) : new Type.ClassType(type, List.<Type>nil(), classSymbol);
                    this.sbp = n;
                    return type;
                }
                case 60: {
                    Symbol.ClassSymbol classSymbol = this.enterClass(this.names.fromUtf(this.signatureBuffer, n, this.sbp - n));
                    type = new Type.ClassType(type, this.sigToTypes('>'), classSymbol){
                        boolean completed;
                        {
                            this.completed = false;
                        }

                        public Type getEnclosingType() {
                            if (!this.completed) {
                                this.completed = true;
                                this.tsym.complete();
                                Type type = this.tsym.type.getEnclosingType();
                                if (type != Type.noType) {
                                    List<Type> list = super.getEnclosingType().allparams();
                                    List<Type> list2 = type.allparams();
                                    if (list2.length() != list.length()) {
                                        super.setEnclosingType(ClassReader.this.types.erasure(type));
                                    } else {
                                        super.setEnclosingType(ClassReader.this.types.subst(type, list2, list));
                                    }
                                } else {
                                    super.setEnclosingType(Type.noType);
                                }
                            }
                            return super.getEnclosingType();
                        }

                        public void setEnclosingType(Type type) {
                            throw new UnsupportedOperationException();
                        }
                    };
                    switch (this.signature[this.sigp++]) {
                        case 59: {
                            if (this.sigp < this.signature.length && this.signature[this.sigp] == 46) {
                                this.sigp += this.sbp - n + 3;
                                this.signatureBuffer[this.sbp++] = 36;
                                continue block10;
                            }
                            this.sbp = n;
                            return type;
                        }
                        case 46: {
                            this.signatureBuffer[this.sbp++] = 36;
                            continue block10;
                        }
                    }
                    throw new AssertionError(this.signature[this.sigp - 1]);
                }
                case 46: {
                    this.signatureBuffer[this.sbp++] = 36;
                    continue block10;
                }
                case 47: {
                    this.signatureBuffer[this.sbp++] = 46;
                    continue block10;
                }
            }
            this.signatureBuffer[this.sbp++] = by;
        }
    }

    List<Type> sigToTypes(char c) {
        List<Object> list;
        List<Object> list2 = list = List.of(null);
        while (this.signature[this.sigp] != c) {
            list2 = list2.setTail(List.of(this.sigToType()));
        }
        ++this.sigp;
        return list.tail;
    }

    List<Type> sigToTypeParams(Name name) {
        return this.sigToTypeParams(name.table.names, name.index, name.len);
    }

    List<Type> sigToTypeParams(byte[] byArray, int n, int n2) {
        this.signature = byArray;
        this.sigp = n;
        this.siglimit = n + n2;
        return this.sigToTypeParams();
    }

    List<Type> sigToTypeParams() {
        List<Type> list = List.nil();
        if (this.signature[this.sigp] == 60) {
            ++this.sigp;
            int n = this.sigp;
            this.sigEnterPhase = true;
            while (this.signature[this.sigp] != 62) {
                list = list.prepend(this.sigToTypeParam());
            }
            this.sigEnterPhase = false;
            this.sigp = n;
            while (this.signature[this.sigp] != 62) {
                this.sigToTypeParam();
            }
            ++this.sigp;
        }
        return list.reverse();
    }

    Type sigToTypeParam() {
        Type.TypeVar typeVar;
        int n = this.sigp;
        while (this.signature[this.sigp] != 58) {
            ++this.sigp;
        }
        Name name = this.names.fromUtf(this.signature, n, this.sigp - n);
        if (this.sigEnterPhase) {
            typeVar = new Type.TypeVar(name, this.currentOwner, this.syms.botType);
            this.typevars.enter(typeVar.tsym);
        } else {
            typeVar = (Type.TypeVar)this.findTypeVar(name);
        }
        List<Type> list = List.nil();
        Type type = null;
        if (this.signature[this.sigp] == 58 && this.signature[this.sigp + 1] == 58) {
            ++this.sigp;
            type = this.syms.objectType;
        }
        while (this.signature[this.sigp] == 58) {
            ++this.sigp;
            list = list.prepend(this.sigToType());
        }
        if (!this.sigEnterPhase) {
            this.types.setBounds(typeVar, list.reverse(), type);
        }
        return typeVar;
    }

    Type findTypeVar(Name name) {
        Scope.Entry entry = this.typevars.lookup(name);
        if (entry.scope != null) {
            return entry.sym.type;
        }
        if (this.readingClassAttr) {
            Type.TypeVar typeVar = new Type.TypeVar(name, this.currentOwner, this.syms.botType);
            this.missingTypeVariables = this.missingTypeVariables.prepend(typeVar);
            return typeVar;
        }
        throw this.badClassFile("undecl.type.var", name);
    }

    void unrecognized(Name name) {
        if (this.checkClassFile) {
            this.printCCF("ccf.unrecognized.attribute", name);
        }
    }

    void readMemberAttr(Symbol symbol, Name name, int n) {
        if (name == this.names.ConstantValue) {
            Object object = this.readPool(this.nextChar());
            if ((symbol.flags() & 0x10L) != 0L) {
                ((Symbol.VarSymbol)symbol).setData(object);
            }
        } else if (name == this.names.Code) {
            if (this.readAllOfClassFile || this.saveParameterNames) {
                ((Symbol.MethodSymbol)symbol).code = this.readCode(symbol);
            } else {
                this.bp += n;
            }
        } else if (name == this.names.Exceptions) {
            int n2 = this.nextChar();
            List<Object> list = List.nil();
            for (int i = 0; i < n2; ++i) {
                list = list.prepend(this.readClassSymbol((int)this.nextChar()).type);
            }
            if (symbol.type.getThrownTypes().isEmpty()) {
                symbol.type.asMethodType().thrown = list.reverse();
            }
        } else if (name == this.names.Synthetic) {
            if (this.allowGenerics || (symbol.flags_field & 0x80000000L) == 0L) {
                symbol.flags_field |= 0x1000L;
            }
        } else if (name == this.names.Bridge) {
            symbol.flags_field |= 0x80000000L;
            if (!this.allowGenerics) {
                symbol.flags_field &= 0xFFFFFFFFFFFFEFFFL;
            }
        } else if (name == this.names.Deprecated) {
            symbol.flags_field |= 0x20000L;
        } else if (name == this.names.Varargs) {
            if (this.allowVarargs) {
                symbol.flags_field |= 0x400000000L;
            }
        } else if (name == this.names.Annotation) {
            if (this.allowAnnotations) {
                symbol.flags_field |= 0x2000L;
            }
        } else if (name == this.names.Enum) {
            symbol.flags_field |= 0x4000L;
        } else if (this.allowGenerics && name == this.names.Signature) {
            List<Type> list = symbol.type.getThrownTypes();
            symbol.type = this.readType(this.nextChar());
            if (symbol.kind == 16 && symbol.type.getThrownTypes().isEmpty()) {
                symbol.type.asMethodType().thrown = list;
            }
        } else if (name == this.names.RuntimeVisibleAnnotations) {
            this.attachAnnotations(symbol);
        } else if (name == this.names.RuntimeInvisibleAnnotations) {
            this.attachAnnotations(symbol);
        } else if (name == this.names.RuntimeVisibleParameterAnnotations) {
            this.attachParameterAnnotations(symbol);
        } else if (name == this.names.RuntimeInvisibleParameterAnnotations) {
            this.attachParameterAnnotations(symbol);
        } else if (name == this.names.LocalVariableTable) {
            int n3 = this.bp + n;
            if (this.saveParameterNames) {
                List<Name> list = List.nil();
                int n4 = (symbol.flags() & 8L) == 0L ? 1 : 0;
                int n5 = n4 + Code.width(symbol.type.getParameterTypes());
                int n6 = this.nextChar();
                block1: for (int i = 0; i < n6; ++i) {
                    char c = this.nextChar();
                    char c2 = this.nextChar();
                    char c3 = this.nextChar();
                    char c4 = this.nextChar();
                    int n7 = this.nextChar();
                    if (c != '\u0000' || n4 > n7 || n7 >= n5) continue;
                    int n8 = n4;
                    for (Type type : symbol.type.getParameterTypes()) {
                        if (n8 == n7) {
                            list = list.prepend(this.readName(c3));
                            continue block1;
                        }
                        n8 += Code.width(type);
                    }
                }
                list = list.reverse();
                ((Symbol.MethodSymbol)symbol).savedParameterNames = list;
            }
            this.bp = n3;
        } else if (name == this.names.AnnotationDefault) {
            this.attachAnnotationDefault(symbol);
        } else if (name == this.names.EnclosingMethod) {
            int n9 = this.bp + n;
            this.readEnclosingMethodAttr(symbol);
            this.bp = n9;
        } else {
            this.unrecognized(name);
            this.bp += n;
        }
    }

    void readEnclosingMethodAttr(Symbol symbol) {
        symbol.owner.members().remove(symbol);
        Symbol.ClassSymbol classSymbol = (Symbol.ClassSymbol)symbol;
        Symbol.ClassSymbol classSymbol2 = this.readClassSymbol(this.nextChar());
        ClassFile.NameAndType nameAndType = (ClassFile.NameAndType)this.readPool(this.nextChar());
        Symbol.MethodSymbol methodSymbol = this.findMethod(nameAndType, classSymbol2.members_field, classSymbol.flags());
        if (nameAndType != null && methodSymbol == null) {
            throw this.badClassFile("bad.enclosing.method", classSymbol);
        }
        classSymbol.name = this.simpleBinaryName(classSymbol.flatname, classSymbol2.flatname);
        classSymbol.owner = methodSymbol != null ? methodSymbol : classSymbol2;
        classSymbol.fullname = classSymbol.name.len == 0 ? null : Symbol.ClassSymbol.formFullName(classSymbol.name, classSymbol.owner);
        if (methodSymbol != null) {
            ((Type.ClassType)symbol.type).setEnclosingType(methodSymbol.type);
        } else if ((classSymbol.flags_field & 8L) == 0L) {
            ((Type.ClassType)symbol.type).setEnclosingType(classSymbol2.type);
        } else {
            ((Type.ClassType)symbol.type).setEnclosingType(Type.noType);
        }
        this.enterTypevars(classSymbol);
        if (!this.missingTypeVariables.isEmpty()) {
            ListBuffer<Type> listBuffer = new ListBuffer<Type>();
            for (Type type : this.missingTypeVariables) {
                listBuffer.append(this.findTypeVar(type.tsym.name));
            }
            this.foundTypeVariables = listBuffer.toList();
        } else {
            this.foundTypeVariables = List.nil();
        }
    }

    private Name simpleBinaryName(Name name, Name name2) {
        int n;
        String string = name.toString().substring(name2.toString().length());
        if (string.length() < 1 || string.charAt(0) != '$') {
            throw this.badClassFile("bad.enclosing.method", name);
        }
        for (n = 1; n < string.length() && ClassReader.isAsciiDigit(string.charAt(n)); ++n) {
        }
        return this.names.fromString(string.substring(n));
    }

    private Symbol.MethodSymbol findMethod(ClassFile.NameAndType nameAndType, Scope scope, long l) {
        if (nameAndType == null) {
            return null;
        }
        Type.MethodType methodType = nameAndType.type.asMethodType();
        Scope.Entry entry = scope.lookup(nameAndType.name);
        while (entry.scope != null) {
            if (entry.sym.kind == 16 && this.isSameBinaryType(entry.sym.type.asMethodType(), methodType)) {
                return (Symbol.MethodSymbol)entry.sym;
            }
            entry = entry.next();
        }
        if (nameAndType.name != this.names.init) {
            return null;
        }
        if ((l & 0x200L) != 0L) {
            return null;
        }
        if (nameAndType.type.getParameterTypes().isEmpty()) {
            return null;
        }
        nameAndType.type = new Type.MethodType(nameAndType.type.getParameterTypes().tail, nameAndType.type.getReturnType(), nameAndType.type.getThrownTypes(), this.syms.methodClass);
        return this.findMethod(nameAndType, scope, l);
    }

    private boolean isSameBinaryType(Type.MethodType methodType, Type.MethodType methodType2) {
        List<Type> list = this.types.erasure((List<Type>)methodType.getParameterTypes()).prepend(this.types.erasure(methodType.getReturnType()));
        List<Type> list2 = ((List)methodType2.getParameterTypes()).prepend(methodType2.getReturnType());
        while (!list.isEmpty() && !list2.isEmpty()) {
            if (((Type)list.head).tsym != ((Type)list2.head).tsym) {
                return false;
            }
            list = list.tail;
            list2 = list2.tail;
        }
        return list.isEmpty() && list2.isEmpty();
    }

    private static boolean isAsciiDigit(char c) {
        return '0' <= c && c <= '9';
    }

    void readMemberAttrs(Symbol symbol) {
        int n = this.nextChar();
        for (int i = 0; i < n; ++i) {
            Name name = this.readName(this.nextChar());
            int n2 = this.nextInt();
            this.readMemberAttr(symbol, name, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void readClassAttr(Symbol.ClassSymbol classSymbol, Name name, int n) {
        if (name == this.names.SourceFile) {
            Name name2 = this.readName(this.nextChar());
            classSymbol.sourcefile = new SourceFileObject(name2);
        } else if (name == this.names.InnerClasses) {
            this.readInnerClasses(classSymbol);
        } else if (this.allowGenerics && name == this.names.Signature) {
            this.readingClassAttr = true;
            try {
                Type.ClassType classType = (Type.ClassType)classSymbol.type;
                assert (classSymbol == this.currentOwner);
                classType.typarams_field = this.readTypeParams(this.nextChar());
                classType.supertype_field = this.sigToType();
                ListBuffer<Type> listBuffer = new ListBuffer<Type>();
                while (this.sigp != this.siglimit) {
                    listBuffer.append(this.sigToType());
                }
                classType.interfaces_field = listBuffer.toList();
                Object var7_7 = null;
                this.readingClassAttr = false;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                this.readingClassAttr = false;
                throw throwable;
            }
        } else {
            this.readMemberAttr(classSymbol, name, n);
        }
    }

    void readClassAttrs(Symbol.ClassSymbol classSymbol) {
        int n = this.nextChar();
        for (int i = 0; i < n; ++i) {
            Name name = this.readName(this.nextChar());
            int n2 = this.nextInt();
            this.readClassAttr(classSymbol, name, n2);
        }
    }

    Code readCode(Symbol symbol) {
        this.nextChar();
        this.nextChar();
        int n = this.nextInt();
        this.bp += n;
        char c = this.nextChar();
        this.bp += c * 8;
        this.readMemberAttrs(symbol);
        return null;
    }

    void attachAnnotations(Symbol symbol) {
        int n = this.nextChar();
        if (n != 0) {
            ListBuffer<CompoundAnnotationProxy> listBuffer = new ListBuffer<CompoundAnnotationProxy>();
            for (int i = 0; i < n; ++i) {
                CompoundAnnotationProxy compoundAnnotationProxy = this.readCompoundAnnotation();
                if (compoundAnnotationProxy.type.tsym == this.syms.proprietaryType.tsym) {
                    symbol.flags_field |= 0x4000000000L;
                    continue;
                }
                listBuffer.append(compoundAnnotationProxy);
            }
            this.annotate.later(new AnnotationCompleter(symbol, listBuffer.toList()));
        }
    }

    void attachParameterAnnotations(Symbol symbol) {
        Symbol.MethodSymbol methodSymbol = (Symbol.MethodSymbol)symbol;
        int n = this.buf[this.bp++] & 0xFF;
        List<Symbol.VarSymbol> list = methodSymbol.params();
        int n2 = 0;
        while (list.tail != null) {
            this.attachAnnotations((Symbol)list.head);
            list = list.tail;
            ++n2;
        }
        if (n2 != n) {
            throw this.badClassFile("bad.runtime.invisible.param.annotations", methodSymbol);
        }
    }

    void attachAnnotationDefault(Symbol symbol) {
        Symbol.MethodSymbol methodSymbol = (Symbol.MethodSymbol)symbol;
        Attribute attribute = this.readAttributeValue();
        this.annotate.later(new AnnotationDefaultCompleter(methodSymbol, attribute));
    }

    Type readTypeOrClassSymbol(int n) {
        if (this.buf[this.poolIdx[n]] == 7) {
            return this.readClassSymbol((int)n).type;
        }
        return this.readType(n);
    }

    Type readEnumType(int n) {
        int n2 = this.poolIdx[n];
        char c = this.getChar(n2 + 1);
        if (this.buf[n2 + c + 2] != 59) {
            return this.enterClass((Name)this.readName((int)n)).type;
        }
        return this.readType(n);
    }

    CompoundAnnotationProxy readCompoundAnnotation() {
        Type type = this.readTypeOrClassSymbol(this.nextChar());
        int n = this.nextChar();
        ListBuffer<Pair<Name, Attribute>> listBuffer = new ListBuffer<Pair<Name, Attribute>>();
        for (int i = 0; i < n; ++i) {
            Name name = this.readName(this.nextChar());
            Attribute attribute = this.readAttributeValue();
            listBuffer.append(new Pair<Name, Attribute>(name, attribute));
        }
        return new CompoundAnnotationProxy(type, listBuffer.toList());
    }

    Attribute readAttributeValue() {
        char c = (char)this.buf[this.bp++];
        switch (c) {
            case 'B': {
                return new Attribute.Constant(this.syms.byteType, this.readPool(this.nextChar()));
            }
            case 'C': {
                return new Attribute.Constant(this.syms.charType, this.readPool(this.nextChar()));
            }
            case 'D': {
                return new Attribute.Constant(this.syms.doubleType, this.readPool(this.nextChar()));
            }
            case 'F': {
                return new Attribute.Constant(this.syms.floatType, this.readPool(this.nextChar()));
            }
            case 'I': {
                return new Attribute.Constant(this.syms.intType, this.readPool(this.nextChar()));
            }
            case 'J': {
                return new Attribute.Constant(this.syms.longType, this.readPool(this.nextChar()));
            }
            case 'S': {
                return new Attribute.Constant(this.syms.shortType, this.readPool(this.nextChar()));
            }
            case 'Z': {
                return new Attribute.Constant(this.syms.booleanType, this.readPool(this.nextChar()));
            }
            case 's': {
                return new Attribute.Constant(this.syms.stringType, this.readPool(this.nextChar()).toString());
            }
            case 'e': {
                return new EnumAttributeProxy(this.readEnumType(this.nextChar()), this.readName(this.nextChar()));
            }
            case 'c': {
                return new Attribute.Class(this.types, this.readTypeOrClassSymbol(this.nextChar()));
            }
            case '[': {
                int n = this.nextChar();
                ListBuffer<Attribute> listBuffer = new ListBuffer<Attribute>();
                for (int i = 0; i < n; ++i) {
                    listBuffer.append(this.readAttributeValue());
                }
                return new ArrayAttributeProxy(listBuffer.toList());
            }
            case '@': {
                return this.readCompoundAnnotation();
            }
        }
        throw new AssertionError((Object)("unknown annotation tag '" + c + "'"));
    }

    Symbol.VarSymbol readField() {
        long l = this.adjustFieldFlags(this.nextChar());
        Name name = this.readName(this.nextChar());
        Type type = this.readType(this.nextChar());
        Symbol.VarSymbol varSymbol = new Symbol.VarSymbol(l, name, type, this.currentOwner);
        this.readMemberAttrs(varSymbol);
        return varSymbol;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Symbol.MethodSymbol readMethod() {
        long l = this.adjustMethodFlags(this.nextChar());
        Name name = this.readName(this.nextChar());
        Type type = this.readType(this.nextChar());
        if (name == this.names.init && this.currentOwner.hasOuterInstance() && this.currentOwner.name.len != 0) {
            type = new Type.MethodType(type.getParameterTypes().tail, type.getReturnType(), type.getThrownTypes(), this.syms.methodClass);
        }
        Symbol.MethodSymbol methodSymbol = new Symbol.MethodSymbol(l, name, type, this.currentOwner);
        Symbol symbol = this.currentOwner;
        this.currentOwner = methodSymbol;
        try {
            this.readMemberAttrs(methodSymbol);
            Object var8_6 = null;
            this.currentOwner = symbol;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            this.currentOwner = symbol;
            throw throwable;
        }
        return methodSymbol;
    }

    void skipMember() {
        this.bp += 6;
        int n = this.nextChar();
        for (int i = 0; i < n; ++i) {
            this.bp += 2;
            int n2 = this.nextInt();
            this.bp += n2;
        }
    }

    protected void enterTypevars(Type type) {
        if (type.getEnclosingType() != null && type.getEnclosingType().tag == 10) {
            this.enterTypevars(type.getEnclosingType());
        }
        List<Type> list = type.getTypeArguments();
        while (list.nonEmpty()) {
            this.typevars.enter(((Type)list.head).tsym);
            list = list.tail;
        }
    }

    protected void enterTypevars(Symbol symbol) {
        if (symbol.owner.kind == 16) {
            this.enterTypevars(symbol.owner);
            this.enterTypevars(symbol.owner.owner);
        }
        this.enterTypevars(symbol.type);
    }

    void readClass(Symbol.ClassSymbol classSymbol) {
        int n;
        int n2;
        int n3;
        Symbol.ClassSymbol classSymbol2;
        Type.ClassType classType = (Type.ClassType)classSymbol.type;
        classSymbol.members_field = new Scope(classSymbol);
        this.typevars = this.typevars.dup(this.currentOwner);
        if (classType.getEnclosingType().tag == 10) {
            this.enterTypevars(classType.getEnclosingType());
        }
        long l = this.adjustClassFlags(this.nextChar());
        if (classSymbol.owner.kind == 1) {
            classSymbol.flags_field = l;
        }
        if (classSymbol != (classSymbol2 = this.readClassSymbol(this.nextChar()))) {
            throw this.badClassFile("class.file.wrong.class", classSymbol2.flatname);
        }
        int n4 = this.bp;
        this.nextChar();
        char c = this.nextChar();
        this.bp += c * 2;
        int n5 = this.nextChar();
        for (n3 = 0; n3 < n5; ++n3) {
            this.skipMember();
        }
        n3 = this.nextChar();
        for (n2 = 0; n2 < n3; ++n2) {
            this.skipMember();
        }
        this.readClassAttrs(classSymbol);
        if (this.readAllOfClassFile) {
            for (n2 = 1; n2 < this.poolObj.length; ++n2) {
                this.readPool(n2);
            }
            classSymbol.pool = new Pool(this.poolObj.length, this.poolObj);
        }
        this.bp = n4;
        n2 = this.nextChar();
        if (classType.supertype_field == null) {
            classType.supertype_field = n2 == 0 ? Type.noType : this.readClassSymbol(n2).erasure(this.types);
        }
        n2 = this.nextChar();
        List<Type> list = List.nil();
        for (n = 0; n < n2; ++n) {
            Type type = this.readClassSymbol(this.nextChar()).erasure(this.types);
            list = list.prepend(type);
        }
        if (classType.interfaces_field == null) {
            classType.interfaces_field = list.reverse();
        }
        if (n5 != this.nextChar()) assert (false);
        for (n = 0; n < n5; ++n) {
            this.enterMember(classSymbol, this.readField());
        }
        if (n3 != this.nextChar()) assert (false);
        for (n = 0; n < n3; ++n) {
            this.enterMember(classSymbol, this.readMethod());
        }
        this.typevars = this.typevars.leave();
    }

    void readInnerClasses(Symbol.ClassSymbol classSymbol) {
        int n = this.nextChar();
        for (int i = 0; i < n; ++i) {
            this.nextChar();
            Symbol.ClassSymbol classSymbol2 = this.readClassSymbol(this.nextChar());
            Name name = this.readName(this.nextChar());
            if (name == null) {
                name = this.names.empty;
            }
            long l = this.adjustClassFlags(this.nextChar());
            if (classSymbol2 == null) continue;
            if (name == this.names.empty) {
                name = this.names.one;
            }
            Symbol.ClassSymbol classSymbol3 = this.enterClass(name, classSymbol2);
            if ((l & 8L) == 0L) {
                ((Type.ClassType)classSymbol3.type).setEnclosingType(classSymbol2.type);
                if (classSymbol3.erasure_field != null) {
                    ((Type.ClassType)classSymbol3.erasure_field).setEnclosingType(this.types.erasure(classSymbol2.type));
                }
            }
            if (classSymbol != classSymbol2) continue;
            classSymbol3.flags_field = l;
            this.enterMember(classSymbol, classSymbol3);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readClassFile(Symbol.ClassSymbol classSymbol) throws IOException {
        int n = this.nextInt();
        if (n != -889275714) {
            throw this.badClassFile("illegal.start.of.class.file", new Object[0]);
        }
        char c = this.nextChar();
        char c2 = this.nextChar();
        int n2 = Target.MAX().majorVersion;
        int n3 = Target.MAX().minorVersion;
        if (c2 > n2 || c2 * 1000 + c < Target.MIN().majorVersion * 1000 + Target.MIN().minorVersion) {
            if (c2 != n2 + 1) throw this.badClassFile("wrong.version", Integer.toString(c2), Integer.toString(c), Integer.toString(n2), Integer.toString(n3));
            this.log.warning("big.major.version", this.currentClassFile, (int)c2, n2);
        } else if (this.checkClassFile && c2 == n2 && c > n3) {
            this.printCCF("found.later.version", Integer.toString(c));
        }
        this.indexPool();
        if (this.signatureBuffer.length < this.bp) {
            int n4 = Integer.highestOneBit(this.bp) << 1;
            this.signatureBuffer = new byte[n4];
        }
        this.readClass(classSymbol);
    }

    long adjustFieldFlags(long l) {
        return l;
    }

    long adjustMethodFlags(long l) {
        if ((l & 0x40L) != 0L) {
            l &= 0xFFFFFFFFFFFFFFBFL;
            l |= 0x80000000L;
            if (!this.allowGenerics) {
                l &= 0xFFFFFFFFFFFFEFFFL;
            }
        }
        if ((l & 0x80L) != 0L) {
            l &= 0xFFFFFFFFFFFFFF7FL;
            l |= 0x400000000L;
        }
        return l;
    }

    long adjustClassFlags(long l) {
        return l & 0xFFFFFFFFFFFFFFDFL;
    }

    public Symbol.ClassSymbol defineClass(Name name, Symbol symbol) {
        Symbol.ClassSymbol classSymbol = new Symbol.ClassSymbol(0L, name, symbol);
        if (symbol.kind == 1) assert (this.classes.get(classSymbol.flatname) == null) : classSymbol;
        classSymbol.completer = this;
        return classSymbol;
    }

    public Symbol.ClassSymbol enterClass(Name name, Symbol.TypeSymbol typeSymbol) {
        Name name2 = Symbol.TypeSymbol.formFlatName(name, typeSymbol);
        Symbol.ClassSymbol classSymbol = this.classes.get(name2);
        if (classSymbol == null) {
            classSymbol = this.defineClass(name, typeSymbol);
            this.classes.put(name2, classSymbol);
        } else if ((classSymbol.name != name || classSymbol.owner != typeSymbol) && typeSymbol.kind == 2 && classSymbol.owner.kind == 1) {
            classSymbol.owner.members().remove(classSymbol);
            classSymbol.name = name;
            classSymbol.owner = typeSymbol;
            classSymbol.fullname = Symbol.ClassSymbol.formFullName(name, typeSymbol);
        }
        return classSymbol;
    }

    public Symbol.ClassSymbol enterClass(Name name, JavaFileObject javaFileObject) {
        Symbol.ClassSymbol classSymbol = this.classes.get(name);
        if (classSymbol != null) {
            String string = Log.format("%s: completer = %s; class file = %s; source file = %s", classSymbol.fullname, classSymbol.completer, classSymbol.classfile, classSymbol.sourcefile);
            throw new AssertionError((Object)string);
        }
        Name name2 = Convert.packagePart(name);
        Symbol.PackageSymbol packageSymbol = name2.isEmpty() ? this.syms.unnamedPackage : this.enterPackage(name2);
        classSymbol = this.defineClass(Convert.shortName(name), packageSymbol);
        classSymbol.classfile = javaFileObject;
        this.classes.put(name, classSymbol);
        return classSymbol;
    }

    public Symbol.ClassSymbol enterClass(Name name) {
        Symbol.ClassSymbol classSymbol = this.classes.get(name);
        if (classSymbol == null) {
            return this.enterClass(name, (JavaFileObject)null);
        }
        return classSymbol;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void complete(Symbol symbol) throws Symbol.CompletionFailure {
        if (symbol.kind == 2) {
            Symbol.ClassSymbol classSymbol = (Symbol.ClassSymbol)symbol;
            classSymbol.members_field = new Scope.ErrorScope(classSymbol);
            boolean bl = this.suppressFlush;
            this.suppressFlush = true;
            try {
                this.completeOwners(classSymbol.owner);
                this.completeEnclosing(classSymbol);
                Object var5_6 = null;
                this.suppressFlush = bl;
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                this.suppressFlush = bl;
                throw throwable;
            }
            this.fillIn(classSymbol);
        } else if (symbol.kind == 1) {
            Symbol.PackageSymbol packageSymbol = (Symbol.PackageSymbol)symbol;
            try {
                this.fillIn(packageSymbol);
            }
            catch (IOException iOException) {
                throw new Symbol.CompletionFailure(symbol, iOException.getLocalizedMessage()).initCause(iOException);
            }
        }
        if (!this.filling && !this.suppressFlush) {
            this.annotate.flush();
        }
    }

    private void completeOwners(Symbol symbol) {
        if (symbol.kind != 1) {
            this.completeOwners(symbol.owner);
        }
        symbol.complete();
    }

    private void completeEnclosing(Symbol.ClassSymbol classSymbol) {
        if (classSymbol.owner.kind == 1) {
            Symbol symbol = classSymbol.owner;
            for (Name name : Convert.enclosingCandidates(Convert.shortName(classSymbol.name))) {
                Symbol symbol2 = symbol.members().lookup((Name)name).sym;
                if (symbol2 == null) {
                    symbol2 = this.classes.get(Symbol.TypeSymbol.formFlatName(name, symbol));
                }
                if (symbol2 == null) continue;
                symbol2.complete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillIn(Symbol.ClassSymbol classSymbol) {
        if (this.completionFailureName == classSymbol.fullname) {
            throw new Symbol.CompletionFailure(classSymbol, "user-selected completion failure by class name");
        }
        this.currentOwner = classSymbol;
        JavaFileObject javaFileObject = classSymbol.classfile;
        if (javaFileObject != null) {
            JavaFileObject javaFileObject2 = this.currentClassFile;
            try {
                try {
                    block16: {
                        assert (!this.filling) : "Filling " + javaFileObject.toUri() + " during " + javaFileObject2;
                        this.currentClassFile = javaFileObject;
                        if (this.verbose) {
                            this.printVerbose("loading", this.currentClassFile.toString());
                        }
                        if (javaFileObject.getKind() == JavaFileObject.Kind.CLASS) {
                            this.filling = true;
                            try {
                                this.bp = 0;
                                this.buf = ClassReader.readInputStream(this.buf, javaFileObject.openInputStream());
                                this.readClassFile(classSymbol);
                                if (!this.missingTypeVariables.isEmpty() && !this.foundTypeVariables.isEmpty()) {
                                    List<Type> list = this.missingTypeVariables;
                                    List<Type> list2 = this.foundTypeVariables;
                                    this.missingTypeVariables = List.nil();
                                    this.foundTypeVariables = List.nil();
                                    this.filling = false;
                                    Type.ClassType classType = (Type.ClassType)this.currentOwner.type;
                                    classType.supertype_field = this.types.subst(classType.supertype_field, list, list2);
                                    classType.interfaces_field = this.types.subst(classType.interfaces_field, list, list2);
                                } else if (this.missingTypeVariables.isEmpty() != this.foundTypeVariables.isEmpty()) {
                                    Name name = ((Type)this.missingTypeVariables.head).tsym.name;
                                    throw this.badClassFile("undecl.type.var", name);
                                }
                                Object var8_9 = null;
                            }
                            catch (Throwable throwable) {
                                Object var8_10 = null;
                                this.missingTypeVariables = List.nil();
                                this.foundTypeVariables = List.nil();
                                this.filling = false;
                                throw throwable;
                            }
                            this.missingTypeVariables = List.nil();
                            this.foundTypeVariables = List.nil();
                            this.filling = false;
                            {
                                break block16;
                            }
                        }
                        if (this.sourceCompleter != null) {
                            this.sourceCompleter.complete(classSymbol);
                        } else {
                            throw new IllegalStateException("Source completer required to read " + javaFileObject.toUri());
                        }
                    }
                    Object var10_12 = null;
                    this.currentClassFile = javaFileObject2;
                    return;
                }
                catch (IOException iOException) {
                    throw this.badClassFile("unable.to.access.file", iOException.getMessage());
                }
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                this.currentClassFile = javaFileObject2;
                throw throwable;
            }
        }
        throw this.newCompletionFailure(classSymbol, Log.getLocalizedString("class.file.not.found", classSymbol.flatname));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] readInputStream(byte[] byArray, InputStream inputStream) throws IOException {
        byte[] byArray2;
        try {
            byArray = ClassReader.ensureCapacity(byArray, inputStream.available());
            int n = inputStream.read(byArray);
            int n2 = 0;
            while (n != -1) {
                byArray = ClassReader.ensureCapacity(byArray, n2 += n);
                n = inputStream.read(byArray, n2, byArray.length - n2);
            }
            byArray2 = byArray;
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return byArray2;
    }

    private static byte[] ensureCapacity(byte[] byArray, int n) {
        if (byArray.length < n) {
            byte[] byArray2 = byArray;
            byArray = new byte[Integer.highestOneBit(n) << 1];
            System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
        }
        return byArray;
    }

    private Symbol.CompletionFailure newCompletionFailure(Symbol.ClassSymbol classSymbol, String string) {
        if (!this.cacheCompletionFailure) {
            return new Symbol.CompletionFailure(classSymbol, string);
        }
        Symbol.CompletionFailure completionFailure = this.cachedCompletionFailure;
        completionFailure.sym = classSymbol;
        completionFailure.errmsg = string;
        return completionFailure;
    }

    public Symbol.ClassSymbol loadClass(Name name) throws Symbol.CompletionFailure {
        boolean bl = this.classes.get(name) == null;
        Symbol.ClassSymbol classSymbol = this.enterClass(name);
        if (classSymbol.members_field == null && classSymbol.completer != null) {
            try {
                classSymbol.complete();
            }
            catch (Symbol.CompletionFailure completionFailure) {
                if (bl) {
                    this.classes.remove(name);
                }
                throw completionFailure;
            }
        }
        return classSymbol;
    }

    public boolean packageExists(Name name) {
        return this.enterPackage(name).exists();
    }

    public Symbol.PackageSymbol enterPackage(Name name) {
        Symbol.PackageSymbol packageSymbol = this.packages.get(name);
        if (packageSymbol == null) {
            assert (!name.isEmpty()) : "rootPackage missing!";
            packageSymbol = new Symbol.PackageSymbol(Convert.shortName(name), this.enterPackage(Convert.packagePart(name)));
            packageSymbol.completer = this;
            this.packages.put(name, packageSymbol);
        }
        return packageSymbol;
    }

    public Symbol.PackageSymbol enterPackage(Name name, Symbol.PackageSymbol packageSymbol) {
        return this.enterPackage(Symbol.TypeSymbol.formFullName(name, packageSymbol));
    }

    protected void includeClassFile(Symbol.PackageSymbol packageSymbol, JavaFileObject javaFileObject) {
        Symbol.ClassSymbol classSymbol;
        Object object;
        if ((packageSymbol.flags_field & 0x800000L) == 0L) {
            object = packageSymbol;
            while (object != null && object.kind == 1) {
                object.flags_field |= 0x800000L;
                object = object.owner;
            }
        }
        int n = (object = javaFileObject.getKind()) == JavaFileObject.Kind.CLASS ? 0x2000000 : 0x4000000;
        String string = this.fileManager.inferBinaryName(this.currentLoc, javaFileObject);
        int n2 = string.lastIndexOf(".");
        Name name = this.names.fromString(string.substring(n2 + 1));
        boolean bl = name == this.names.package_info;
        Symbol.ClassSymbol classSymbol2 = classSymbol = bl ? packageSymbol.package_info : (Symbol.ClassSymbol)packageSymbol.members_field.lookup((Name)name).sym;
        if (classSymbol == null) {
            classSymbol = this.enterClass(name, packageSymbol);
            if (classSymbol.classfile == null) {
                classSymbol.classfile = javaFileObject;
            }
            if (bl) {
                packageSymbol.package_info = classSymbol;
            } else if (classSymbol.owner == packageSymbol) {
                packageSymbol.members_field.enter(classSymbol);
            }
        } else if (classSymbol.classfile != null && (classSymbol.flags_field & (long)n) == 0L && (classSymbol.flags_field & 0x6000000L) != 0L) {
            classSymbol.classfile = this.preferredFileObject(javaFileObject, classSymbol.classfile);
        }
        classSymbol.flags_field |= (long)n;
    }

    protected JavaFileObject preferredFileObject(JavaFileObject javaFileObject, JavaFileObject javaFileObject2) {
        long l;
        if (this.preferSource) {
            return javaFileObject.getKind() == JavaFileObject.Kind.SOURCE ? javaFileObject : javaFileObject2;
        }
        long l2 = javaFileObject.getLastModified();
        return l2 > (l = javaFileObject2.getLastModified()) ? javaFileObject : javaFileObject2;
    }

    protected EnumSet<JavaFileObject.Kind> getPackageFileKinds() {
        return EnumSet.of(JavaFileObject.Kind.CLASS, JavaFileObject.Kind.SOURCE);
    }

    protected void extraFileActions(Symbol.PackageSymbol packageSymbol, JavaFileObject javaFileObject) {
    }

    private void fillIn(Symbol.PackageSymbol packageSymbol) throws IOException {
        if (packageSymbol.members_field == null) {
            packageSymbol.members_field = new Scope(packageSymbol);
        }
        String string = packageSymbol.fullname.toString();
        EnumSet<JavaFileObject.Kind> enumSet = this.getPackageFileKinds();
        this.fillIn(packageSymbol, StandardLocation.PLATFORM_CLASS_PATH, this.fileManager.list(StandardLocation.PLATFORM_CLASS_PATH, string, EnumSet.of(JavaFileObject.Kind.CLASS), false));
        EnumSet<JavaFileObject.Kind> enumSet2 = EnumSet.copyOf(enumSet);
        enumSet2.remove((Object)JavaFileObject.Kind.SOURCE);
        boolean bl = !enumSet2.isEmpty();
        EnumSet<JavaFileObject.Kind> enumSet3 = EnumSet.copyOf(enumSet);
        enumSet3.remove((Object)JavaFileObject.Kind.CLASS);
        boolean bl2 = !enumSet3.isEmpty();
        boolean bl3 = this.fileManager.hasLocation(StandardLocation.SOURCE_PATH);
        if (this.verbose && this.verbosePath && this.fileManager instanceof StandardJavaFileManager) {
            List<Object> list;
            StandardJavaFileManager standardJavaFileManager = (StandardJavaFileManager)this.fileManager;
            if (bl3 && bl2) {
                list = List.nil();
                for (File file : standardJavaFileManager.getLocation(StandardLocation.SOURCE_PATH)) {
                    list = list.prepend(file);
                }
                this.printVerbose("sourcepath", list.reverse().toString());
            } else if (bl2) {
                list = List.nil();
                for (File file : standardJavaFileManager.getLocation(StandardLocation.CLASS_PATH)) {
                    list = list.prepend(file);
                }
                this.printVerbose("sourcepath", list.reverse().toString());
            }
            if (bl) {
                list = List.nil();
                for (File file : standardJavaFileManager.getLocation(StandardLocation.PLATFORM_CLASS_PATH)) {
                    list = list.prepend(file);
                }
                for (File file : standardJavaFileManager.getLocation(StandardLocation.CLASS_PATH)) {
                    list = list.prepend(file);
                }
                this.printVerbose("classpath", list.reverse().toString());
            }
        }
        if (bl2 && !bl3) {
            this.fillIn(packageSymbol, StandardLocation.CLASS_PATH, this.fileManager.list(StandardLocation.CLASS_PATH, string, enumSet, false));
        } else {
            if (bl) {
                this.fillIn(packageSymbol, StandardLocation.CLASS_PATH, this.fileManager.list(StandardLocation.CLASS_PATH, string, enumSet2, false));
            }
            if (bl2) {
                this.fillIn(packageSymbol, StandardLocation.SOURCE_PATH, this.fileManager.list(StandardLocation.SOURCE_PATH, string, enumSet3, false));
            }
        }
        this.verbosePath = false;
    }

    private void fillIn(Symbol.PackageSymbol packageSymbol, JavaFileManager.Location location, Iterable<JavaFileObject> iterable) {
        this.currentLoc = location;
        block3: for (JavaFileObject javaFileObject : iterable) {
            switch (javaFileObject.getKind()) {
                case CLASS: 
                case SOURCE: {
                    String string = this.fileManager.inferBinaryName(this.currentLoc, javaFileObject);
                    String string2 = string.substring(string.lastIndexOf(".") + 1);
                    if (!SourceVersion.isIdentifier(string2) && !string2.equals("package-info")) continue block3;
                    this.includeClassFile(packageSymbol, javaFileObject);
                    continue block3;
                }
            }
            this.extraFileActions(packageSymbol, javaFileObject);
        }
    }

    private void printVerbose(String string, CharSequence charSequence) {
        Log.printLines(this.log.noticeWriter, Log.getLocalizedString("verbose." + string, charSequence));
    }

    private void printCCF(String string, Object object) {
        Log.printLines(this.log.noticeWriter, Log.getLocalizedString(string, object));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class AnnotationCompleter
    extends AnnotationDeproxy
    implements Annotate.Annotator {
        final Symbol sym;
        final List<CompoundAnnotationProxy> l;
        final JavaFileObject classFile;

        @Override
        public String toString() {
            return " ClassReader annotate " + this.sym.owner + "." + this.sym + " with " + this.l;
        }

        AnnotationCompleter(Symbol symbol, List<CompoundAnnotationProxy> list) {
            this.sym = symbol;
            this.l = list;
            this.classFile = ClassReader.this.currentClassFile;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void enterAnnotation() {
            JavaFileObject javaFileObject = ClassReader.this.currentClassFile;
            try {
                ClassReader.this.currentClassFile = this.classFile;
                List<Attribute.Compound> list = this.deproxyCompoundList(this.l);
                this.sym.attributes_field = this.sym.attributes_field == null ? list : list.prependList(this.sym.attributes_field);
                Object var4_3 = null;
                ClassReader.this.currentClassFile = javaFileObject;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                ClassReader.this.currentClassFile = javaFileObject;
                throw throwable;
            }
        }
    }

    class AnnotationDefaultCompleter
    extends AnnotationDeproxy
    implements Annotate.Annotator {
        final Symbol.MethodSymbol sym;
        final Attribute value;
        final JavaFileObject classFile;

        public String toString() {
            return " ClassReader store default for " + this.sym.owner + "." + this.sym + " is " + this.value;
        }

        AnnotationDefaultCompleter(Symbol.MethodSymbol methodSymbol, Attribute attribute) {
            this.classFile = ClassReader.this.currentClassFile;
            this.sym = methodSymbol;
            this.value = attribute;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void enterAnnotation() {
            JavaFileObject javaFileObject = ClassReader.this.currentClassFile;
            try {
                ClassReader.this.currentClassFile = this.classFile;
                this.sym.defaultValue = this.deproxy(this.sym.type.getReturnType(), this.value);
                Object var3_2 = null;
                ClassReader.this.currentClassFile = javaFileObject;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                ClassReader.this.currentClassFile = javaFileObject;
                throw throwable;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class AnnotationDeproxy
    implements ProxyVisitor {
        private Symbol.ClassSymbol requestingOwner;
        Attribute result;
        Type type;

        AnnotationDeproxy() {
            this.requestingOwner = ClassReader.this.currentOwner.kind == 16 ? ClassReader.this.currentOwner.enclClass() : (Symbol.ClassSymbol)ClassReader.this.currentOwner;
        }

        List<Attribute.Compound> deproxyCompoundList(List<CompoundAnnotationProxy> list) {
            ListBuffer<Attribute.Compound> listBuffer = new ListBuffer<Attribute.Compound>();
            List<CompoundAnnotationProxy> list2 = list;
            while (list2.nonEmpty()) {
                listBuffer.append(this.deproxyCompound((CompoundAnnotationProxy)list2.head));
                list2 = list2.tail;
            }
            return listBuffer.toList();
        }

        Attribute.Compound deproxyCompound(CompoundAnnotationProxy compoundAnnotationProxy) {
            ListBuffer<Pair<Symbol.MethodSymbol, Attribute>> listBuffer = new ListBuffer<Pair<Symbol.MethodSymbol, Attribute>>();
            List<Pair<Name, Attribute>> list = compoundAnnotationProxy.values;
            while (list.nonEmpty()) {
                Symbol.MethodSymbol methodSymbol = this.findAccessMethod(compoundAnnotationProxy.type, (Name)((Pair)list.head).fst);
                listBuffer.append(new Pair<Symbol.MethodSymbol, Attribute>(methodSymbol, this.deproxy(methodSymbol.type.getReturnType(), (Attribute)((Pair)list.head).snd)));
                list = list.tail;
            }
            return new Attribute.Compound(compoundAnnotationProxy.type, listBuffer.toList());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Symbol.MethodSymbol findAccessMethod(Type type, Name name) {
            AnnotatedConstruct annotatedConstruct;
            Object object;
            Symbol.CompletionFailure completionFailure = null;
            try {
                object = type.tsym.members().lookup(name);
                while (((Scope.Entry)object).scope != null) {
                    annotatedConstruct = ((Scope.Entry)object).sym;
                    if (annotatedConstruct.kind == 16 && annotatedConstruct.type.getParameterTypes().length() == 0) {
                        return (Symbol.MethodSymbol)annotatedConstruct;
                    }
                    object = ((Scope.Entry)object).next();
                }
            }
            catch (Symbol.CompletionFailure completionFailure2) {
                completionFailure = completionFailure2;
            }
            object = ClassReader.this.log.useSource(this.requestingOwner.classfile);
            try {
                if (completionFailure == null) {
                    ClassReader.this.log.warning("annotation.method.not.found", type, name);
                } else {
                    ClassReader.this.log.warning("annotation.method.not.found.reason", type, name, completionFailure.getMessage());
                }
                Object var7_7 = null;
                ClassReader.this.log.useSource((JavaFileObject)object);
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                ClassReader.this.log.useSource((JavaFileObject)object);
                throw throwable;
            }
            annotatedConstruct = new Type.MethodType(List.<Type>nil(), ClassReader.this.syms.botType, List.<Type>nil(), ClassReader.this.syms.methodClass);
            return new Symbol.MethodSymbol(1025L, name, (Type)annotatedConstruct, type.tsym);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Attribute deproxy(Type type, Attribute attribute) {
            Type type2 = this.type;
            try {
                this.type = type;
                attribute.accept(this);
                Attribute attribute2 = this.result;
                Object var6_5 = null;
                this.type = type2;
                return attribute2;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                this.type = type2;
                throw throwable;
            }
        }

        @Override
        public void visitConstant(Attribute.Constant constant) {
            this.result = constant;
        }

        @Override
        public void visitClass(Attribute.Class clazz) {
            this.result = clazz;
        }

        @Override
        public void visitEnum(Attribute.Enum enum_) {
            throw new AssertionError();
        }

        @Override
        public void visitCompound(Attribute.Compound compound) {
            throw new AssertionError();
        }

        @Override
        public void visitArray(Attribute.Array array) {
            throw new AssertionError();
        }

        @Override
        public void visitError(Attribute.Error error) {
            throw new AssertionError();
        }

        @Override
        public void visitEnumAttributeProxy(EnumAttributeProxy enumAttributeProxy) {
            Symbol.TypeSymbol typeSymbol = enumAttributeProxy.enumType.tsym;
            Symbol.VarSymbol varSymbol = null;
            Scope.Entry entry = typeSymbol.members().lookup(enumAttributeProxy.enumerator);
            while (entry.scope != null) {
                if (entry.sym.kind == 4) {
                    varSymbol = (Symbol.VarSymbol)entry.sym;
                    break;
                }
                entry = entry.next();
            }
            if (varSymbol == null) {
                ClassReader.this.log.error("unknown.enum.constant", ClassReader.this.currentClassFile, typeSymbol, enumAttributeProxy.enumerator);
                this.result = new Attribute.Error(typeSymbol.type);
            } else {
                this.result = new Attribute.Enum(typeSymbol.type, varSymbol);
            }
        }

        @Override
        public void visitArrayAttributeProxy(ArrayAttributeProxy arrayAttributeProxy) {
            int n = arrayAttributeProxy.values.length();
            Attribute[] attributeArray = new Attribute[n];
            Type type = ClassReader.this.types.elemtype(this.type);
            int n2 = 0;
            List<Attribute> list = arrayAttributeProxy.values;
            while (list.nonEmpty()) {
                attributeArray[n2++] = this.deproxy(type, (Attribute)list.head);
                list = list.tail;
            }
            this.result = new Attribute.Array(this.type, attributeArray);
        }

        @Override
        public void visitCompoundAnnotationProxy(CompoundAnnotationProxy compoundAnnotationProxy) {
            this.result = this.deproxyCompound(compoundAnnotationProxy);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ArrayAttributeProxy
    extends Attribute {
        List<Attribute> values;

        ArrayAttributeProxy(List<Attribute> list) {
            super(null);
            this.values = list;
        }

        @Override
        public void accept(Attribute.Visitor visitor) {
            ((ProxyVisitor)visitor).visitArrayAttributeProxy(this);
        }

        @Override
        public String toString() {
            return "{" + this.values + "}";
        }
    }

    public static class BadClassFile
    extends Symbol.CompletionFailure {
        private static final long serialVersionUID = 0L;

        public BadClassFile(Symbol.ClassSymbol classSymbol, Object object, Object object2) {
            super(classSymbol, Log.getLocalizedString("bad.class.file.header", object, object2));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CompoundAnnotationProxy
    extends Attribute {
        final List<Pair<Name, Attribute>> values;

        public CompoundAnnotationProxy(Type type, List<Pair<Name, Attribute>> list) {
            super(type);
            this.values = list;
        }

        @Override
        public void accept(Attribute.Visitor visitor) {
            ((ProxyVisitor)visitor).visitCompoundAnnotationProxy(this);
        }

        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("@");
            stringBuffer.append(this.type.tsym.getQualifiedName());
            stringBuffer.append("/*proxy*/{");
            boolean bl = true;
            List<Pair<Name, Attribute>> list = this.values;
            while (list.nonEmpty()) {
                Pair pair = (Pair)list.head;
                if (!bl) {
                    stringBuffer.append(",");
                }
                bl = false;
                stringBuffer.append((CharSequence)pair.fst);
                stringBuffer.append("=");
                stringBuffer.append(pair.snd);
                list = list.tail;
            }
            stringBuffer.append("}");
            return stringBuffer.toString();
        }
    }

    static class EnumAttributeProxy
    extends Attribute {
        Type enumType;
        Name enumerator;

        public EnumAttributeProxy(Type type, Name name) {
            super(null);
            this.enumType = type;
            this.enumerator = name;
        }

        public void accept(Attribute.Visitor visitor) {
            ((ProxyVisitor)visitor).visitEnumAttributeProxy(this);
        }

        public String toString() {
            return "/*proxy enum*/" + this.enumType + "." + this.enumerator;
        }
    }

    static interface ProxyVisitor
    extends Attribute.Visitor {
        public void visitEnumAttributeProxy(EnumAttributeProxy var1);

        public void visitArrayAttributeProxy(ArrayAttributeProxy var1);

        public void visitCompoundAnnotationProxy(CompoundAnnotationProxy var1);
    }

    public static interface SourceCompleter {
        public void complete(Symbol.ClassSymbol var1) throws Symbol.CompletionFailure;
    }

    private static class SourceFileObject
    extends BaseFileObject {
        private Name name;

        public SourceFileObject(Name name) {
            this.name = name;
        }

        public InputStream openInputStream() {
            throw new UnsupportedOperationException();
        }

        public OutputStream openOutputStream() {
            throw new UnsupportedOperationException();
        }

        public Reader openReader() {
            throw new UnsupportedOperationException();
        }

        public Writer openWriter() {
            throw new UnsupportedOperationException();
        }

        @Deprecated
        public String getName() {
            return this.name.toString();
        }

        public long getLastModified() {
            throw new UnsupportedOperationException();
        }

        public boolean delete() {
            throw new UnsupportedOperationException();
        }

        public CharBuffer getCharContent(boolean bl) {
            throw new UnsupportedOperationException();
        }

        public boolean equals(Object object) {
            if (!(object instanceof SourceFileObject)) {
                return false;
            }
            SourceFileObject sourceFileObject = (SourceFileObject)object;
            return this.name.equals(sourceFileObject.name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean isNameCompatible(String string, JavaFileObject.Kind kind) {
            return this.name.toString().equals(string + kind.extension);
        }

        public URI toUri() {
            return URI.create(this.name.toString());
        }

        public Reader openReader(boolean bl) throws IOException {
            throw new UnsupportedOperationException();
        }
    }
}

