/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.swt.table.util;

import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.EMFFormsDatabinding;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public class DMRCellLabelProvider
extends CellLabelProvider {
    private final VDomainModelReference dmr;
    private final EMFFormsDatabinding databindingService;

    public DMRCellLabelProvider(VDomainModelReference dmr) {
        this(dmr, DMRCellLabelProvider.getService(EMFFormsDatabinding.class));
    }

    public DMRCellLabelProvider(VDomainModelReference dmr, EMFFormsDatabinding databindingService) {
        this.dmr = dmr;
        this.databindingService = databindingService;
    }

    public String getToolTipText(Object element) {
        IObservableValue observableValue;
        EObject domainObject = (EObject)element;
        try {
            observableValue = this.databindingService.getObservableValue(this.dmr, domainObject);
        }
        catch (DatabindingFailedException ex) {
            return null;
        }
        Object value = observableValue.getValue();
        observableValue.dispose();
        if (value == null) {
            return null;
        }
        return String.valueOf(value);
    }

    public void update(ViewerCell cell) {
        EObject element = (EObject)cell.getElement();
        try {
            IObservableValue observableValue = this.databindingService.getObservableValue(this.dmr, element);
            Object value = observableValue.getValue();
            observableValue.dispose();
            if (value == null) {
                cell.setText("");
            }
            cell.setText(String.valueOf(value));
        }
        catch (DatabindingFailedException ex) {
            cell.setText("");
        }
    }

    private static <T> T getService(Class<T> clazz) {
        Bundle bundle = FrameworkUtil.getBundle(DMRCellLabelProvider.class);
        BundleContext bundleContext = bundle.getBundleContext();
        ServiceReference serviceReference = bundleContext.getServiceReference(clazz);
        Object service = bundleContext.getService(serviceReference);
        bundleContext.ungetService(serviceReference);
        return (T)service;
    }
}

