/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.core.services.databinding;

import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.databinding.IEMFListProperty;
import org.eclipse.emf.databinding.IEMFObservable;
import org.eclipse.emf.databinding.IEMFValueProperty;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.emf.DomainModelReferenceConverterEMF;
import org.eclipse.emfforms.spi.core.services.databinding.emf.EMFFormsDatabindingEMF;

public class EMFFormsDatabindingImpl
implements EMFFormsDatabindingEMF {
    private final Set<DomainModelReferenceConverterEMF> referenceConverters = new LinkedHashSet<DomainModelReferenceConverterEMF>();

    @Override
    public IObservableValue getObservableValue(VDomainModelReference domainModelReference, EObject object) throws DatabindingFailedException {
        if (domainModelReference == null) {
            throw new IllegalArgumentException("The given VDomainModelReference must not be null.");
        }
        if (object == null) {
            throw new IllegalArgumentException("The given EObject must not be null.");
        }
        IEMFValueProperty valueProperty = this.getValueProperty(domainModelReference, object);
        return valueProperty.observe((Object)object);
    }

    @Override
    public IEMFValueProperty getValueProperty(VDomainModelReference domainModelReference, EObject object) throws DatabindingFailedException {
        DomainModelReferenceConverterEMF bestConverter = this.getBestDomainModelReferenceConverter(domainModelReference);
        if (bestConverter != null) {
            return bestConverter.convertToValueProperty(domainModelReference, object);
        }
        throw new DatabindingFailedException(String.format("No applicable DomainModelReferenceConverter could be found for %1$s .", domainModelReference.eClass().getName()));
    }

    protected void addDomainModelReferenceConverter(DomainModelReferenceConverterEMF converter) {
        this.referenceConverters.add(converter);
    }

    protected void removeDomainModelReferenceConverter(DomainModelReferenceConverterEMF converter) {
        this.referenceConverters.remove(converter);
    }

    @Override
    public IObservableList getObservableList(VDomainModelReference domainModelReference, EObject object) throws DatabindingFailedException {
        if (domainModelReference == null) {
            throw new IllegalArgumentException("The given VDomainModelReference must not be null.");
        }
        if (object == null) {
            throw new IllegalArgumentException("The given EObject must not be null.");
        }
        IEMFListProperty listProperty = this.getListProperty(domainModelReference, object);
        return listProperty.observe((Object)object);
    }

    @Override
    public IEMFListProperty getListProperty(VDomainModelReference domainModelReference, EObject object) throws DatabindingFailedException {
        DomainModelReferenceConverterEMF bestConverter = this.getBestDomainModelReferenceConverter(domainModelReference);
        if (bestConverter != null) {
            return bestConverter.convertToListProperty(domainModelReference, object);
        }
        throw new DatabindingFailedException("No applicable DomainModelReferenceConverter could be found.");
    }

    private DomainModelReferenceConverterEMF getBestDomainModelReferenceConverter(VDomainModelReference domainModelReference) {
        if (domainModelReference == null) {
            throw new IllegalArgumentException("The given VDomainModelReference must not be null.");
        }
        double highestPriority = Double.NEGATIVE_INFINITY;
        DomainModelReferenceConverterEMF bestConverter = null;
        for (DomainModelReferenceConverterEMF converter : this.referenceConverters) {
            double priority = converter.isApplicable(domainModelReference);
            if (!(priority > highestPriority)) continue;
            highestPriority = priority;
            bestConverter = converter;
        }
        return bestConverter;
    }

    @Override
    public EStructuralFeature extractFeature(IObservableValue observableValue) throws DatabindingFailedException {
        if (IEMFObservable.class.isInstance(observableValue)) {
            return ((IEMFObservable)IEMFObservable.class.cast(observableValue)).getStructuralFeature();
        }
        throw new DatabindingFailedException(String.format("The IObservableValue class %1$s is not supported!", observableValue.getClass().getName()));
    }

    @Override
    public EStructuralFeature extractFeature(IObservableList observableList) throws DatabindingFailedException {
        if (IEMFObservable.class.isInstance(observableList)) {
            return ((IEMFObservable)IEMFObservable.class.cast(observableList)).getStructuralFeature();
        }
        throw new DatabindingFailedException(String.format("The IObservableList class %1$s is not supported!", observableList.getClass().getName()));
    }

    @Override
    public EObject extractObserved(IObservableValue observableValue) throws DatabindingFailedException {
        if (IEMFObservable.class.isInstance(observableValue)) {
            return (EObject)((IEMFObservable)IEMFObservable.class.cast(observableValue)).getObserved();
        }
        throw new DatabindingFailedException(String.format("The IObservableValue class %1$s is not supported!", observableValue.getClass().getName()));
    }

    @Override
    public EObject extractObserved(IObservableList observableList) throws DatabindingFailedException {
        if (IEMFObservable.class.isInstance(observableList)) {
            return (EObject)((IEMFObservable)IEMFObservable.class.cast(observableList)).getObserved();
        }
        throw new DatabindingFailedException(String.format("The IObservableList class %1$s is not supported!", observableList.getClass().getName()));
    }
}

