/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.spi.swt.core.util;

import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class PopupWindow {
    private Composite content;
    private final Shell shell;

    public PopupWindow(Control control, int maxHeight) {
        this(control, maxHeight, 16);
    }

    public PopupWindow(Control control, int maxHeight, int style) {
        Assert.isNotNull((Object)control);
        this.shell = new Shell(control.getShell(), style);
        this.configurePopupWindow(control, maxHeight, false);
    }

    public PopupWindow(Control control, int maxHeight, int style, boolean stretchUp) {
        Assert.isNotNull((Object)control);
        this.shell = new Shell(control.getShell(), style);
        this.configurePopupWindow(control, maxHeight, stretchUp);
    }

    protected void configurePopupWindow(Control control, int maxHeight, boolean stretchUp) {
        Point location = control.toDisplay(0, 0);
        Shell parentShell = control.getShell();
        Rectangle clientArea = control.getShell().getClientArea();
        Point bottomRight = parentShell.toDisplay(clientArea.width, clientArea.height);
        int distanceToScreenBottom = bottomRight.y - location.y;
        int verticalMoveUp = 0;
        int shellHeight = maxHeight;
        if (distanceToScreenBottom < maxHeight) {
            if (!stretchUp) {
                shellHeight = Math.min(maxHeight, distanceToScreenBottom);
            } else {
                verticalMoveUp = maxHeight - distanceToScreenBottom;
            }
        }
        this.shell.setSize(control.getSize().x, shellHeight);
        this.shell.setLayout((Layout)new FillLayout());
        this.shell.setLocation(location.x - 4, location.y - 4 - verticalMoveUp);
    }

    public Composite getContent() {
        if (this.content == null) {
            this.content = new Composite((Composite)this.shell, 0);
            this.content.setLayout((Layout)new GridLayout());
        }
        return this.content;
    }

    public void open() {
        this.shell.open();
    }

    public void close() {
        this.shell.close();
    }
}

