/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.diffmerge.swt;

import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecp.diffmerge.spi.context.DefaultMergeUtil;
import org.eclipse.emf.ecp.diffmerge.spi.context.DiffMergeModelContext;
import org.eclipse.emf.ecp.diffmerge.swt.Activator;
import org.eclipse.emf.ecp.diffmerge.swt.DiffDialogHelper;
import org.eclipse.emf.ecp.ui.view.ECPRendererException;
import org.eclipse.emf.ecp.ui.view.swt.ECPSWTViewRenderer;
import org.eclipse.emf.ecp.view.spi.model.LabelAlignment;
import org.eclipse.emf.ecp.view.spi.model.VContainedElement;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.model.VView;
import org.eclipse.emf.ecp.view.spi.model.VViewFactory;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emfforms.spi.localization.LocalizationServiceHelper;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class DiffDialog {
    private static final String CUSTOM_VARIANT = "org.eclipse.rap.rwt.customVariant";
    private final VControl left;
    private final VControl right;
    private final VControl main;
    private final String diffAttribute;
    private final DiffMergeModelContext viewModelContext;
    private VControl mergeControl;
    private EObject mergeDomainObject;
    private boolean diffConfirmed = true;

    public DiffDialog(DiffMergeModelContext viewModelContext, String diffAttribute, VControl left, VControl right, VControl main) {
        this.viewModelContext = viewModelContext;
        this.diffAttribute = diffAttribute;
        this.left = left;
        this.right = right;
        this.main = main;
    }

    public void create(Composite parent) {
        Composite mainComposite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(1).equalWidth(false).extendedMargins(10, 10, 10, 10).applyTo(mainComposite);
        ScrolledComposite scrolledComposite = new ScrolledComposite(mainComposite, 768);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        scrolledComposite.setShowFocusedControl(true);
        GridLayoutFactory.fillDefaults().numColumns(1).equalWidth(false).applyTo((Composite)scrolledComposite);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)scrolledComposite);
        Composite composite = new Composite((Composite)scrolledComposite, 0);
        GridLayoutFactory.fillDefaults().numColumns(1).equalWidth(false).applyTo(composite);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)composite);
        Control title = this.createTitleLabel(composite);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo(title);
        Control diff = this.createDiff(composite);
        GridDataFactory.fillDefaults().align(4, 1).grab(false, false).applyTo(diff);
        Control merge = this.createTarget(composite);
        GridDataFactory.fillDefaults().align(4, 1).grab(false, false).applyTo(merge);
        scrolledComposite.setContent((Control)composite);
        composite.layout();
        Point point = composite.computeSize(-1, -1);
        scrolledComposite.setMinSize(point);
        Control nextPrevious = this.createButtonRow(mainComposite);
        GridDataFactory.fillDefaults().align(4, 1).grab(true, false).applyTo(nextPrevious);
    }

    private Control createButtonRow(Composite parent) {
        Composite buttonRowComposite = new Composite(parent, 0);
        buttonRowComposite.setData(CUSTOM_VARIANT, (Object)"org_eclipse_emf_ecp_compare_dialog_buttonRow");
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(true).applyTo(buttonRowComposite);
        Composite diffConfirmedComposite = new Composite(buttonRowComposite, 0);
        GridDataFactory.fillDefaults().align(4, 1).grab(true, false).span(2, 1).applyTo((Control)diffConfirmedComposite);
        diffConfirmedComposite.setLayout((Layout)new FillLayout(256));
        final Button buttonDiffConfirmed = new Button(diffConfirmedComposite, 32);
        buttonDiffConfirmed.setText(LocalizationServiceHelper.getString(this.getClass(), (String)"DiffDialog_DiffConfirmed"));
        buttonDiffConfirmed.setSelection(this.diffConfirmed);
        buttonDiffConfirmed.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                DiffDialog.this.diffConfirmed = buttonDiffConfirmed.getSelection();
            }
        });
        final int index = this.viewModelContext.getIndexOf(this.main);
        Composite nextPreviousComposite = new Composite(buttonRowComposite, 0);
        nextPreviousComposite.setData(CUSTOM_VARIANT, (Object)"org_eclipse_emf_ecp_compare_dialog_nextPrevious");
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(true).applyTo(nextPreviousComposite);
        GridDataFactory.fillDefaults().align(1, 1).grab(true, false).applyTo((Control)nextPreviousComposite);
        final Button previous = new Button(nextPreviousComposite, 8);
        previous.setText(LocalizationServiceHelper.getString(this.getClass(), (String)"DiffDialog_Previous"));
        previous.setImage(Activator.getImage("icons/arrow_left.png"));
        GridDataFactory.fillDefaults().align(4, 1).grab(false, false).applyTo((Control)previous);
        previous.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                DiffDialog.this.saveAndCloseDialog(previous.getShell());
                DiffDialogHelper.showDialog(DiffDialog.this.viewModelContext, index - 1);
            }
        });
        final Button next = new Button(nextPreviousComposite, 8);
        next.setText(LocalizationServiceHelper.getString(this.getClass(), (String)"DiffDialog_Next"));
        next.setImage(Activator.getImage("icons/arrow_right.png"));
        GridDataFactory.fillDefaults().align(4, 1).grab(false, false).applyTo((Control)next);
        next.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                DiffDialog.this.saveAndCloseDialog(next.getShell());
                DiffDialogHelper.showDialog(DiffDialog.this.viewModelContext, index + 1);
            }
        });
        if (index == 0) {
            previous.setEnabled(false);
        }
        if (index + 1 == this.viewModelContext.getTotalNumberOfDiffs()) {
            next.setEnabled(false);
        }
        final Button bConfirm = new Button(buttonRowComposite, 8);
        bConfirm.setText(LocalizationServiceHelper.getString(this.getClass(), (String)"DiffDialog_Confirm"));
        bConfirm.setData(CUSTOM_VARIANT, (Object)"org_eclipse_emf_ecp_compare_dialog_merge_confirm");
        GridDataFactory.fillDefaults().align(0x1000008, 1).grab(true, false).applyTo((Control)bConfirm);
        bConfirm.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                DiffDialog.this.saveAndCloseDialog(bConfirm.getShell());
            }
        });
        return buttonRowComposite;
    }

    private Control createTarget(Composite parent) {
        Group targetGroup = new Group(parent, 0);
        targetGroup.setData(CUSTOM_VARIANT, (Object)"org_eclipse_emf_ecp_compare_dialog_target");
        targetGroup.setText(LocalizationServiceHelper.getString(this.getClass(), (String)"DiffDialog_targetObject"));
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false).applyTo((Composite)targetGroup);
        this.mergeControl = (VControl)EcoreUtil.copy((EObject)this.main);
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        AdapterFactoryEditingDomain domain = new AdapterFactoryEditingDomain((AdapterFactory)new ComposedAdapterFactory(new AdapterFactory[]{new ReflectiveItemProviderAdapterFactory(), new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE)}), (CommandStack)new BasicCommandStack(), (ResourceSet)resourceSet);
        this.mergeDomainObject = EcoreUtil.copy((EObject)this.viewModelContext.getDomainModel());
        resourceSet.eAdapters().add((Object)new AdapterFactoryEditingDomain.EditingDomainProvider((EditingDomain)domain));
        Resource resource = resourceSet.createResource(URI.createURI((String)"VIRTUAL_URI_TEMP"));
        resource.getContents().add((Object)this.mergeDomainObject);
        this.createControl((Composite)targetGroup, this.mergeControl, this.mergeDomainObject, false);
        return targetGroup;
    }

    private Control createDiff(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(LocalizationServiceHelper.getString(this.getClass(), (String)"DiffDialog_DifferenceGroup"));
        group.setData(CUSTOM_VARIANT, (Object)"org_eclipse_emf_ecp_compare_dialog_diff");
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false).applyTo((Composite)group);
        Label leftObject = new Label((Composite)group, 0);
        leftObject.setText(LocalizationServiceHelper.getString(this.getClass(), (String)"DiffDialog_leftObject:"));
        leftObject.setData(CUSTOM_VARIANT, (Object)"org_eclipse_emf_ecp_compare_dialog_diff_left");
        GridDataFactory.fillDefaults().align(1, 4).grab(false, false).span(2, 1).applyTo((Control)leftObject);
        this.createControl((Composite)group, (VControl)EcoreUtil.copy((EObject)this.left), EcoreUtil.copy((EObject)this.viewModelContext.getLeftModel()), true);
        Button bReplaceWithLeft = new Button((Composite)group, 8);
        bReplaceWithLeft.setText(LocalizationServiceHelper.getString(this.getClass(), (String)"DiffDialog_replaceWithLeft"));
        bReplaceWithLeft.setImage(Activator.getImage("icons/arrow_down.png"));
        bReplaceWithLeft.setData(CUSTOM_VARIANT, (Object)"org_eclipse_emf_ecp_compare_dialog_diff_leftReplace");
        GridDataFactory.fillDefaults().align(4, 1).grab(false, false).applyTo((Control)bReplaceWithLeft);
        bReplaceWithLeft.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                DiffDialog.this.replaceMainWith(DiffDialog.this.left, DiffDialog.this.viewModelContext.getLeftModel());
            }
        });
        Label rightObject = new Label((Composite)group, 0);
        rightObject.setText(LocalizationServiceHelper.getString(this.getClass(), (String)"DiffDialog_rightObject:"));
        rightObject.setData(CUSTOM_VARIANT, (Object)"org_eclipse_emf_ecp_compare_dialog_diff_right");
        GridDataFactory.fillDefaults().align(1, 4).grab(false, false).span(2, 1).applyTo((Control)rightObject);
        this.createControl((Composite)group, (VControl)EcoreUtil.copy((EObject)this.right), EcoreUtil.copy((EObject)this.viewModelContext.getRightModel()), true);
        Button bReplaceWithRight = new Button((Composite)group, 8);
        bReplaceWithRight.setText(LocalizationServiceHelper.getString(this.getClass(), (String)"DiffDialog_replaceWithRight"));
        bReplaceWithRight.setImage(Activator.getImage("icons/arrow_down.png"));
        bReplaceWithLeft.setData(CUSTOM_VARIANT, (Object)"org_eclipse_emf_ecp_compare_dialog_diff_rightReplace");
        GridDataFactory.fillDefaults().align(4, 1).grab(false, false).applyTo((Control)bReplaceWithRight);
        bReplaceWithRight.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                DiffDialog.this.replaceMainWith(DiffDialog.this.right, DiffDialog.this.viewModelContext.getRightModel());
            }
        });
        return group;
    }

    private void createControl(Composite parent, VControl control, EObject domainObject, boolean readonly) {
        VView leftView = VViewFactory.eINSTANCE.createView();
        leftView.setRootEClass(domainObject.eClass());
        VControl leftControl = control;
        leftControl.setReadonly(readonly);
        leftControl.setLabelAlignment(LabelAlignment.NONE);
        leftView.getChildren().add((Object)leftControl);
        try {
            ECPSWTViewRenderer.INSTANCE.render(parent, domainObject, leftView);
        }
        catch (ECPRendererException ex) {
            ex.printStackTrace();
        }
    }

    private void replaceMainWith(VControl replaceControl, EObject replaceDomainModel) {
        DefaultMergeUtil.copyValues((VControl)replaceControl, (EObject)replaceDomainModel, (VControl)this.mergeControl, (EObject)this.mergeDomainObject);
    }

    private Control createTitleLabel(Composite parent) {
        Label title = new Label(parent, 0);
        ArrayList<String> breadCrumb = new ArrayList<String>();
        breadCrumb.add(this.diffAttribute);
        EObject parentEObject = this.main.eContainer();
        while (!VView.class.isInstance(parentEObject)) {
            VElement vElement = (VElement)parentEObject;
            if (!VContainedElement.class.isInstance(vElement)) {
                breadCrumb.add(vElement.getName());
            }
            parentEObject = parentEObject.eContainer();
        }
        Collections.reverse(breadCrumb);
        StringBuilder sb = new StringBuilder();
        for (String bc : breadCrumb) {
            if (sb.length() != 0) {
                sb.append(">");
            }
            sb.append(bc);
        }
        title.setText(sb.toString());
        title.setData(CUSTOM_VARIANT, (Object)"org_eclipse_emf_ecp_compare_dialog_title");
        return title;
    }

    private void saveAndCloseDialog(Shell shell) {
        DefaultMergeUtil.copyValues((VControl)this.mergeControl, (EObject)this.mergeDomainObject, (VControl)this.main, (EObject)this.viewModelContext.getDomainModel());
        this.viewModelContext.markControl(this.main, this.diffConfirmed);
        shell.dispose();
    }
}

