/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.model.internal.fx;

import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import org.eclipse.emf.ecp.view.model.internal.fx.GridCellFX;
import org.eclipse.emf.ecp.view.model.internal.fx.GridDescriptionFX;
import org.eclipse.emf.ecp.view.model.internal.fx.GridDescriptionFXFactory;
import org.eclipse.emf.ecp.view.model.internal.fx.RendererFX;
import org.eclipse.emf.ecp.view.model.internal.fx.RendererFactory;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.model.VContainedContainer;
import org.eclipse.emf.ecp.view.spi.model.VContainedElement;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.model.VView;
import org.eclipse.emf.ecp.view.spi.renderer.NoPropertyDescriptorFoundExeption;
import org.eclipse.emf.ecp.view.spi.renderer.NoRendererFoundException;
import org.eclipse.emfforms.spi.common.report.ReportService;

public class ViewRendererFX
extends RendererFX<VView> {
    private GridDescriptionFX gridDescription;

    public ViewRendererFX(VView vElement, ViewModelContext viewContext, ReportService reportService) {
        super(vElement, viewContext, reportService);
    }

    @Override
    public GridDescriptionFX getGridDescription() {
        if (this.gridDescription == null) {
            this.gridDescription = GridDescriptionFXFactory.INSTANCE.createSimpleGrid(1, 1, this);
        }
        return this.gridDescription;
    }

    @Override
    protected Node renderNode(GridCellFX cell) throws NoRendererFoundException, NoPropertyDescriptorFoundExeption {
        if (cell.getColumn() != 0) {
            return null;
        }
        VView vView = (VView)this.getVElement();
        GridPane grid = new GridPane();
        grid.getStyleClass().add((Object)"vertical");
        int maxColumns = 1;
        for (VContainedElement composite : vView.getChildren()) {
            RendererFX<VElement> compositeRenderer = RendererFactory.INSTANCE.getRenderer((VElement)composite, this.getViewModelContext());
            GridDescriptionFX rendererGrid = compositeRenderer.getGridDescription();
            int columns = rendererGrid.getColumns();
            if (columns <= maxColumns) continue;
            maxColumns = columns;
        }
        int gridRow = -1;
        for (VContainedElement composite : vView.getChildren()) {
            RendererFX<VElement> compositeRenderer = RendererFactory.INSTANCE.getRenderer((VElement)composite, this.getViewModelContext());
            GridDescriptionFX rendererGrid = compositeRenderer.getGridDescription();
            int rows = rendererGrid.getRows();
            int columns = rendererGrid.getColumns();
            int i = 0;
            while (i < rows) {
                ++gridRow;
                int j = 0;
                while (j < columns) {
                    Node node = compositeRenderer.render((GridCellFX)((Object)rendererGrid.getGrid().get(i * columns + j)));
                    grid.add(node, j, gridRow);
                    if (node instanceof Label) {
                        GridPane.setHgrow((Node)node, (Priority)Priority.SOMETIMES);
                    } else {
                        GridPane.setHgrow((Node)node, (Priority)Priority.ALWAYS);
                    }
                    if (VContainedContainer.class.isInstance(composite)) {
                        GridPane.setVgrow((Node)node, (Priority)Priority.ALWAYS);
                    }
                    if (j == columns - 1) {
                        GridPane.setColumnSpan((Node)node, (Integer)(maxColumns - columns + 1));
                    }
                    ++j;
                }
                ++i;
            }
        }
        if (grid.getChildren().size() == 1) {
            GridPane.setVgrow((Node)((Node)grid.getChildren().get(0)), (Priority)Priority.ALWAYS);
        }
        return grid;
    }
}

