/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.pde.core.plugin.IPlugin;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.TargetPlatformHelper;
import org.eclipse.pde.internal.core.ibundle.IBundlePluginBase;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.wizards.product.UpdateSplashHandlerAction;
import org.eclipse.pde.internal.ui.wizards.templates.ControlStack;
import org.eclipse.pde.ui.templates.IVariableProvider;
import org.osgi.framework.Bundle;

public class TemplateFileGenerator
implements IVariableProvider {
    public static final String KEY_PLUGIN_CLASS = "pluginClass";
    public static final String KEY_ACTIVATOR_SIMPLE = "activator";
    public static final String KEY_PLUGIN_ID = "pluginId";
    public static final String KEY_PLUGIN_NAME = "pluginName";
    public static final String KEY_PACKAGE_NAME = "packageName";
    private IProject fProject;
    private IPluginModelBase fModel;
    private String fPluginID;
    private String fPackage;
    private String fClass;
    private String fTemplate;

    public TemplateFileGenerator(IProject project, IPluginModelBase model, String pluginID, String targetPackage, String targetClass, String template) {
        this.fProject = project;
        this.fModel = model;
        this.fPluginID = pluginID;
        this.fPackage = targetPackage;
        this.fClass = targetClass;
        this.fTemplate = template;
    }

    public void generateFiles(IProgressMonitor monitor) throws CoreException {
        this.generateFiles(monitor, this.getTemplateLocation());
        Bundle templateBundle = Platform.getBundle((String)"org.eclipse.pde.ui.templates");
        if (templateBundle == null) {
            return;
        }
        this.generateFiles(monitor, templateBundle.getEntry("branding/"));
    }

    public URL getTemplateLocation() {
        Bundle bundle = Platform.getBundle((String)"org.eclipse.pde.ui.templates");
        if (bundle == null) {
            return null;
        }
        try {
            String[] candidates;
            String[] stringArray = candidates = this.getDirectoryCandidates();
            int n = candidates.length;
            int n2 = 0;
            while (n2 < n) {
                String directoryCandidate = stringArray[n2];
                if (bundle.getEntry(directoryCandidate) != null) {
                    URL candidate = new URL(bundle.getEntry("/"), directoryCandidate);
                    return candidate;
                }
                ++n2;
            }
        }
        catch (MalformedURLException malformedURLException) {}
        return null;
    }

    protected void generateFiles(IProgressMonitor monitor, URL locationUrl) throws CoreException {
        monitor.setTaskName(PDEUIMessages.AbstractTemplateSection_generating);
        if (locationUrl == null) {
            return;
        }
        try {
            locationUrl = FileLocator.resolve((URL)locationUrl);
            locationUrl = FileLocator.toFileURL((URL)locationUrl);
        }
        catch (IOException iOException) {
            return;
        }
        if ("file".equals(locationUrl.getProtocol())) {
            File templateDirectory = new File(locationUrl.getFile());
            if (!templateDirectory.exists()) {
                return;
            }
            this.generateFiles(templateDirectory, (IContainer)this.fProject, true, false, monitor);
        } else if ("jar".equals(locationUrl.getProtocol())) {
            String file = locationUrl.getFile();
            int exclamation = file.indexOf(33);
            if (exclamation < 0) {
                return;
            }
            URL fileUrl = null;
            try {
                fileUrl = new URL(file.substring(0, exclamation));
            }
            catch (MalformedURLException malformedURLException) {
                return;
            }
            File pluginJar = new File(fileUrl.getFile());
            if (!pluginJar.exists()) {
                return;
            }
            String templateDirectory = file.substring(exclamation + 1);
            Path path = new Path(templateDirectory);
            try {
                Throwable throwable = null;
                Object var10_12 = null;
                try (ZipFile zipFile = new ZipFile(pluginJar);){
                    this.generateFiles(zipFile, (IPath)path, (IContainer)this.fProject, true, false, monitor);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (ZipException zipException) {
            }
            catch (IOException iOException) {}
        }
        monitor.subTask("");
        monitor.worked(1);
    }

    private void generateFiles(File src, IContainer dst, boolean firstLevel, boolean binary, IProgressMonitor monitor) throws CoreException {
        File[] members;
        File[] fileArray = members = src.listFiles();
        int n = members.length;
        int n2 = 0;
        while (n2 < n) {
            block20: {
                File member;
                block21: {
                    IFolder dstContainer;
                    block23: {
                        block22: {
                            member = fileArray[n2];
                            if (!member.isDirectory()) break block21;
                            dstContainer = null;
                            if (!firstLevel) break block22;
                            binary = false;
                            if (!this.isOkToCreateFolder(member)) break block20;
                            if (member.getName().equals("java")) {
                                IFolder sourceFolder = this.getSourceFolder(monitor);
                                dstContainer = this.generateJavaSourceFolder(sourceFolder, monitor);
                            } else if (member.getName().equals("bin")) {
                                binary = true;
                                dstContainer = dst;
                            }
                        }
                        if (dstContainer != null) break block23;
                        if (!this.isOkToCreateFolder(member)) break block20;
                        String folderName = this.getProcessedString(member.getName(), member.getName());
                        dstContainer = dst.getFolder((IPath)new Path(folderName));
                    }
                    if (dstContainer instanceof IFolder && !dstContainer.exists()) {
                        ((IFolder)dstContainer).create(true, true, monitor);
                    }
                    this.generateFiles(member, (IContainer)dstContainer, false, binary, monitor);
                    break block20;
                }
                if (this.isOkToCreateFile(member)) {
                    if (firstLevel) {
                        binary = false;
                    }
                    try {
                        Throwable throwable = null;
                        Object var12_13 = null;
                        try (FileInputStream in = new FileInputStream(member);){
                            this.copyFile(member.getName(), in, dst, binary, monitor);
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (IOException iOException) {}
                }
            }
            ++n2;
        }
    }

    private void copyFile(String fileName, InputStream input, IContainer dst, boolean binary, IProgressMonitor monitor) throws CoreException {
        String targetFileName = this.getProcessedString(fileName, fileName);
        monitor.subTask(targetFileName);
        IFile dstFile = dst.getFile((IPath)new Path(targetFileName));
        try {
            Throwable throwable = null;
            Object var9_10 = null;
            try (InputStream stream = this.getProcessedStream(fileName, input, binary);){
                if (dstFile.exists()) {
                    dstFile.setContents(stream, true, true, monitor);
                } else {
                    dstFile.create(stream, true, monitor);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {}
    }

    private void generateFiles(ZipFile zipFile, IPath path, IContainer dst, boolean firstLevel, boolean binary, IProgressMonitor monitor) throws CoreException {
        int pathLength = path.segmentCount();
        HashMap<String, ZipEntry> childZipEntries = new HashMap<String, ZipEntry>();
        Enumeration<? extends ZipEntry> zipEntries = zipFile.entries();
        while (zipEntries.hasMoreElements()) {
            ZipEntry zipEntry = zipEntries.nextElement();
            Path entryPath = new Path(zipEntry.getName());
            if (entryPath.segmentCount() <= pathLength || !path.isPrefixOf((IPath)entryPath)) continue;
            if (entryPath.segmentCount() == pathLength + 1) {
                childZipEntries.put(zipEntry.getName(), zipEntry);
                continue;
            }
            String name = entryPath.uptoSegment(pathLength + 1).addTrailingSeparator().toString();
            if (childZipEntries.containsKey(name)) continue;
            ZipEntry dirEntry = new ZipEntry(name);
            childZipEntries.put(name, dirEntry);
        }
        for (ZipEntry zipEnry : childZipEntries.values()) {
            String name = new Path(zipEnry.getName()).lastSegment().toString();
            if (zipEnry.isDirectory()) {
                IContainer dstContainer = null;
                if (firstLevel) {
                    binary = false;
                    if (name.equals("java")) {
                        IFolder sourceFolder = this.getSourceFolder(monitor);
                        dstContainer = this.generateJavaSourceFolder(sourceFolder, monitor);
                    } else if (name.equals("bin")) {
                        binary = true;
                        dstContainer = dst;
                    }
                }
                if (dstContainer == null) {
                    if (!this.isOkToCreateFolder(new File(path.toFile(), name))) continue;
                    String folderName = this.getProcessedString(name, name);
                    dstContainer = dst.getFolder((IPath)new Path(folderName));
                }
                if (dstContainer instanceof IFolder && !dstContainer.exists()) {
                    ((IFolder)dstContainer).create(true, true, monitor);
                }
                this.generateFiles(zipFile, path.append(name), dstContainer, false, binary, monitor);
                continue;
            }
            if (!this.isOkToCreateFile(new File(path.toFile(), name))) continue;
            if (firstLevel) {
                binary = false;
            }
            try {
                Throwable throwable = null;
                Object var13_14 = null;
                try (InputStream in = zipFile.getInputStream(zipEnry);){
                    this.copyFile(name, in, dst, binary, monitor);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {}
        }
    }

    protected boolean isOkToCreateFolder(File sourceFolder) {
        boolean extensibleTemplateSelected = UpdateSplashHandlerAction.isExtensibleTemplateSelected(this.fTemplate);
        String sourceFolderString = sourceFolder.toString();
        if (!extensibleTemplateSelected && sourceFolderString.endsWith("icons")) {
            return false;
        }
        return extensibleTemplateSelected || !sourceFolderString.endsWith("schema");
    }

    protected boolean isOkToCreateFile(File sourceFile) {
        String javaSuffix = ".java";
        String targetFile = String.valueOf(this.fClass) + javaSuffix;
        String copyFile = sourceFile.toString();
        if (copyFile.endsWith(javaSuffix)) {
            if (!copyFile.endsWith(targetFile) || this.fProject.exists((IPath)new Path("src/" + this.fPackage.replace('.', '/') + '/' + targetFile))) {
                return false;
            }
        } else {
            if (copyFile.endsWith("splash.bmp") && this.fProject.exists((IPath)new Path("splash.bmp"))) {
                return false;
            }
            if (copyFile.endsWith(".png")) {
                if (copyFile.endsWith("af.png") && this.fProject.exists((IPath)new Path("icons/af.png"))) {
                    return false;
                }
                if (copyFile.endsWith("embedded.png") && this.fProject.exists((IPath)new Path("icons/embedded.png"))) {
                    return false;
                }
                if (copyFile.endsWith("enterprise.png") && this.fProject.exists((IPath)new Path("icons/enterprise.png"))) {
                    return false;
                }
                if (copyFile.endsWith("rcp.png") && this.fProject.exists((IPath)new Path("icons/rcp.png"))) {
                    return false;
                }
                if (copyFile.endsWith("languages.png") && this.fProject.exists((IPath)new Path("icons/languages.png"))) {
                    return false;
                }
            } else if (copyFile.endsWith("splashExtension.exsd") && this.fProject.exists((IPath)new Path("schema/splashExtension.exsd"))) {
                return false;
            }
        }
        return true;
    }

    protected IFolder getSourceFolder(IProgressMonitor monitor) throws CoreException {
        IFolder sourceFolder = null;
        try {
            IClasspathEntry[] classpath;
            IJavaProject javaProject = JavaCore.create((IProject)this.fProject);
            IClasspathEntry[] iClasspathEntryArray = classpath = javaProject.getRawClasspath();
            int n = classpath.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry entry = iClasspathEntryArray[n2];
                if (entry.getEntryKind() == 3) {
                    IPath path = entry.getPath().removeFirstSegments(1);
                    if (path.segmentCount() > 0) {
                        sourceFolder = this.fProject.getFolder(path);
                    }
                    break;
                }
                ++n2;
            }
        }
        catch (JavaModelException javaModelException) {}
        return sourceFolder;
    }

    @Override
    public Object getValue(String key) {
        return this.getKeyValue(key);
    }

    private IFolder generateJavaSourceFolder(IFolder sourceFolder, IProgressMonitor monitor) throws CoreException {
        String packageName;
        Object packageValue = this.getValue(KEY_PACKAGE_NAME);
        String string = packageName = packageValue != null ? packageValue.toString() : null;
        if (packageName == null) {
            packageName = this.fModel.getPluginBase().getId();
        }
        Path path = new Path(packageName.replace('.', File.separatorChar));
        if (sourceFolder != null) {
            path = sourceFolder.getProjectRelativePath().append((IPath)path);
        }
        int i = 1;
        while (i <= path.segmentCount()) {
            IPath subpath = path.uptoSegment(i);
            IFolder subfolder = this.fProject.getFolder(subpath);
            if (!subfolder.exists()) {
                subfolder.create(true, true, monitor);
            }
            ++i;
        }
        return this.fProject.getFolder((IPath)path);
    }

    private String getProcessedString(String fileName, String source) {
        if (source.indexOf(36) == -1) {
            return source;
        }
        int loc = -1;
        StringBuilder buffer = new StringBuilder();
        boolean replacementMode = false;
        int i = 0;
        while (i < source.length()) {
            char c = source.charAt(i);
            if (c == '$') {
                if (replacementMode) {
                    String key = source.substring(loc, i);
                    String value = key.length() == 0 ? "$" : this.getReplacementString(fileName, key);
                    buffer.append(value);
                    replacementMode = false;
                } else {
                    replacementMode = true;
                    loc = i + 1;
                }
            } else if (!replacementMode) {
                buffer.append(c);
            }
            ++i;
        }
        return buffer.toString();
    }

    public String getReplacementString(String fileName, String key) {
        String result = this.getKeyValue(key);
        return result != null ? result : key;
    }

    private String getKeyValue(String key) {
        IPlugin plugin;
        String qualified;
        if (this.fModel == null) {
            return null;
        }
        if (key.equals(KEY_PLUGIN_CLASS) && this.fModel instanceof IPluginModel) {
            IPlugin plugin2 = (IPlugin)this.fModel.getPluginBase();
            return plugin2.getClassName();
        }
        if (key.equals(KEY_ACTIVATOR_SIMPLE) && this.fModel instanceof IPluginModel && (qualified = (plugin = (IPlugin)this.fModel.getPluginBase()).getClassName()) != null) {
            int lastDot = qualified.lastIndexOf(46);
            return lastDot != -1 && lastDot < qualified.length() - 1 ? qualified.substring(lastDot + 1) : qualified;
        }
        if (key.equals(KEY_PLUGIN_ID)) {
            return this.fPluginID;
        }
        if (key.equals(KEY_PLUGIN_NAME)) {
            plugin = this.fModel.getPluginBase();
            return plugin.getTranslatedName();
        }
        if (key.equals(KEY_PACKAGE_NAME) && this.fModel instanceof IPluginModel) {
            return this.fPackage;
        }
        return null;
    }

    private InputStream getProcessedStream(String fileName, InputStream stream, boolean binary) throws IOException, CoreException {
        if (binary) {
            return stream;
        }
        InputStreamReader reader = new InputStreamReader(stream);
        int bufsize = 1024;
        char[] cbuffer = new char[bufsize];
        int read = 0;
        StringBuilder keyBuffer = new StringBuilder();
        StringBuilder outBuffer = new StringBuilder();
        StringBuilder preBuffer = new StringBuilder();
        boolean newLine = true;
        ControlStack preStack = new ControlStack();
        preStack.setValueProvider(this);
        boolean replacementMode = false;
        boolean preprocessorMode = false;
        boolean escape = false;
        while (read != -1) {
            read = reader.read(cbuffer);
            int i = 0;
            while (i < read) {
                char c = cbuffer[i];
                if (escape) {
                    StringBuilder buf = preprocessorMode ? preBuffer : outBuffer;
                    buf.append(c);
                    escape = false;
                } else if (newLine && c == '%') {
                    preprocessorMode = true;
                    preBuffer.delete(0, preBuffer.length());
                } else if (preprocessorMode) {
                    if (c == '\\') {
                        escape = true;
                    } else if (c == '\n') {
                        preprocessorMode = false;
                        newLine = true;
                        String line = preBuffer.toString().trim();
                        preStack.processLine(line);
                    } else {
                        preBuffer.append(c);
                    }
                } else if (preStack.getCurrentState()) {
                    if (c == '$') {
                        if (replacementMode) {
                            replacementMode = false;
                            String key = keyBuffer.toString();
                            String value = key.length() == 0 ? "$" : this.getReplacementString(fileName, key);
                            outBuffer.append(value);
                            keyBuffer.delete(0, keyBuffer.length());
                        } else {
                            replacementMode = true;
                        }
                    } else if (replacementMode) {
                        keyBuffer.append(c);
                    } else {
                        outBuffer.append(c);
                        newLine = c == '\n';
                    }
                }
                ++i;
            }
        }
        return new ByteArrayInputStream(outBuffer.toString().getBytes(this.fProject.getDefaultCharset()));
    }

    private String[] getDirectoryCandidates() {
        double version = this.getTargetVersion();
        ArrayList<String> result = new ArrayList<String>();
        if (version >= 3.3) {
            result.add("templates_3.3/" + this.getSectionId() + "/");
        }
        if (version >= 3.2) {
            result.add("templates_3.2/" + this.getSectionId() + "/");
        }
        if (version >= 3.1) {
            result.add("templates_3.1/" + this.getSectionId() + "/");
        }
        if (version >= 3.0) {
            result.add("templates_3.0/" + this.getSectionId() + "/");
        }
        return result.toArray(new String[result.size()]);
    }

    public String getSectionId() {
        return "splashHandlers";
    }

    protected double getTargetVersion() {
        try {
            IPluginBase plugin = this.fModel.getPluginBase();
            if (plugin instanceof IBundlePluginBase) {
                return Double.parseDouble(((IBundlePluginBase)plugin).getTargetVersion());
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return TargetPlatformHelper.getTargetVersion();
    }
}

