/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.resources;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ISynchronizer;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.resources.SyncInfoCache;
import org.eclipse.team.internal.ccvs.core.syncinfo.FolderSyncInfo;
import org.eclipse.team.internal.ccvs.core.syncinfo.ResourceSyncInfo;
import org.eclipse.team.internal.ccvs.core.util.Util;

class SynchronizerSyncInfoCache
extends SyncInfoCache {
    Map<IResource, Object> pendingCacheWrites = new HashMap<IResource, Object>();
    private static final Object BYTES_REMOVED = new byte[0];

    public SynchronizerSyncInfoCache() {
        this.getWorkspaceSynchronizer().add(FOLDER_SYNC_KEY);
        this.getWorkspaceSynchronizer().add(RESOURCE_SYNC_KEY);
    }

    private ISynchronizer getWorkspaceSynchronizer() {
        return ResourcesPlugin.getWorkspace().getSynchronizer();
    }

    void flush(IProject project) throws CVSException {
        this.purgeCache((IContainer)project, true);
    }

    void flush(IFolder folder) throws CVSException {
        this.purgeCache((IContainer)folder, false);
    }

    @Override
    FolderSyncInfo getCachedFolderSync(IContainer container, boolean threadSafeAccess) throws CVSException {
        byte[] bytes = this.internalGetCachedSyncBytes(container);
        if (bytes == null) {
            return null;
        }
        return FolderSyncInfo.getFolderSyncInfo(bytes);
    }

    boolean hasCachedFolderSync(IContainer container) throws CVSException {
        return this.internalGetCachedSyncBytes(container) != null;
    }

    private byte[] internalGetCachedSyncBytes(IContainer container) throws CVSException {
        try {
            return this.getWorkspaceSynchronizer().getSyncInfo(FOLDER_SYNC_KEY, (IResource)container);
        }
        catch (CoreException e) {
            throw CVSException.wrapException(e);
        }
    }

    @Override
    void setCachedFolderSync(IContainer container, FolderSyncInfo info, boolean canModifyWorkspace) throws CVSException {
        try {
            if (info == null) {
                if (container.exists() || container.isPhantom()) {
                    this.getWorkspaceSynchronizer().flushSyncInfo(FOLDER_SYNC_KEY, (IResource)container, 0);
                }
            } else {
                this.getWorkspaceSynchronizer().setSyncInfo(FOLDER_SYNC_KEY, (IResource)container, info.getBytes());
            }
        }
        catch (CoreException e) {
            throw CVSException.wrapException(e);
        }
    }

    @Override
    byte[] getCachedSyncBytes(IResource resource, boolean threadSafeAccess) throws CVSException {
        try {
            byte[] bytes = null;
            if (!this.hasPendingCacheRemoval(resource) && (bytes = this.getPendingCacheWrite(resource)) == null) {
                bytes = this.getWorkspaceSynchronizer().getSyncInfo(RESOURCE_SYNC_KEY, resource);
            }
            if (bytes != null && resource.getType() == 1) {
                if (ResourceSyncInfo.isAddition(bytes)) {
                    bytes = null;
                } else if (!ResourceSyncInfo.isDeletion(bytes)) {
                    bytes = ResourceSyncInfo.convertToDeletion(bytes);
                }
            }
            return bytes;
        }
        catch (CoreException e) {
            throw CVSException.wrapException(e);
        }
    }

    @Override
    void setCachedSyncBytes(IResource resource, byte[] syncBytes, boolean canModifyWorkspace) throws CVSException {
        byte[] oldBytes = this.getCachedSyncBytes(resource, true);
        try {
            if (syncBytes == null) {
                if (oldBytes != null) {
                    if (canModifyWorkspace) {
                        if (resource.exists() || resource.isPhantom()) {
                            this.getWorkspaceSynchronizer().flushSyncInfo(RESOURCE_SYNC_KEY, resource, 0);
                        }
                        this.removePendingCacheWrite(resource);
                    } else if (resource.exists() || resource.isPhantom()) {
                        this.setPendingCacheWriteToDelete(resource);
                    }
                }
            } else if (oldBytes == null || !this.equals(syncBytes, oldBytes)) {
                if (canModifyWorkspace) {
                    this.getWorkspaceSynchronizer().setSyncInfo(RESOURCE_SYNC_KEY, resource, syncBytes);
                    this.removePendingCacheWrite(resource);
                } else {
                    this.setPendingCacheWrite(resource, syncBytes);
                }
            }
        }
        catch (CoreException e) {
            throw CVSException.wrapException(e);
        }
    }

    private boolean equals(byte[] syncBytes, byte[] oldBytes) throws CVSException {
        if (!ResourceSyncInfo.isFolder(syncBytes)) {
            syncBytes = ResourceSyncInfo.convertToDeletion(syncBytes);
        }
        if (!ResourceSyncInfo.isFolder(oldBytes)) {
            try {
                oldBytes = ResourceSyncInfo.convertToDeletion(oldBytes);
            }
            catch (CVSException e) {
                CVSProviderPlugin.log((CoreException)((Object)e));
                return false;
            }
        }
        return Util.equals(syncBytes, oldBytes);
    }

    @Override
    String getDirtyIndicator(IResource resource, boolean threadSafeAccess) throws CVSException {
        if (resource.getType() == 1) {
            return this.getCachedSyncBytes(resource, threadSafeAccess) != null ? "d" : "c";
        }
        return this.calculateDirtyCountForPhantomFolder((IContainer)resource);
    }

    @Override
    void setDirtyIndicator(IResource resource, String indicator) throws CVSException {
    }

    @Override
    public boolean cachesDirtyState() {
        return false;
    }

    @Override
    void flushDirtyCache(IResource container) throws CVSException {
    }

    @Override
    boolean isSyncInfoLoaded(IContainer parent) throws CVSException {
        return true;
    }

    @Override
    boolean isResourceSyncInfoCached(IContainer container) throws CVSException {
        return true;
    }

    @Override
    void setResourceSyncInfoCached(IContainer container) throws CVSException {
    }

    @Override
    boolean isFolderSyncInfoCached(IContainer container) throws CVSException {
        return true;
    }

    private String calculateDirtyCountForPhantomFolder(IContainer parent) throws CVSException {
        ICVSFolder cvsFolder = CVSWorkspaceRoot.getCVSFolderFor(parent);
        if (this.getCachedFolderSync(parent, true) == null) {
            return "c";
        }
        String indicator = "c";
        ICVSResource[] children = cvsFolder.members(80);
        int i = 0;
        while (i < children.length) {
            ICVSResource resource = children[i];
            if (!resource.isFolder()) {
                indicator = "d";
                break;
            }
            indicator = this.calculateDirtyCountForPhantomFolder((IContainer)resource.getIResource());
            ++i;
        }
        return indicator;
    }

    public void purgeCache(IContainer root, boolean deep) throws CVSException {
        int depth = deep ? 2 : 0;
        try {
            if (root.exists() || root.isPhantom()) {
                this.getWorkspaceSynchronizer().flushSyncInfo(RESOURCE_SYNC_KEY, (IResource)root, depth);
            }
            if (root.exists() || root.isPhantom()) {
                this.getWorkspaceSynchronizer().flushSyncInfo(FOLDER_SYNC_KEY, (IResource)root, depth);
            }
            if (deep) {
                this.removePendingCacheWritesUnder(root);
            } else {
                this.removePendingCacheWrite((IResource)root);
            }
        }
        catch (CoreException e) {
            if (e.getStatus().getCode() == 368) {
                return;
            }
            throw CVSException.wrapException(e);
        }
    }

    public boolean isPhantom(IResource resource) {
        return resource.isPhantom() || this.hasPendingCacheWrite(resource);
    }

    public IResource[] members(IContainer folder) throws CoreException {
        IResource[] pendingWrites = this.getPendingCacheWrites();
        if (pendingWrites != null) {
            HashSet<IResource> cachedResources = new HashSet<IResource>();
            int i = 0;
            while (i < pendingWrites.length) {
                IResource resource = pendingWrites[i];
                if (resource.getParent().equals((Object)folder)) {
                    cachedResources.add(resource);
                }
                ++i;
            }
            if (cachedResources.size() != 0) {
                IResource[] resources = folder.members(true);
                IResource[] cachedResourcesArray = cachedResources.toArray(new IResource[cachedResources.size()]);
                IResource[] finalResources = new IResource[resources.length + cachedResourcesArray.length];
                System.arraycopy(resources, 0, finalResources, 0, resources.length);
                System.arraycopy(cachedResourcesArray, 0, finalResources, resources.length, cachedResourcesArray.length);
                return finalResources;
            }
        }
        try {
            return folder.members(true);
        }
        catch (CoreException e) {
            if (e.getStatus().getCode() == 368) {
                return new IResource[0];
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasPendingCacheWrite(IResource resource) {
        Map<IResource, Object> map = this.pendingCacheWrites;
        synchronized (map) {
            return this.pendingCacheWrites.containsKey(resource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getPendingCacheWrite(IResource resource) {
        Map<IResource, Object> map = this.pendingCacheWrites;
        synchronized (map) {
            Object object = this.pendingCacheWrites.get(resource);
            if (object instanceof byte[]) {
                return (byte[])object;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasPendingCacheRemoval(IResource resource) {
        Map<IResource, Object> map = this.pendingCacheWrites;
        synchronized (map) {
            Object object = this.pendingCacheWrites.get(resource);
            return object == BYTES_REMOVED;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPendingCacheWrite(IResource resource, byte[] syncBytes) {
        Map<IResource, Object> map = this.pendingCacheWrites;
        synchronized (map) {
            this.pendingCacheWrites.put(resource, syncBytes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPendingCacheWriteToDelete(IResource resource) {
        Map<IResource, Object> map = this.pendingCacheWrites;
        synchronized (map) {
            this.pendingCacheWrites.put(resource, BYTES_REMOVED);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removePendingCacheWrite(IResource resource) {
        Map<IResource, Object> map = this.pendingCacheWrites;
        synchronized (map) {
            this.pendingCacheWrites.remove(resource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removePendingCacheWritesUnder(IContainer root) {
        Map<IResource, Object> map = this.pendingCacheWrites;
        synchronized (map) {
            IPath fullPath = root.getFullPath();
            Iterator<IResource> iter = this.pendingCacheWrites.keySet().iterator();
            while (iter.hasNext()) {
                IResource resource = iter.next();
                if (!fullPath.isPrefixOf(resource.getFullPath())) continue;
                iter.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IResource[] getPendingCacheWrites() {
        Map<IResource, Object> map = this.pendingCacheWrites;
        synchronized (map) {
            block4: {
                if (!this.pendingCacheWrites.isEmpty()) break block4;
                return null;
            }
            return this.pendingCacheWrites.keySet().toArray(new IResource[this.pendingCacheWrites.size()]);
        }
    }
}

