/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.tabbedproperties.sections.widgets;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecoretools.tabbedproperties.AbstractTabbedPropertySheetPage;
import org.eclipse.emf.ecoretools.tabbedproperties.internal.Messages;
import org.eclipse.emf.ecoretools.tabbedproperties.internal.sections.TableObjectManager;
import org.eclipse.emf.ecoretools.tabbedproperties.internal.sections.listeners.CellModifier;
import org.eclipse.emf.ecoretools.tabbedproperties.providers.TabbedPropertiesLabelProvider;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableViewerComposite
extends Composite {
    private TabbedPropertySheetWidgetFactory widgetFactory;
    private TableObjectManager objectManager;
    private TableViewer tableViewer;
    private Table table;
    private String[] columnNames;
    private Button addButton;
    private Button removeButton;
    private List<Button> otherButtons;
    private ILabelProvider labelProvider;
    private final Set<SelectionListener> selectionListeners;
    private SelectionListener removeListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            int index = TableViewerComposite.this.table.getSelectionIndex();
            Object object = TableViewerComposite.this.table.getItem(index).getData();
            TableViewerComposite.this.removeElement(object);
            TableViewerComposite.this.fireWidgetSelected();
        }
    };
    private SelectionListener addListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            TableViewerComposite.this.addElement();
            TableViewerComposite.this.fireWidgetSelected();
        }
    };

    public TableViewerComposite(Composite parent, String[] colNames, TabbedPropertySheetWidgetFactory widgetFactory) {
        super(parent, 0);
        this.widgetFactory = widgetFactory;
        this.widgetFactory.adapt((Composite)this);
        this.setLayout((Layout)new GridLayout(2, false));
        this.columnNames = colNames;
        this.createContents();
        this.labelProvider = new TabbedPropertiesLabelProvider((AdapterFactory)new ComposedAdapterFactory(AbstractTabbedPropertySheetPage.getPrincipalAdapterFactories()));
        this.selectionListeners = new HashSet<SelectionListener>();
    }

    private void createContents() {
        this.createTable(this);
        this.createButtons(this);
        this.createTableViewer();
    }

    protected void createTable(Composite parent) {
        int style = 101124;
        this.table = this.widgetFactory.createTable(parent, style);
        GridData gridData = new GridData(1808);
        gridData.grabExcessVerticalSpace = true;
        gridData.verticalSpan = 2;
        this.table.setLayoutData((Object)gridData);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        this.createColumns(this.table, this.columnNames);
    }

    private void createColumns(Table tab, String[] colNames) {
        int i = 0;
        while (i < colNames.length) {
            TableColumn column = new TableColumn(tab, 16384, i);
            column.setText(colNames[i]);
            column.setWidth(100);
            ++i;
        }
    }

    protected void createTableViewer() {
        this.tableViewer = new TableViewer(this.table);
        this.tableViewer.setUseHashlookup(true);
        this.tableViewer.setColumnProperties(this.columnNames);
        this.tableViewer.setCellModifier((ICellModifier)new CellModifier(this));
        this.tableViewer.setContentProvider((IContentProvider)new TableContentProvider());
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (TableViewerComposite.this.table.getSelection().length > 0) {
                    TableViewerComposite.this.updateSelectedItem(TableViewerComposite.this.table.getSelection()[0].getData());
                } else {
                    TableViewerComposite.this.updateSelectedItem(null);
                }
            }
        });
    }

    private CellEditor[] createCells(int numberOfCells) {
        if (numberOfCells < 0) {
            return new CellEditor[0];
        }
        CellEditor[] editors = new CellEditor[numberOfCells];
        int i = 0;
        while (i < numberOfCells) {
            switch (this.objectManager.getEType()) {
                case 1: {
                    CheckboxCellEditor cellEditor = new CheckboxCellEditor((Composite)this.table);
                    editors[i] = cellEditor;
                    break;
                }
                case 2: {
                    CheckboxCellEditor cellEditor = new ComboBoxCellEditor((Composite)this.table, this.objectManager.getEnumLiterals(), 8);
                    editors[i] = cellEditor;
                    break;
                }
                case 4: 
                case 6: 
                case 7: {
                    CheckboxCellEditor cellEditor = new TextCellEditor((Composite)this.table);
                    Text text = (Text)cellEditor.getControl();
                    text.setTextLimit(7);
                    text.addVerifyListener(new VerifyListener(){

                        public void verifyText(VerifyEvent e) {
                            e.doit = "0123456789".indexOf(e.text) >= 0;
                        }
                    });
                    editors[i] = cellEditor;
                    break;
                }
                case 3: {
                    CheckboxCellEditor cellEditor = new TextCellEditor((Composite)this.table);
                    ((Text)cellEditor.getControl()).setTextLimit(60);
                    editors[i] = cellEditor;
                    break;
                }
            }
            ++i;
        }
        return editors;
    }

    protected void createButtons(Composite parent) {
        Composite comp = this.widgetFactory.createComposite(parent);
        comp.setLayout((Layout)new GridLayout());
        this.createAddButton(comp);
        this.createRemoveButton(comp);
        this.createOtherButtons(comp);
        this.hookListeners();
    }

    protected void createAddButton(Composite comp) {
        this.addButton = this.widgetFactory.createButton(comp, Messages.TableViewerComposite_Add, 0);
        this.addButton.setLayoutData((Object)new GridData(768));
    }

    protected void createRemoveButton(Composite comp) {
        this.removeButton = this.widgetFactory.createButton(comp, Messages.TableViewerComposite_Remove, 0);
        this.removeButton.setLayoutData((Object)new GridData(768));
    }

    protected void createOtherButtons(Composite comp) {
        this.otherButtons = new ArrayList<Button>();
    }

    protected void hookListeners() {
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableViewerComposite.this.fireWidgetSelected();
            }
        });
        this.hookButtonListeners();
    }

    protected void hookButtonListeners() {
        if (this.addButton != null && this.removeButton != null) {
            this.addButton.addSelectionListener(this.addListener);
            this.removeButton.addSelectionListener(this.removeListener);
        }
    }

    public void setInput(EObject eObject, EStructuralFeature feature) {
        if (this.objectManager == null || !this.objectManager.getInputEObject().equals(eObject)) {
            this.objectManager = new TableObjectManager(eObject, feature);
            this.objectManager.setLabelProvider(this.labelProvider);
            this.tableViewer.setInput((Object)this.objectManager);
            CellEditor[] editors = this.createCells(this.columnNames.length);
            this.tableViewer.setCellEditors(editors);
        }
    }

    public void setLabelProvider(IBaseLabelProvider labelProvider) {
        if (labelProvider instanceof ILabelProvider) {
            this.labelProvider = (ILabelProvider)labelProvider;
            this.tableViewer.setLabelProvider(labelProvider);
            if (this.objectManager != null) {
                this.objectManager.setLabelProvider(this.labelProvider);
            }
        }
    }

    public void setEnabled(boolean enabled) {
        this.table.setEnabled(enabled);
        if (this.addButton != null && !this.addButton.isDisposed()) {
            this.addButton.setEnabled(enabled);
        }
        if (this.removeButton != null && !this.removeButton.isDisposed()) {
            this.removeButton.setEnabled(enabled);
        }
    }

    public void setEditingDomain(EditingDomain editingDomain) {
        this.objectManager.setEditingDomain(editingDomain);
    }

    public void refresh() {
        this.tableViewer.refresh();
    }

    public void addElement() {
        if (this.objectManager != null) {
            this.objectManager.addElement();
        }
    }

    public void addElement(Object newElement) {
        if (this.objectManager != null) {
            this.objectManager.addElement(newElement);
        }
    }

    public void removeElement(Object element) {
        if (this.objectManager != null) {
            this.objectManager.removeElement(element);
        }
    }

    public String[] getColumnHeaders() {
        return this.columnNames;
    }

    public void setColumnNames(String[] newColumnNames) {
        this.columnNames = (String[])newColumnNames.clone();
    }

    public TableObjectManager getObjectManager() {
        return this.objectManager;
    }

    public Button getAddButton() {
        return this.addButton;
    }

    public Button getRemoveButton() {
        return this.removeButton;
    }

    public List<Button> getOtherButtons() {
        return this.otherButtons;
    }

    public void setOtherButtons(List<Button> buttons) {
        this.otherButtons = buttons;
    }

    public ISelection getSelection() {
        return this.tableViewer.getSelection();
    }

    public Object getSelectionItem() {
        ISelection sel = this.getSelection();
        if (sel instanceof IStructuredSelection) {
            IStructuredSelection ssel = (IStructuredSelection)sel;
            return ssel.getFirstElement();
        }
        return null;
    }

    public List<?> getValue() {
        return this.objectManager.eGet();
    }

    public void setAddListener(SelectionListener listener) {
        SelectionListener oldListener = this.addListener;
        this.addListener = listener;
        this.addButton.removeSelectionListener(oldListener);
        this.addButton.addSelectionListener(this.addListener);
    }

    public void setRemoveListener(SelectionListener listener) {
        SelectionListener oldListener = this.removeListener;
        this.removeListener = listener;
        this.removeButton.removeSelectionListener(oldListener);
        this.removeButton.addSelectionListener(this.removeListener);
    }

    public Table getTable() {
        return this.table;
    }

    public void updateSelectedItem(Object data) {
    }

    protected TabbedPropertySheetWidgetFactory getWidgetFactory() {
        return this.widgetFactory;
    }

    protected void fireWidgetSelected() {
        for (SelectionListener listener : this.selectionListeners) {
            Event e = new Event();
            e.widget = this.table;
            listener.widgetSelected(new SelectionEvent(e));
        }
    }

    public void addSelectionListener(SelectionListener listener) {
        this.selectionListeners.add(listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.selectionListeners.remove(listener);
    }

    class TableContentProvider
    implements IStructuredContentProvider {
        TableContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            List<?> list = TableViewerComposite.this.objectManager.eGet();
            int size = list.size();
            return list.toArray(new Object[size]);
        }
    }
}

