/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.modules.modeling;

import com.google.common.collect.SortedSetMultimap;
import com.google.common.collect.TreeMultimap;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ease.Logger;
import org.eclipse.ease.modules.modeling.ISelector;
import org.eclipse.ease.modules.modeling.impl.SelectorWrapper;

public class SelectorService {
    private static final String SELECTOR_EXT_POINT_ID = "org.eclipse.ease.modules.modeling.selector";
    private SortedSetMultimap<Integer, SelectorWrapper> selectors = null;
    private Map<String, SelectorWrapper> selectorsMap = null;

    public static SelectorService getInstance() {
        return SingletonHolder.INSTANCE;
    }

    SelectorService() {
        this.init();
    }

    public Object getSelectionFromContext(Object in, IEvaluationContext context) {
        for (Integer priority : this.selectors.keySet()) {
            for (SelectorWrapper selector : this.selectors.get((Object)priority)) {
                Object selection;
                Expression expression = selector.getExpression();
                if (expression != null) {
                    try {
                        if (expression.evaluate(context) != EvaluationResult.TRUE || (selection = selector.getSelector().getCustomSelection(in)) == null) continue;
                        return selection;
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                selection = selector.getSelector().getCustomSelection(in);
                if (selection == null) continue;
                return selection;
            }
        }
        return null;
    }

    public Object getSelectionFromSelector(Object in, String id) {
        SelectorWrapper selector = this.selectorsMap.get(id);
        if (selector != null) {
            return selector.getSelector().getCustomSelection(in);
        }
        return null;
    }

    public Object getSelection(Object in) {
        for (Integer priority : this.selectors.keySet()) {
            for (SelectorWrapper selector : this.selectors.get((Object)priority)) {
                Object selection = selector.getSelector().getCustomSelection(in);
                if (selection == null) continue;
                return selection;
            }
        }
        return null;
    }

    protected void init() {
        if (this.selectors == null) {
            IConfigurationElement[] config;
            this.selectors = TreeMultimap.create((Comparator)new Comparator<Integer>(){

                @Override
                public int compare(Integer o1, Integer o2) {
                    return o2.compareTo(o1);
                }
            }, (Comparator)new Comparator<SelectorWrapper>(){

                @Override
                public int compare(SelectorWrapper o1, SelectorWrapper o2) {
                    return o1.compareTo(o2);
                }
            });
            this.selectorsMap = new HashMap<String, SelectorWrapper>();
            IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor(SELECTOR_EXT_POINT_ID);
            int n = config.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement e = iConfigurationElementArray[n2];
                if ("selector".equals(e.getName())) {
                    String id = e.getAttribute("id");
                    try {
                        ISelector newSelector = (ISelector)e.createExecutableExtension("impl");
                        String priorityS = e.getAttribute("priority");
                        int priority = Integer.parseInt(priorityS);
                        SelectorWrapper oldSelector = this.selectorsMap.get(id);
                        if (oldSelector != null) {
                            this.selectorsMap.remove(id);
                            SortedSet selects = this.selectors.get((Object)priority);
                            selects.remove(oldSelector);
                        }
                        Expression expression = null;
                        IConfigurationElement[] iConfigurationElementArray2 = e.getChildren();
                        int n3 = iConfigurationElementArray2.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IConfigurationElement child = iConfigurationElementArray2[n4];
                            expression = ExpressionConverter.getDefault().perform(child);
                            if (expression != null) break;
                            ++n4;
                        }
                        SelectorWrapper selectorWrapper = new SelectorWrapper(newSelector, expression, id);
                        this.selectors.put((Object)priority, (Object)selectorWrapper);
                        this.selectorsMap.put(id, selectorWrapper);
                    }
                    catch (CoreException e1) {
                        Logger.error((String)"org.eclipse.ease.modules.modeling", (String)("Unable to create the a selector from " + id), (Throwable)e1);
                    }
                }
                ++n2;
            }
        }
    }

    private static class SingletonHolder {
        private static SelectorService INSTANCE = new SelectorService();

        private SingletonHolder() {
        }
    }
}

