/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.lang.unittest.ui.editor;

import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.ease.lang.unittest.UnitTestHelper;
import org.eclipse.ease.lang.unittest.definition.IDefinitionPackage;
import org.eclipse.ease.lang.unittest.definition.ITestSuiteDefinition;
import org.eclipse.ease.lang.unittest.definition.IVariable;
import org.eclipse.ease.lang.unittest.runtime.ITestSuite;
import org.eclipse.ease.lang.unittest.ui.editor.AbstractEditorPage;
import org.eclipse.ease.ui.tools.AbstractVirtualTreeProvider;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.part.ResourceTransfer;
import org.eclipse.ui.progress.UIJob;

public class VariablesPage
extends AbstractEditorPage {
    private static final String VARIABLES_EDITOR_ID = "org.eclipse.ease.editor.suiteEditor.variables";
    private static final Pattern VARIABLE_NAME_PATTERN = Pattern.compile("([a-zA-Z_$][0-9a-zA-Z_$]*)");
    private final UIJob fUpdateUIJob = new UIJob("Update variables"){

        public IStatus runInUIThread(IProgressMonitor monitor) {
            VariablesPage.this.fTreeViewer.refresh();
            return Status.OK_STATUS;
        }
    };
    private TreeViewer fTreeViewer;

    private static boolean isValidNamePattern(String name) {
        return VARIABLE_NAME_PATTERN.matcher(name).matches();
    }

    public VariablesPage(FormEditor editor, String id, String title) {
        super(editor, id, title);
    }

    @Override
    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        managedForm.getForm().getBody().setLayout((Layout)new GridLayout(1, false));
        Label lblDefineVariablesThat = new Label(managedForm.getForm().getBody(), 0);
        managedForm.getToolkit().adapt((Control)lblDefineVariablesThat, true, true);
        lblDefineVariablesThat.setText("Define variables that will be visible in your scripts.");
        Composite composite = new Composite(managedForm.getForm().getBody(), 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 4));
        managedForm.getToolkit().adapt(composite);
        managedForm.getToolkit().paintBordersFor(composite);
        TreeColumnLayout tcl_composite = new TreeColumnLayout();
        composite.setLayout((Layout)tcl_composite);
        Tree tree = new Tree(composite, 67586);
        this.fTreeViewer = new TreeViewer(tree);
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        managedForm.getToolkit().paintBordersFor((Composite)tree);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.fTreeViewer);
        this.fTreeViewer.setContentProvider((IContentProvider)new VariablesTreeContentProvider());
        this.fTreeViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof IVariable && e2 instanceof IVariable) {
                    return ((IVariable)e1).getName().compareToIgnoreCase(((IVariable)e2).getName());
                }
                return super.compare(viewer, e1, e2);
            }

            public int category(Object element) {
                return element instanceof IPath ? 1 : 2;
            }
        });
        TreeViewerColumn treeViewerColumn = new TreeViewerColumn(this.fTreeViewer, 0);
        TreeColumn tblclmnVariable = treeViewerColumn.getColumn();
        tcl_composite.setColumnData((Widget)tblclmnVariable, (ColumnLayoutData)new ColumnWeightData(2, 20, true));
        tblclmnVariable.setText("Variable");
        treeViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof IVariable) {
                    return ((IVariable)element).getName();
                }
                if (element instanceof IPath) {
                    return ((IPath)element).lastSegment();
                }
                return super.getText(element);
            }

            public Image getImage(Object element) {
                if (element instanceof IVariable) {
                    return DebugUITools.getImage((String)"IMG_VIEW_VARIABLES");
                }
                if (element instanceof IPath) {
                    return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
                }
                return super.getImage(element);
            }

            public String getToolTipText(Object element) {
                String description;
                if (element instanceof IVariable && (description = ((IVariable)element).getDescription()) != null) {
                    return description.replaceAll("\\\\n", "\n");
                }
                return super.getToolTipText(element);
            }
        });
        treeViewerColumn.setEditingSupport(new EditingSupport((ColumnViewer)this.fTreeViewer){

            protected void setValue(Object element, Object value) {
                IPath newPath;
                if (element instanceof IVariable) {
                    Path newPath2 = new Path(value.toString());
                    if (newPath2.segmentCount() == 1) {
                        String newName;
                        String oldName = ((IVariable)element).getName();
                        if (!oldName.equals(newName = value.toString()) && VariablesPage.isValidNamePattern(newName) && VariablesPage.this.isUniqueName(newName)) {
                            IPath newFullName = ((IVariable)element).getPath().append(newName);
                            Command command = SetCommand.create((EditingDomain)VariablesPage.this.getEditingDomain(), (Object)element, (Object)IDefinitionPackage.Literals.VARIABLE__FULL_NAME, (Object)newFullName);
                            VariablesPage.this.getEditor().executeCommand(command);
                            VariablesPage.this.fTreeViewer.update(element, null);
                        }
                    } else {
                        String newName = newPath2.lastSegment();
                        if (VariablesPage.isValidNamePattern(newName) && (VariablesPage.this.isUniqueName(newName) || ((IVariable)element).getName().equals(newName))) {
                            Path newFullName = newPath2.isAbsolute() ? newPath2 : ((IVariable)element).getPath().append((IPath)newPath2);
                            Command command = SetCommand.create((EditingDomain)VariablesPage.this.getEditingDomain(), (Object)element, (Object)IDefinitionPackage.Literals.VARIABLE__FULL_NAME, (Object)newFullName);
                            VariablesPage.this.getEditor().executeCommand(command);
                            VariablesPage.this.fTreeViewer.refresh();
                        }
                    }
                } else if (element instanceof IPath && !element.equals(newPath = ((IPath)element).removeLastSegments(1).append(value.toString()).makeAbsolute())) {
                    CompoundCommand compoundCommand = new CompoundCommand();
                    for (IVariable variable : VariablesPage.this.getTestSuiteDefinition().getVariables()) {
                        if (!((IPath)element).isPrefixOf(variable.getFullName())) continue;
                        IPath updatedName = newPath.append(variable.getFullName().removeFirstSegments(((IPath)element).segmentCount()));
                        Command command = SetCommand.create((EditingDomain)VariablesPage.this.getEditingDomain(), (Object)variable, (Object)IDefinitionPackage.Literals.VARIABLE__FULL_NAME, (Object)updatedName);
                        compoundCommand.append(command);
                    }
                    if (!compoundCommand.isEmpty()) {
                        VariablesPage.this.getEditor().executeCommand((Command)compoundCommand);
                    }
                    VariablesPage.this.removePath((IPath)element);
                    VariablesPage.this.addPath(newPath);
                    VariablesPage.this.fTreeViewer.refresh();
                }
            }

            protected Object getValue(Object element) {
                if (element instanceof IVariable) {
                    return ((IVariable)element).getName();
                }
                if (element instanceof IPath) {
                    return ((IPath)element).lastSegment();
                }
                return "";
            }

            protected CellEditor getCellEditor(Object element) {
                return new TextCellEditor((Composite)VariablesPage.this.fTreeViewer.getTree());
            }

            protected boolean canEdit(Object element) {
                return true;
            }
        });
        TreeViewerColumn treeViewerColumn_1 = new TreeViewerColumn(this.fTreeViewer, 0);
        TreeColumn tblclmnContent = treeViewerColumn_1.getColumn();
        tcl_composite.setColumnData((Widget)tblclmnContent, (ColumnLayoutData)new ColumnWeightData(2, 20, true));
        tblclmnContent.setText("Content");
        treeViewerColumn_1.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof IVariable) {
                    return ((IVariable)element).getContent();
                }
                if (element instanceof IPath) {
                    return "";
                }
                return super.getText(element);
            }
        });
        treeViewerColumn_1.setEditingSupport(new EditingSupport((ColumnViewer)this.fTreeViewer){

            protected void setValue(Object element, Object value) {
                String newContent;
                String oldContent;
                if (element instanceof IVariable && !(oldContent = ((IVariable)element).getContent()).equals(newContent = value.toString())) {
                    Command command = SetCommand.create((EditingDomain)VariablesPage.this.getEditingDomain(), (Object)element, (Object)IDefinitionPackage.Literals.VARIABLE__CONTENT, (Object)newContent);
                    VariablesPage.this.getEditor().executeCommand(command);
                    VariablesPage.this.fTreeViewer.update(element, null);
                }
            }

            protected Object getValue(Object element) {
                if (element instanceof IVariable) {
                    return ((IVariable)element).getContent();
                }
                return "";
            }

            protected CellEditor getCellEditor(Object element) {
                return new TextCellEditor((Composite)VariablesPage.this.fTreeViewer.getTree());
            }

            protected boolean canEdit(Object element) {
                return element instanceof IVariable;
            }
        });
        TreeViewerColumn treeViewerColumn_3 = new TreeViewerColumn(this.fTreeViewer, 0);
        TreeColumn tblclmnDescription = treeViewerColumn_3.getColumn();
        tcl_composite.setColumnData((Widget)tblclmnDescription, (ColumnLayoutData)new ColumnWeightData(3, 20, true));
        tblclmnDescription.setText("Description");
        treeViewerColumn_3.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof IVariable) {
                    return ((IVariable)element).getDescription();
                }
                if (element instanceof IPath) {
                    return "";
                }
                return super.getText(element);
            }
        });
        treeViewerColumn_3.setEditingSupport(new EditingSupport((ColumnViewer)this.fTreeViewer){

            protected void setValue(Object element, Object value) {
                String newDescription;
                String oldDescription;
                if (element instanceof IVariable && !(oldDescription = ((IVariable)element).getDescription()).equals(newDescription = value.toString())) {
                    Command command = SetCommand.create((EditingDomain)VariablesPage.this.getEditingDomain(), (Object)element, (Object)IDefinitionPackage.Literals.VARIABLE__DESCRIPTION, (Object)newDescription);
                    VariablesPage.this.getEditor().executeCommand(command);
                    VariablesPage.this.fTreeViewer.update(element, null);
                }
            }

            protected Object getValue(Object element) {
                if (element instanceof IVariable) {
                    return ((IVariable)element).getDescription();
                }
                return "";
            }

            protected CellEditor getCellEditor(Object element) {
                return new TextCellEditor((Composite)VariablesPage.this.fTreeViewer.getTree());
            }

            protected boolean canEdit(Object element) {
                return element instanceof IVariable;
            }
        });
        this.initializeDnD();
        MenuManager contextMenu = new MenuManager("", VARIABLES_EDITOR_ID);
        Menu menu = contextMenu.createContextMenu((Control)this.fTreeViewer.getTree());
        contextMenu.setRemoveAllWhenShown(true);
        this.fTreeViewer.getTree().setMenu(menu);
        this.getEditorSite().registerContextMenu(VARIABLES_EDITOR_ID, contextMenu, (ISelectionProvider)this.fTreeViewer, false);
        this.populateContent();
        this.getTestSuiteDefinition().eAdapters().add((Object)new EContentAdapter(){

            public void notifyChanged(Notification notification) {
                super.notifyChanged(notification);
                VariablesPage.this.fUpdateUIJob.schedule(100L);
            }

            public boolean isAdapterForType(Object type) {
                return type instanceof ITestSuite;
            }
        });
        this.getSite().setSelectionProvider((ISelectionProvider)this.fTreeViewer);
    }

    @Override
    protected void populateContent() {
        this.fTreeViewer.setInput((Object)this.getTestSuiteDefinition());
        this.fTreeViewer.refresh();
        this.fTreeViewer.expandAll();
    }

    @Override
    protected String getPageTitle() {
        return "Variables";
    }

    private void initializeDnD() {
        int operations = 2;
        final Transfer[] transferTypes = new Transfer[]{ResourceTransfer.getInstance(), LocalSelectionTransfer.getTransfer()};
        this.fTreeViewer.addDragSupport(2, new Transfer[]{LocalSelectionTransfer.getTransfer()}, (DragSourceListener)new DragSourceAdapter(){

            public void dragFinished(DragSourceEvent event) {
                LocalSelectionTransfer.getTransfer().setSelection(null);
            }

            public void dragStart(DragSourceEvent event) {
                LocalSelectionTransfer.getTransfer().setSelection(VariablesPage.this.fTreeViewer.getSelection());
            }
        });
        ViewerDropAdapter dropSupport = new ViewerDropAdapter((Viewer)this.fTreeViewer){

            public boolean validateDrop(Object target, int operation, TransferData transferData) {
                Transfer[] transferArray = transferTypes;
                int n = transferTypes.length;
                int n2 = 0;
                while (n2 < n) {
                    Transfer transferType = transferArray[n2];
                    if (transferType.isSupportedType(transferData)) {
                        return true;
                    }
                    ++n2;
                }
                return false;
            }

            public boolean performDrop(Object data) {
                if (data instanceof IStructuredSelection) {
                    Object file = ((IStructuredSelection)data).getFirstElement();
                    if (file instanceof IFile) {
                        if (!file.equals(VariablesPage.this.getFile())) {
                            try {
                                ITestSuiteDefinition droppedDefinition = UnitTestHelper.loadTestSuite((InputStream)((IFile)file).getContents());
                                CompoundCommand compoundCommand = new CompoundCommand();
                                for (IVariable variable : droppedDefinition.getVariables()) {
                                    Command command;
                                    IVariable existingVariable = VariablesPage.this.getTestSuiteDefinition().getVariable(variable.getName());
                                    if (existingVariable != null) {
                                        command = SetCommand.create((EditingDomain)VariablesPage.this.getEditingDomain(), (Object)existingVariable, (Object)IDefinitionPackage.Literals.VARIABLE__CONTENT, (Object)variable.getContent());
                                        compoundCommand.append(command);
                                        continue;
                                    }
                                    command = AddCommand.create((EditingDomain)VariablesPage.this.getEditingDomain(), (Object)VariablesPage.this.getTestSuiteDefinition(), (Object)IDefinitionPackage.Literals.TEST_SUITE_DEFINITION__VARIABLES, (Object)variable);
                                    compoundCommand.append(command);
                                }
                                VariablesPage.this.getEditor().executeCommand((Command)compoundCommand);
                                VariablesPage.this.fTreeViewer.refresh();
                            }
                            catch (Exception e) {
                                return false;
                            }
                        }
                    } else {
                        Object target = this.getCurrentTarget();
                        if (target == null) {
                            target = Path.ROOT;
                        }
                        if (target instanceof IPath) {
                            CompoundCommand compoundCommand = new CompoundCommand();
                            for (Object element : ((IStructuredSelection)data).toList()) {
                                if (element instanceof IVariable) {
                                    IPath newFullName = ((IPath)target).append(((IVariable)element).getName());
                                    Command command = SetCommand.create((EditingDomain)VariablesPage.this.getEditingDomain(), element, (Object)IDefinitionPackage.Literals.VARIABLE__FULL_NAME, (Object)newFullName);
                                    compoundCommand.append(command);
                                    continue;
                                }
                                if (!(element instanceof IPath)) continue;
                                for (IVariable variable : VariablesPage.this.getTestSuiteDefinition().getVariables()) {
                                    if (!((IPath)element).isPrefixOf(variable.getFullName())) continue;
                                    IPath updatedName = ((IPath)target).append(variable.getName());
                                    Command command = SetCommand.create((EditingDomain)VariablesPage.this.getEditingDomain(), (Object)variable, (Object)IDefinitionPackage.Literals.VARIABLE__FULL_NAME, (Object)updatedName);
                                    compoundCommand.append(command);
                                }
                            }
                            VariablesPage.this.getEditor().executeCommand((Command)compoundCommand);
                            VariablesPage.this.fTreeViewer.refresh();
                            return true;
                        }
                    }
                }
                return false;
            }
        };
        this.fTreeViewer.addDropSupport(2, transferTypes, (DropTargetListener)dropSupport);
    }

    public boolean isUniqueName(String name) {
        for (IVariable variable : this.getTestSuiteDefinition().getVariables()) {
            if (!name.equals(variable.getName())) continue;
            return false;
        }
        return true;
    }

    public void addPath(IPath path) {
        ((VariablesTreeContentProvider)this.fTreeViewer.getContentProvider()).addPath(path);
        this.fTreeViewer.refresh();
    }

    public void removePath(IPath path) {
        ((VariablesTreeContentProvider)this.fTreeViewer.getContentProvider()).removePath(path);
        this.fTreeViewer.refresh();
    }

    public boolean containsPath(IPath path) {
        return ((VariablesTreeContentProvider)this.fTreeViewer.getContentProvider()).containsPath(path);
    }

    public Image getTitleImage() {
        return DebugUITools.getImage((String)"IMG_VIEW_VARIABLES");
    }

    protected Image getDefaultImage() {
        return DebugUITools.getImage((String)"IMG_VIEW_VARIABLES");
    }

    private class VariablesTreeContentProvider
    extends AbstractVirtualTreeProvider {
        private final Collection<IPath> fAdditionalPaths = new HashSet<IPath>();

        private VariablesTreeContentProvider() {
        }

        protected void populateElements(Object inputElement) {
            this.setShowRoot(false);
            if (inputElement instanceof ITestSuiteDefinition) {
                for (Object element : ((ITestSuiteDefinition)inputElement).getVariables()) {
                    if (!(element instanceof IVariable)) continue;
                    this.registerElement(((IVariable)element).getPath(), element);
                }
            }
            for (IPath additionalPath : this.fAdditionalPaths) {
                this.registerPath(additionalPath);
            }
        }

        public void addPath(IPath path) {
            this.fAdditionalPaths.add(path.makeAbsolute());
            this.registerPath(path);
        }

        public void removePath(IPath path) {
            this.fAdditionalPaths.remove(path.makeAbsolute());
        }

        public boolean containsPath(IPath path) {
            return this.fAdditionalPaths.contains(path.makeAbsolute());
        }
    }
}

