/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.scripts.dialogs;

import java.io.File;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ease.ui.scripts.preferences.PreferencesHelper;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;

public class SelectScriptStorageDialog
extends Dialog {
    private Text txtWorkspace;
    private Text txtFileSystem;
    private Button btnStoreInSettings;
    private Button btnStoreInWorkspace;
    private Button btnStoreOnFileSystem;
    private String fLocation = null;

    public SelectScriptStorageDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Script Storage Location");
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        container.setLayout((Layout)new GridLayout(2, false));
        Label lblWhereDoYou = new Label(container, 0);
        lblWhereDoYou.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        lblWhereDoYou.setText("Where do you want to store your recorded scripts to?");
        this.btnStoreInSettings = new Button(container, 16);
        this.btnStoreInSettings.setSelection(true);
        this.btnStoreInSettings.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        GridData gd_btnStoreInSettings = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_btnStoreInSettings.verticalIndent = 20;
        this.btnStoreInSettings.setLayoutData((Object)gd_btnStoreInSettings);
        this.btnStoreInSettings.setText("Store in my workspace settings");
        new Label(container, 0);
        this.btnStoreInWorkspace = new Button(container, 16);
        this.btnStoreInWorkspace.setText("Use a workspace project");
        new Label(container, 0);
        this.txtWorkspace = new Text(container, 2048);
        GridData gd_txtWorkspace = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_txtWorkspace.horizontalIndent = 17;
        this.txtWorkspace.setLayoutData((Object)gd_txtWorkspace);
        Button btnNewButton = new Button(container, 0);
        btnNewButton.setText("Browse...");
        btnNewButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object[] result;
                ContainerSelectionDialog dialog = new ContainerSelectionDialog(SelectScriptStorageDialog.this.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), true, "Select script storage folder");
                if (dialog.open() == 0 && (result = dialog.getResult()).length > 0 && result[0] instanceof IPath) {
                    SelectScriptStorageDialog.this.txtWorkspace.setText(result[0].toString());
                }
            }
        });
        this.btnStoreOnFileSystem = new Button(container, 16);
        this.btnStoreOnFileSystem.setText("On the file system");
        new Label(container, 0);
        this.txtFileSystem = new Text(container, 2048);
        GridData gd_txtFileSystem = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_txtFileSystem.horizontalIndent = 17;
        this.txtFileSystem.setLayoutData((Object)gd_txtFileSystem);
        Button btnNewButton_1 = new Button(container, 0);
        btnNewButton_1.setText("Browse...");
        btnNewButton_1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(SelectScriptStorageDialog.this.getShell());
                String path = dialog.open();
                if (path != null) {
                    SelectScriptStorageDialog.this.txtFileSystem.setText(new File(path).toURI().toString());
                }
            }
        });
        return container;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getInitialSize() {
        return new Point(450, 300);
    }

    protected void okPressed() {
        if (this.btnStoreInSettings.getSelection()) {
            this.fLocation = PreferencesHelper.getDefaultScriptStorageLocation();
        } else if (this.btnStoreInWorkspace.getSelection()) {
            this.fLocation = this.txtWorkspace.getText().startsWith("/") ? "workspace:/" + this.txtWorkspace.getText() : "workspace://" + this.txtWorkspace.getText();
        } else if (this.btnStoreOnFileSystem.getSelection()) {
            this.fLocation = this.txtFileSystem.getText();
        }
        super.okPressed();
    }

    public String getLocation() {
        return this.fLocation;
    }
}

