/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.completion;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ease.ICompletionContext;
import org.eclipse.ease.Logger;
import org.eclipse.ease.ui.completion.IHelpResolver;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension5;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension6;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class ScriptCompletionProposal
implements ICompletionProposal,
ICompletionProposalExtension5,
ICompletionProposalExtension6,
IContentProposal,
Comparable<ScriptCompletionProposal> {
    public static final int ORDER_FIELD = 20;
    public static final int ORDER_METHOD = 40;
    public static final int ORDER_PACKAGE = 60;
    public static final int ORDER_CLASS = 80;
    public static final int ORDER_DEFAULT = 100;
    private final String fDisplayString;
    private final String fReplacementString;
    private final ImageDescriptor fImageDescriptor;
    private StyledString fStyledString;
    private final int fSortOrder;
    private final IHelpResolver fHelpResolver;
    private final ICompletionContext fContext;

    public ScriptCompletionProposal(ICompletionContext context, String displayString, String replacementString, ImageDescriptor imageDescriptor, int sortOrder, IHelpResolver helpResolver) {
        this.fContext = context;
        this.fDisplayString = displayString;
        this.fReplacementString = replacementString;
        this.fImageDescriptor = imageDescriptor;
        this.fSortOrder = sortOrder;
        this.fHelpResolver = helpResolver;
    }

    public ScriptCompletionProposal(ICompletionContext context, StyledString styledString, String replacementString, ImageDescriptor imageDescriptor, int sortOrder, IHelpResolver helpResolver) {
        this(context, styledString.getString(), replacementString, imageDescriptor, sortOrder, helpResolver);
        this.fStyledString = styledString;
    }

    @Override
    public int compareTo(ScriptCompletionProposal o) {
        int priority = this.fSortOrder - o.fSortOrder;
        if (priority != 0) {
            return priority;
        }
        return this.getDisplayString().compareToIgnoreCase(o.getDisplayString());
    }

    public String getDisplayString() {
        return this.fDisplayString;
    }

    public Image getImage() {
        return this.fImageDescriptor != null ? this.fImageDescriptor.createImage() : null;
    }

    public StyledString getStyledDisplayString() {
        return this.fStyledString != null ? this.fStyledString : new StyledString(this.getDisplayString());
    }

    public void apply(IDocument document) {
        try {
            if (this.fContext.getFilter() != null) {
                document.replace(this.fContext.getOffset() - this.fContext.getFilter().length(), this.fContext.getFilter().length(), this.fReplacementString);
            } else {
                document.replace(this.fContext.getOffset(), 0, this.fReplacementString);
            }
        }
        catch (BadLocationException e) {
            Logger.error((String)"org.eclipse.ease.ui", (String)"Could not insert completion proposal into document", (Throwable)e);
        }
    }

    public Point getSelection(IDocument document) {
        if (this.fContext.getFilter() != null) {
            return new Point(this.fContext.getOffset() - this.fContext.getFilter().length() + this.fReplacementString.length(), 0);
        }
        return new Point(this.fContext.getOffset() + this.fReplacementString.length(), 0);
    }

    public String getAdditionalProposalInfo() {
        if (this.fHelpResolver != null) {
            String htmlHelp = this.fHelpResolver.resolveHTMLHelp();
            return htmlHelp != null ? htmlHelp : this.fHelpResolver.resolveHelp();
        }
        return null;
    }

    public Object getAdditionalProposalInfo(IProgressMonitor monitor) {
        return this.getAdditionalProposalInfo();
    }

    public IContextInformation getContextInformation() {
        return null;
    }

    public String getContent() {
        String original = this.fContext.getOriginalCode();
        return String.valueOf(original.substring(0, original.length() - this.fContext.getFilter().length())) + this.fReplacementString;
    }

    public int getCursorPosition() {
        return this.getContent().length();
    }

    public String getLabel() {
        return String.valueOf(this.getDisplayString()) + "x";
    }

    public String getDescription() {
        return this.getAdditionalProposalInfo();
    }
}

