/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.scripts.repository.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.ease.service.IScriptService;
import org.eclipse.ease.service.ScriptType;
import org.eclipse.ease.tools.StringTools;
import org.eclipse.ease.ui.scripts.repository.IRepositoryService;
import org.eclipse.ease.ui.scripts.repository.IScriptLocation;
import org.eclipse.ease.ui.scripts.repository.impl.InputStreamParser;
import org.eclipse.emf.common.util.URI;
import org.eclipse.ui.PlatformUI;

public class HttpParser
extends InputStreamParser {
    public void parse(String location, IScriptLocation entry) {
        block7: {
            IScriptService scriptService = (IScriptService)PlatformUI.getWorkbench().getService(IScriptService.class);
            ScriptType scriptType = scriptService.getScriptType(location);
            if (scriptType != null) {
                IRepositoryService repositoryService = (IRepositoryService)PlatformUI.getWorkbench().getService(IRepositoryService.class);
                repositoryService.updateLocation(entry, location, System.currentTimeMillis());
            } else {
                try {
                    InputStream stream = new URL(location).openStream();
                    if (stream == null) break block7;
                    String content = StringTools.toString((InputStream)stream);
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {}
                    Collection<String> anchors = this.extractAnchors(location, content);
                    for (String subLocation : anchors) {
                        this.parse(subLocation, entry);
                    }
                }
                catch (IOException iOException) {}
            }
        }
    }

    private Collection<String> extractAnchors(String base, String content) {
        HashSet<String> anchorNodes = new HashSet<String>();
        URI baseURI = URI.createURI((String)base);
        if (baseURI.fileExtension() != null) {
            baseURI = baseURI.trimSegments(1);
        }
        if (baseURI.hasTrailingPathSeparator()) {
            baseURI = baseURI.trimSegments(1);
        }
        int pos = content.indexOf(" href=");
        do {
            if (pos == -1) continue;
            int endpos = content.indexOf(content.charAt(pos + 6), pos + 7);
            if (content.charAt(pos + 7) == '#') continue;
            URI candidate = URI.createURI((String)content.substring(pos + 7, endpos));
            if (candidate.isRelative()) {
                candidate = candidate.resolve(baseURI);
            }
            if (candidate.hasTrailingPathSeparator()) {
                candidate = candidate.trimSegments(1);
            }
            if (!candidate.toString().startsWith(baseURI.toString()) || candidate.segmentCount() <= baseURI.segmentCount()) continue;
            anchorNodes.add(candidate.toString());
        } while ((pos = content.indexOf(" href=", pos + 1)) != -1);
        anchorNodes.remove(base);
        return anchorNodes;
    }
}

