/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.modules.unittest.ui.launching;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ease.Logger;
import org.eclipse.ui.model.WorkbenchContentProvider;

public class FileFilterContentProvider
extends WorkbenchContentProvider {
    private final List<String> fExtensions;

    public FileFilterContentProvider(String[] extensions) {
        this.fExtensions = Arrays.asList(extensions);
    }

    public Object[] getChildren(Object element) {
        if (element instanceof IContainer) {
            return this.containsFiles((IContainer)element) ? super.getChildren(element) : new Object[]{};
        }
        return super.getChildren(element);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean containsFiles(IContainer container) {
        try {
            IResource resource;
            IResource[] iResourceArray = container.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                String fileExtension;
                resource = iResourceArray[n2];
                if (resource instanceof IFile && this.fExtensions.contains(fileExtension = resource.getFullPath().getFileExtension())) {
                    return true;
                }
                ++n2;
            }
            iResourceArray = container.members();
            n = iResourceArray.length;
            n2 = 0;
            while (n2 < n) {
                resource = iResourceArray[n2];
                if (resource instanceof IContainer && this.containsFiles((IContainer)resource)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
        catch (CoreException e) {
            Logger.error((String)"org.eclipse.ease.modules.unittest.ui", (String)("Could not traverse " + container), (Throwable)e);
            return true;
        }
    }
}

