/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.modules.unittest.reporters;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ease.modules.unittest.reporters.IReportGenerator;

public class ReportTools {
    private static final String EXTENSION_REPORTS_ID = "org.eclipse.ease.modules.unittest.report";
    private static final String EXTENSION_GENERATOR = "generator";
    private static final String EXTENSION_GENERATOR_NAME = "name";
    private static final String EXTENSION_GENERATOR_CLASS = "class";

    public static List<String> getReportTemplates() {
        IConfigurationElement[] config;
        ArrayList<String> templates = new ArrayList<String>();
        IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_REPORTS_ID);
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            if (e.getName().equals(EXTENSION_GENERATOR)) {
                templates.add(e.getAttribute(EXTENSION_GENERATOR_NAME));
            }
            ++n2;
        }
        Collections.sort(templates);
        return templates;
    }

    public static IReportGenerator getReport(String name) {
        IConfigurationElement[] config;
        IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_REPORTS_ID);
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            if (e.getName().equals(EXTENSION_GENERATOR) && e.getAttribute(EXTENSION_GENERATOR_NAME).equals(name)) {
                try {
                    Object generator = e.createExecutableExtension(EXTENSION_GENERATOR_CLASS);
                    if (generator instanceof IReportGenerator) {
                        return (IReportGenerator)generator;
                    }
                }
                catch (CoreException coreException) {}
            }
            ++n2;
        }
        return null;
    }
}

