/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.scripts.repository.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ease.IHeaderParser;
import org.eclipse.ease.Logger;
import org.eclipse.ease.service.IScriptService;
import org.eclipse.ease.service.ScriptType;
import org.eclipse.ease.tools.ResourceTools;
import org.eclipse.ease.ui.scripts.Activator;
import org.eclipse.ease.ui.scripts.preferences.PreferencesHelper;
import org.eclipse.ease.ui.scripts.repository.IRepositoryFactory;
import org.eclipse.ease.ui.scripts.repository.IRepositoryService;
import org.eclipse.ease.ui.scripts.repository.IScript;
import org.eclipse.ease.ui.scripts.repository.IScriptListener;
import org.eclipse.ease.ui.scripts.repository.IScriptLocation;
import org.eclipse.ease.ui.scripts.repository.IStorage;
import org.eclipse.ease.ui.scripts.repository.impl.ParameterDelta;
import org.eclipse.ease.ui.scripts.repository.impl.RepositoryFactoryImpl;
import org.eclipse.ease.ui.scripts.repository.impl.ScriptEvent;
import org.eclipse.ease.ui.scripts.repository.impl.UIIntegrationJob;
import org.eclipse.ease.ui.scripts.repository.impl.UpdateRepositoryJob;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.ui.PlatformUI;

public class RepositoryService
implements IRepositoryService,
IResourceChangeListener {
    static final long UPDATE_URI_INTERVAL = 1000L;
    static final long UPDATE_SCRIPT_INTERVAL = 1000L;
    private static RepositoryService fInstance;
    private static final String CACHE_FILE_NAME = "script.repository";
    private static final long DEFAULT_DELAY = 60000L;
    public static final long UPDATE_STREAM_INTERVAL = 0L;
    private IStorage fRepository = null;
    private final UpdateRepositoryJob fUpdateJob;
    private final Job fSaveJob = new Job("Save Script Repositories"){

        protected IStatus run(IProgressMonitor monitor) {
            IPath path = Activator.getDefault().getStateLocation().append(RepositoryService.CACHE_FILE_NAME);
            File file = path.toFile();
            ResourceSetImpl resSet = new ResourceSetImpl();
            Resource resource = resSet.createResource(URI.createFileURI((String)file.getAbsolutePath()));
            resource.getContents().add((Object)RepositoryService.this.fRepository);
            try {
                resource.save(Collections.emptyMap());
            }
            catch (IOException iOException) {
                Logger.logError((String)"Could not store script repositories");
            }
            return Status.OK_STATUS;
        }
    };
    private final ListenerList fListeners = new ListenerList();

    public static RepositoryService getInstance() {
        if (fInstance == null) {
            fInstance = new RepositoryService();
        }
        return fInstance;
    }

    private RepositoryService() {
        RepositoryFactoryImpl.init();
        IPath path = Activator.getDefault().getStateLocation().append(CACHE_FILE_NAME);
        File file = path.toFile();
        if (file != null && file.exists()) {
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            Resource resource = resourceSet.createResource(URI.createURI((String)file.toURI().toString()));
            try {
                resource.load(null);
                this.fRepository = (IStorage)resource.getContents().get(0);
            }
            catch (IOException iOException) {}
        }
        long updateDelay = 0L;
        if (this.fRepository == null) {
            this.fRepository = IRepositoryFactory.eINSTANCE.createStorage();
        } else {
            updateDelay = 60000L;
        }
        if (!this.equals((Collection<IScriptLocation>)this.fRepository.getEntries(), PreferencesHelper.getLocations())) {
            this.fRepository.getEntries().clear();
            this.fRepository.getEntries().addAll(PreferencesHelper.getLocations());
            this.save();
        }
        new UIIntegrationJob(this);
        this.fUpdateJob = new UpdateRepositoryJob(this);
        this.fUpdateJob.schedule(updateDelay);
        for (IScriptLocation location : this.getLocations()) {
            if (!location.getLocation().startsWith("workspace://")) continue;
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
            break;
        }
    }

    private boolean equals(Collection<IScriptLocation> first, Collection<IScriptLocation> second) {
        if (first.size() != second.size()) {
            return false;
        }
        for (IScriptLocation firstEntry : first) {
            boolean found = false;
            for (IScriptLocation secondEntry : second) {
                if (!firstEntry.equals(secondEntry)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    @Override
    public void update(boolean force) {
        if (force) {
            for (IScript script : this.getScripts()) {
                script.setTimestamp(0L);
            }
        }
        this.fUpdateJob.update();
    }

    @Override
    public IScript getScript(String name) {
        for (IScript script : this.fRepository.getScripts()) {
            if (!name.equals(script.getPath().toString())) continue;
            return script;
        }
        return null;
    }

    void save() {
        this.fSaveJob.cancel();
        this.fSaveJob.schedule(500L);
    }

    private void fireScriptEvent(ScriptEvent event) {
        Object[] objectArray = this.fListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IScriptListener)listener).notify(event);
            ++n2;
        }
    }

    @Override
    public Collection<IScript> getScripts() {
        return Collections.unmodifiableCollection(this.fRepository.getScripts());
    }

    @Override
    public void addScriptListener(IScriptListener listener) {
        this.fListeners.add((Object)listener);
    }

    @Override
    public void removeScriptListener(IScriptListener listener) {
        this.fListeners.remove((Object)listener);
    }

    @Override
    public Collection<IScriptLocation> getLocations() {
        return Collections.unmodifiableCollection(this.fRepository.getEntries());
    }

    @Override
    public void updateLocation(IScriptLocation entry, String location, long lastChanged) {
        IScriptService scriptService = (IScriptService)PlatformUI.getWorkbench().getService(IScriptService.class);
        IScript script = this.getScriptByLocation(location);
        ScriptType scriptType = scriptService.getScriptType(ResourceTools.toAbsoluteLocation((Object)location, null));
        if (scriptType != null) {
            if (script == null) {
                script = IRepositoryFactory.eINSTANCE.createScript();
                script.setEntry(entry);
                script.setLocation(location);
                entry.getScripts().add((Object)script);
                this.fireScriptEvent(new ScriptEvent(script, 1, null));
            } else if (script.getTimestamp() == lastChanged) {
                script.setUpdatePending(false);
                return;
            }
            Map<String, String> oldParameters = script.getParameters();
            Map<String, String> parameters = RepositoryService.extractParameters(scriptType, script.getInputStream());
            script.getScriptParameters().clear();
            script.getScriptParameters().putAll(parameters);
            Map<String, String> newParameters = script.getParameters();
            if (!oldParameters.equals(newParameters)) {
                this.fireScriptEvent(new ScriptEvent(script, 2, new ParameterDelta(oldParameters, newParameters)));
            }
            script.setTimestamp(lastChanged);
            script.setUpdatePending(false);
        } else if (script != null) {
            this.removeScript(script);
        }
    }

    private IScript getScriptByLocation(String location) {
        for (IScript script : this.getScripts()) {
            if (!script.getLocation().equals(location)) continue;
            return script;
        }
        return null;
    }

    private static Map<String, String> extractParameters(ScriptType type, InputStream stream) {
        IHeaderParser parser;
        if (type != null && (parser = type.getHeaderParser()) != null) {
            return parser.parse(stream);
        }
        return Collections.emptyMap();
    }

    void removeScript(IScript script) {
        script.getEntry().getScripts().remove((Object)script);
        this.fireScriptEvent(new ScriptEvent(script, 4, null));
    }

    public void resourceChanged(IResourceChangeEvent event) {
        try {
            event.getDelta().accept(new IResourceDeltaVisitor(){

                public boolean visit(IResourceDelta delta) throws CoreException {
                    IResource resource = delta.getResource();
                    String location = "workspace:/" + resource.getFullPath();
                    for (IScriptLocation entry : RepositoryService.this.getLocations()) {
                        if (!entry.getLocation().equals(location)) continue;
                        RepositoryService.this.fUpdateJob.update(entry);
                        return false;
                    }
                    return true;
                }
            });
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void addLocation(String locationURI, boolean defaultLocation, boolean recursive) {
        IScriptLocation entry = IRepositoryFactory.eINSTANCE.createScriptLocation();
        entry.setLocation(locationURI);
        entry.setRecursive(recursive);
        entry.setDefault(defaultLocation);
        for (IScriptLocation location : new HashSet<IScriptLocation>(this.getLocations())) {
            if (!location.getLocation().equals(locationURI)) continue;
            if (!EcoreUtil.equals((EObject)location, (EObject)entry)) {
                this.removeLocation(location.getLocation());
                continue;
            }
            return;
        }
        PreferencesHelper.addLocation(entry);
        this.fRepository.getEntries().add((Object)entry);
        if (entry.getLocation().startsWith("workspace://")) {
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        }
        this.fUpdateJob.update(entry);
    }

    @Override
    public void removeLocation(String locationURI) {
        for (IScriptLocation entry : new HashSet<IScriptLocation>((Collection<IScriptLocation>)this.fRepository.getEntries())) {
            if (!entry.getLocation().equals(locationURI)) continue;
            this.fRepository.getEntries().remove((Object)entry);
            for (IScript script : new HashSet<IScript>((Collection<IScript>)entry.getScripts())) {
                this.removeScript(script);
            }
            this.save();
            break;
        }
        PreferencesHelper.removeLocation(locationURI);
    }
}

