/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.modules.unittest.ui.dialogs;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ease.modules.unittest.reporters.IReportGenerator;
import org.eclipse.ease.modules.unittest.reporters.ReportTools;
import org.eclipse.ease.modules.unittest.ui.Activator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.XMLMemento;

public class CreateReportDialog
extends Dialog {
    private static final String HISTORY_FILE = "export_history.xml";
    private static final String FILELOCATION = "filelocation";
    private static final String TITLE = "title";
    private static final String DESCRIPTION = "description";
    private static final String TYPE = "type";
    private Text mTxtFileName;
    private Text mTxtTitle;
    private Text mTxtDescription;
    private String mFileName = null;
    private String mTitle = "";
    private String mDescription = "";
    private Button btnOpenReportAfter;
    private boolean mOpenAfterSave;
    private Combo mCmbType;
    private String mType;

    public CreateReportDialog(Shell parentShell) {
        super(parentShell);
    }

    protected Control createDialogArea(Composite parent) {
        Map<String, String> history = this.loadHistory();
        Composite container = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = (GridLayout)container.getLayout();
        gridLayout.numColumns = 3;
        Label lblType = new Label(container, 0);
        lblType.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblType.setText("Type:");
        this.mCmbType = new Combo(container, 8);
        this.mCmbType.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.mCmbType.setItems(ReportTools.getReportTemplates().toArray(new String[0]));
        if (history.containsKey(TYPE) && history.get(TYPE) != null) {
            this.mTxtFileName.setText(history.get(TYPE));
        } else {
            this.mCmbType.setText(this.mCmbType.getItem(0));
        }
        new Label(container, 0);
        Label lblFile = new Label(container, 0);
        lblFile.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblFile.setText("File:");
        this.mTxtFileName = new Text(container, 2048);
        this.mTxtFileName.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        if (history.containsKey(FILELOCATION) && history.get(FILELOCATION) != null) {
            this.mTxtFileName.setText(history.get(FILELOCATION));
        }
        Button btnBrowse = new Button(container, 0);
        btnBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(CreateReportDialog.this.getShell(), 8192);
                dialog.setText("Save Report to File");
                dialog.setOverwrite(true);
                IReportGenerator report = ReportTools.getReport((String)CreateReportDialog.this.mCmbType.getText());
                if (report != null) {
                    dialog.setFileName("report." + report.getDefaultExtension());
                    dialog.setFilterExtensions(new String[]{"*." + report.getDefaultExtension()});
                } else {
                    dialog.setFileName("report");
                    dialog.setFilterExtensions(new String[]{"*.*"});
                }
                String location = dialog.open();
                if (location != null) {
                    CreateReportDialog.this.mTxtFileName.setText(location);
                }
            }
        });
        btnBrowse.setText("Browse...");
        Label label = new Label(container, 258);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        Label lblTitle = new Label(container, 0);
        lblTitle.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblTitle.setText("Title:");
        this.mTxtTitle = new Text(container, 2048);
        this.mTxtTitle.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        if (history.containsKey(TITLE) && history.get(TITLE) != null) {
            this.mTxtTitle.setText(history.get(TITLE));
        }
        Label lblDescription = new Label(container, 0);
        lblDescription.setLayoutData((Object)new GridData(131072, 128, false, false, 1, 1));
        lblDescription.setText("Description:");
        this.mTxtDescription = new Text(container, 2626);
        this.mTxtDescription.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        if (history.containsKey(DESCRIPTION) && history.get(DESCRIPTION) != null) {
            this.mTxtDescription.setText(history.get(DESCRIPTION));
        }
        new Label(container, 0);
        this.btnOpenReportAfter = new Button(container, 32);
        this.btnOpenReportAfter.setSelection(true);
        this.btnOpenReportAfter.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        this.btnOpenReportAfter.setText("Open report after saving");
        return container;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button clearButton = this.createButton(parent, 14, "Clear", false);
        clearButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CreateReportDialog.this.mTxtFileName.setText("");
                CreateReportDialog.this.mTxtTitle.setText("");
                CreateReportDialog.this.mTxtDescription.setText("");
                CreateReportDialog.this.btnOpenReportAfter.setSelection(false);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getInitialSize() {
        return new Point(450, 300);
    }

    protected void okPressed() {
        this.mType = this.mCmbType.getText();
        this.mFileName = this.mTxtFileName.getText();
        this.mTitle = this.mTxtTitle.getText();
        this.mDescription = this.mTxtDescription.getText();
        this.mOpenAfterSave = this.btnOpenReportAfter.getSelection();
        HashMap<String, String> history = new HashMap<String, String>();
        history.put(FILELOCATION, this.mTxtFileName.getText());
        history.put(TITLE, this.mTxtTitle.getText());
        history.put(DESCRIPTION, this.mTxtDescription.getText());
        history.put(TYPE, this.mCmbType.getText());
        this.saveHistory(history);
        super.okPressed();
    }

    public String getFileName() {
        return this.mFileName;
    }

    public String getTitle() {
        return this.mTitle;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public boolean isOpenReport() {
        return this.mOpenAfterSave;
    }

    public IReportGenerator getReport() {
        return ReportTools.getReport((String)this.mType);
    }

    private Map<String, String> loadHistory() {
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            IPath location = Activator.getDefault().getStateLocation();
            File file = location.append(HISTORY_FILE).toFile();
            if (file.exists()) {
                FileReader reader = new FileReader(file);
                XMLMemento memento = XMLMemento.createReadRoot((Reader)reader);
                reader.close();
                String[] stringArray = new String[]{FILELOCATION, TITLE, DESCRIPTION};
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String key = stringArray[n2];
                    IMemento node = memento.getChild(key);
                    if (node != null) {
                        result.put(key, node.getTextData());
                    }
                    ++n2;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private void saveHistory(Map<String, String> data) {
        XMLMemento memento = XMLMemento.createWriteRoot((String)"history");
        for (Map.Entry<String, String> entry : data.entrySet()) {
            memento.createChild(entry.getKey()).putTextData(entry.getValue());
        }
        try {
            IPath location = Activator.getDefault().getStateLocation();
            File file = location.append(HISTORY_FILE).toFile();
            FileWriter writer = new FileWriter(file);
            memento.save((Writer)writer);
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

