/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.lang.javascript.ui;

import java.util.Collection;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.ease.modules.ModuleDefinition;
import org.eclipse.ease.modules.ModuleHelper;
import org.eclipse.ease.service.IScriptService;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.ui.text.java.ContentAssistInvocationContext;

public class ModuleProposalCalculator {
    private static final Pattern LOAD_MODULE_PATTERN = Pattern.compile("loadModule\\([\"'](.*)[\"']\\)");
    private static final Pattern LINE_DATA_PATTERN = Pattern.compile(".*?([^\\p{Alnum}]?)(\\p{Alnum}*)$");
    final IScriptService scriptService = (IScriptService)PlatformUI.getWorkbench().getService(IScriptService.class);

    protected Collection<ModuleDefinition> getLoadedModules(ContentAssistInvocationContext context) {
        HashSet<ModuleDefinition> modules = new HashSet<ModuleDefinition>();
        modules.add((ModuleDefinition)this.scriptService.getAvailableModules().get("/System/Environment"));
        try {
            IDocument document = context.getDocument();
            String prefix = document.get(0, context.getInvocationOffset());
            for (String name : this.getModuleNames(prefix)) {
                String fullName = ModuleHelper.resolveName((String)name);
                ModuleDefinition definition = (ModuleDefinition)this.scriptService.getAvailableModules().get(fullName);
                if (definition == null) continue;
                modules.add(definition);
            }
        }
        catch (BadLocationException e1) {
            e1.printStackTrace();
        }
        return modules;
    }

    private Collection<String> getModuleNames(String code) {
        HashSet<String> modules = new HashSet<String>();
        Matcher matcher = LOAD_MODULE_PATTERN.matcher(code);
        while (matcher.find()) {
            modules.add(matcher.group(1));
        }
        return modules;
    }

    protected Matcher matchLastToken(ContentAssistInvocationContext context) throws BadLocationException {
        String data = this.getCurrentLine(context);
        return LINE_DATA_PATTERN.matcher(data);
    }

    protected String getCurrentLine(ContentAssistInvocationContext context) throws BadLocationException {
        IDocument document = context.getDocument();
        int lineNumber = document.getLineOfOffset(context.getInvocationOffset());
        IRegion lineInformation = document.getLineInformation(lineNumber);
        return document.get(lineInformation.getOffset(), context.getInvocationOffset() - lineInformation.getOffset());
    }
}

